% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialise_com.R
\name{initialise_inv}
\alias{initialise_inv}
\title{Initialise Invasion Parameters}
\usage{
initialise_inv(invaders, invasion_times, propagule_size = 1)
}
\arguments{
\item{invaders}{An integer vector of species indices indicating which species are invaders.These indices should match the species layers in the input maps (\code{n1_map} and \code{K_map}).}

\item{invasion_times}{A matrix or vector specifying when each invader enters the system.
If a vector is provided, it is assumed to apply to all invaders.
If a matrix, it must have one row per invader and columns corresponding to invasion events.}

\item{propagule_size}{A numeric scalar specifying the number of individuals introduced
at each invasion time. Defaults to 1.}
}
\value{
A named list with the following components:
\describe{
\item{invaders}{Integer vector of invading species indices.}
\item{propagule_size}{Number of individuals introduced per invasion event.}
\item{invasion_times}{Matrix of invasion times, with one row per invader.}
}
}
\description{
Prepares a list of invasion configuration details, including the identifiers of the invading species, the times of invasion and the number of individuals introduced at each event.
Result of this helper function is designed to be passed to \code{\link[=initialise_com]{initialise_com()}} as \code{invasion} argument.
}
\examples{
# Define invaders and invasion times
initialise_inv(
  invaders = c(1, 3),
  invasion_times = matrix(c(5, 10, 5, 20), nrow = 2, byrow = TRUE),
  propagule_size = 10
)

# Uniform invasion times across all invaders
initialise_inv(
  invaders = c(2, 4),
  invasion_times = c(5, 10, 15)
)

}
