% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{project_block}
\alias{project_block}
\title{Project a single "block" of data onto the subspace}
\usage{
project_block(x, new_data, block, ...)
}
\arguments{
\item{x}{The model fit, typically an object of a class that implements a \code{project_block} method}

\item{new_data}{A matrix or vector of new observation(s) with the same number of columns as the original data}

\item{block}{An integer representing the block ID to select in the block projection matrix. This ID corresponds to the specific block of data to be projected}

\item{...}{Additional arguments passed to the underlying \code{project_block} method}
}
\value{
A matrix or vector of the projected data for the specified block
}
\description{
When observations are concatenated into "blocks", it may be useful to project one block from the set.
This function facilitates the projection of a specific block of data onto a subspace. It is a
convenience method for multi-block fits and is equivalent to a "partial projection" where the
column indices are associated with a given block.
}
\seealso{
\code{\link{project}} for the generic projection function

Other project: 
\code{\link{project}()},
\code{\link{project.cross_projector}()},
\code{\link{project_vars}()}
}
\concept{project}
