% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_dob_permit_issuance.R
\name{nyc_dob_permit_issuance}
\alias{nyc_dob_permit_issuance}
\title{DOB Permit Issuance}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Housing-Development/DOB-Permit-Issuance/ipu4-2q9a/about_data>
}
\usage{
nyc_dob_permit_issuance(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing DOB Permit Issuance data.
}
\description{
Downloads DOB Permit Issuance data from NYC Open Data.
}
\details{
The Department of Buildings (DOB) issues permits for construction and demolition activities in the City of New York.
The construction industry must submit an application to DOB with details of the construction job they would like to complete.
The primary types of application, aka job type, are: New Building, Demolition, and Alterations Type 1, 2, and 3.
Each job type can have multiple work types, such as general construction, boiler, elevator, and plumbing.
Each work type will receive a separate permit. (See the DOB Job Application Filings dataset for information about each job application.)
Each row/record in this dataset represents the life cycle of one permit for one work type. The dataset is updated daily with new records, and each existing record will be updated as the permit application moves through the approval process to reflect the latest status of the application.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_dob_permit_issuance(limit = 10)
head(small_sample)

\dontrun{
nyc_dob_permit_issuance(limit = 5000)
nyc_dob_permit_issuance(filters = list(borough = "BROOKLYN"))
}
}
