% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_macro_economic_data.R
\name{get_macro_economic_data}
\alias{get_macro_economic_data}
\title{Load a list of macroeconomic data from WDI}
\usage{
get_macro_economic_data(longterm_data)
}
\arguments{
\item{longterm_data}{The long-term data series resulting from the function \code{\link{decompose_load_data}}. Contains information on country (longterm$country) and years (longterm$year).}
}
\value{
Data frame with the original time series and 10 additional columns with macroeconomic indicators.
}
\description{
This function downloads a set of ten macroeconomic variables via API from the World Development Indicators (WDI) of the World Bank (https://databank.worldbank.org/source/world-development-indicators).
The variables are suspected to have a predictive capacity for the load data.
}
\examples{
example_longterm_and_macro_data <- get_macro_economic_data(example_longterm_data)
print("Macro economic variables are added from the World Bank Developer Indicators:")
example_longterm_and_macro_data

}
\seealso{
See function \code{\link{decompose_load_data}} for the generation of the long-term series and \code{\link{long_term_lm}} for the selection of covariates.
}
