% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_install.R
\name{osrm_clear_path}
\alias{osrm_clear_path}
\title{Clear OSRM Path from Project's .Rprofile}
\usage{
osrm_clear_path(quiet = FALSE)
}
\arguments{
\item{quiet}{A logical value. If \code{TRUE}, suppresses messages. Defaults to \code{FALSE}.}
}
\value{
\code{TRUE} if the file was modified, \code{FALSE} otherwise.
}
\description{
Scans the \code{.Rprofile} file in the current project's root directory and
removes any lines that were added by \code{osrm_install()} to modify the \code{PATH}.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  # Clean up a temporary project's .Rprofile
  old <- setwd(tempdir())
  on.exit(setwd(old), add = TRUE)
  writeLines(
    c(
      "#added-by-r-pkg-osrm.backend",
      'Sys.setenv(PATH = paste("dummy", Sys.getenv("PATH"), sep = .Platform$path.sep))'
    ),
    ".Rprofile"
  )
  osrm_clear_path(quiet = TRUE)
  unlink(".Rprofile")
}
}
}
