#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
# pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2355
#define LARGE_STATE_COUNT 1063
#define SYMBOL_COUNT 134
#define ALIAS_COUNT 1
#define TOKEN_COUNT 80
#define EXTERNAL_TOKEN_COUNT 13
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 55

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_BSLASH = 2,
  anon_sym_function = 3,
  anon_sym_EQ = 4,
  anon_sym_if = 5,
  anon_sym_for = 6,
  anon_sym_in = 7,
  anon_sym_while = 8,
  anon_sym_repeat = 9,
  anon_sym_QMARK = 10,
  anon_sym_TILDE = 11,
  anon_sym_BANG = 12,
  anon_sym_PLUS = 13,
  anon_sym_DASH = 14,
  anon_sym_LT_DASH = 15,
  anon_sym_LT_LT_DASH = 16,
  anon_sym_COLON_EQ = 17,
  anon_sym_DASH_GT = 18,
  anon_sym_DASH_GT_GT = 19,
  anon_sym_PIPE = 20,
  anon_sym_AMP = 21,
  anon_sym_PIPE_PIPE = 22,
  anon_sym_AMP_AMP = 23,
  anon_sym_LT = 24,
  anon_sym_LT_EQ = 25,
  anon_sym_GT = 26,
  anon_sym_GT_EQ = 27,
  anon_sym_EQ_EQ = 28,
  anon_sym_BANG_EQ = 29,
  anon_sym_STAR = 30,
  anon_sym_SLASH = 31,
  anon_sym_STAR_STAR = 32,
  anon_sym_CARET = 33,
  aux_sym_binary_operator_token1 = 34,
  anon_sym_PIPE_GT = 35,
  anon_sym_COLON = 36,
  anon_sym_DOLLAR = 37,
  anon_sym_AT = 38,
  anon_sym_COLON_COLON = 39,
  anon_sym_COLON_COLON_COLON = 40,
  anon_sym_L = 41,
  anon_sym_i = 42,
  sym__hex_literal = 43,
  sym__number_literal = 44,
  anon_sym_SQUOTE = 45,
  anon_sym_DQUOTE = 46,
  aux_sym__single_quoted_string_content_token1 = 47,
  aux_sym__double_quoted_string_content_token1 = 48,
  sym_escape_sequence = 49,
  sym_return = 50,
  sym_next = 51,
  sym_break = 52,
  sym_true = 53,
  sym_false = 54,
  sym_null = 55,
  sym_inf = 56,
  sym_nan = 57,
  anon_sym_NA = 58,
  anon_sym_NA_integer_ = 59,
  anon_sym_NA_real_ = 60,
  anon_sym_NA_complex_ = 61,
  anon_sym_NA_character_ = 62,
  sym_dots = 63,
  sym_dot_dot_i = 64,
  sym_comment = 65,
  sym_comma = 66,
  sym__newline = 67,
  sym__semicolon = 68,
  sym__raw_string_literal = 69,
  sym__external_else = 70,
  sym__external_open_parenthesis = 71,
  sym__external_close_parenthesis = 72,
  sym__external_open_brace = 73,
  sym__external_close_brace = 74,
  sym__external_open_bracket = 75,
  sym__external_close_bracket = 76,
  sym__external_open_bracket2 = 77,
  sym__external_close_bracket2 = 78,
  sym__error_sentinel = 79,
  sym_program = 80,
  sym_function_definition = 81,
  sym_parameters = 82,
  sym_parameter = 83,
  sym__parameter_with_default = 84,
  sym__parameter_without_default = 85,
  sym_if_statement = 86,
  sym_for_statement = 87,
  sym_while_statement = 88,
  sym_repeat_statement = 89,
  sym_braced_expression = 90,
  sym_parenthesized_expression = 91,
  sym_call = 92,
  sym_subset = 93,
  sym_subset2 = 94,
  sym_call_arguments = 95,
  sym_subset_arguments = 96,
  sym_subset2_arguments = 97,
  sym__argument = 98,
  sym_argument = 99,
  sym__argument_named = 100,
  sym__argument_unnamed = 101,
  sym__argument_value = 102,
  sym_unary_operator = 103,
  sym_binary_operator = 104,
  sym_extract_operator = 105,
  sym_namespace_operator = 106,
  sym_integer = 107,
  sym_complex = 108,
  sym_float = 109,
  sym__float_literal = 110,
  sym_string = 111,
  sym__single_quoted_string = 112,
  sym__double_quoted_string = 113,
  aux_sym__single_quoted_string_content = 114,
  aux_sym__double_quoted_string_content = 115,
  sym_na = 116,
  sym__expression = 117,
  sym__string_or_identifier = 118,
  sym__else = 119,
  sym__open_parenthesis = 120,
  sym__close_parenthesis = 121,
  sym__open_brace = 122,
  sym__close_brace = 123,
  sym__open_bracket = 124,
  sym__close_bracket = 125,
  sym__open_bracket2 = 126,
  sym__close_bracket2 = 127,
  aux_sym_program_repeat1 = 128,
  aux_sym_function_definition_repeat1 = 129,
  aux_sym_parameters_repeat1 = 130,
  aux_sym_braced_expression_repeat1 = 131,
  aux_sym_parenthesized_expression_repeat1 = 132,
  aux_sym_call_arguments_repeat1 = 133,
  alias_sym_string_content = 134,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_if] = "if",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_QMARK] = "\?",
  [anon_sym_TILDE] = "~",
  [anon_sym_BANG] = "!",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_CARET] = "^",
  [aux_sym_binary_operator_token1] = "special",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_COLON] = ":",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [anon_sym_L] = "L",
  [anon_sym_i] = "i",
  [sym__hex_literal] = "_hex_literal",
  [sym__number_literal] = "_number_literal",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__single_quoted_string_content_token1] = "_single_quoted_string_content_token1",
  [aux_sym__double_quoted_string_content_token1] = "_double_quoted_string_content_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_return] = "return",
  [sym_next] = "next",
  [sym_break] = "break",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_character_] = "NA_character_",
  [sym_dots] = "dots",
  [sym_dot_dot_i] = "dot_dot_i",
  [sym_comment] = "comment",
  [sym_comma] = "comma",
  [sym__newline] = "_newline",
  [sym__semicolon] = "_semicolon",
  [sym__raw_string_literal] = "_raw_string_literal",
  [sym__external_else] = "else",
  [sym__external_open_parenthesis] = "(",
  [sym__external_close_parenthesis] = ")",
  [sym__external_open_brace] = "{",
  [sym__external_close_brace] = "}",
  [sym__external_open_bracket] = "[",
  [sym__external_close_bracket] = "]",
  [sym__external_open_bracket2] = "[[",
  [sym__external_close_bracket2] = "]]",
  [sym__error_sentinel] = "_error_sentinel",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym__parameter_with_default] = "_parameter_with_default",
  [sym__parameter_without_default] = "_parameter_without_default",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_braced_expression] = "braced_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call] = "call",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_call_arguments] = "arguments",
  [sym_subset_arguments] = "arguments",
  [sym_subset2_arguments] = "arguments",
  [sym__argument] = "_argument",
  [sym_argument] = "argument",
  [sym__argument_named] = "_argument_named",
  [sym__argument_unnamed] = "_argument_unnamed",
  [sym__argument_value] = "_argument_value",
  [sym_unary_operator] = "unary_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_extract_operator] = "extract_operator",
  [sym_namespace_operator] = "namespace_operator",
  [sym_integer] = "integer",
  [sym_complex] = "complex",
  [sym_float] = "float",
  [sym__float_literal] = "_float_literal",
  [sym_string] = "string",
  [sym__single_quoted_string] = "_single_quoted_string",
  [sym__double_quoted_string] = "_double_quoted_string",
  [aux_sym__single_quoted_string_content] = "_single_quoted_string_content",
  [aux_sym__double_quoted_string_content] = "_double_quoted_string_content",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym__string_or_identifier] = "_string_or_identifier",
  [sym__else] = "_else",
  [sym__open_parenthesis] = "_open_parenthesis",
  [sym__close_parenthesis] = "_close_parenthesis",
  [sym__open_brace] = "_open_brace",
  [sym__close_brace] = "_close_brace",
  [sym__open_bracket] = "_open_bracket",
  [sym__close_bracket] = "_close_bracket",
  [sym__open_bracket2] = "_open_bracket2",
  [sym__close_bracket2] = "_close_bracket2",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_braced_expression_repeat1] = "braced_expression_repeat1",
  [aux_sym_parenthesized_expression_repeat1] = "parenthesized_expression_repeat1",
  [aux_sym_call_arguments_repeat1] = "call_arguments_repeat1",
  [alias_sym_string_content] = "string_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_CARET] = anon_sym_CARET,
  [aux_sym_binary_operator_token1] = aux_sym_binary_operator_token1,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [anon_sym_L] = anon_sym_L,
  [anon_sym_i] = anon_sym_i,
  [sym__hex_literal] = sym__hex_literal,
  [sym__number_literal] = sym__number_literal,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__single_quoted_string_content_token1] = aux_sym__single_quoted_string_content_token1,
  [aux_sym__double_quoted_string_content_token1] = aux_sym__double_quoted_string_content_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_return] = sym_return,
  [sym_next] = sym_next,
  [sym_break] = sym_break,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [sym_dots] = sym_dots,
  [sym_dot_dot_i] = sym_dot_dot_i,
  [sym_comment] = sym_comment,
  [sym_comma] = sym_comma,
  [sym__newline] = sym__newline,
  [sym__semicolon] = sym__semicolon,
  [sym__raw_string_literal] = sym__raw_string_literal,
  [sym__external_else] = sym__external_else,
  [sym__external_open_parenthesis] = sym__external_open_parenthesis,
  [sym__external_close_parenthesis] = sym__external_close_parenthesis,
  [sym__external_open_brace] = sym__external_open_brace,
  [sym__external_close_brace] = sym__external_close_brace,
  [sym__external_open_bracket] = sym__external_open_bracket,
  [sym__external_close_bracket] = sym__external_close_bracket,
  [sym__external_open_bracket2] = sym__external_open_bracket2,
  [sym__external_close_bracket2] = sym__external_close_bracket2,
  [sym__error_sentinel] = sym__error_sentinel,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym__parameter_with_default] = sym__parameter_with_default,
  [sym__parameter_without_default] = sym__parameter_without_default,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_braced_expression] = sym_braced_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call] = sym_call,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_call_arguments] = sym_call_arguments,
  [sym_subset_arguments] = sym_call_arguments,
  [sym_subset2_arguments] = sym_call_arguments,
  [sym__argument] = sym__argument,
  [sym_argument] = sym_argument,
  [sym__argument_named] = sym__argument_named,
  [sym__argument_unnamed] = sym__argument_unnamed,
  [sym__argument_value] = sym__argument_value,
  [sym_unary_operator] = sym_unary_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_extract_operator] = sym_extract_operator,
  [sym_namespace_operator] = sym_namespace_operator,
  [sym_integer] = sym_integer,
  [sym_complex] = sym_complex,
  [sym_float] = sym_float,
  [sym__float_literal] = sym__float_literal,
  [sym_string] = sym_string,
  [sym__single_quoted_string] = sym__single_quoted_string,
  [sym__double_quoted_string] = sym__double_quoted_string,
  [aux_sym__single_quoted_string_content] = aux_sym__single_quoted_string_content,
  [aux_sym__double_quoted_string_content] = aux_sym__double_quoted_string_content,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym__string_or_identifier] = sym__string_or_identifier,
  [sym__else] = sym__else,
  [sym__open_parenthesis] = sym__open_parenthesis,
  [sym__close_parenthesis] = sym__close_parenthesis,
  [sym__open_brace] = sym__open_brace,
  [sym__close_brace] = sym__close_brace,
  [sym__open_bracket] = sym__open_bracket,
  [sym__close_bracket] = sym__close_bracket,
  [sym__open_bracket2] = sym__open_bracket2,
  [sym__close_bracket2] = sym__close_bracket2,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_braced_expression_repeat1] = aux_sym_braced_expression_repeat1,
  [aux_sym_parenthesized_expression_repeat1] = aux_sym_parenthesized_expression_repeat1,
  [aux_sym_call_arguments_repeat1] = aux_sym_call_arguments_repeat1,
  [alias_sym_string_content] = alias_sym_string_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_binary_operator_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_L] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [sym__hex_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__number_literal] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__single_quoted_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_dot_i] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__external_else] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_parenthesis] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_parenthesis] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_bracket] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_bracket] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_bracket2] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_bracket2] = {
    .visible = true,
    .named = false,
  },
  [sym__error_sentinel] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_with_default] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter_without_default] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_call_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subset_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_named] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_unnamed] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_value] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_extract_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__float_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quoted_string] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quoted_string] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__single_quoted_string_content] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_string_content] = {
    .visible = false,
    .named = false,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__string_or_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__else] = {
    .visible = false,
    .named = true,
  },
  [sym__open_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__close_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__open_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__close_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__open_bracket] = {
    .visible = false,
    .named = true,
  },
  [sym__close_bracket] = {
    .visible = false,
    .named = true,
  },
  [sym__open_bracket2] = {
    .visible = false,
    .named = true,
  },
  [sym__close_bracket2] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_braced_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_string_content] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_body = 4,
  field_close = 5,
  field_condition = 6,
  field_consequence = 7,
  field_content = 8,
  field_default = 9,
  field_function = 10,
  field_lhs = 11,
  field_name = 12,
  field_open = 13,
  field_operator = 14,
  field_parameter = 15,
  field_parameters = 16,
  field_rhs = 17,
  field_sequence = 18,
  field_value = 19,
  field_variable = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_close] = "close",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_content] = "content",
  [field_default] = "default",
  [field_function] = "function",
  [field_lhs] = "lhs",
  [field_name] = "name",
  [field_open] = "open",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_rhs] = "rhs",
  [field_sequence] = "sequence",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 3},
  [9] = {.index = 14, .length = 1},
  [10] = {.index = 15, .length = 2},
  [11] = {.index = 17, .length = 1},
  [12] = {.index = 18, .length = 1},
  [13] = {.index = 19, .length = 2},
  [14] = {.index = 21, .length = 1},
  [15] = {.index = 22, .length = 3},
  [16] = {.index = 25, .length = 1},
  [17] = {.index = 26, .length = 1},
  [18] = {.index = 27, .length = 1},
  [19] = {.index = 28, .length = 2},
  [20] = {.index = 30, .length = 1},
  [21] = {.index = 31, .length = 3},
  [22] = {.index = 34, .length = 2},
  [23] = {.index = 36, .length = 3},
  [24] = {.index = 39, .length = 3},
  [25] = {.index = 42, .length = 3},
  [26] = {.index = 45, .length = 3},
  [27] = {.index = 48, .length = 3},
  [28] = {.index = 51, .length = 2},
  [29] = {.index = 53, .length = 2},
  [30] = {.index = 55, .length = 1},
  [31] = {.index = 56, .length = 4},
  [32] = {.index = 60, .length = 2},
  [33] = {.index = 62, .length = 3},
  [34] = {.index = 65, .length = 4},
  [35] = {.index = 69, .length = 4},
  [36] = {.index = 73, .length = 2},
  [37] = {.index = 75, .length = 4},
  [38] = {.index = 79, .length = 4},
  [39] = {.index = 83, .length = 4},
  [40] = {.index = 87, .length = 4},
  [41] = {.index = 91, .length = 5},
  [42] = {.index = 96, .length = 4},
  [43] = {.index = 100, .length = 5},
  [44] = {.index = 105, .length = 4},
  [45] = {.index = 109, .length = 5},
  [46] = {.index = 114, .length = 5},
  [47] = {.index = 119, .length = 5},
  [48] = {.index = 124, .length = 5},
  [49] = {.index = 129, .length = 5},
  [50] = {.index = 134, .length = 5},
  [51] = {.index = 139, .length = 5},
  [52] = {.index = 144, .length = 5},
  [53] = {.index = 149, .length = 5},
  [54] = {.index = 154, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_content, 0, .inherited = true},
  [1] =
    {field_body, 1},
  [2] =
    {field_operator, 0},
    {field_rhs, 1},
  [4] =
    {field_lhs, 0},
    {field_operator, 1},
  [6] =
    {field_arguments, 1},
    {field_function, 0},
  [8] =
    {field_body, 0},
  [9] =
    {field_close, 1},
    {field_open, 0},
  [11] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [14] =
    {field_name, 0},
  [15] =
    {field_default, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [17] =
    {field_name, 0, .inherited = true},
  [18] =
    {field_body, 2},
  [19] =
    {field_operator, 0},
    {field_rhs, 2},
  [21] =
    {field_content, 1},
  [22] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 2},
  [25] =
    {field_value, 0},
  [26] =
    {field_argument, 0, .inherited = true},
  [27] =
    {field_argument, 0},
  [28] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [30] =
    {field_value, 0, .inherited = true},
  [31] =
    {field_body, 1, .inherited = true},
    {field_close, 2},
    {field_open, 0},
  [34] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
  [36] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 1},
  [39] =
    {field_close, 2},
    {field_open, 0},
    {field_parameter, 1},
  [42] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2},
  [45] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 3},
  [48] =
    {field_argument, 1, .inherited = true},
    {field_close, 2},
    {field_open, 0},
  [51] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [53] =
    {field_default, 2},
    {field_name, 0},
  [55] =
    {field_parameter, 1},
  [56] =
    {field_close, 3},
    {field_open, 0},
    {field_parameter, 1},
    {field_parameter, 2, .inherited = true},
  [60] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [62] =
    {field_body, 4},
    {field_name, 0},
    {field_parameters, 2},
  [65] =
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [69] =
    {field_body, 4},
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [73] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [75] =
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [79] =
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [83] =
    {field_body, 5},
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [87] =
    {field_body, 5},
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [91] =
    {field_alternative, 6},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [96] =
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
  [100] =
    {field_body, 6},
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [105] =
    {field_body, 6},
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [109] =
    {field_alternative, 7},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [114] =
    {field_alternative, 7},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [119] =
    {field_alternative, 7},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [124] =
    {field_body, 7},
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [129] =
    {field_body, 7},
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
  [134] =
    {field_alternative, 8},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [139] =
    {field_alternative, 8},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [144] =
    {field_alternative, 8},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
  [149] =
    {field_body, 8},
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
  [154] =
    {field_alternative, 9},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [14] = {
    [1] = alias_sym_string_content,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__single_quoted_string_content, 2,
    aux_sym__single_quoted_string_content,
    alias_sym_string_content,
  aux_sym__double_quoted_string_content, 2,
    aux_sym__double_quoted_string_content,
    alias_sym_string_content,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 5,
  [6] = 6,
  [7] = 3,
  [8] = 2,
  [9] = 5,
  [10] = 6,
  [11] = 3,
  [12] = 2,
  [13] = 5,
  [14] = 6,
  [15] = 3,
  [16] = 2,
  [17] = 5,
  [18] = 2,
  [19] = 3,
  [20] = 5,
  [21] = 3,
  [22] = 2,
  [23] = 5,
  [24] = 6,
  [25] = 3,
  [26] = 2,
  [27] = 5,
  [28] = 6,
  [29] = 3,
  [30] = 2,
  [31] = 5,
  [32] = 6,
  [33] = 3,
  [34] = 6,
  [35] = 5,
  [36] = 6,
  [37] = 3,
  [38] = 2,
  [39] = 5,
  [40] = 6,
  [41] = 6,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 42,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 43,
  [100] = 44,
  [101] = 45,
  [102] = 46,
  [103] = 47,
  [104] = 48,
  [105] = 49,
  [106] = 50,
  [107] = 51,
  [108] = 52,
  [109] = 53,
  [110] = 54,
  [111] = 55,
  [112] = 56,
  [113] = 57,
  [114] = 58,
  [115] = 59,
  [116] = 60,
  [117] = 61,
  [118] = 62,
  [119] = 63,
  [120] = 64,
  [121] = 65,
  [122] = 66,
  [123] = 67,
  [124] = 68,
  [125] = 69,
  [126] = 70,
  [127] = 71,
  [128] = 72,
  [129] = 73,
  [130] = 42,
  [131] = 75,
  [132] = 76,
  [133] = 77,
  [134] = 78,
  [135] = 79,
  [136] = 80,
  [137] = 81,
  [138] = 77,
  [139] = 82,
  [140] = 83,
  [141] = 84,
  [142] = 85,
  [143] = 86,
  [144] = 87,
  [145] = 88,
  [146] = 89,
  [147] = 90,
  [148] = 91,
  [149] = 92,
  [150] = 93,
  [151] = 94,
  [152] = 95,
  [153] = 96,
  [154] = 97,
  [155] = 98,
  [156] = 43,
  [157] = 44,
  [158] = 45,
  [159] = 46,
  [160] = 47,
  [161] = 48,
  [162] = 49,
  [163] = 50,
  [164] = 51,
  [165] = 52,
  [166] = 53,
  [167] = 54,
  [168] = 55,
  [169] = 56,
  [170] = 57,
  [171] = 58,
  [172] = 59,
  [173] = 60,
  [174] = 61,
  [175] = 62,
  [176] = 63,
  [177] = 64,
  [178] = 65,
  [179] = 66,
  [180] = 67,
  [181] = 68,
  [182] = 69,
  [183] = 70,
  [184] = 71,
  [185] = 72,
  [186] = 73,
  [187] = 42,
  [188] = 75,
  [189] = 76,
  [190] = 77,
  [191] = 78,
  [192] = 79,
  [193] = 80,
  [194] = 98,
  [195] = 82,
  [196] = 83,
  [197] = 84,
  [198] = 85,
  [199] = 86,
  [200] = 87,
  [201] = 88,
  [202] = 89,
  [203] = 90,
  [204] = 91,
  [205] = 92,
  [206] = 93,
  [207] = 94,
  [208] = 95,
  [209] = 96,
  [210] = 97,
  [211] = 98,
  [212] = 43,
  [213] = 44,
  [214] = 45,
  [215] = 46,
  [216] = 47,
  [217] = 48,
  [218] = 49,
  [219] = 50,
  [220] = 51,
  [221] = 52,
  [222] = 53,
  [223] = 54,
  [224] = 55,
  [225] = 56,
  [226] = 57,
  [227] = 58,
  [228] = 59,
  [229] = 60,
  [230] = 61,
  [231] = 62,
  [232] = 63,
  [233] = 64,
  [234] = 65,
  [235] = 66,
  [236] = 67,
  [237] = 68,
  [238] = 69,
  [239] = 70,
  [240] = 71,
  [241] = 72,
  [242] = 73,
  [243] = 42,
  [244] = 75,
  [245] = 76,
  [246] = 77,
  [247] = 78,
  [248] = 79,
  [249] = 80,
  [250] = 81,
  [251] = 82,
  [252] = 83,
  [253] = 84,
  [254] = 85,
  [255] = 86,
  [256] = 87,
  [257] = 88,
  [258] = 89,
  [259] = 90,
  [260] = 91,
  [261] = 92,
  [262] = 93,
  [263] = 94,
  [264] = 95,
  [265] = 96,
  [266] = 97,
  [267] = 98,
  [268] = 43,
  [269] = 44,
  [270] = 45,
  [271] = 46,
  [272] = 47,
  [273] = 48,
  [274] = 49,
  [275] = 50,
  [276] = 51,
  [277] = 52,
  [278] = 53,
  [279] = 54,
  [280] = 55,
  [281] = 56,
  [282] = 57,
  [283] = 58,
  [284] = 59,
  [285] = 60,
  [286] = 61,
  [287] = 62,
  [288] = 63,
  [289] = 64,
  [290] = 65,
  [291] = 66,
  [292] = 67,
  [293] = 68,
  [294] = 69,
  [295] = 70,
  [296] = 71,
  [297] = 72,
  [298] = 73,
  [299] = 78,
  [300] = 75,
  [301] = 76,
  [302] = 79,
  [303] = 80,
  [304] = 81,
  [305] = 82,
  [306] = 83,
  [307] = 84,
  [308] = 85,
  [309] = 86,
  [310] = 87,
  [311] = 88,
  [312] = 89,
  [313] = 90,
  [314] = 91,
  [315] = 92,
  [316] = 93,
  [317] = 94,
  [318] = 95,
  [319] = 96,
  [320] = 97,
  [321] = 81,
  [322] = 45,
  [323] = 77,
  [324] = 78,
  [325] = 79,
  [326] = 80,
  [327] = 81,
  [328] = 82,
  [329] = 83,
  [330] = 84,
  [331] = 85,
  [332] = 86,
  [333] = 87,
  [334] = 88,
  [335] = 89,
  [336] = 90,
  [337] = 91,
  [338] = 92,
  [339] = 93,
  [340] = 94,
  [341] = 95,
  [342] = 96,
  [343] = 97,
  [344] = 98,
  [345] = 43,
  [346] = 44,
  [347] = 347,
  [348] = 348,
  [349] = 45,
  [350] = 46,
  [351] = 47,
  [352] = 48,
  [353] = 49,
  [354] = 50,
  [355] = 51,
  [356] = 52,
  [357] = 53,
  [358] = 54,
  [359] = 55,
  [360] = 56,
  [361] = 57,
  [362] = 58,
  [363] = 59,
  [364] = 60,
  [365] = 81,
  [366] = 61,
  [367] = 62,
  [368] = 63,
  [369] = 64,
  [370] = 65,
  [371] = 66,
  [372] = 67,
  [373] = 68,
  [374] = 69,
  [375] = 70,
  [376] = 71,
  [377] = 72,
  [378] = 73,
  [379] = 42,
  [380] = 75,
  [381] = 76,
  [382] = 77,
  [383] = 78,
  [384] = 79,
  [385] = 80,
  [386] = 81,
  [387] = 82,
  [388] = 83,
  [389] = 84,
  [390] = 85,
  [391] = 86,
  [392] = 87,
  [393] = 88,
  [394] = 89,
  [395] = 90,
  [396] = 91,
  [397] = 92,
  [398] = 93,
  [399] = 94,
  [400] = 95,
  [401] = 96,
  [402] = 97,
  [403] = 98,
  [404] = 43,
  [405] = 44,
  [406] = 347,
  [407] = 348,
  [408] = 45,
  [409] = 46,
  [410] = 47,
  [411] = 48,
  [412] = 49,
  [413] = 50,
  [414] = 51,
  [415] = 52,
  [416] = 53,
  [417] = 54,
  [418] = 55,
  [419] = 56,
  [420] = 57,
  [421] = 58,
  [422] = 59,
  [423] = 60,
  [424] = 61,
  [425] = 62,
  [426] = 63,
  [427] = 64,
  [428] = 65,
  [429] = 66,
  [430] = 67,
  [431] = 68,
  [432] = 69,
  [433] = 70,
  [434] = 71,
  [435] = 72,
  [436] = 73,
  [437] = 42,
  [438] = 75,
  [439] = 76,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 82,
  [446] = 83,
  [447] = 84,
  [448] = 85,
  [449] = 86,
  [450] = 87,
  [451] = 88,
  [452] = 89,
  [453] = 90,
  [454] = 91,
  [455] = 455,
  [456] = 347,
  [457] = 348,
  [458] = 92,
  [459] = 93,
  [460] = 94,
  [461] = 95,
  [462] = 96,
  [463] = 97,
  [464] = 98,
  [465] = 43,
  [466] = 44,
  [467] = 467,
  [468] = 468,
  [469] = 347,
  [470] = 348,
  [471] = 46,
  [472] = 47,
  [473] = 48,
  [474] = 49,
  [475] = 50,
  [476] = 51,
  [477] = 52,
  [478] = 53,
  [479] = 54,
  [480] = 55,
  [481] = 56,
  [482] = 443,
  [483] = 57,
  [484] = 58,
  [485] = 59,
  [486] = 60,
  [487] = 61,
  [488] = 62,
  [489] = 63,
  [490] = 64,
  [491] = 65,
  [492] = 455,
  [493] = 347,
  [494] = 348,
  [495] = 66,
  [496] = 67,
  [497] = 68,
  [498] = 69,
  [499] = 70,
  [500] = 71,
  [501] = 72,
  [502] = 73,
  [503] = 42,
  [504] = 75,
  [505] = 76,
  [506] = 77,
  [507] = 78,
  [508] = 79,
  [509] = 80,
  [510] = 81,
  [511] = 82,
  [512] = 83,
  [513] = 84,
  [514] = 443,
  [515] = 85,
  [516] = 86,
  [517] = 87,
  [518] = 88,
  [519] = 89,
  [520] = 90,
  [521] = 91,
  [522] = 442,
  [523] = 93,
  [524] = 94,
  [525] = 95,
  [526] = 96,
  [527] = 97,
  [528] = 98,
  [529] = 43,
  [530] = 44,
  [531] = 455,
  [532] = 347,
  [533] = 348,
  [534] = 467,
  [535] = 468,
  [536] = 347,
  [537] = 348,
  [538] = 45,
  [539] = 46,
  [540] = 47,
  [541] = 48,
  [542] = 49,
  [543] = 50,
  [544] = 51,
  [545] = 52,
  [546] = 53,
  [547] = 54,
  [548] = 55,
  [549] = 56,
  [550] = 57,
  [551] = 58,
  [552] = 59,
  [553] = 347,
  [554] = 348,
  [555] = 60,
  [556] = 556,
  [557] = 61,
  [558] = 443,
  [559] = 62,
  [560] = 63,
  [561] = 64,
  [562] = 65,
  [563] = 66,
  [564] = 67,
  [565] = 68,
  [566] = 69,
  [567] = 70,
  [568] = 71,
  [569] = 72,
  [570] = 73,
  [571] = 42,
  [572] = 75,
  [573] = 76,
  [574] = 455,
  [575] = 347,
  [576] = 348,
  [577] = 77,
  [578] = 78,
  [579] = 79,
  [580] = 80,
  [581] = 81,
  [582] = 82,
  [583] = 83,
  [584] = 84,
  [585] = 85,
  [586] = 86,
  [587] = 87,
  [588] = 88,
  [589] = 89,
  [590] = 90,
  [591] = 91,
  [592] = 92,
  [593] = 93,
  [594] = 443,
  [595] = 94,
  [596] = 95,
  [597] = 96,
  [598] = 97,
  [599] = 98,
  [600] = 43,
  [601] = 44,
  [602] = 467,
  [603] = 347,
  [604] = 348,
  [605] = 455,
  [606] = 347,
  [607] = 348,
  [608] = 45,
  [609] = 46,
  [610] = 47,
  [611] = 48,
  [612] = 49,
  [613] = 50,
  [614] = 51,
  [615] = 52,
  [616] = 53,
  [617] = 54,
  [618] = 55,
  [619] = 56,
  [620] = 57,
  [621] = 58,
  [622] = 59,
  [623] = 60,
  [624] = 77,
  [625] = 61,
  [626] = 78,
  [627] = 79,
  [628] = 62,
  [629] = 63,
  [630] = 64,
  [631] = 80,
  [632] = 65,
  [633] = 440,
  [634] = 441,
  [635] = 442,
  [636] = 66,
  [637] = 67,
  [638] = 68,
  [639] = 69,
  [640] = 468,
  [641] = 70,
  [642] = 71,
  [643] = 72,
  [644] = 73,
  [645] = 42,
  [646] = 75,
  [647] = 76,
  [648] = 347,
  [649] = 348,
  [650] = 440,
  [651] = 441,
  [652] = 442,
  [653] = 468,
  [654] = 440,
  [655] = 441,
  [656] = 442,
  [657] = 468,
  [658] = 440,
  [659] = 441,
  [660] = 442,
  [661] = 468,
  [662] = 440,
  [663] = 441,
  [664] = 442,
  [665] = 468,
  [666] = 440,
  [667] = 441,
  [668] = 442,
  [669] = 468,
  [670] = 440,
  [671] = 441,
  [672] = 442,
  [673] = 468,
  [674] = 440,
  [675] = 441,
  [676] = 442,
  [677] = 468,
  [678] = 440,
  [679] = 441,
  [680] = 442,
  [681] = 468,
  [682] = 440,
  [683] = 441,
  [684] = 442,
  [685] = 468,
  [686] = 440,
  [687] = 441,
  [688] = 92,
  [689] = 443,
  [690] = 690,
  [691] = 691,
  [692] = 455,
  [693] = 443,
  [694] = 455,
  [695] = 691,
  [696] = 443,
  [697] = 690,
  [698] = 455,
  [699] = 690,
  [700] = 443,
  [701] = 455,
  [702] = 702,
  [703] = 455,
  [704] = 691,
  [705] = 690,
  [706] = 443,
  [707] = 690,
  [708] = 690,
  [709] = 690,
  [710] = 690,
  [711] = 690,
  [712] = 690,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 714,
  [717] = 715,
  [718] = 718,
  [719] = 713,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 714,
  [726] = 715,
  [727] = 718,
  [728] = 713,
  [729] = 720,
  [730] = 721,
  [731] = 722,
  [732] = 723,
  [733] = 724,
  [734] = 718,
  [735] = 713,
  [736] = 720,
  [737] = 721,
  [738] = 722,
  [739] = 723,
  [740] = 724,
  [741] = 714,
  [742] = 715,
  [743] = 714,
  [744] = 715,
  [745] = 718,
  [746] = 713,
  [747] = 720,
  [748] = 721,
  [749] = 722,
  [750] = 723,
  [751] = 724,
  [752] = 718,
  [753] = 720,
  [754] = 721,
  [755] = 722,
  [756] = 723,
  [757] = 724,
  [758] = 714,
  [759] = 724,
  [760] = 718,
  [761] = 714,
  [762] = 715,
  [763] = 713,
  [764] = 764,
  [765] = 765,
  [766] = 720,
  [767] = 723,
  [768] = 721,
  [769] = 713,
  [770] = 724,
  [771] = 764,
  [772] = 718,
  [773] = 722,
  [774] = 713,
  [775] = 714,
  [776] = 720,
  [777] = 721,
  [778] = 715,
  [779] = 722,
  [780] = 720,
  [781] = 721,
  [782] = 714,
  [783] = 722,
  [784] = 723,
  [785] = 765,
  [786] = 765,
  [787] = 723,
  [788] = 724,
  [789] = 723,
  [790] = 718,
  [791] = 713,
  [792] = 720,
  [793] = 721,
  [794] = 722,
  [795] = 718,
  [796] = 713,
  [797] = 720,
  [798] = 721,
  [799] = 723,
  [800] = 724,
  [801] = 765,
  [802] = 724,
  [803] = 718,
  [804] = 765,
  [805] = 764,
  [806] = 715,
  [807] = 714,
  [808] = 715,
  [809] = 715,
  [810] = 722,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 811,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 813,
  [821] = 814,
  [822] = 815,
  [823] = 811,
  [824] = 824,
  [825] = 817,
  [826] = 818,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 812,
  [831] = 831,
  [832] = 765,
  [833] = 831,
  [834] = 819,
  [835] = 827,
  [836] = 828,
  [837] = 829,
  [838] = 824,
  [839] = 812,
  [840] = 813,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 814,
  [846] = 815,
  [847] = 841,
  [848] = 842,
  [849] = 849,
  [850] = 843,
  [851] = 844,
  [852] = 849,
  [853] = 853,
  [854] = 854,
  [855] = 831,
  [856] = 853,
  [857] = 854,
  [858] = 831,
  [859] = 765,
  [860] = 817,
  [861] = 818,
  [862] = 819,
  [863] = 813,
  [864] = 814,
  [865] = 815,
  [866] = 831,
  [867] = 831,
  [868] = 811,
  [869] = 765,
  [870] = 817,
  [871] = 827,
  [872] = 828,
  [873] = 829,
  [874] = 812,
  [875] = 818,
  [876] = 831,
  [877] = 819,
  [878] = 813,
  [879] = 814,
  [880] = 815,
  [881] = 824,
  [882] = 811,
  [883] = 824,
  [884] = 884,
  [885] = 817,
  [886] = 818,
  [887] = 827,
  [888] = 828,
  [889] = 829,
  [890] = 812,
  [891] = 831,
  [892] = 765,
  [893] = 841,
  [894] = 819,
  [895] = 841,
  [896] = 842,
  [897] = 884,
  [898] = 842,
  [899] = 843,
  [900] = 844,
  [901] = 884,
  [902] = 827,
  [903] = 843,
  [904] = 884,
  [905] = 849,
  [906] = 884,
  [907] = 844,
  [908] = 849,
  [909] = 828,
  [910] = 884,
  [911] = 824,
  [912] = 853,
  [913] = 854,
  [914] = 831,
  [915] = 884,
  [916] = 831,
  [917] = 853,
  [918] = 884,
  [919] = 854,
  [920] = 841,
  [921] = 884,
  [922] = 842,
  [923] = 831,
  [924] = 884,
  [925] = 843,
  [926] = 884,
  [927] = 844,
  [928] = 849,
  [929] = 765,
  [930] = 853,
  [931] = 884,
  [932] = 854,
  [933] = 831,
  [934] = 829,
  [935] = 841,
  [936] = 936,
  [937] = 828,
  [938] = 818,
  [939] = 841,
  [940] = 811,
  [941] = 841,
  [942] = 843,
  [943] = 853,
  [944] = 854,
  [945] = 843,
  [946] = 815,
  [947] = 824,
  [948] = 844,
  [949] = 819,
  [950] = 827,
  [951] = 936,
  [952] = 828,
  [953] = 842,
  [954] = 829,
  [955] = 812,
  [956] = 827,
  [957] = 854,
  [958] = 813,
  [959] = 814,
  [960] = 811,
  [961] = 811,
  [962] = 841,
  [963] = 963,
  [964] = 811,
  [965] = 849,
  [966] = 824,
  [967] = 967,
  [968] = 968,
  [969] = 844,
  [970] = 842,
  [971] = 819,
  [972] = 843,
  [973] = 844,
  [974] = 817,
  [975] = 829,
  [976] = 963,
  [977] = 812,
  [978] = 824,
  [979] = 967,
  [980] = 849,
  [981] = 815,
  [982] = 818,
  [983] = 815,
  [984] = 842,
  [985] = 985,
  [986] = 819,
  [987] = 817,
  [988] = 812,
  [989] = 989,
  [990] = 841,
  [991] = 824,
  [992] = 854,
  [993] = 842,
  [994] = 968,
  [995] = 813,
  [996] = 828,
  [997] = 849,
  [998] = 829,
  [999] = 963,
  [1000] = 814,
  [1001] = 968,
  [1002] = 1002,
  [1003] = 813,
  [1004] = 843,
  [1005] = 819,
  [1006] = 827,
  [1007] = 842,
  [1008] = 968,
  [1009] = 817,
  [1010] = 817,
  [1011] = 843,
  [1012] = 844,
  [1013] = 963,
  [1014] = 849,
  [1015] = 968,
  [1016] = 818,
  [1017] = 853,
  [1018] = 853,
  [1019] = 811,
  [1020] = 963,
  [1021] = 827,
  [1022] = 968,
  [1023] = 827,
  [1024] = 967,
  [1025] = 936,
  [1026] = 817,
  [1027] = 963,
  [1028] = 818,
  [1029] = 968,
  [1030] = 828,
  [1031] = 963,
  [1032] = 854,
  [1033] = 819,
  [1034] = 963,
  [1035] = 828,
  [1036] = 968,
  [1037] = 813,
  [1038] = 814,
  [1039] = 968,
  [1040] = 813,
  [1041] = 963,
  [1042] = 829,
  [1043] = 968,
  [1044] = 818,
  [1045] = 844,
  [1046] = 849,
  [1047] = 814,
  [1048] = 963,
  [1049] = 814,
  [1050] = 968,
  [1051] = 829,
  [1052] = 853,
  [1053] = 854,
  [1054] = 812,
  [1055] = 963,
  [1056] = 815,
  [1057] = 968,
  [1058] = 812,
  [1059] = 815,
  [1060] = 824,
  [1061] = 853,
  [1062] = 963,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1065,
  [1078] = 1078,
  [1079] = 1068,
  [1080] = 1074,
  [1081] = 1081,
  [1082] = 1081,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1083,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1085,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1087,
  [1097] = 1097,
  [1098] = 1089,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1066,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1067,
  [1117] = 1069,
  [1118] = 1070,
  [1119] = 1071,
  [1120] = 1120,
  [1121] = 1076,
  [1122] = 1078,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1084,
  [1127] = 1064,
  [1128] = 1088,
  [1129] = 1090,
  [1130] = 1130,
  [1131] = 1115,
  [1132] = 1094,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1097,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1099,
  [1141] = 1100,
  [1142] = 1101,
  [1143] = 1104,
  [1144] = 1105,
  [1145] = 1066,
  [1146] = 1107,
  [1147] = 1108,
  [1148] = 1091,
  [1149] = 1109,
  [1150] = 1110,
  [1151] = 1151,
  [1152] = 1111,
  [1153] = 1153,
  [1154] = 1120,
  [1155] = 1124,
  [1156] = 1125,
  [1157] = 1064,
  [1158] = 1130,
  [1159] = 1159,
  [1160] = 1133,
  [1161] = 1134,
  [1162] = 1135,
  [1163] = 1137,
  [1164] = 1138,
  [1165] = 1139,
  [1166] = 1072,
  [1167] = 1073,
  [1168] = 1151,
  [1169] = 1153,
  [1170] = 1075,
  [1171] = 1065,
  [1172] = 1068,
  [1173] = 1074,
  [1174] = 1072,
  [1175] = 1081,
  [1176] = 1073,
  [1177] = 1075,
  [1178] = 1083,
  [1179] = 1065,
  [1180] = 1068,
  [1181] = 1085,
  [1182] = 1074,
  [1183] = 1081,
  [1184] = 1087,
  [1185] = 1083,
  [1186] = 1085,
  [1187] = 1089,
  [1188] = 1087,
  [1189] = 1089,
  [1190] = 1091,
  [1191] = 1091,
  [1192] = 1092,
  [1193] = 1092,
  [1194] = 1092,
  [1195] = 1102,
  [1196] = 1103,
  [1197] = 1102,
  [1198] = 1103,
  [1199] = 1112,
  [1200] = 1113,
  [1201] = 1114,
  [1202] = 1115,
  [1203] = 1067,
  [1204] = 1069,
  [1205] = 1070,
  [1206] = 1071,
  [1207] = 1076,
  [1208] = 1078,
  [1209] = 1112,
  [1210] = 1113,
  [1211] = 1114,
  [1212] = 1084,
  [1213] = 1088,
  [1214] = 1090,
  [1215] = 1115,
  [1216] = 1094,
  [1217] = 1067,
  [1218] = 1097,
  [1219] = 1069,
  [1220] = 1070,
  [1221] = 1099,
  [1222] = 1100,
  [1223] = 1101,
  [1224] = 1104,
  [1225] = 1105,
  [1226] = 1071,
  [1227] = 1076,
  [1228] = 1078,
  [1229] = 1066,
  [1230] = 1107,
  [1231] = 1108,
  [1232] = 1109,
  [1233] = 1084,
  [1234] = 1110,
  [1235] = 1111,
  [1236] = 1088,
  [1237] = 1090,
  [1238] = 1120,
  [1239] = 1124,
  [1240] = 1125,
  [1241] = 1094,
  [1242] = 1130,
  [1243] = 1159,
  [1244] = 1133,
  [1245] = 1134,
  [1246] = 1135,
  [1247] = 1137,
  [1248] = 1138,
  [1249] = 1139,
  [1250] = 1097,
  [1251] = 1102,
  [1252] = 1099,
  [1253] = 1100,
  [1254] = 1151,
  [1255] = 1153,
  [1256] = 1101,
  [1257] = 1104,
  [1258] = 1105,
  [1259] = 1259,
  [1260] = 1066,
  [1261] = 1072,
  [1262] = 1073,
  [1263] = 1107,
  [1264] = 1075,
  [1265] = 1065,
  [1266] = 1108,
  [1267] = 1068,
  [1268] = 1074,
  [1269] = 1109,
  [1270] = 1081,
  [1271] = 1083,
  [1272] = 1110,
  [1273] = 1085,
  [1274] = 1087,
  [1275] = 1111,
  [1276] = 1089,
  [1277] = 1103,
  [1278] = 1091,
  [1279] = 1092,
  [1280] = 1120,
  [1281] = 1123,
  [1282] = 1124,
  [1283] = 1125,
  [1284] = 1064,
  [1285] = 1130,
  [1286] = 1159,
  [1287] = 1133,
  [1288] = 1134,
  [1289] = 1135,
  [1290] = 1102,
  [1291] = 1103,
  [1292] = 1137,
  [1293] = 1138,
  [1294] = 1139,
  [1295] = 1107,
  [1296] = 1102,
  [1297] = 1103,
  [1298] = 1151,
  [1299] = 1151,
  [1300] = 1153,
  [1301] = 1112,
  [1302] = 1113,
  [1303] = 1114,
  [1304] = 1115,
  [1305] = 1153,
  [1306] = 1067,
  [1307] = 1069,
  [1308] = 1070,
  [1309] = 1071,
  [1310] = 1076,
  [1311] = 1078,
  [1312] = 1072,
  [1313] = 1073,
  [1314] = 1084,
  [1315] = 1088,
  [1316] = 1090,
  [1317] = 1075,
  [1318] = 1094,
  [1319] = 1065,
  [1320] = 1068,
  [1321] = 1097,
  [1322] = 1074,
  [1323] = 1099,
  [1324] = 1100,
  [1325] = 1101,
  [1326] = 1104,
  [1327] = 1105,
  [1328] = 1066,
  [1329] = 1107,
  [1330] = 1108,
  [1331] = 1109,
  [1332] = 1110,
  [1333] = 1111,
  [1334] = 1120,
  [1335] = 1124,
  [1336] = 1125,
  [1337] = 1064,
  [1338] = 1130,
  [1339] = 1159,
  [1340] = 1133,
  [1341] = 1134,
  [1342] = 1135,
  [1343] = 1137,
  [1344] = 1138,
  [1345] = 1139,
  [1346] = 1151,
  [1347] = 1153,
  [1348] = 1081,
  [1349] = 1072,
  [1350] = 1073,
  [1351] = 1075,
  [1352] = 1065,
  [1353] = 1068,
  [1354] = 1074,
  [1355] = 1081,
  [1356] = 1083,
  [1357] = 1085,
  [1358] = 1087,
  [1359] = 1089,
  [1360] = 1091,
  [1361] = 1092,
  [1362] = 1083,
  [1363] = 1102,
  [1364] = 1103,
  [1365] = 1112,
  [1366] = 1113,
  [1367] = 1114,
  [1368] = 1115,
  [1369] = 1067,
  [1370] = 1069,
  [1371] = 1070,
  [1372] = 1071,
  [1373] = 1076,
  [1374] = 1078,
  [1375] = 1084,
  [1376] = 1088,
  [1377] = 1090,
  [1378] = 1094,
  [1379] = 1097,
  [1380] = 1380,
  [1381] = 1099,
  [1382] = 1100,
  [1383] = 1101,
  [1384] = 1104,
  [1385] = 1105,
  [1386] = 1085,
  [1387] = 1387,
  [1388] = 1087,
  [1389] = 1089,
  [1390] = 1066,
  [1391] = 1107,
  [1392] = 1091,
  [1393] = 1108,
  [1394] = 1109,
  [1395] = 1092,
  [1396] = 1110,
  [1397] = 1112,
  [1398] = 1111,
  [1399] = 1113,
  [1400] = 1114,
  [1401] = 1112,
  [1402] = 1120,
  [1403] = 1124,
  [1404] = 1125,
  [1405] = 1064,
  [1406] = 1130,
  [1407] = 1159,
  [1408] = 1133,
  [1409] = 1134,
  [1410] = 1135,
  [1411] = 1137,
  [1412] = 1138,
  [1413] = 1139,
  [1414] = 1113,
  [1415] = 1115,
  [1416] = 1114,
  [1417] = 1067,
  [1418] = 1069,
  [1419] = 1102,
  [1420] = 1103,
  [1421] = 1151,
  [1422] = 1153,
  [1423] = 1070,
  [1424] = 1071,
  [1425] = 1108,
  [1426] = 1426,
  [1427] = 1076,
  [1428] = 1078,
  [1429] = 1115,
  [1430] = 1072,
  [1431] = 1084,
  [1432] = 1073,
  [1433] = 1109,
  [1434] = 1075,
  [1435] = 1088,
  [1436] = 1065,
  [1437] = 1090,
  [1438] = 1068,
  [1439] = 1067,
  [1440] = 1074,
  [1441] = 1081,
  [1442] = 1094,
  [1443] = 1083,
  [1444] = 1069,
  [1445] = 1085,
  [1446] = 1070,
  [1447] = 1087,
  [1448] = 1071,
  [1449] = 1089,
  [1450] = 1097,
  [1451] = 1091,
  [1452] = 1112,
  [1453] = 1092,
  [1454] = 1113,
  [1455] = 1114,
  [1456] = 1110,
  [1457] = 1115,
  [1458] = 1076,
  [1459] = 1099,
  [1460] = 1067,
  [1461] = 1100,
  [1462] = 1069,
  [1463] = 1070,
  [1464] = 1071,
  [1465] = 1102,
  [1466] = 1103,
  [1467] = 1101,
  [1468] = 1104,
  [1469] = 1076,
  [1470] = 1078,
  [1471] = 1105,
  [1472] = 1078,
  [1473] = 1084,
  [1474] = 1111,
  [1475] = 1088,
  [1476] = 1090,
  [1477] = 1084,
  [1478] = 1094,
  [1479] = 1066,
  [1480] = 1107,
  [1481] = 1097,
  [1482] = 1088,
  [1483] = 1112,
  [1484] = 1113,
  [1485] = 1114,
  [1486] = 1115,
  [1487] = 1108,
  [1488] = 1090,
  [1489] = 1067,
  [1490] = 1099,
  [1491] = 1069,
  [1492] = 1070,
  [1493] = 1071,
  [1494] = 1100,
  [1495] = 1076,
  [1496] = 1078,
  [1497] = 1101,
  [1498] = 1104,
  [1499] = 1105,
  [1500] = 1084,
  [1501] = 1109,
  [1502] = 1088,
  [1503] = 1090,
  [1504] = 1072,
  [1505] = 1110,
  [1506] = 1094,
  [1507] = 1111,
  [1508] = 1066,
  [1509] = 1097,
  [1510] = 1094,
  [1511] = 1107,
  [1512] = 1073,
  [1513] = 1099,
  [1514] = 1100,
  [1515] = 1101,
  [1516] = 1104,
  [1517] = 1105,
  [1518] = 1108,
  [1519] = 1109,
  [1520] = 1075,
  [1521] = 1110,
  [1522] = 1066,
  [1523] = 1120,
  [1524] = 1107,
  [1525] = 1111,
  [1526] = 1108,
  [1527] = 1123,
  [1528] = 1109,
  [1529] = 1124,
  [1530] = 1110,
  [1531] = 1125,
  [1532] = 1111,
  [1533] = 1064,
  [1534] = 1120,
  [1535] = 1123,
  [1536] = 1124,
  [1537] = 1120,
  [1538] = 1124,
  [1539] = 1125,
  [1540] = 1064,
  [1541] = 1130,
  [1542] = 1159,
  [1543] = 1133,
  [1544] = 1134,
  [1545] = 1135,
  [1546] = 1137,
  [1547] = 1138,
  [1548] = 1139,
  [1549] = 1125,
  [1550] = 1064,
  [1551] = 1130,
  [1552] = 1159,
  [1553] = 1133,
  [1554] = 1134,
  [1555] = 1135,
  [1556] = 1137,
  [1557] = 1138,
  [1558] = 1151,
  [1559] = 1153,
  [1560] = 1139,
  [1561] = 1130,
  [1562] = 1159,
  [1563] = 1133,
  [1564] = 1134,
  [1565] = 1135,
  [1566] = 1137,
  [1567] = 1138,
  [1568] = 1072,
  [1569] = 1139,
  [1570] = 1073,
  [1571] = 1097,
  [1572] = 1075,
  [1573] = 1151,
  [1574] = 1065,
  [1575] = 1153,
  [1576] = 1068,
  [1577] = 1074,
  [1578] = 1081,
  [1579] = 1065,
  [1580] = 1083,
  [1581] = 1085,
  [1582] = 1099,
  [1583] = 1087,
  [1584] = 1100,
  [1585] = 1089,
  [1586] = 1101,
  [1587] = 1091,
  [1588] = 1104,
  [1589] = 1092,
  [1590] = 1105,
  [1591] = 1072,
  [1592] = 1151,
  [1593] = 1073,
  [1594] = 1153,
  [1595] = 1075,
  [1596] = 1068,
  [1597] = 1065,
  [1598] = 1068,
  [1599] = 1074,
  [1600] = 1074,
  [1601] = 1102,
  [1602] = 1103,
  [1603] = 1099,
  [1604] = 1081,
  [1605] = 1081,
  [1606] = 1083,
  [1607] = 1066,
  [1608] = 1085,
  [1609] = 1100,
  [1610] = 1087,
  [1611] = 1107,
  [1612] = 1089,
  [1613] = 1083,
  [1614] = 1091,
  [1615] = 1072,
  [1616] = 1092,
  [1617] = 1108,
  [1618] = 1073,
  [1619] = 1120,
  [1620] = 1075,
  [1621] = 1109,
  [1622] = 1112,
  [1623] = 1113,
  [1624] = 1114,
  [1625] = 1115,
  [1626] = 1065,
  [1627] = 1085,
  [1628] = 1067,
  [1629] = 1068,
  [1630] = 1069,
  [1631] = 1070,
  [1632] = 1071,
  [1633] = 1110,
  [1634] = 1076,
  [1635] = 1078,
  [1636] = 1074,
  [1637] = 1123,
  [1638] = 1081,
  [1639] = 1084,
  [1640] = 1102,
  [1641] = 1088,
  [1642] = 1090,
  [1643] = 1103,
  [1644] = 1111,
  [1645] = 1094,
  [1646] = 1083,
  [1647] = 1087,
  [1648] = 1085,
  [1649] = 1097,
  [1650] = 1124,
  [1651] = 1087,
  [1652] = 1089,
  [1653] = 1089,
  [1654] = 1125,
  [1655] = 1091,
  [1656] = 1120,
  [1657] = 1092,
  [1658] = 1123,
  [1659] = 1259,
  [1660] = 1124,
  [1661] = 1380,
  [1662] = 1387,
  [1663] = 1125,
  [1664] = 1426,
  [1665] = 1064,
  [1666] = 1112,
  [1667] = 1113,
  [1668] = 1114,
  [1669] = 1115,
  [1670] = 1130,
  [1671] = 1159,
  [1672] = 1067,
  [1673] = 1133,
  [1674] = 1069,
  [1675] = 1070,
  [1676] = 1071,
  [1677] = 1134,
  [1678] = 1135,
  [1679] = 1076,
  [1680] = 1078,
  [1681] = 1137,
  [1682] = 1138,
  [1683] = 1139,
  [1684] = 1259,
  [1685] = 1380,
  [1686] = 1387,
  [1687] = 1426,
  [1688] = 1084,
  [1689] = 1091,
  [1690] = 1088,
  [1691] = 1090,
  [1692] = 1064,
  [1693] = 1092,
  [1694] = 1094,
  [1695] = 1259,
  [1696] = 1380,
  [1697] = 1387,
  [1698] = 1426,
  [1699] = 1102,
  [1700] = 1103,
  [1701] = 1130,
  [1702] = 1097,
  [1703] = 1159,
  [1704] = 1133,
  [1705] = 1259,
  [1706] = 1380,
  [1707] = 1387,
  [1708] = 1426,
  [1709] = 1099,
  [1710] = 1100,
  [1711] = 1101,
  [1712] = 1104,
  [1713] = 1105,
  [1714] = 1134,
  [1715] = 1259,
  [1716] = 1380,
  [1717] = 1387,
  [1718] = 1426,
  [1719] = 1151,
  [1720] = 1153,
  [1721] = 1066,
  [1722] = 1107,
  [1723] = 1259,
  [1724] = 1380,
  [1725] = 1387,
  [1726] = 1426,
  [1727] = 1108,
  [1728] = 1109,
  [1729] = 1110,
  [1730] = 1135,
  [1731] = 1111,
  [1732] = 1259,
  [1733] = 1380,
  [1734] = 1387,
  [1735] = 1426,
  [1736] = 1137,
  [1737] = 1138,
  [1738] = 1139,
  [1739] = 1120,
  [1740] = 1124,
  [1741] = 1125,
  [1742] = 1259,
  [1743] = 1380,
  [1744] = 1387,
  [1745] = 1426,
  [1746] = 1064,
  [1747] = 1130,
  [1748] = 1159,
  [1749] = 1133,
  [1750] = 1134,
  [1751] = 1135,
  [1752] = 1137,
  [1753] = 1259,
  [1754] = 1380,
  [1755] = 1387,
  [1756] = 1426,
  [1757] = 1138,
  [1758] = 1139,
  [1759] = 1072,
  [1760] = 1101,
  [1761] = 1073,
  [1762] = 1104,
  [1763] = 1112,
  [1764] = 1259,
  [1765] = 1380,
  [1766] = 1387,
  [1767] = 1426,
  [1768] = 1113,
  [1769] = 1114,
  [1770] = 1075,
  [1771] = 1151,
  [1772] = 1153,
  [1773] = 1105,
  [1774] = 1259,
  [1775] = 1380,
  [1776] = 1387,
  [1777] = 1426,
  [1778] = 1159,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1779,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1781,
  [1786] = 1779,
  [1787] = 1787,
  [1788] = 1780,
  [1789] = 1781,
  [1790] = 1779,
  [1791] = 1787,
  [1792] = 1780,
  [1793] = 1781,
  [1794] = 1779,
  [1795] = 1787,
  [1796] = 1780,
  [1797] = 1781,
  [1798] = 1779,
  [1799] = 1787,
  [1800] = 1780,
  [1801] = 1781,
  [1802] = 1779,
  [1803] = 1787,
  [1804] = 1780,
  [1805] = 1781,
  [1806] = 1779,
  [1807] = 1787,
  [1808] = 1780,
  [1809] = 1781,
  [1810] = 1779,
  [1811] = 1787,
  [1812] = 1780,
  [1813] = 1781,
  [1814] = 1779,
  [1815] = 1787,
  [1816] = 1780,
  [1817] = 1781,
  [1818] = 1784,
  [1819] = 1787,
  [1820] = 1780,
  [1821] = 1781,
  [1822] = 1779,
  [1823] = 1787,
  [1824] = 1780,
  [1825] = 1781,
  [1826] = 1779,
  [1827] = 1787,
  [1828] = 1780,
  [1829] = 1783,
  [1830] = 1784,
  [1831] = 1783,
  [1832] = 1784,
  [1833] = 1783,
  [1834] = 1784,
  [1835] = 1783,
  [1836] = 1784,
  [1837] = 1783,
  [1838] = 1784,
  [1839] = 1783,
  [1840] = 1784,
  [1841] = 1783,
  [1842] = 1784,
  [1843] = 1783,
  [1844] = 1784,
  [1845] = 1783,
  [1846] = 1784,
  [1847] = 1783,
  [1848] = 1784,
  [1849] = 1783,
  [1850] = 1787,
  [1851] = 455,
  [1852] = 443,
  [1853] = 443,
  [1854] = 455,
  [1855] = 690,
  [1856] = 5,
  [1857] = 2,
  [1858] = 3,
  [1859] = 2,
  [1860] = 690,
  [1861] = 6,
  [1862] = 3,
  [1863] = 5,
  [1864] = 6,
  [1865] = 89,
  [1866] = 64,
  [1867] = 65,
  [1868] = 66,
  [1869] = 67,
  [1870] = 68,
  [1871] = 69,
  [1872] = 48,
  [1873] = 70,
  [1874] = 71,
  [1875] = 72,
  [1876] = 73,
  [1877] = 42,
  [1878] = 75,
  [1879] = 76,
  [1880] = 45,
  [1881] = 49,
  [1882] = 44,
  [1883] = 46,
  [1884] = 54,
  [1885] = 55,
  [1886] = 50,
  [1887] = 56,
  [1888] = 51,
  [1889] = 52,
  [1890] = 53,
  [1891] = 57,
  [1892] = 765,
  [1893] = 43,
  [1894] = 59,
  [1895] = 60,
  [1896] = 77,
  [1897] = 78,
  [1898] = 79,
  [1899] = 80,
  [1900] = 81,
  [1901] = 61,
  [1902] = 62,
  [1903] = 63,
  [1904] = 82,
  [1905] = 83,
  [1906] = 84,
  [1907] = 85,
  [1908] = 86,
  [1909] = 87,
  [1910] = 88,
  [1911] = 47,
  [1912] = 90,
  [1913] = 91,
  [1914] = 92,
  [1915] = 93,
  [1916] = 94,
  [1917] = 95,
  [1918] = 96,
  [1919] = 97,
  [1920] = 98,
  [1921] = 58,
  [1922] = 1922,
  [1923] = 97,
  [1924] = 57,
  [1925] = 50,
  [1926] = 51,
  [1927] = 66,
  [1928] = 67,
  [1929] = 83,
  [1930] = 68,
  [1931] = 84,
  [1932] = 98,
  [1933] = 69,
  [1934] = 1934,
  [1935] = 1935,
  [1936] = 1922,
  [1937] = 1937,
  [1938] = 58,
  [1939] = 43,
  [1940] = 1934,
  [1941] = 70,
  [1942] = 1935,
  [1943] = 71,
  [1944] = 1922,
  [1945] = 1937,
  [1946] = 59,
  [1947] = 1934,
  [1948] = 1935,
  [1949] = 1922,
  [1950] = 1937,
  [1951] = 44,
  [1952] = 77,
  [1953] = 52,
  [1954] = 1934,
  [1955] = 1935,
  [1956] = 1922,
  [1957] = 1937,
  [1958] = 72,
  [1959] = 73,
  [1960] = 765,
  [1961] = 1934,
  [1962] = 1935,
  [1963] = 1922,
  [1964] = 1937,
  [1965] = 42,
  [1966] = 1934,
  [1967] = 75,
  [1968] = 1935,
  [1969] = 1922,
  [1970] = 1937,
  [1971] = 86,
  [1972] = 87,
  [1973] = 1934,
  [1974] = 76,
  [1975] = 1935,
  [1976] = 1935,
  [1977] = 1922,
  [1978] = 1937,
  [1979] = 53,
  [1980] = 45,
  [1981] = 1934,
  [1982] = 78,
  [1983] = 1935,
  [1984] = 1922,
  [1985] = 1937,
  [1986] = 46,
  [1987] = 60,
  [1988] = 79,
  [1989] = 88,
  [1990] = 1934,
  [1991] = 85,
  [1992] = 1934,
  [1993] = 1935,
  [1994] = 1994,
  [1995] = 1922,
  [1996] = 1937,
  [1997] = 89,
  [1998] = 1934,
  [1999] = 1935,
  [2000] = 1922,
  [2001] = 1937,
  [2002] = 2002,
  [2003] = 61,
  [2004] = 1994,
  [2005] = 2002,
  [2006] = 90,
  [2007] = 1994,
  [2008] = 91,
  [2009] = 2002,
  [2010] = 1994,
  [2011] = 55,
  [2012] = 2002,
  [2013] = 1994,
  [2014] = 92,
  [2015] = 2002,
  [2016] = 47,
  [2017] = 1994,
  [2018] = 93,
  [2019] = 80,
  [2020] = 2002,
  [2021] = 62,
  [2022] = 1994,
  [2023] = 48,
  [2024] = 2002,
  [2025] = 1994,
  [2026] = 63,
  [2027] = 2002,
  [2028] = 94,
  [2029] = 1994,
  [2030] = 64,
  [2031] = 2002,
  [2032] = 1994,
  [2033] = 81,
  [2034] = 2002,
  [2035] = 1994,
  [2036] = 1937,
  [2037] = 2002,
  [2038] = 95,
  [2039] = 1994,
  [2040] = 82,
  [2041] = 1934,
  [2042] = 2002,
  [2043] = 1935,
  [2044] = 96,
  [2045] = 1922,
  [2046] = 56,
  [2047] = 49,
  [2048] = 1937,
  [2049] = 65,
  [2050] = 2050,
  [2051] = 54,
  [2052] = 2052,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 714,
  [2056] = 715,
  [2057] = 2057,
  [2058] = 713,
  [2059] = 2059,
  [2060] = 2060,
  [2061] = 2054,
  [2062] = 718,
  [2063] = 2063,
  [2064] = 720,
  [2065] = 721,
  [2066] = 2053,
  [2067] = 2052,
  [2068] = 723,
  [2069] = 2069,
  [2070] = 2069,
  [2071] = 724,
  [2072] = 2057,
  [2073] = 722,
  [2074] = 2052,
  [2075] = 2054,
  [2076] = 2059,
  [2077] = 2057,
  [2078] = 2053,
  [2079] = 2069,
  [2080] = 2063,
  [2081] = 2059,
  [2082] = 2063,
  [2083] = 713,
  [2084] = 765,
  [2085] = 715,
  [2086] = 721,
  [2087] = 720,
  [2088] = 723,
  [2089] = 722,
  [2090] = 718,
  [2091] = 714,
  [2092] = 724,
  [2093] = 2093,
  [2094] = 824,
  [2095] = 2095,
  [2096] = 814,
  [2097] = 854,
  [2098] = 812,
  [2099] = 843,
  [2100] = 815,
  [2101] = 829,
  [2102] = 811,
  [2103] = 844,
  [2104] = 841,
  [2105] = 2105,
  [2106] = 817,
  [2107] = 818,
  [2108] = 827,
  [2109] = 828,
  [2110] = 842,
  [2111] = 2111,
  [2112] = 849,
  [2113] = 819,
  [2114] = 853,
  [2115] = 813,
  [2116] = 849,
  [2117] = 819,
  [2118] = 842,
  [2119] = 841,
  [2120] = 843,
  [2121] = 844,
  [2122] = 827,
  [2123] = 829,
  [2124] = 828,
  [2125] = 853,
  [2126] = 824,
  [2127] = 854,
  [2128] = 813,
  [2129] = 811,
  [2130] = 814,
  [2131] = 815,
  [2132] = 817,
  [2133] = 818,
  [2134] = 812,
  [2135] = 2135,
  [2136] = 2136,
  [2137] = 2136,
  [2138] = 2138,
  [2139] = 2136,
  [2140] = 2138,
  [2141] = 2138,
  [2142] = 2138,
  [2143] = 2136,
  [2144] = 2136,
  [2145] = 2138,
  [2146] = 2138,
  [2147] = 2138,
  [2148] = 2136,
  [2149] = 2136,
  [2150] = 2136,
  [2151] = 2138,
  [2152] = 2136,
  [2153] = 2138,
  [2154] = 2136,
  [2155] = 2138,
  [2156] = 2138,
  [2157] = 2157,
  [2158] = 2138,
  [2159] = 2136,
  [2160] = 2136,
  [2161] = 2161,
  [2162] = 2162,
  [2163] = 2163,
  [2164] = 2164,
  [2165] = 2163,
  [2166] = 2161,
  [2167] = 2161,
  [2168] = 2168,
  [2169] = 2169,
  [2170] = 2170,
  [2171] = 2169,
  [2172] = 2161,
  [2173] = 2173,
  [2174] = 2169,
  [2175] = 2169,
  [2176] = 2169,
  [2177] = 2161,
  [2178] = 2161,
  [2179] = 2169,
  [2180] = 2163,
  [2181] = 2168,
  [2182] = 2163,
  [2183] = 2169,
  [2184] = 2184,
  [2185] = 2169,
  [2186] = 2168,
  [2187] = 2168,
  [2188] = 2163,
  [2189] = 2163,
  [2190] = 2163,
  [2191] = 2191,
  [2192] = 2168,
  [2193] = 2161,
  [2194] = 2161,
  [2195] = 2169,
  [2196] = 2161,
  [2197] = 2169,
  [2198] = 2168,
  [2199] = 2168,
  [2200] = 2200,
  [2201] = 2163,
  [2202] = 2170,
  [2203] = 2169,
  [2204] = 2168,
  [2205] = 2200,
  [2206] = 2170,
  [2207] = 2168,
  [2208] = 2200,
  [2209] = 2168,
  [2210] = 2170,
  [2211] = 2163,
  [2212] = 2200,
  [2213] = 2161,
  [2214] = 2170,
  [2215] = 2168,
  [2216] = 2200,
  [2217] = 2217,
  [2218] = 2170,
  [2219] = 2163,
  [2220] = 2200,
  [2221] = 2169,
  [2222] = 2170,
  [2223] = 2200,
  [2224] = 2200,
  [2225] = 2170,
  [2226] = 2163,
  [2227] = 2200,
  [2228] = 2163,
  [2229] = 2200,
  [2230] = 2230,
  [2231] = 2170,
  [2232] = 2200,
  [2233] = 2161,
  [2234] = 2170,
  [2235] = 2168,
  [2236] = 2200,
  [2237] = 2170,
  [2238] = 2238,
  [2239] = 2238,
  [2240] = 2164,
  [2241] = 2161,
  [2242] = 2238,
  [2243] = 2164,
  [2244] = 2238,
  [2245] = 2164,
  [2246] = 2238,
  [2247] = 2164,
  [2248] = 2238,
  [2249] = 2164,
  [2250] = 2238,
  [2251] = 2164,
  [2252] = 2238,
  [2253] = 2164,
  [2254] = 2238,
  [2255] = 2164,
  [2256] = 2238,
  [2257] = 2164,
  [2258] = 2238,
  [2259] = 2164,
  [2260] = 2238,
  [2261] = 2173,
  [2262] = 2164,
  [2263] = 2217,
  [2264] = 2173,
  [2265] = 2217,
  [2266] = 2173,
  [2267] = 2217,
  [2268] = 2173,
  [2269] = 2217,
  [2270] = 2173,
  [2271] = 2217,
  [2272] = 2173,
  [2273] = 2217,
  [2274] = 2173,
  [2275] = 2217,
  [2276] = 2173,
  [2277] = 2217,
  [2278] = 2173,
  [2279] = 2217,
  [2280] = 2173,
  [2281] = 2217,
  [2282] = 2173,
  [2283] = 2217,
  [2284] = 2170,
  [2285] = 2285,
  [2286] = 2286,
  [2287] = 765,
  [2288] = 2288,
  [2289] = 2289,
  [2290] = 2290,
  [2291] = 2290,
  [2292] = 2290,
  [2293] = 2290,
  [2294] = 2294,
  [2295] = 2290,
  [2296] = 2296,
  [2297] = 2297,
  [2298] = 2290,
  [2299] = 2290,
  [2300] = 2290,
  [2301] = 2290,
  [2302] = 2290,
  [2303] = 2290,
  [2304] = 2304,
  [2305] = 2290,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 2306,
  [2311] = 2307,
  [2312] = 2308,
  [2313] = 2306,
  [2314] = 2306,
  [2315] = 2307,
  [2316] = 2309,
  [2317] = 2306,
  [2318] = 2306,
  [2319] = 2307,
  [2320] = 2308,
  [2321] = 2309,
  [2322] = 2306,
  [2323] = 2307,
  [2324] = 2308,
  [2325] = 2309,
  [2326] = 2307,
  [2327] = 2307,
  [2328] = 2306,
  [2329] = 2307,
  [2330] = 2307,
  [2331] = 2308,
  [2332] = 2308,
  [2333] = 2309,
  [2334] = 2307,
  [2335] = 2308,
  [2336] = 2306,
  [2337] = 2306,
  [2338] = 2308,
  [2339] = 2309,
  [2340] = 2308,
  [2341] = 2309,
  [2342] = 2307,
  [2343] = 2309,
  [2344] = 2308,
  [2345] = 2309,
  [2346] = 2307,
  [2347] = 2347,
  [2348] = 2308,
  [2349] = 2309,
  [2350] = 2308,
  [2351] = 2309,
  [2352] = 2306,
  [2353] = 2306,
  [2354] = 2309,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'.', '.'}, {'A', 'Z'}, {'_', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'.', '.'}, {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7},
  {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee},
  {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf},
  {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3},
  {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa},
  {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963},
  {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc},
  {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36},
  {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e},
  {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9},
  {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03},
  {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48},
  {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a},
  {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9},
  {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10},
  {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d},
  {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9},
  {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3},
  {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f},
  {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca},
  {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59},
  {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6},
  {0xec8, 0xece}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37},
  {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049},
  {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f},
  {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715},
  {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd},
  {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b},
  {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e},
  {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59},
  {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf},
  {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
  {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054},
  {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107},
  {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f},
  {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d},
  {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6},
  {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c},
  {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff},
  {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1},
  {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c},
  {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c},
  {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2},
  {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e},
  {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb},
  {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e},
  {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9},
  {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79},
  {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe},
  {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d},
  {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0},
  {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d},
  {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592},
  {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767},
  {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c},
  {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7},
  {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1},
  {0x10efd, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075},
  {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173},
  {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241},
  {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303},
  {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348},
  {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459},
  {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640},
  {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746},
  {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938},
  {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47},
  {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f},
  {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47},
  {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6},
  {0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543},
  {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe},
  {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f},
  {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7},
  {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152},
  {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e},
  {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244},
  {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb},
  {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544},
  {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734},
  {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36},
  {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006},
  {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d},
  {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee},
  {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22},
  {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47},
  {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b},
  {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c},
  {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df},
  {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
  {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(25);
      ADVANCE_MAP(
        '!', 30,
        '"', 70,
        '#', 95,
        '$', 56,
        '%', 5,
        '&', 39,
        '\'', 69,
        '*', 48,
        '+', 31,
        ',', 96,
        '-', 32,
        '.', 90,
        '/', 49,
        '0', 61,
        ':', 54,
        '<', 42,
        '=', 27,
        '>', 44,
        '?', 28,
        '@', 57,
        '\\', 26,
        '^', 51,
        '`', 9,
        '|', 38,
        '~', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(62);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(92);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 7,
        '"', 70,
        '#', 95,
        '$', 56,
        '%', 5,
        '&', 39,
        '\'', 69,
        '*', 48,
        '+', 31,
        ',', 96,
        '-', 32,
        '/', 49,
        ':', 55,
        '<', 42,
        '=', 27,
        '>', 44,
        '?', 28,
        '@', 57,
        '^', 51,
        '`', 9,
        '|', 38,
        '~', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(92);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(70);
      if (lookahead == '#') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead != 0) ADVANCE(76);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '`') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(92);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(72);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 5:
      if (lookahead == '%') ADVANCE(52);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\') ADVANCE(5);
      END_STATE();
    case 6:
      if (lookahead == '-') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 8:
      if (lookahead == 'U') ADVANCE(10);
      if (lookahead == 'u') ADVANCE(11);
      if (lookahead == 'x') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(79);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead)) ADVANCE(77);
      END_STATE();
    case 9:
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '`') ADVANCE(87);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '{') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 11:
      if (lookahead == '{') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 12:
      if (lookahead == '}') ADVANCE(77);
      END_STATE();
    case 13:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 14:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 15:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(14);
      END_STATE();
    case 16:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(16);
      END_STATE();
    case 18:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(18);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(19);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 24:
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(36);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '>') ADVANCE(37);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DASH_GT_GT);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(53);
      if (lookahead == '|') ADVANCE(40);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(41);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(33);
      if (lookahead == '<') ADVANCE(6);
      if (lookahead == '=') ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(50);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym_binary_operator_token1);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(59);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym__hex_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym__number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym__number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead == '#') ADVANCE(71);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(72);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(73);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead == '#') ADVANCE(74);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\\') ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(77);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(78);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(77);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(93);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(89);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_dots);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_dot_dot_i);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'F', 1,
        'I', 2,
        'L', 3,
        'N', 4,
        'T', 5,
        'b', 6,
        'f', 7,
        'i', 8,
        'n', 9,
        'r', 10,
        'w', 11,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(12);
      END_STATE();
    case 2:
      if (lookahead == 'n') ADVANCE(13);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_L);
      END_STATE();
    case 4:
      if (lookahead == 'A') ADVANCE(14);
      if (lookahead == 'U') ADVANCE(15);
      if (lookahead == 'a') ADVANCE(16);
      END_STATE();
    case 5:
      if (lookahead == 'R') ADVANCE(17);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'L') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(27);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(28);
      END_STATE();
    case 15:
      if (lookahead == 'L') ADVANCE(29);
      END_STATE();
    case 16:
      if (lookahead == 'N') ADVANCE(30);
      END_STATE();
    case 17:
      if (lookahead == 'U') ADVANCE(31);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 23:
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'p') ADVANCE(36);
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 26:
      if (lookahead == 'S') ADVANCE(39);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_inf);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(40);
      if (lookahead == 'i') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 29:
      if (lookahead == 'L') ADVANCE(43);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_nan);
      END_STATE();
    case 31:
      if (lookahead == 'E') ADVANCE(44);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'E') ADVANCE(51);
      END_STATE();
    case 40:
      if (lookahead == 'h') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 45:
      if (lookahead == 'k') ADVANCE(56);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_next);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 53:
      if (lookahead == 'm') ADVANCE(62);
      END_STATE();
    case 54:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 62:
      if (lookahead == 'p') ADVANCE(69);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 65:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_return);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(74);
      END_STATE();
    case 70:
      if (lookahead == 'g') ADVANCE(75);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(76);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(78);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 79:
      if (lookahead == 'x') ADVANCE(82);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 82:
      if (lookahead == '_') ADVANCE(85);
      END_STATE();
    case 83:
      if (lookahead == '_') ADVANCE(86);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      END_STATE();
    case 87:
      if (lookahead == '_') ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 0, .external_lex_state = 3},
  [3] = {.lex_state = 0, .external_lex_state = 4},
  [4] = {.lex_state = 0, .external_lex_state = 5},
  [5] = {.lex_state = 0, .external_lex_state = 5},
  [6] = {.lex_state = 0, .external_lex_state = 5},
  [7] = {.lex_state = 0, .external_lex_state = 5},
  [8] = {.lex_state = 0, .external_lex_state = 6},
  [9] = {.lex_state = 0, .external_lex_state = 6},
  [10] = {.lex_state = 0, .external_lex_state = 6},
  [11] = {.lex_state = 0, .external_lex_state = 6},
  [12] = {.lex_state = 0, .external_lex_state = 3},
  [13] = {.lex_state = 0, .external_lex_state = 3},
  [14] = {.lex_state = 0, .external_lex_state = 3},
  [15] = {.lex_state = 0, .external_lex_state = 3},
  [16] = {.lex_state = 0, .external_lex_state = 7},
  [17] = {.lex_state = 0, .external_lex_state = 7},
  [18] = {.lex_state = 0, .external_lex_state = 4},
  [19] = {.lex_state = 0, .external_lex_state = 7},
  [20] = {.lex_state = 0, .external_lex_state = 4},
  [21] = {.lex_state = 0, .external_lex_state = 7},
  [22] = {.lex_state = 0, .external_lex_state = 4},
  [23] = {.lex_state = 0, .external_lex_state = 4},
  [24] = {.lex_state = 0, .external_lex_state = 4},
  [25] = {.lex_state = 0, .external_lex_state = 4},
  [26] = {.lex_state = 0, .external_lex_state = 5},
  [27] = {.lex_state = 0, .external_lex_state = 5},
  [28] = {.lex_state = 0, .external_lex_state = 5},
  [29] = {.lex_state = 0, .external_lex_state = 5},
  [30] = {.lex_state = 0, .external_lex_state = 6},
  [31] = {.lex_state = 0, .external_lex_state = 6},
  [32] = {.lex_state = 0, .external_lex_state = 6},
  [33] = {.lex_state = 0, .external_lex_state = 6},
  [34] = {.lex_state = 0, .external_lex_state = 4},
  [35] = {.lex_state = 0, .external_lex_state = 3},
  [36] = {.lex_state = 0, .external_lex_state = 3},
  [37] = {.lex_state = 0, .external_lex_state = 3},
  [38] = {.lex_state = 0, .external_lex_state = 7},
  [39] = {.lex_state = 0, .external_lex_state = 7},
  [40] = {.lex_state = 0, .external_lex_state = 7},
  [41] = {.lex_state = 0, .external_lex_state = 7},
  [42] = {.lex_state = 0, .external_lex_state = 7},
  [43] = {.lex_state = 0, .external_lex_state = 4},
  [44] = {.lex_state = 0, .external_lex_state = 4},
  [45] = {.lex_state = 0, .external_lex_state = 4},
  [46] = {.lex_state = 0, .external_lex_state = 4},
  [47] = {.lex_state = 0, .external_lex_state = 4},
  [48] = {.lex_state = 0, .external_lex_state = 4},
  [49] = {.lex_state = 0, .external_lex_state = 4},
  [50] = {.lex_state = 0, .external_lex_state = 4},
  [51] = {.lex_state = 0, .external_lex_state = 4},
  [52] = {.lex_state = 0, .external_lex_state = 4},
  [53] = {.lex_state = 0, .external_lex_state = 4},
  [54] = {.lex_state = 0, .external_lex_state = 4},
  [55] = {.lex_state = 0, .external_lex_state = 4},
  [56] = {.lex_state = 0, .external_lex_state = 4},
  [57] = {.lex_state = 0, .external_lex_state = 4},
  [58] = {.lex_state = 0, .external_lex_state = 4},
  [59] = {.lex_state = 0, .external_lex_state = 4},
  [60] = {.lex_state = 0, .external_lex_state = 4},
  [61] = {.lex_state = 0, .external_lex_state = 4},
  [62] = {.lex_state = 0, .external_lex_state = 4},
  [63] = {.lex_state = 0, .external_lex_state = 4},
  [64] = {.lex_state = 0, .external_lex_state = 4},
  [65] = {.lex_state = 0, .external_lex_state = 4},
  [66] = {.lex_state = 0, .external_lex_state = 4},
  [67] = {.lex_state = 0, .external_lex_state = 4},
  [68] = {.lex_state = 0, .external_lex_state = 4},
  [69] = {.lex_state = 0, .external_lex_state = 4},
  [70] = {.lex_state = 0, .external_lex_state = 4},
  [71] = {.lex_state = 0, .external_lex_state = 4},
  [72] = {.lex_state = 0, .external_lex_state = 4},
  [73] = {.lex_state = 0, .external_lex_state = 4},
  [74] = {.lex_state = 0, .external_lex_state = 4},
  [75] = {.lex_state = 0, .external_lex_state = 4},
  [76] = {.lex_state = 0, .external_lex_state = 4},
  [77] = {.lex_state = 0, .external_lex_state = 5},
  [78] = {.lex_state = 0, .external_lex_state = 5},
  [79] = {.lex_state = 0, .external_lex_state = 5},
  [80] = {.lex_state = 0, .external_lex_state = 5},
  [81] = {.lex_state = 0, .external_lex_state = 5},
  [82] = {.lex_state = 0, .external_lex_state = 5},
  [83] = {.lex_state = 0, .external_lex_state = 5},
  [84] = {.lex_state = 0, .external_lex_state = 5},
  [85] = {.lex_state = 0, .external_lex_state = 5},
  [86] = {.lex_state = 0, .external_lex_state = 5},
  [87] = {.lex_state = 0, .external_lex_state = 5},
  [88] = {.lex_state = 0, .external_lex_state = 5},
  [89] = {.lex_state = 0, .external_lex_state = 5},
  [90] = {.lex_state = 0, .external_lex_state = 5},
  [91] = {.lex_state = 0, .external_lex_state = 5},
  [92] = {.lex_state = 0, .external_lex_state = 5},
  [93] = {.lex_state = 0, .external_lex_state = 5},
  [94] = {.lex_state = 0, .external_lex_state = 5},
  [95] = {.lex_state = 0, .external_lex_state = 5},
  [96] = {.lex_state = 0, .external_lex_state = 5},
  [97] = {.lex_state = 0, .external_lex_state = 5},
  [98] = {.lex_state = 0, .external_lex_state = 5},
  [99] = {.lex_state = 0, .external_lex_state = 5},
  [100] = {.lex_state = 0, .external_lex_state = 5},
  [101] = {.lex_state = 0, .external_lex_state = 5},
  [102] = {.lex_state = 0, .external_lex_state = 5},
  [103] = {.lex_state = 0, .external_lex_state = 5},
  [104] = {.lex_state = 0, .external_lex_state = 5},
  [105] = {.lex_state = 0, .external_lex_state = 5},
  [106] = {.lex_state = 0, .external_lex_state = 5},
  [107] = {.lex_state = 0, .external_lex_state = 5},
  [108] = {.lex_state = 0, .external_lex_state = 5},
  [109] = {.lex_state = 0, .external_lex_state = 5},
  [110] = {.lex_state = 0, .external_lex_state = 5},
  [111] = {.lex_state = 0, .external_lex_state = 5},
  [112] = {.lex_state = 0, .external_lex_state = 5},
  [113] = {.lex_state = 0, .external_lex_state = 5},
  [114] = {.lex_state = 0, .external_lex_state = 5},
  [115] = {.lex_state = 0, .external_lex_state = 5},
  [116] = {.lex_state = 0, .external_lex_state = 5},
  [117] = {.lex_state = 0, .external_lex_state = 5},
  [118] = {.lex_state = 0, .external_lex_state = 5},
  [119] = {.lex_state = 0, .external_lex_state = 5},
  [120] = {.lex_state = 0, .external_lex_state = 5},
  [121] = {.lex_state = 0, .external_lex_state = 5},
  [122] = {.lex_state = 0, .external_lex_state = 5},
  [123] = {.lex_state = 0, .external_lex_state = 5},
  [124] = {.lex_state = 0, .external_lex_state = 5},
  [125] = {.lex_state = 0, .external_lex_state = 5},
  [126] = {.lex_state = 0, .external_lex_state = 5},
  [127] = {.lex_state = 0, .external_lex_state = 5},
  [128] = {.lex_state = 0, .external_lex_state = 5},
  [129] = {.lex_state = 0, .external_lex_state = 5},
  [130] = {.lex_state = 0, .external_lex_state = 5},
  [131] = {.lex_state = 0, .external_lex_state = 5},
  [132] = {.lex_state = 0, .external_lex_state = 5},
  [133] = {.lex_state = 0, .external_lex_state = 6},
  [134] = {.lex_state = 0, .external_lex_state = 6},
  [135] = {.lex_state = 0, .external_lex_state = 6},
  [136] = {.lex_state = 0, .external_lex_state = 6},
  [137] = {.lex_state = 0, .external_lex_state = 6},
  [138] = {.lex_state = 0, .external_lex_state = 4},
  [139] = {.lex_state = 0, .external_lex_state = 6},
  [140] = {.lex_state = 0, .external_lex_state = 6},
  [141] = {.lex_state = 0, .external_lex_state = 6},
  [142] = {.lex_state = 0, .external_lex_state = 6},
  [143] = {.lex_state = 0, .external_lex_state = 6},
  [144] = {.lex_state = 0, .external_lex_state = 6},
  [145] = {.lex_state = 0, .external_lex_state = 6},
  [146] = {.lex_state = 0, .external_lex_state = 6},
  [147] = {.lex_state = 0, .external_lex_state = 6},
  [148] = {.lex_state = 0, .external_lex_state = 6},
  [149] = {.lex_state = 0, .external_lex_state = 6},
  [150] = {.lex_state = 0, .external_lex_state = 6},
  [151] = {.lex_state = 0, .external_lex_state = 6},
  [152] = {.lex_state = 0, .external_lex_state = 6},
  [153] = {.lex_state = 0, .external_lex_state = 6},
  [154] = {.lex_state = 0, .external_lex_state = 6},
  [155] = {.lex_state = 0, .external_lex_state = 6},
  [156] = {.lex_state = 0, .external_lex_state = 6},
  [157] = {.lex_state = 0, .external_lex_state = 6},
  [158] = {.lex_state = 0, .external_lex_state = 6},
  [159] = {.lex_state = 0, .external_lex_state = 6},
  [160] = {.lex_state = 0, .external_lex_state = 6},
  [161] = {.lex_state = 0, .external_lex_state = 6},
  [162] = {.lex_state = 0, .external_lex_state = 6},
  [163] = {.lex_state = 0, .external_lex_state = 6},
  [164] = {.lex_state = 0, .external_lex_state = 6},
  [165] = {.lex_state = 0, .external_lex_state = 6},
  [166] = {.lex_state = 0, .external_lex_state = 6},
  [167] = {.lex_state = 0, .external_lex_state = 6},
  [168] = {.lex_state = 0, .external_lex_state = 6},
  [169] = {.lex_state = 0, .external_lex_state = 6},
  [170] = {.lex_state = 0, .external_lex_state = 6},
  [171] = {.lex_state = 0, .external_lex_state = 6},
  [172] = {.lex_state = 0, .external_lex_state = 6},
  [173] = {.lex_state = 0, .external_lex_state = 6},
  [174] = {.lex_state = 0, .external_lex_state = 6},
  [175] = {.lex_state = 0, .external_lex_state = 6},
  [176] = {.lex_state = 0, .external_lex_state = 6},
  [177] = {.lex_state = 0, .external_lex_state = 6},
  [178] = {.lex_state = 0, .external_lex_state = 6},
  [179] = {.lex_state = 0, .external_lex_state = 6},
  [180] = {.lex_state = 0, .external_lex_state = 6},
  [181] = {.lex_state = 0, .external_lex_state = 6},
  [182] = {.lex_state = 0, .external_lex_state = 6},
  [183] = {.lex_state = 0, .external_lex_state = 6},
  [184] = {.lex_state = 0, .external_lex_state = 6},
  [185] = {.lex_state = 0, .external_lex_state = 6},
  [186] = {.lex_state = 0, .external_lex_state = 6},
  [187] = {.lex_state = 0, .external_lex_state = 6},
  [188] = {.lex_state = 0, .external_lex_state = 6},
  [189] = {.lex_state = 0, .external_lex_state = 6},
  [190] = {.lex_state = 0, .external_lex_state = 3},
  [191] = {.lex_state = 0, .external_lex_state = 3},
  [192] = {.lex_state = 0, .external_lex_state = 3},
  [193] = {.lex_state = 0, .external_lex_state = 3},
  [194] = {.lex_state = 0, .external_lex_state = 4},
  [195] = {.lex_state = 0, .external_lex_state = 3},
  [196] = {.lex_state = 0, .external_lex_state = 3},
  [197] = {.lex_state = 0, .external_lex_state = 3},
  [198] = {.lex_state = 0, .external_lex_state = 3},
  [199] = {.lex_state = 0, .external_lex_state = 3},
  [200] = {.lex_state = 0, .external_lex_state = 3},
  [201] = {.lex_state = 0, .external_lex_state = 3},
  [202] = {.lex_state = 0, .external_lex_state = 3},
  [203] = {.lex_state = 0, .external_lex_state = 3},
  [204] = {.lex_state = 0, .external_lex_state = 3},
  [205] = {.lex_state = 0, .external_lex_state = 3},
  [206] = {.lex_state = 0, .external_lex_state = 3},
  [207] = {.lex_state = 0, .external_lex_state = 3},
  [208] = {.lex_state = 0, .external_lex_state = 3},
  [209] = {.lex_state = 0, .external_lex_state = 3},
  [210] = {.lex_state = 0, .external_lex_state = 3},
  [211] = {.lex_state = 0, .external_lex_state = 3},
  [212] = {.lex_state = 0, .external_lex_state = 3},
  [213] = {.lex_state = 0, .external_lex_state = 3},
  [214] = {.lex_state = 0, .external_lex_state = 3},
  [215] = {.lex_state = 0, .external_lex_state = 3},
  [216] = {.lex_state = 0, .external_lex_state = 3},
  [217] = {.lex_state = 0, .external_lex_state = 3},
  [218] = {.lex_state = 0, .external_lex_state = 3},
  [219] = {.lex_state = 0, .external_lex_state = 3},
  [220] = {.lex_state = 0, .external_lex_state = 3},
  [221] = {.lex_state = 0, .external_lex_state = 3},
  [222] = {.lex_state = 0, .external_lex_state = 3},
  [223] = {.lex_state = 0, .external_lex_state = 3},
  [224] = {.lex_state = 0, .external_lex_state = 3},
  [225] = {.lex_state = 0, .external_lex_state = 3},
  [226] = {.lex_state = 0, .external_lex_state = 3},
  [227] = {.lex_state = 0, .external_lex_state = 3},
  [228] = {.lex_state = 0, .external_lex_state = 3},
  [229] = {.lex_state = 0, .external_lex_state = 3},
  [230] = {.lex_state = 0, .external_lex_state = 3},
  [231] = {.lex_state = 0, .external_lex_state = 3},
  [232] = {.lex_state = 0, .external_lex_state = 3},
  [233] = {.lex_state = 0, .external_lex_state = 3},
  [234] = {.lex_state = 0, .external_lex_state = 3},
  [235] = {.lex_state = 0, .external_lex_state = 3},
  [236] = {.lex_state = 0, .external_lex_state = 3},
  [237] = {.lex_state = 0, .external_lex_state = 3},
  [238] = {.lex_state = 0, .external_lex_state = 3},
  [239] = {.lex_state = 0, .external_lex_state = 3},
  [240] = {.lex_state = 0, .external_lex_state = 3},
  [241] = {.lex_state = 0, .external_lex_state = 3},
  [242] = {.lex_state = 0, .external_lex_state = 3},
  [243] = {.lex_state = 0, .external_lex_state = 3},
  [244] = {.lex_state = 0, .external_lex_state = 3},
  [245] = {.lex_state = 0, .external_lex_state = 3},
  [246] = {.lex_state = 0, .external_lex_state = 7},
  [247] = {.lex_state = 0, .external_lex_state = 7},
  [248] = {.lex_state = 0, .external_lex_state = 7},
  [249] = {.lex_state = 0, .external_lex_state = 7},
  [250] = {.lex_state = 0, .external_lex_state = 7},
  [251] = {.lex_state = 0, .external_lex_state = 7},
  [252] = {.lex_state = 0, .external_lex_state = 7},
  [253] = {.lex_state = 0, .external_lex_state = 7},
  [254] = {.lex_state = 0, .external_lex_state = 7},
  [255] = {.lex_state = 0, .external_lex_state = 7},
  [256] = {.lex_state = 0, .external_lex_state = 7},
  [257] = {.lex_state = 0, .external_lex_state = 7},
  [258] = {.lex_state = 0, .external_lex_state = 7},
  [259] = {.lex_state = 0, .external_lex_state = 7},
  [260] = {.lex_state = 0, .external_lex_state = 7},
  [261] = {.lex_state = 0, .external_lex_state = 7},
  [262] = {.lex_state = 0, .external_lex_state = 7},
  [263] = {.lex_state = 0, .external_lex_state = 7},
  [264] = {.lex_state = 0, .external_lex_state = 7},
  [265] = {.lex_state = 0, .external_lex_state = 7},
  [266] = {.lex_state = 0, .external_lex_state = 7},
  [267] = {.lex_state = 0, .external_lex_state = 7},
  [268] = {.lex_state = 0, .external_lex_state = 7},
  [269] = {.lex_state = 0, .external_lex_state = 7},
  [270] = {.lex_state = 0, .external_lex_state = 7},
  [271] = {.lex_state = 0, .external_lex_state = 7},
  [272] = {.lex_state = 0, .external_lex_state = 7},
  [273] = {.lex_state = 0, .external_lex_state = 7},
  [274] = {.lex_state = 0, .external_lex_state = 7},
  [275] = {.lex_state = 0, .external_lex_state = 7},
  [276] = {.lex_state = 0, .external_lex_state = 7},
  [277] = {.lex_state = 0, .external_lex_state = 7},
  [278] = {.lex_state = 0, .external_lex_state = 7},
  [279] = {.lex_state = 0, .external_lex_state = 7},
  [280] = {.lex_state = 0, .external_lex_state = 7},
  [281] = {.lex_state = 0, .external_lex_state = 7},
  [282] = {.lex_state = 0, .external_lex_state = 7},
  [283] = {.lex_state = 0, .external_lex_state = 7},
  [284] = {.lex_state = 0, .external_lex_state = 7},
  [285] = {.lex_state = 0, .external_lex_state = 7},
  [286] = {.lex_state = 0, .external_lex_state = 7},
  [287] = {.lex_state = 0, .external_lex_state = 7},
  [288] = {.lex_state = 0, .external_lex_state = 7},
  [289] = {.lex_state = 0, .external_lex_state = 7},
  [290] = {.lex_state = 0, .external_lex_state = 7},
  [291] = {.lex_state = 0, .external_lex_state = 7},
  [292] = {.lex_state = 0, .external_lex_state = 7},
  [293] = {.lex_state = 0, .external_lex_state = 7},
  [294] = {.lex_state = 0, .external_lex_state = 7},
  [295] = {.lex_state = 0, .external_lex_state = 7},
  [296] = {.lex_state = 0, .external_lex_state = 7},
  [297] = {.lex_state = 0, .external_lex_state = 7},
  [298] = {.lex_state = 0, .external_lex_state = 7},
  [299] = {.lex_state = 0, .external_lex_state = 4},
  [300] = {.lex_state = 0, .external_lex_state = 7},
  [301] = {.lex_state = 0, .external_lex_state = 7},
  [302] = {.lex_state = 0, .external_lex_state = 4},
  [303] = {.lex_state = 0, .external_lex_state = 4},
  [304] = {.lex_state = 0, .external_lex_state = 4},
  [305] = {.lex_state = 0, .external_lex_state = 4},
  [306] = {.lex_state = 0, .external_lex_state = 4},
  [307] = {.lex_state = 0, .external_lex_state = 4},
  [308] = {.lex_state = 0, .external_lex_state = 4},
  [309] = {.lex_state = 0, .external_lex_state = 4},
  [310] = {.lex_state = 0, .external_lex_state = 4},
  [311] = {.lex_state = 0, .external_lex_state = 4},
  [312] = {.lex_state = 0, .external_lex_state = 4},
  [313] = {.lex_state = 0, .external_lex_state = 4},
  [314] = {.lex_state = 0, .external_lex_state = 4},
  [315] = {.lex_state = 0, .external_lex_state = 4},
  [316] = {.lex_state = 0, .external_lex_state = 4},
  [317] = {.lex_state = 0, .external_lex_state = 4},
  [318] = {.lex_state = 0, .external_lex_state = 4},
  [319] = {.lex_state = 0, .external_lex_state = 4},
  [320] = {.lex_state = 0, .external_lex_state = 4},
  [321] = {.lex_state = 0, .external_lex_state = 3},
  [322] = {.lex_state = 0, .external_lex_state = 8},
  [323] = {.lex_state = 0, .external_lex_state = 9},
  [324] = {.lex_state = 0, .external_lex_state = 9},
  [325] = {.lex_state = 0, .external_lex_state = 9},
  [326] = {.lex_state = 0, .external_lex_state = 9},
  [327] = {.lex_state = 0, .external_lex_state = 9},
  [328] = {.lex_state = 0, .external_lex_state = 9},
  [329] = {.lex_state = 0, .external_lex_state = 9},
  [330] = {.lex_state = 0, .external_lex_state = 9},
  [331] = {.lex_state = 0, .external_lex_state = 9},
  [332] = {.lex_state = 0, .external_lex_state = 9},
  [333] = {.lex_state = 0, .external_lex_state = 9},
  [334] = {.lex_state = 0, .external_lex_state = 9},
  [335] = {.lex_state = 0, .external_lex_state = 9},
  [336] = {.lex_state = 0, .external_lex_state = 9},
  [337] = {.lex_state = 0, .external_lex_state = 9},
  [338] = {.lex_state = 0, .external_lex_state = 9},
  [339] = {.lex_state = 0, .external_lex_state = 9},
  [340] = {.lex_state = 0, .external_lex_state = 9},
  [341] = {.lex_state = 0, .external_lex_state = 9},
  [342] = {.lex_state = 0, .external_lex_state = 9},
  [343] = {.lex_state = 0, .external_lex_state = 9},
  [344] = {.lex_state = 0, .external_lex_state = 9},
  [345] = {.lex_state = 0, .external_lex_state = 9},
  [346] = {.lex_state = 0, .external_lex_state = 9},
  [347] = {.lex_state = 0, .external_lex_state = 10},
  [348] = {.lex_state = 0, .external_lex_state = 11},
  [349] = {.lex_state = 0, .external_lex_state = 9},
  [350] = {.lex_state = 0, .external_lex_state = 9},
  [351] = {.lex_state = 0, .external_lex_state = 9},
  [352] = {.lex_state = 0, .external_lex_state = 9},
  [353] = {.lex_state = 0, .external_lex_state = 9},
  [354] = {.lex_state = 0, .external_lex_state = 9},
  [355] = {.lex_state = 0, .external_lex_state = 9},
  [356] = {.lex_state = 0, .external_lex_state = 9},
  [357] = {.lex_state = 0, .external_lex_state = 9},
  [358] = {.lex_state = 0, .external_lex_state = 9},
  [359] = {.lex_state = 0, .external_lex_state = 9},
  [360] = {.lex_state = 0, .external_lex_state = 9},
  [361] = {.lex_state = 0, .external_lex_state = 9},
  [362] = {.lex_state = 0, .external_lex_state = 9},
  [363] = {.lex_state = 0, .external_lex_state = 9},
  [364] = {.lex_state = 0, .external_lex_state = 9},
  [365] = {.lex_state = 0, .external_lex_state = 8},
  [366] = {.lex_state = 0, .external_lex_state = 9},
  [367] = {.lex_state = 0, .external_lex_state = 9},
  [368] = {.lex_state = 0, .external_lex_state = 9},
  [369] = {.lex_state = 0, .external_lex_state = 9},
  [370] = {.lex_state = 0, .external_lex_state = 9},
  [371] = {.lex_state = 0, .external_lex_state = 9},
  [372] = {.lex_state = 0, .external_lex_state = 9},
  [373] = {.lex_state = 0, .external_lex_state = 9},
  [374] = {.lex_state = 0, .external_lex_state = 9},
  [375] = {.lex_state = 0, .external_lex_state = 9},
  [376] = {.lex_state = 0, .external_lex_state = 9},
  [377] = {.lex_state = 0, .external_lex_state = 9},
  [378] = {.lex_state = 0, .external_lex_state = 9},
  [379] = {.lex_state = 0, .external_lex_state = 9},
  [380] = {.lex_state = 0, .external_lex_state = 9},
  [381] = {.lex_state = 0, .external_lex_state = 9},
  [382] = {.lex_state = 0, .external_lex_state = 12},
  [383] = {.lex_state = 0, .external_lex_state = 12},
  [384] = {.lex_state = 0, .external_lex_state = 12},
  [385] = {.lex_state = 0, .external_lex_state = 12},
  [386] = {.lex_state = 0, .external_lex_state = 12},
  [387] = {.lex_state = 0, .external_lex_state = 12},
  [388] = {.lex_state = 0, .external_lex_state = 12},
  [389] = {.lex_state = 0, .external_lex_state = 12},
  [390] = {.lex_state = 0, .external_lex_state = 12},
  [391] = {.lex_state = 0, .external_lex_state = 12},
  [392] = {.lex_state = 0, .external_lex_state = 12},
  [393] = {.lex_state = 0, .external_lex_state = 12},
  [394] = {.lex_state = 0, .external_lex_state = 12},
  [395] = {.lex_state = 0, .external_lex_state = 12},
  [396] = {.lex_state = 0, .external_lex_state = 12},
  [397] = {.lex_state = 0, .external_lex_state = 12},
  [398] = {.lex_state = 0, .external_lex_state = 12},
  [399] = {.lex_state = 0, .external_lex_state = 12},
  [400] = {.lex_state = 0, .external_lex_state = 12},
  [401] = {.lex_state = 0, .external_lex_state = 12},
  [402] = {.lex_state = 0, .external_lex_state = 12},
  [403] = {.lex_state = 0, .external_lex_state = 12},
  [404] = {.lex_state = 0, .external_lex_state = 12},
  [405] = {.lex_state = 0, .external_lex_state = 12},
  [406] = {.lex_state = 0, .external_lex_state = 10},
  [407] = {.lex_state = 0, .external_lex_state = 11},
  [408] = {.lex_state = 0, .external_lex_state = 12},
  [409] = {.lex_state = 0, .external_lex_state = 12},
  [410] = {.lex_state = 0, .external_lex_state = 12},
  [411] = {.lex_state = 0, .external_lex_state = 12},
  [412] = {.lex_state = 0, .external_lex_state = 12},
  [413] = {.lex_state = 0, .external_lex_state = 12},
  [414] = {.lex_state = 0, .external_lex_state = 12},
  [415] = {.lex_state = 0, .external_lex_state = 12},
  [416] = {.lex_state = 0, .external_lex_state = 12},
  [417] = {.lex_state = 0, .external_lex_state = 12},
  [418] = {.lex_state = 0, .external_lex_state = 12},
  [419] = {.lex_state = 0, .external_lex_state = 12},
  [420] = {.lex_state = 0, .external_lex_state = 12},
  [421] = {.lex_state = 0, .external_lex_state = 12},
  [422] = {.lex_state = 0, .external_lex_state = 12},
  [423] = {.lex_state = 0, .external_lex_state = 12},
  [424] = {.lex_state = 0, .external_lex_state = 12},
  [425] = {.lex_state = 0, .external_lex_state = 12},
  [426] = {.lex_state = 0, .external_lex_state = 12},
  [427] = {.lex_state = 0, .external_lex_state = 12},
  [428] = {.lex_state = 0, .external_lex_state = 12},
  [429] = {.lex_state = 0, .external_lex_state = 12},
  [430] = {.lex_state = 0, .external_lex_state = 12},
  [431] = {.lex_state = 0, .external_lex_state = 12},
  [432] = {.lex_state = 0, .external_lex_state = 12},
  [433] = {.lex_state = 0, .external_lex_state = 12},
  [434] = {.lex_state = 0, .external_lex_state = 12},
  [435] = {.lex_state = 0, .external_lex_state = 12},
  [436] = {.lex_state = 0, .external_lex_state = 12},
  [437] = {.lex_state = 0, .external_lex_state = 12},
  [438] = {.lex_state = 0, .external_lex_state = 12},
  [439] = {.lex_state = 0, .external_lex_state = 12},
  [440] = {.lex_state = 0, .external_lex_state = 13},
  [441] = {.lex_state = 0, .external_lex_state = 10},
  [442] = {.lex_state = 0, .external_lex_state = 11},
  [443] = {.lex_state = 0, .external_lex_state = 4},
  [444] = {.lex_state = 0, .external_lex_state = 14},
  [445] = {.lex_state = 0, .external_lex_state = 8},
  [446] = {.lex_state = 0, .external_lex_state = 8},
  [447] = {.lex_state = 0, .external_lex_state = 8},
  [448] = {.lex_state = 0, .external_lex_state = 8},
  [449] = {.lex_state = 0, .external_lex_state = 8},
  [450] = {.lex_state = 0, .external_lex_state = 8},
  [451] = {.lex_state = 0, .external_lex_state = 8},
  [452] = {.lex_state = 0, .external_lex_state = 8},
  [453] = {.lex_state = 0, .external_lex_state = 8},
  [454] = {.lex_state = 0, .external_lex_state = 8},
  [455] = {.lex_state = 0, .external_lex_state = 4},
  [456] = {.lex_state = 0, .external_lex_state = 10},
  [457] = {.lex_state = 0, .external_lex_state = 11},
  [458] = {.lex_state = 0, .external_lex_state = 8},
  [459] = {.lex_state = 0, .external_lex_state = 8},
  [460] = {.lex_state = 0, .external_lex_state = 8},
  [461] = {.lex_state = 0, .external_lex_state = 8},
  [462] = {.lex_state = 0, .external_lex_state = 8},
  [463] = {.lex_state = 0, .external_lex_state = 8},
  [464] = {.lex_state = 0, .external_lex_state = 8},
  [465] = {.lex_state = 0, .external_lex_state = 8},
  [466] = {.lex_state = 0, .external_lex_state = 8},
  [467] = {.lex_state = 0, .external_lex_state = 15},
  [468] = {.lex_state = 0, .external_lex_state = 13},
  [469] = {.lex_state = 0, .external_lex_state = 10},
  [470] = {.lex_state = 0, .external_lex_state = 11},
  [471] = {.lex_state = 0, .external_lex_state = 8},
  [472] = {.lex_state = 0, .external_lex_state = 8},
  [473] = {.lex_state = 0, .external_lex_state = 8},
  [474] = {.lex_state = 0, .external_lex_state = 8},
  [475] = {.lex_state = 0, .external_lex_state = 8},
  [476] = {.lex_state = 0, .external_lex_state = 8},
  [477] = {.lex_state = 0, .external_lex_state = 8},
  [478] = {.lex_state = 0, .external_lex_state = 8},
  [479] = {.lex_state = 0, .external_lex_state = 8},
  [480] = {.lex_state = 0, .external_lex_state = 8},
  [481] = {.lex_state = 0, .external_lex_state = 8},
  [482] = {.lex_state = 0, .external_lex_state = 5},
  [483] = {.lex_state = 0, .external_lex_state = 8},
  [484] = {.lex_state = 0, .external_lex_state = 8},
  [485] = {.lex_state = 0, .external_lex_state = 8},
  [486] = {.lex_state = 0, .external_lex_state = 8},
  [487] = {.lex_state = 0, .external_lex_state = 8},
  [488] = {.lex_state = 0, .external_lex_state = 8},
  [489] = {.lex_state = 0, .external_lex_state = 8},
  [490] = {.lex_state = 0, .external_lex_state = 8},
  [491] = {.lex_state = 0, .external_lex_state = 8},
  [492] = {.lex_state = 0, .external_lex_state = 5},
  [493] = {.lex_state = 0, .external_lex_state = 10},
  [494] = {.lex_state = 0, .external_lex_state = 11},
  [495] = {.lex_state = 0, .external_lex_state = 8},
  [496] = {.lex_state = 0, .external_lex_state = 8},
  [497] = {.lex_state = 0, .external_lex_state = 8},
  [498] = {.lex_state = 0, .external_lex_state = 8},
  [499] = {.lex_state = 0, .external_lex_state = 8},
  [500] = {.lex_state = 0, .external_lex_state = 8},
  [501] = {.lex_state = 0, .external_lex_state = 8},
  [502] = {.lex_state = 0, .external_lex_state = 8},
  [503] = {.lex_state = 0, .external_lex_state = 8},
  [504] = {.lex_state = 0, .external_lex_state = 8},
  [505] = {.lex_state = 0, .external_lex_state = 8},
  [506] = {.lex_state = 0, .external_lex_state = 15},
  [507] = {.lex_state = 0, .external_lex_state = 15},
  [508] = {.lex_state = 0, .external_lex_state = 15},
  [509] = {.lex_state = 0, .external_lex_state = 15},
  [510] = {.lex_state = 0, .external_lex_state = 15},
  [511] = {.lex_state = 0, .external_lex_state = 15},
  [512] = {.lex_state = 0, .external_lex_state = 15},
  [513] = {.lex_state = 0, .external_lex_state = 15},
  [514] = {.lex_state = 0, .external_lex_state = 6},
  [515] = {.lex_state = 0, .external_lex_state = 15},
  [516] = {.lex_state = 0, .external_lex_state = 15},
  [517] = {.lex_state = 0, .external_lex_state = 15},
  [518] = {.lex_state = 0, .external_lex_state = 15},
  [519] = {.lex_state = 0, .external_lex_state = 15},
  [520] = {.lex_state = 0, .external_lex_state = 15},
  [521] = {.lex_state = 0, .external_lex_state = 15},
  [522] = {.lex_state = 0, .external_lex_state = 11},
  [523] = {.lex_state = 0, .external_lex_state = 15},
  [524] = {.lex_state = 0, .external_lex_state = 15},
  [525] = {.lex_state = 0, .external_lex_state = 15},
  [526] = {.lex_state = 0, .external_lex_state = 15},
  [527] = {.lex_state = 0, .external_lex_state = 15},
  [528] = {.lex_state = 0, .external_lex_state = 15},
  [529] = {.lex_state = 0, .external_lex_state = 15},
  [530] = {.lex_state = 0, .external_lex_state = 15},
  [531] = {.lex_state = 0, .external_lex_state = 6},
  [532] = {.lex_state = 0, .external_lex_state = 10},
  [533] = {.lex_state = 0, .external_lex_state = 11},
  [534] = {.lex_state = 0, .external_lex_state = 9},
  [535] = {.lex_state = 0, .external_lex_state = 13},
  [536] = {.lex_state = 0, .external_lex_state = 10},
  [537] = {.lex_state = 0, .external_lex_state = 11},
  [538] = {.lex_state = 0, .external_lex_state = 15},
  [539] = {.lex_state = 0, .external_lex_state = 15},
  [540] = {.lex_state = 0, .external_lex_state = 15},
  [541] = {.lex_state = 0, .external_lex_state = 15},
  [542] = {.lex_state = 0, .external_lex_state = 15},
  [543] = {.lex_state = 0, .external_lex_state = 15},
  [544] = {.lex_state = 0, .external_lex_state = 15},
  [545] = {.lex_state = 0, .external_lex_state = 15},
  [546] = {.lex_state = 0, .external_lex_state = 15},
  [547] = {.lex_state = 0, .external_lex_state = 15},
  [548] = {.lex_state = 0, .external_lex_state = 15},
  [549] = {.lex_state = 0, .external_lex_state = 15},
  [550] = {.lex_state = 0, .external_lex_state = 15},
  [551] = {.lex_state = 0, .external_lex_state = 15},
  [552] = {.lex_state = 0, .external_lex_state = 15},
  [553] = {.lex_state = 0, .external_lex_state = 10},
  [554] = {.lex_state = 0, .external_lex_state = 11},
  [555] = {.lex_state = 0, .external_lex_state = 15},
  [556] = {.lex_state = 0, .external_lex_state = 8},
  [557] = {.lex_state = 0, .external_lex_state = 15},
  [558] = {.lex_state = 0, .external_lex_state = 3},
  [559] = {.lex_state = 0, .external_lex_state = 15},
  [560] = {.lex_state = 0, .external_lex_state = 15},
  [561] = {.lex_state = 0, .external_lex_state = 15},
  [562] = {.lex_state = 0, .external_lex_state = 15},
  [563] = {.lex_state = 0, .external_lex_state = 15},
  [564] = {.lex_state = 0, .external_lex_state = 15},
  [565] = {.lex_state = 0, .external_lex_state = 15},
  [566] = {.lex_state = 0, .external_lex_state = 15},
  [567] = {.lex_state = 0, .external_lex_state = 15},
  [568] = {.lex_state = 0, .external_lex_state = 15},
  [569] = {.lex_state = 0, .external_lex_state = 15},
  [570] = {.lex_state = 0, .external_lex_state = 15},
  [571] = {.lex_state = 0, .external_lex_state = 15},
  [572] = {.lex_state = 0, .external_lex_state = 15},
  [573] = {.lex_state = 0, .external_lex_state = 15},
  [574] = {.lex_state = 0, .external_lex_state = 3},
  [575] = {.lex_state = 0, .external_lex_state = 10},
  [576] = {.lex_state = 0, .external_lex_state = 11},
  [577] = {.lex_state = 0, .external_lex_state = 14},
  [578] = {.lex_state = 0, .external_lex_state = 14},
  [579] = {.lex_state = 0, .external_lex_state = 14},
  [580] = {.lex_state = 0, .external_lex_state = 14},
  [581] = {.lex_state = 0, .external_lex_state = 14},
  [582] = {.lex_state = 0, .external_lex_state = 14},
  [583] = {.lex_state = 0, .external_lex_state = 14},
  [584] = {.lex_state = 0, .external_lex_state = 14},
  [585] = {.lex_state = 0, .external_lex_state = 14},
  [586] = {.lex_state = 0, .external_lex_state = 14},
  [587] = {.lex_state = 0, .external_lex_state = 14},
  [588] = {.lex_state = 0, .external_lex_state = 14},
  [589] = {.lex_state = 0, .external_lex_state = 14},
  [590] = {.lex_state = 0, .external_lex_state = 14},
  [591] = {.lex_state = 0, .external_lex_state = 14},
  [592] = {.lex_state = 0, .external_lex_state = 14},
  [593] = {.lex_state = 0, .external_lex_state = 14},
  [594] = {.lex_state = 0, .external_lex_state = 7},
  [595] = {.lex_state = 0, .external_lex_state = 14},
  [596] = {.lex_state = 0, .external_lex_state = 14},
  [597] = {.lex_state = 0, .external_lex_state = 14},
  [598] = {.lex_state = 0, .external_lex_state = 14},
  [599] = {.lex_state = 0, .external_lex_state = 14},
  [600] = {.lex_state = 0, .external_lex_state = 14},
  [601] = {.lex_state = 0, .external_lex_state = 14},
  [602] = {.lex_state = 0, .external_lex_state = 12},
  [603] = {.lex_state = 0, .external_lex_state = 10},
  [604] = {.lex_state = 0, .external_lex_state = 11},
  [605] = {.lex_state = 0, .external_lex_state = 7},
  [606] = {.lex_state = 0, .external_lex_state = 10},
  [607] = {.lex_state = 0, .external_lex_state = 11},
  [608] = {.lex_state = 0, .external_lex_state = 14},
  [609] = {.lex_state = 0, .external_lex_state = 14},
  [610] = {.lex_state = 0, .external_lex_state = 14},
  [611] = {.lex_state = 0, .external_lex_state = 14},
  [612] = {.lex_state = 0, .external_lex_state = 14},
  [613] = {.lex_state = 0, .external_lex_state = 14},
  [614] = {.lex_state = 0, .external_lex_state = 14},
  [615] = {.lex_state = 0, .external_lex_state = 14},
  [616] = {.lex_state = 0, .external_lex_state = 14},
  [617] = {.lex_state = 0, .external_lex_state = 14},
  [618] = {.lex_state = 0, .external_lex_state = 14},
  [619] = {.lex_state = 0, .external_lex_state = 14},
  [620] = {.lex_state = 0, .external_lex_state = 14},
  [621] = {.lex_state = 0, .external_lex_state = 14},
  [622] = {.lex_state = 0, .external_lex_state = 14},
  [623] = {.lex_state = 0, .external_lex_state = 14},
  [624] = {.lex_state = 0, .external_lex_state = 8},
  [625] = {.lex_state = 0, .external_lex_state = 14},
  [626] = {.lex_state = 0, .external_lex_state = 8},
  [627] = {.lex_state = 0, .external_lex_state = 8},
  [628] = {.lex_state = 0, .external_lex_state = 14},
  [629] = {.lex_state = 0, .external_lex_state = 14},
  [630] = {.lex_state = 0, .external_lex_state = 14},
  [631] = {.lex_state = 0, .external_lex_state = 8},
  [632] = {.lex_state = 0, .external_lex_state = 14},
  [633] = {.lex_state = 0, .external_lex_state = 13},
  [634] = {.lex_state = 0, .external_lex_state = 10},
  [635] = {.lex_state = 0, .external_lex_state = 11},
  [636] = {.lex_state = 0, .external_lex_state = 14},
  [637] = {.lex_state = 0, .external_lex_state = 14},
  [638] = {.lex_state = 0, .external_lex_state = 14},
  [639] = {.lex_state = 0, .external_lex_state = 14},
  [640] = {.lex_state = 0, .external_lex_state = 13},
  [641] = {.lex_state = 0, .external_lex_state = 14},
  [642] = {.lex_state = 0, .external_lex_state = 14},
  [643] = {.lex_state = 0, .external_lex_state = 14},
  [644] = {.lex_state = 0, .external_lex_state = 14},
  [645] = {.lex_state = 0, .external_lex_state = 14},
  [646] = {.lex_state = 0, .external_lex_state = 14},
  [647] = {.lex_state = 0, .external_lex_state = 14},
  [648] = {.lex_state = 0, .external_lex_state = 10},
  [649] = {.lex_state = 0, .external_lex_state = 11},
  [650] = {.lex_state = 0, .external_lex_state = 13},
  [651] = {.lex_state = 0, .external_lex_state = 10},
  [652] = {.lex_state = 0, .external_lex_state = 11},
  [653] = {.lex_state = 0, .external_lex_state = 13},
  [654] = {.lex_state = 0, .external_lex_state = 13},
  [655] = {.lex_state = 0, .external_lex_state = 10},
  [656] = {.lex_state = 0, .external_lex_state = 11},
  [657] = {.lex_state = 0, .external_lex_state = 13},
  [658] = {.lex_state = 0, .external_lex_state = 13},
  [659] = {.lex_state = 0, .external_lex_state = 10},
  [660] = {.lex_state = 0, .external_lex_state = 11},
  [661] = {.lex_state = 0, .external_lex_state = 13},
  [662] = {.lex_state = 0, .external_lex_state = 13},
  [663] = {.lex_state = 0, .external_lex_state = 10},
  [664] = {.lex_state = 0, .external_lex_state = 11},
  [665] = {.lex_state = 0, .external_lex_state = 13},
  [666] = {.lex_state = 0, .external_lex_state = 13},
  [667] = {.lex_state = 0, .external_lex_state = 10},
  [668] = {.lex_state = 0, .external_lex_state = 11},
  [669] = {.lex_state = 0, .external_lex_state = 13},
  [670] = {.lex_state = 0, .external_lex_state = 13},
  [671] = {.lex_state = 0, .external_lex_state = 10},
  [672] = {.lex_state = 0, .external_lex_state = 11},
  [673] = {.lex_state = 0, .external_lex_state = 13},
  [674] = {.lex_state = 0, .external_lex_state = 13},
  [675] = {.lex_state = 0, .external_lex_state = 10},
  [676] = {.lex_state = 0, .external_lex_state = 11},
  [677] = {.lex_state = 0, .external_lex_state = 13},
  [678] = {.lex_state = 0, .external_lex_state = 13},
  [679] = {.lex_state = 0, .external_lex_state = 10},
  [680] = {.lex_state = 0, .external_lex_state = 11},
  [681] = {.lex_state = 0, .external_lex_state = 13},
  [682] = {.lex_state = 0, .external_lex_state = 13},
  [683] = {.lex_state = 0, .external_lex_state = 10},
  [684] = {.lex_state = 0, .external_lex_state = 11},
  [685] = {.lex_state = 0, .external_lex_state = 13},
  [686] = {.lex_state = 0, .external_lex_state = 13},
  [687] = {.lex_state = 0, .external_lex_state = 10},
  [688] = {.lex_state = 0, .external_lex_state = 15},
  [689] = {.lex_state = 0, .external_lex_state = 8},
  [690] = {.lex_state = 0, .external_lex_state = 3},
  [691] = {.lex_state = 0, .external_lex_state = 13},
  [692] = {.lex_state = 0, .external_lex_state = 14},
  [693] = {.lex_state = 0, .external_lex_state = 9},
  [694] = {.lex_state = 0, .external_lex_state = 8},
  [695] = {.lex_state = 0, .external_lex_state = 11},
  [696] = {.lex_state = 0, .external_lex_state = 14},
  [697] = {.lex_state = 0, .external_lex_state = 6},
  [698] = {.lex_state = 0, .external_lex_state = 9},
  [699] = {.lex_state = 0, .external_lex_state = 4},
  [700] = {.lex_state = 0, .external_lex_state = 12},
  [701] = {.lex_state = 0, .external_lex_state = 15},
  [702] = {.lex_state = 0, .external_lex_state = 15},
  [703] = {.lex_state = 0, .external_lex_state = 12},
  [704] = {.lex_state = 0, .external_lex_state = 10},
  [705] = {.lex_state = 0, .external_lex_state = 5},
  [706] = {.lex_state = 0, .external_lex_state = 15},
  [707] = {.lex_state = 0, .external_lex_state = 7},
  [708] = {.lex_state = 0, .external_lex_state = 15},
  [709] = {.lex_state = 0, .external_lex_state = 14},
  [710] = {.lex_state = 0, .external_lex_state = 9},
  [711] = {.lex_state = 0, .external_lex_state = 8},
  [712] = {.lex_state = 0, .external_lex_state = 12},
  [713] = {.lex_state = 0, .external_lex_state = 6},
  [714] = {.lex_state = 0, .external_lex_state = 6},
  [715] = {.lex_state = 0, .external_lex_state = 6},
  [716] = {.lex_state = 0, .external_lex_state = 4},
  [717] = {.lex_state = 0, .external_lex_state = 4},
  [718] = {.lex_state = 0, .external_lex_state = 3},
  [719] = {.lex_state = 0, .external_lex_state = 3},
  [720] = {.lex_state = 0, .external_lex_state = 3},
  [721] = {.lex_state = 0, .external_lex_state = 3},
  [722] = {.lex_state = 0, .external_lex_state = 3},
  [723] = {.lex_state = 0, .external_lex_state = 3},
  [724] = {.lex_state = 0, .external_lex_state = 3},
  [725] = {.lex_state = 0, .external_lex_state = 3},
  [726] = {.lex_state = 0, .external_lex_state = 3},
  [727] = {.lex_state = 0, .external_lex_state = 5},
  [728] = {.lex_state = 0, .external_lex_state = 5},
  [729] = {.lex_state = 0, .external_lex_state = 5},
  [730] = {.lex_state = 0, .external_lex_state = 5},
  [731] = {.lex_state = 0, .external_lex_state = 5},
  [732] = {.lex_state = 0, .external_lex_state = 5},
  [733] = {.lex_state = 0, .external_lex_state = 6},
  [734] = {.lex_state = 0, .external_lex_state = 7},
  [735] = {.lex_state = 0, .external_lex_state = 7},
  [736] = {.lex_state = 0, .external_lex_state = 7},
  [737] = {.lex_state = 0, .external_lex_state = 7},
  [738] = {.lex_state = 0, .external_lex_state = 7},
  [739] = {.lex_state = 0, .external_lex_state = 7},
  [740] = {.lex_state = 0, .external_lex_state = 7},
  [741] = {.lex_state = 0, .external_lex_state = 7},
  [742] = {.lex_state = 0, .external_lex_state = 7},
  [743] = {.lex_state = 0, .external_lex_state = 5},
  [744] = {.lex_state = 0, .external_lex_state = 5},
  [745] = {.lex_state = 0, .external_lex_state = 4},
  [746] = {.lex_state = 0, .external_lex_state = 4},
  [747] = {.lex_state = 0, .external_lex_state = 4},
  [748] = {.lex_state = 0, .external_lex_state = 4},
  [749] = {.lex_state = 0, .external_lex_state = 4},
  [750] = {.lex_state = 0, .external_lex_state = 4},
  [751] = {.lex_state = 0, .external_lex_state = 4},
  [752] = {.lex_state = 0, .external_lex_state = 6},
  [753] = {.lex_state = 0, .external_lex_state = 6},
  [754] = {.lex_state = 0, .external_lex_state = 6},
  [755] = {.lex_state = 0, .external_lex_state = 6},
  [756] = {.lex_state = 0, .external_lex_state = 6},
  [757] = {.lex_state = 0, .external_lex_state = 5},
  [758] = {.lex_state = 0, .external_lex_state = 9},
  [759] = {.lex_state = 0, .external_lex_state = 9},
  [760] = {.lex_state = 0, .external_lex_state = 12},
  [761] = {.lex_state = 0, .external_lex_state = 8},
  [762] = {.lex_state = 0, .external_lex_state = 8},
  [763] = {.lex_state = 0, .external_lex_state = 12},
  [764] = {.lex_state = 0, .external_lex_state = 9},
  [765] = {.lex_state = 0, .external_lex_state = 6},
  [766] = {.lex_state = 0, .external_lex_state = 12},
  [767] = {.lex_state = 0, .external_lex_state = 8},
  [768] = {.lex_state = 0, .external_lex_state = 12},
  [769] = {.lex_state = 0, .external_lex_state = 8},
  [770] = {.lex_state = 0, .external_lex_state = 8},
  [771] = {.lex_state = 0, .external_lex_state = 12},
  [772] = {.lex_state = 0, .external_lex_state = 14},
  [773] = {.lex_state = 0, .external_lex_state = 9},
  [774] = {.lex_state = 0, .external_lex_state = 14},
  [775] = {.lex_state = 0, .external_lex_state = 12},
  [776] = {.lex_state = 0, .external_lex_state = 8},
  [777] = {.lex_state = 0, .external_lex_state = 8},
  [778] = {.lex_state = 0, .external_lex_state = 12},
  [779] = {.lex_state = 0, .external_lex_state = 8},
  [780] = {.lex_state = 0, .external_lex_state = 14},
  [781] = {.lex_state = 0, .external_lex_state = 14},
  [782] = {.lex_state = 0, .external_lex_state = 15},
  [783] = {.lex_state = 0, .external_lex_state = 12},
  [784] = {.lex_state = 0, .external_lex_state = 12},
  [785] = {.lex_state = 0, .external_lex_state = 3},
  [786] = {.lex_state = 0, .external_lex_state = 7},
  [787] = {.lex_state = 0, .external_lex_state = 9},
  [788] = {.lex_state = 0, .external_lex_state = 12},
  [789] = {.lex_state = 0, .external_lex_state = 14},
  [790] = {.lex_state = 0, .external_lex_state = 15},
  [791] = {.lex_state = 0, .external_lex_state = 15},
  [792] = {.lex_state = 0, .external_lex_state = 15},
  [793] = {.lex_state = 0, .external_lex_state = 15},
  [794] = {.lex_state = 0, .external_lex_state = 15},
  [795] = {.lex_state = 0, .external_lex_state = 9},
  [796] = {.lex_state = 0, .external_lex_state = 9},
  [797] = {.lex_state = 0, .external_lex_state = 9},
  [798] = {.lex_state = 0, .external_lex_state = 9},
  [799] = {.lex_state = 0, .external_lex_state = 15},
  [800] = {.lex_state = 0, .external_lex_state = 15},
  [801] = {.lex_state = 0, .external_lex_state = 4},
  [802] = {.lex_state = 0, .external_lex_state = 14},
  [803] = {.lex_state = 0, .external_lex_state = 8},
  [804] = {.lex_state = 0, .external_lex_state = 5},
  [805] = {.lex_state = 0, .external_lex_state = 15},
  [806] = {.lex_state = 0, .external_lex_state = 15},
  [807] = {.lex_state = 0, .external_lex_state = 14},
  [808] = {.lex_state = 0, .external_lex_state = 14},
  [809] = {.lex_state = 0, .external_lex_state = 9},
  [810] = {.lex_state = 0, .external_lex_state = 14},
  [811] = {.lex_state = 0, .external_lex_state = 7},
  [812] = {.lex_state = 0, .external_lex_state = 4},
  [813] = {.lex_state = 0, .external_lex_state = 6},
  [814] = {.lex_state = 0, .external_lex_state = 6},
  [815] = {.lex_state = 0, .external_lex_state = 6},
  [816] = {.lex_state = 0, .external_lex_state = 3},
  [817] = {.lex_state = 0, .external_lex_state = 3},
  [818] = {.lex_state = 0, .external_lex_state = 3},
  [819] = {.lex_state = 0, .external_lex_state = 3},
  [820] = {.lex_state = 0, .external_lex_state = 3},
  [821] = {.lex_state = 0, .external_lex_state = 3},
  [822] = {.lex_state = 0, .external_lex_state = 3},
  [823] = {.lex_state = 0, .external_lex_state = 4},
  [824] = {.lex_state = 0, .external_lex_state = 5},
  [825] = {.lex_state = 0, .external_lex_state = 4},
  [826] = {.lex_state = 0, .external_lex_state = 4},
  [827] = {.lex_state = 0, .external_lex_state = 3},
  [828] = {.lex_state = 0, .external_lex_state = 3},
  [829] = {.lex_state = 0, .external_lex_state = 3},
  [830] = {.lex_state = 0, .external_lex_state = 3},
  [831] = {.lex_state = 0, .external_lex_state = 16},
  [832] = {.lex_state = 0, .external_lex_state = 8},
  [833] = {.lex_state = 0, .external_lex_state = 16},
  [834] = {.lex_state = 0, .external_lex_state = 4},
  [835] = {.lex_state = 0, .external_lex_state = 6},
  [836] = {.lex_state = 0, .external_lex_state = 6},
  [837] = {.lex_state = 0, .external_lex_state = 6},
  [838] = {.lex_state = 0, .external_lex_state = 7},
  [839] = {.lex_state = 0, .external_lex_state = 6},
  [840] = {.lex_state = 0, .external_lex_state = 4},
  [841] = {.lex_state = 0, .external_lex_state = 5},
  [842] = {.lex_state = 0, .external_lex_state = 5},
  [843] = {.lex_state = 0, .external_lex_state = 5},
  [844] = {.lex_state = 0, .external_lex_state = 5},
  [845] = {.lex_state = 0, .external_lex_state = 4},
  [846] = {.lex_state = 0, .external_lex_state = 4},
  [847] = {.lex_state = 0, .external_lex_state = 7},
  [848] = {.lex_state = 0, .external_lex_state = 7},
  [849] = {.lex_state = 0, .external_lex_state = 5},
  [850] = {.lex_state = 0, .external_lex_state = 7},
  [851] = {.lex_state = 0, .external_lex_state = 7},
  [852] = {.lex_state = 0, .external_lex_state = 7},
  [853] = {.lex_state = 0, .external_lex_state = 7},
  [854] = {.lex_state = 0, .external_lex_state = 7},
  [855] = {.lex_state = 0, .external_lex_state = 16},
  [856] = {.lex_state = 0, .external_lex_state = 5},
  [857] = {.lex_state = 0, .external_lex_state = 5},
  [858] = {.lex_state = 0, .external_lex_state = 16},
  [859] = {.lex_state = 0, .external_lex_state = 12},
  [860] = {.lex_state = 0, .external_lex_state = 7},
  [861] = {.lex_state = 0, .external_lex_state = 7},
  [862] = {.lex_state = 0, .external_lex_state = 7},
  [863] = {.lex_state = 0, .external_lex_state = 7},
  [864] = {.lex_state = 0, .external_lex_state = 7},
  [865] = {.lex_state = 0, .external_lex_state = 7},
  [866] = {.lex_state = 0, .external_lex_state = 16},
  [867] = {.lex_state = 0, .external_lex_state = 16},
  [868] = {.lex_state = 0, .external_lex_state = 5},
  [869] = {.lex_state = 0, .external_lex_state = 14},
  [870] = {.lex_state = 0, .external_lex_state = 5},
  [871] = {.lex_state = 0, .external_lex_state = 7},
  [872] = {.lex_state = 0, .external_lex_state = 7},
  [873] = {.lex_state = 0, .external_lex_state = 7},
  [874] = {.lex_state = 0, .external_lex_state = 7},
  [875] = {.lex_state = 0, .external_lex_state = 5},
  [876] = {.lex_state = 0, .external_lex_state = 16},
  [877] = {.lex_state = 0, .external_lex_state = 5},
  [878] = {.lex_state = 0, .external_lex_state = 5},
  [879] = {.lex_state = 0, .external_lex_state = 5},
  [880] = {.lex_state = 0, .external_lex_state = 5},
  [881] = {.lex_state = 0, .external_lex_state = 4},
  [882] = {.lex_state = 0, .external_lex_state = 6},
  [883] = {.lex_state = 0, .external_lex_state = 3},
  [884] = {.lex_state = 0, .external_lex_state = 16},
  [885] = {.lex_state = 0, .external_lex_state = 6},
  [886] = {.lex_state = 0, .external_lex_state = 6},
  [887] = {.lex_state = 0, .external_lex_state = 5},
  [888] = {.lex_state = 0, .external_lex_state = 5},
  [889] = {.lex_state = 0, .external_lex_state = 5},
  [890] = {.lex_state = 0, .external_lex_state = 5},
  [891] = {.lex_state = 0, .external_lex_state = 16},
  [892] = {.lex_state = 0, .external_lex_state = 15},
  [893] = {.lex_state = 0, .external_lex_state = 4},
  [894] = {.lex_state = 0, .external_lex_state = 6},
  [895] = {.lex_state = 0, .external_lex_state = 3},
  [896] = {.lex_state = 0, .external_lex_state = 3},
  [897] = {.lex_state = 0, .external_lex_state = 16},
  [898] = {.lex_state = 0, .external_lex_state = 4},
  [899] = {.lex_state = 0, .external_lex_state = 4},
  [900] = {.lex_state = 0, .external_lex_state = 4},
  [901] = {.lex_state = 0, .external_lex_state = 16},
  [902] = {.lex_state = 0, .external_lex_state = 4},
  [903] = {.lex_state = 0, .external_lex_state = 3},
  [904] = {.lex_state = 0, .external_lex_state = 16},
  [905] = {.lex_state = 0, .external_lex_state = 4},
  [906] = {.lex_state = 0, .external_lex_state = 16},
  [907] = {.lex_state = 0, .external_lex_state = 3},
  [908] = {.lex_state = 0, .external_lex_state = 3},
  [909] = {.lex_state = 0, .external_lex_state = 4},
  [910] = {.lex_state = 0, .external_lex_state = 16},
  [911] = {.lex_state = 0, .external_lex_state = 6},
  [912] = {.lex_state = 0, .external_lex_state = 3},
  [913] = {.lex_state = 0, .external_lex_state = 3},
  [914] = {.lex_state = 0, .external_lex_state = 16},
  [915] = {.lex_state = 0, .external_lex_state = 16},
  [916] = {.lex_state = 0, .external_lex_state = 16},
  [917] = {.lex_state = 0, .external_lex_state = 4},
  [918] = {.lex_state = 0, .external_lex_state = 16},
  [919] = {.lex_state = 0, .external_lex_state = 4},
  [920] = {.lex_state = 0, .external_lex_state = 6},
  [921] = {.lex_state = 0, .external_lex_state = 16},
  [922] = {.lex_state = 0, .external_lex_state = 6},
  [923] = {.lex_state = 0, .external_lex_state = 16},
  [924] = {.lex_state = 0, .external_lex_state = 16},
  [925] = {.lex_state = 0, .external_lex_state = 6},
  [926] = {.lex_state = 0, .external_lex_state = 16},
  [927] = {.lex_state = 0, .external_lex_state = 6},
  [928] = {.lex_state = 0, .external_lex_state = 6},
  [929] = {.lex_state = 0, .external_lex_state = 9},
  [930] = {.lex_state = 0, .external_lex_state = 6},
  [931] = {.lex_state = 0, .external_lex_state = 16},
  [932] = {.lex_state = 0, .external_lex_state = 6},
  [933] = {.lex_state = 0, .external_lex_state = 16},
  [934] = {.lex_state = 0, .external_lex_state = 4},
  [935] = {.lex_state = 0, .external_lex_state = 15},
  [936] = {.lex_state = 0, .external_lex_state = 10},
  [937] = {.lex_state = 0, .external_lex_state = 15},
  [938] = {.lex_state = 0, .external_lex_state = 8},
  [939] = {.lex_state = 0, .external_lex_state = 8},
  [940] = {.lex_state = 0, .external_lex_state = 8},
  [941] = {.lex_state = 0, .external_lex_state = 9},
  [942] = {.lex_state = 0, .external_lex_state = 8},
  [943] = {.lex_state = 0, .external_lex_state = 12},
  [944] = {.lex_state = 0, .external_lex_state = 12},
  [945] = {.lex_state = 0, .external_lex_state = 12},
  [946] = {.lex_state = 0, .external_lex_state = 15},
  [947] = {.lex_state = 0, .external_lex_state = 12},
  [948] = {.lex_state = 0, .external_lex_state = 12},
  [949] = {.lex_state = 0, .external_lex_state = 8},
  [950] = {.lex_state = 0, .external_lex_state = 14},
  [951] = {.lex_state = 0, .external_lex_state = 11},
  [952] = {.lex_state = 0, .external_lex_state = 14},
  [953] = {.lex_state = 0, .external_lex_state = 8},
  [954] = {.lex_state = 0, .external_lex_state = 14},
  [955] = {.lex_state = 0, .external_lex_state = 14},
  [956] = {.lex_state = 0, .external_lex_state = 12},
  [957] = {.lex_state = 0, .external_lex_state = 8},
  [958] = {.lex_state = 0, .external_lex_state = 8},
  [959] = {.lex_state = 0, .external_lex_state = 8},
  [960] = {.lex_state = 0, .external_lex_state = 12},
  [961] = {.lex_state = 0, .external_lex_state = 9},
  [962] = {.lex_state = 0, .external_lex_state = 12},
  [963] = {.lex_state = 0, .external_lex_state = 13},
  [964] = {.lex_state = 0, .external_lex_state = 15},
  [965] = {.lex_state = 0, .external_lex_state = 8},
  [966] = {.lex_state = 0, .external_lex_state = 14},
  [967] = {.lex_state = 0, .external_lex_state = 9},
  [968] = {.lex_state = 0, .external_lex_state = 13},
  [969] = {.lex_state = 0, .external_lex_state = 8},
  [970] = {.lex_state = 0, .external_lex_state = 9},
  [971] = {.lex_state = 0, .external_lex_state = 12},
  [972] = {.lex_state = 0, .external_lex_state = 9},
  [973] = {.lex_state = 0, .external_lex_state = 9},
  [974] = {.lex_state = 0, .external_lex_state = 15},
  [975] = {.lex_state = 0, .external_lex_state = 15},
  [976] = {.lex_state = 0, .external_lex_state = 13},
  [977] = {.lex_state = 0, .external_lex_state = 15},
  [978] = {.lex_state = 0, .external_lex_state = 15},
  [979] = {.lex_state = 0, .external_lex_state = 15},
  [980] = {.lex_state = 0, .external_lex_state = 12},
  [981] = {.lex_state = 0, .external_lex_state = 12},
  [982] = {.lex_state = 0, .external_lex_state = 15},
  [983] = {.lex_state = 0, .external_lex_state = 8},
  [984] = {.lex_state = 0, .external_lex_state = 12},
  [985] = {.lex_state = 0, .external_lex_state = 16},
  [986] = {.lex_state = 0, .external_lex_state = 15},
  [987] = {.lex_state = 0, .external_lex_state = 8},
  [988] = {.lex_state = 0, .external_lex_state = 9},
  [989] = {.lex_state = 0, .external_lex_state = 2},
  [990] = {.lex_state = 0, .external_lex_state = 14},
  [991] = {.lex_state = 0, .external_lex_state = 9},
  [992] = {.lex_state = 0, .external_lex_state = 9},
  [993] = {.lex_state = 0, .external_lex_state = 14},
  [994] = {.lex_state = 0, .external_lex_state = 13},
  [995] = {.lex_state = 0, .external_lex_state = 15},
  [996] = {.lex_state = 0, .external_lex_state = 12},
  [997] = {.lex_state = 0, .external_lex_state = 9},
  [998] = {.lex_state = 0, .external_lex_state = 12},
  [999] = {.lex_state = 0, .external_lex_state = 13},
  [1000] = {.lex_state = 0, .external_lex_state = 12},
  [1001] = {.lex_state = 0, .external_lex_state = 13},
  [1002] = {.lex_state = 0, .external_lex_state = 2},
  [1003] = {.lex_state = 0, .external_lex_state = 9},
  [1004] = {.lex_state = 0, .external_lex_state = 14},
  [1005] = {.lex_state = 0, .external_lex_state = 9},
  [1006] = {.lex_state = 0, .external_lex_state = 15},
  [1007] = {.lex_state = 0, .external_lex_state = 15},
  [1008] = {.lex_state = 0, .external_lex_state = 13},
  [1009] = {.lex_state = 0, .external_lex_state = 9},
  [1010] = {.lex_state = 0, .external_lex_state = 12},
  [1011] = {.lex_state = 0, .external_lex_state = 15},
  [1012] = {.lex_state = 0, .external_lex_state = 15},
  [1013] = {.lex_state = 0, .external_lex_state = 13},
  [1014] = {.lex_state = 0, .external_lex_state = 15},
  [1015] = {.lex_state = 0, .external_lex_state = 13},
  [1016] = {.lex_state = 0, .external_lex_state = 9},
  [1017] = {.lex_state = 0, .external_lex_state = 9},
  [1018] = {.lex_state = 0, .external_lex_state = 15},
  [1019] = {.lex_state = 0, .external_lex_state = 14},
  [1020] = {.lex_state = 0, .external_lex_state = 13},
  [1021] = {.lex_state = 0, .external_lex_state = 8},
  [1022] = {.lex_state = 0, .external_lex_state = 13},
  [1023] = {.lex_state = 0, .external_lex_state = 9},
  [1024] = {.lex_state = 0, .external_lex_state = 12},
  [1025] = {.lex_state = 0, .external_lex_state = 13},
  [1026] = {.lex_state = 0, .external_lex_state = 14},
  [1027] = {.lex_state = 0, .external_lex_state = 13},
  [1028] = {.lex_state = 0, .external_lex_state = 14},
  [1029] = {.lex_state = 0, .external_lex_state = 13},
  [1030] = {.lex_state = 0, .external_lex_state = 8},
  [1031] = {.lex_state = 0, .external_lex_state = 13},
  [1032] = {.lex_state = 0, .external_lex_state = 15},
  [1033] = {.lex_state = 0, .external_lex_state = 14},
  [1034] = {.lex_state = 0, .external_lex_state = 13},
  [1035] = {.lex_state = 0, .external_lex_state = 9},
  [1036] = {.lex_state = 0, .external_lex_state = 13},
  [1037] = {.lex_state = 0, .external_lex_state = 14},
  [1038] = {.lex_state = 0, .external_lex_state = 14},
  [1039] = {.lex_state = 0, .external_lex_state = 13},
  [1040] = {.lex_state = 0, .external_lex_state = 12},
  [1041] = {.lex_state = 0, .external_lex_state = 13},
  [1042] = {.lex_state = 0, .external_lex_state = 9},
  [1043] = {.lex_state = 0, .external_lex_state = 13},
  [1044] = {.lex_state = 0, .external_lex_state = 12},
  [1045] = {.lex_state = 0, .external_lex_state = 14},
  [1046] = {.lex_state = 0, .external_lex_state = 14},
  [1047] = {.lex_state = 0, .external_lex_state = 9},
  [1048] = {.lex_state = 0, .external_lex_state = 13},
  [1049] = {.lex_state = 0, .external_lex_state = 15},
  [1050] = {.lex_state = 0, .external_lex_state = 13},
  [1051] = {.lex_state = 0, .external_lex_state = 8},
  [1052] = {.lex_state = 0, .external_lex_state = 14},
  [1053] = {.lex_state = 0, .external_lex_state = 14},
  [1054] = {.lex_state = 0, .external_lex_state = 12},
  [1055] = {.lex_state = 0, .external_lex_state = 13},
  [1056] = {.lex_state = 0, .external_lex_state = 14},
  [1057] = {.lex_state = 0, .external_lex_state = 13},
  [1058] = {.lex_state = 0, .external_lex_state = 8},
  [1059] = {.lex_state = 0, .external_lex_state = 9},
  [1060] = {.lex_state = 0, .external_lex_state = 8},
  [1061] = {.lex_state = 0, .external_lex_state = 8},
  [1062] = {.lex_state = 0, .external_lex_state = 13},
  [1063] = {.lex_state = 0, .external_lex_state = 13},
  [1064] = {.lex_state = 0, .external_lex_state = 17},
  [1065] = {.lex_state = 0, .external_lex_state = 17},
  [1066] = {.lex_state = 0, .external_lex_state = 17},
  [1067] = {.lex_state = 0, .external_lex_state = 17},
  [1068] = {.lex_state = 0, .external_lex_state = 17},
  [1069] = {.lex_state = 0, .external_lex_state = 17},
  [1070] = {.lex_state = 0, .external_lex_state = 17},
  [1071] = {.lex_state = 0, .external_lex_state = 17},
  [1072] = {.lex_state = 0, .external_lex_state = 17},
  [1073] = {.lex_state = 0, .external_lex_state = 17},
  [1074] = {.lex_state = 0, .external_lex_state = 17},
  [1075] = {.lex_state = 0, .external_lex_state = 17},
  [1076] = {.lex_state = 0, .external_lex_state = 17},
  [1077] = {.lex_state = 0, .external_lex_state = 17},
  [1078] = {.lex_state = 0, .external_lex_state = 17},
  [1079] = {.lex_state = 0, .external_lex_state = 17},
  [1080] = {.lex_state = 0, .external_lex_state = 17},
  [1081] = {.lex_state = 0, .external_lex_state = 17},
  [1082] = {.lex_state = 0, .external_lex_state = 17},
  [1083] = {.lex_state = 0, .external_lex_state = 17},
  [1084] = {.lex_state = 0, .external_lex_state = 17},
  [1085] = {.lex_state = 0, .external_lex_state = 17},
  [1086] = {.lex_state = 0, .external_lex_state = 17},
  [1087] = {.lex_state = 0, .external_lex_state = 17},
  [1088] = {.lex_state = 0, .external_lex_state = 17},
  [1089] = {.lex_state = 0, .external_lex_state = 17},
  [1090] = {.lex_state = 0, .external_lex_state = 17},
  [1091] = {.lex_state = 0, .external_lex_state = 17},
  [1092] = {.lex_state = 0, .external_lex_state = 17},
  [1093] = {.lex_state = 0, .external_lex_state = 17},
  [1094] = {.lex_state = 0, .external_lex_state = 17},
  [1095] = {.lex_state = 0, .external_lex_state = 18},
  [1096] = {.lex_state = 0, .external_lex_state = 17},
  [1097] = {.lex_state = 0, .external_lex_state = 17},
  [1098] = {.lex_state = 0, .external_lex_state = 17},
  [1099] = {.lex_state = 0, .external_lex_state = 17},
  [1100] = {.lex_state = 0, .external_lex_state = 17},
  [1101] = {.lex_state = 0, .external_lex_state = 17},
  [1102] = {.lex_state = 0, .external_lex_state = 17},
  [1103] = {.lex_state = 0, .external_lex_state = 17},
  [1104] = {.lex_state = 0, .external_lex_state = 17},
  [1105] = {.lex_state = 0, .external_lex_state = 17},
  [1106] = {.lex_state = 0, .external_lex_state = 17},
  [1107] = {.lex_state = 0, .external_lex_state = 17},
  [1108] = {.lex_state = 0, .external_lex_state = 17},
  [1109] = {.lex_state = 0, .external_lex_state = 17},
  [1110] = {.lex_state = 0, .external_lex_state = 17},
  [1111] = {.lex_state = 0, .external_lex_state = 17},
  [1112] = {.lex_state = 0, .external_lex_state = 17},
  [1113] = {.lex_state = 0, .external_lex_state = 17},
  [1114] = {.lex_state = 0, .external_lex_state = 17},
  [1115] = {.lex_state = 0, .external_lex_state = 17},
  [1116] = {.lex_state = 0, .external_lex_state = 17},
  [1117] = {.lex_state = 0, .external_lex_state = 17},
  [1118] = {.lex_state = 0, .external_lex_state = 17},
  [1119] = {.lex_state = 0, .external_lex_state = 17},
  [1120] = {.lex_state = 0, .external_lex_state = 17},
  [1121] = {.lex_state = 0, .external_lex_state = 17},
  [1122] = {.lex_state = 0, .external_lex_state = 17},
  [1123] = {.lex_state = 0, .external_lex_state = 17},
  [1124] = {.lex_state = 0, .external_lex_state = 17},
  [1125] = {.lex_state = 0, .external_lex_state = 17},
  [1126] = {.lex_state = 0, .external_lex_state = 17},
  [1127] = {.lex_state = 0, .external_lex_state = 17},
  [1128] = {.lex_state = 0, .external_lex_state = 17},
  [1129] = {.lex_state = 0, .external_lex_state = 17},
  [1130] = {.lex_state = 0, .external_lex_state = 17},
  [1131] = {.lex_state = 0, .external_lex_state = 17},
  [1132] = {.lex_state = 0, .external_lex_state = 17},
  [1133] = {.lex_state = 0, .external_lex_state = 17},
  [1134] = {.lex_state = 0, .external_lex_state = 17},
  [1135] = {.lex_state = 0, .external_lex_state = 17},
  [1136] = {.lex_state = 0, .external_lex_state = 17},
  [1137] = {.lex_state = 0, .external_lex_state = 17},
  [1138] = {.lex_state = 0, .external_lex_state = 17},
  [1139] = {.lex_state = 0, .external_lex_state = 17},
  [1140] = {.lex_state = 0, .external_lex_state = 17},
  [1141] = {.lex_state = 0, .external_lex_state = 17},
  [1142] = {.lex_state = 0, .external_lex_state = 17},
  [1143] = {.lex_state = 0, .external_lex_state = 17},
  [1144] = {.lex_state = 0, .external_lex_state = 17},
  [1145] = {.lex_state = 0, .external_lex_state = 17},
  [1146] = {.lex_state = 0, .external_lex_state = 17},
  [1147] = {.lex_state = 0, .external_lex_state = 17},
  [1148] = {.lex_state = 0, .external_lex_state = 17},
  [1149] = {.lex_state = 0, .external_lex_state = 17},
  [1150] = {.lex_state = 0, .external_lex_state = 17},
  [1151] = {.lex_state = 0, .external_lex_state = 17},
  [1152] = {.lex_state = 0, .external_lex_state = 17},
  [1153] = {.lex_state = 0, .external_lex_state = 17},
  [1154] = {.lex_state = 0, .external_lex_state = 17},
  [1155] = {.lex_state = 0, .external_lex_state = 17},
  [1156] = {.lex_state = 0, .external_lex_state = 17},
  [1157] = {.lex_state = 0, .external_lex_state = 17},
  [1158] = {.lex_state = 0, .external_lex_state = 17},
  [1159] = {.lex_state = 0, .external_lex_state = 17},
  [1160] = {.lex_state = 0, .external_lex_state = 17},
  [1161] = {.lex_state = 0, .external_lex_state = 17},
  [1162] = {.lex_state = 0, .external_lex_state = 17},
  [1163] = {.lex_state = 0, .external_lex_state = 17},
  [1164] = {.lex_state = 0, .external_lex_state = 17},
  [1165] = {.lex_state = 0, .external_lex_state = 17},
  [1166] = {.lex_state = 0, .external_lex_state = 17},
  [1167] = {.lex_state = 0, .external_lex_state = 17},
  [1168] = {.lex_state = 0, .external_lex_state = 17},
  [1169] = {.lex_state = 0, .external_lex_state = 17},
  [1170] = {.lex_state = 0, .external_lex_state = 17},
  [1171] = {.lex_state = 0, .external_lex_state = 17},
  [1172] = {.lex_state = 0, .external_lex_state = 17},
  [1173] = {.lex_state = 0, .external_lex_state = 17},
  [1174] = {.lex_state = 0, .external_lex_state = 17},
  [1175] = {.lex_state = 0, .external_lex_state = 17},
  [1176] = {.lex_state = 0, .external_lex_state = 17},
  [1177] = {.lex_state = 0, .external_lex_state = 17},
  [1178] = {.lex_state = 0, .external_lex_state = 17},
  [1179] = {.lex_state = 0, .external_lex_state = 17},
  [1180] = {.lex_state = 0, .external_lex_state = 17},
  [1181] = {.lex_state = 0, .external_lex_state = 17},
  [1182] = {.lex_state = 0, .external_lex_state = 17},
  [1183] = {.lex_state = 0, .external_lex_state = 17},
  [1184] = {.lex_state = 0, .external_lex_state = 17},
  [1185] = {.lex_state = 0, .external_lex_state = 17},
  [1186] = {.lex_state = 0, .external_lex_state = 17},
  [1187] = {.lex_state = 0, .external_lex_state = 17},
  [1188] = {.lex_state = 0, .external_lex_state = 17},
  [1189] = {.lex_state = 0, .external_lex_state = 17},
  [1190] = {.lex_state = 0, .external_lex_state = 17},
  [1191] = {.lex_state = 0, .external_lex_state = 17},
  [1192] = {.lex_state = 0, .external_lex_state = 17},
  [1193] = {.lex_state = 0, .external_lex_state = 17},
  [1194] = {.lex_state = 0, .external_lex_state = 17},
  [1195] = {.lex_state = 0, .external_lex_state = 17},
  [1196] = {.lex_state = 0, .external_lex_state = 17},
  [1197] = {.lex_state = 0, .external_lex_state = 17},
  [1198] = {.lex_state = 0, .external_lex_state = 17},
  [1199] = {.lex_state = 0, .external_lex_state = 17},
  [1200] = {.lex_state = 0, .external_lex_state = 17},
  [1201] = {.lex_state = 0, .external_lex_state = 17},
  [1202] = {.lex_state = 0, .external_lex_state = 17},
  [1203] = {.lex_state = 0, .external_lex_state = 17},
  [1204] = {.lex_state = 0, .external_lex_state = 17},
  [1205] = {.lex_state = 0, .external_lex_state = 17},
  [1206] = {.lex_state = 0, .external_lex_state = 17},
  [1207] = {.lex_state = 0, .external_lex_state = 17},
  [1208] = {.lex_state = 0, .external_lex_state = 17},
  [1209] = {.lex_state = 0, .external_lex_state = 17},
  [1210] = {.lex_state = 0, .external_lex_state = 17},
  [1211] = {.lex_state = 0, .external_lex_state = 17},
  [1212] = {.lex_state = 0, .external_lex_state = 17},
  [1213] = {.lex_state = 0, .external_lex_state = 17},
  [1214] = {.lex_state = 0, .external_lex_state = 17},
  [1215] = {.lex_state = 0, .external_lex_state = 17},
  [1216] = {.lex_state = 0, .external_lex_state = 17},
  [1217] = {.lex_state = 0, .external_lex_state = 17},
  [1218] = {.lex_state = 0, .external_lex_state = 17},
  [1219] = {.lex_state = 0, .external_lex_state = 17},
  [1220] = {.lex_state = 0, .external_lex_state = 17},
  [1221] = {.lex_state = 0, .external_lex_state = 17},
  [1222] = {.lex_state = 0, .external_lex_state = 17},
  [1223] = {.lex_state = 0, .external_lex_state = 17},
  [1224] = {.lex_state = 0, .external_lex_state = 17},
  [1225] = {.lex_state = 0, .external_lex_state = 17},
  [1226] = {.lex_state = 0, .external_lex_state = 17},
  [1227] = {.lex_state = 0, .external_lex_state = 17},
  [1228] = {.lex_state = 0, .external_lex_state = 17},
  [1229] = {.lex_state = 0, .external_lex_state = 17},
  [1230] = {.lex_state = 0, .external_lex_state = 17},
  [1231] = {.lex_state = 0, .external_lex_state = 17},
  [1232] = {.lex_state = 0, .external_lex_state = 17},
  [1233] = {.lex_state = 0, .external_lex_state = 17},
  [1234] = {.lex_state = 0, .external_lex_state = 17},
  [1235] = {.lex_state = 0, .external_lex_state = 17},
  [1236] = {.lex_state = 0, .external_lex_state = 17},
  [1237] = {.lex_state = 0, .external_lex_state = 17},
  [1238] = {.lex_state = 0, .external_lex_state = 17},
  [1239] = {.lex_state = 0, .external_lex_state = 17},
  [1240] = {.lex_state = 0, .external_lex_state = 17},
  [1241] = {.lex_state = 0, .external_lex_state = 17},
  [1242] = {.lex_state = 0, .external_lex_state = 17},
  [1243] = {.lex_state = 0, .external_lex_state = 17},
  [1244] = {.lex_state = 0, .external_lex_state = 17},
  [1245] = {.lex_state = 0, .external_lex_state = 17},
  [1246] = {.lex_state = 0, .external_lex_state = 17},
  [1247] = {.lex_state = 0, .external_lex_state = 17},
  [1248] = {.lex_state = 0, .external_lex_state = 17},
  [1249] = {.lex_state = 0, .external_lex_state = 17},
  [1250] = {.lex_state = 0, .external_lex_state = 17},
  [1251] = {.lex_state = 0, .external_lex_state = 17},
  [1252] = {.lex_state = 0, .external_lex_state = 17},
  [1253] = {.lex_state = 0, .external_lex_state = 17},
  [1254] = {.lex_state = 0, .external_lex_state = 17},
  [1255] = {.lex_state = 0, .external_lex_state = 17},
  [1256] = {.lex_state = 0, .external_lex_state = 17},
  [1257] = {.lex_state = 0, .external_lex_state = 17},
  [1258] = {.lex_state = 0, .external_lex_state = 17},
  [1259] = {.lex_state = 0, .external_lex_state = 17},
  [1260] = {.lex_state = 0, .external_lex_state = 17},
  [1261] = {.lex_state = 0, .external_lex_state = 17},
  [1262] = {.lex_state = 0, .external_lex_state = 17},
  [1263] = {.lex_state = 0, .external_lex_state = 17},
  [1264] = {.lex_state = 0, .external_lex_state = 17},
  [1265] = {.lex_state = 0, .external_lex_state = 17},
  [1266] = {.lex_state = 0, .external_lex_state = 17},
  [1267] = {.lex_state = 0, .external_lex_state = 17},
  [1268] = {.lex_state = 0, .external_lex_state = 17},
  [1269] = {.lex_state = 0, .external_lex_state = 17},
  [1270] = {.lex_state = 0, .external_lex_state = 17},
  [1271] = {.lex_state = 0, .external_lex_state = 17},
  [1272] = {.lex_state = 0, .external_lex_state = 17},
  [1273] = {.lex_state = 0, .external_lex_state = 17},
  [1274] = {.lex_state = 0, .external_lex_state = 17},
  [1275] = {.lex_state = 0, .external_lex_state = 17},
  [1276] = {.lex_state = 0, .external_lex_state = 17},
  [1277] = {.lex_state = 0, .external_lex_state = 17},
  [1278] = {.lex_state = 0, .external_lex_state = 17},
  [1279] = {.lex_state = 0, .external_lex_state = 17},
  [1280] = {.lex_state = 0, .external_lex_state = 17},
  [1281] = {.lex_state = 0, .external_lex_state = 17},
  [1282] = {.lex_state = 0, .external_lex_state = 17},
  [1283] = {.lex_state = 0, .external_lex_state = 17},
  [1284] = {.lex_state = 0, .external_lex_state = 17},
  [1285] = {.lex_state = 0, .external_lex_state = 17},
  [1286] = {.lex_state = 0, .external_lex_state = 17},
  [1287] = {.lex_state = 0, .external_lex_state = 17},
  [1288] = {.lex_state = 0, .external_lex_state = 17},
  [1289] = {.lex_state = 0, .external_lex_state = 17},
  [1290] = {.lex_state = 0, .external_lex_state = 17},
  [1291] = {.lex_state = 0, .external_lex_state = 17},
  [1292] = {.lex_state = 0, .external_lex_state = 17},
  [1293] = {.lex_state = 0, .external_lex_state = 17},
  [1294] = {.lex_state = 0, .external_lex_state = 17},
  [1295] = {.lex_state = 0, .external_lex_state = 17},
  [1296] = {.lex_state = 0, .external_lex_state = 17},
  [1297] = {.lex_state = 0, .external_lex_state = 17},
  [1298] = {.lex_state = 0, .external_lex_state = 17},
  [1299] = {.lex_state = 0, .external_lex_state = 17},
  [1300] = {.lex_state = 0, .external_lex_state = 17},
  [1301] = {.lex_state = 0, .external_lex_state = 17},
  [1302] = {.lex_state = 0, .external_lex_state = 17},
  [1303] = {.lex_state = 0, .external_lex_state = 17},
  [1304] = {.lex_state = 0, .external_lex_state = 17},
  [1305] = {.lex_state = 0, .external_lex_state = 17},
  [1306] = {.lex_state = 0, .external_lex_state = 17},
  [1307] = {.lex_state = 0, .external_lex_state = 17},
  [1308] = {.lex_state = 0, .external_lex_state = 17},
  [1309] = {.lex_state = 0, .external_lex_state = 17},
  [1310] = {.lex_state = 0, .external_lex_state = 17},
  [1311] = {.lex_state = 0, .external_lex_state = 17},
  [1312] = {.lex_state = 0, .external_lex_state = 17},
  [1313] = {.lex_state = 0, .external_lex_state = 17},
  [1314] = {.lex_state = 0, .external_lex_state = 17},
  [1315] = {.lex_state = 0, .external_lex_state = 17},
  [1316] = {.lex_state = 0, .external_lex_state = 17},
  [1317] = {.lex_state = 0, .external_lex_state = 17},
  [1318] = {.lex_state = 0, .external_lex_state = 17},
  [1319] = {.lex_state = 0, .external_lex_state = 17},
  [1320] = {.lex_state = 0, .external_lex_state = 17},
  [1321] = {.lex_state = 0, .external_lex_state = 17},
  [1322] = {.lex_state = 0, .external_lex_state = 17},
  [1323] = {.lex_state = 0, .external_lex_state = 17},
  [1324] = {.lex_state = 0, .external_lex_state = 17},
  [1325] = {.lex_state = 0, .external_lex_state = 17},
  [1326] = {.lex_state = 0, .external_lex_state = 17},
  [1327] = {.lex_state = 0, .external_lex_state = 17},
  [1328] = {.lex_state = 0, .external_lex_state = 17},
  [1329] = {.lex_state = 0, .external_lex_state = 17},
  [1330] = {.lex_state = 0, .external_lex_state = 17},
  [1331] = {.lex_state = 0, .external_lex_state = 17},
  [1332] = {.lex_state = 0, .external_lex_state = 17},
  [1333] = {.lex_state = 0, .external_lex_state = 17},
  [1334] = {.lex_state = 0, .external_lex_state = 17},
  [1335] = {.lex_state = 0, .external_lex_state = 17},
  [1336] = {.lex_state = 0, .external_lex_state = 17},
  [1337] = {.lex_state = 0, .external_lex_state = 17},
  [1338] = {.lex_state = 0, .external_lex_state = 17},
  [1339] = {.lex_state = 0, .external_lex_state = 17},
  [1340] = {.lex_state = 0, .external_lex_state = 17},
  [1341] = {.lex_state = 0, .external_lex_state = 17},
  [1342] = {.lex_state = 0, .external_lex_state = 17},
  [1343] = {.lex_state = 0, .external_lex_state = 17},
  [1344] = {.lex_state = 0, .external_lex_state = 17},
  [1345] = {.lex_state = 0, .external_lex_state = 17},
  [1346] = {.lex_state = 0, .external_lex_state = 17},
  [1347] = {.lex_state = 0, .external_lex_state = 17},
  [1348] = {.lex_state = 0, .external_lex_state = 17},
  [1349] = {.lex_state = 0, .external_lex_state = 17},
  [1350] = {.lex_state = 0, .external_lex_state = 17},
  [1351] = {.lex_state = 0, .external_lex_state = 17},
  [1352] = {.lex_state = 0, .external_lex_state = 17},
  [1353] = {.lex_state = 0, .external_lex_state = 17},
  [1354] = {.lex_state = 0, .external_lex_state = 17},
  [1355] = {.lex_state = 0, .external_lex_state = 17},
  [1356] = {.lex_state = 0, .external_lex_state = 17},
  [1357] = {.lex_state = 0, .external_lex_state = 17},
  [1358] = {.lex_state = 0, .external_lex_state = 17},
  [1359] = {.lex_state = 0, .external_lex_state = 17},
  [1360] = {.lex_state = 0, .external_lex_state = 17},
  [1361] = {.lex_state = 0, .external_lex_state = 17},
  [1362] = {.lex_state = 0, .external_lex_state = 17},
  [1363] = {.lex_state = 0, .external_lex_state = 17},
  [1364] = {.lex_state = 0, .external_lex_state = 17},
  [1365] = {.lex_state = 0, .external_lex_state = 17},
  [1366] = {.lex_state = 0, .external_lex_state = 17},
  [1367] = {.lex_state = 0, .external_lex_state = 17},
  [1368] = {.lex_state = 0, .external_lex_state = 17},
  [1369] = {.lex_state = 0, .external_lex_state = 17},
  [1370] = {.lex_state = 0, .external_lex_state = 17},
  [1371] = {.lex_state = 0, .external_lex_state = 17},
  [1372] = {.lex_state = 0, .external_lex_state = 17},
  [1373] = {.lex_state = 0, .external_lex_state = 17},
  [1374] = {.lex_state = 0, .external_lex_state = 17},
  [1375] = {.lex_state = 0, .external_lex_state = 17},
  [1376] = {.lex_state = 0, .external_lex_state = 17},
  [1377] = {.lex_state = 0, .external_lex_state = 17},
  [1378] = {.lex_state = 0, .external_lex_state = 17},
  [1379] = {.lex_state = 0, .external_lex_state = 17},
  [1380] = {.lex_state = 0, .external_lex_state = 17},
  [1381] = {.lex_state = 0, .external_lex_state = 17},
  [1382] = {.lex_state = 0, .external_lex_state = 17},
  [1383] = {.lex_state = 0, .external_lex_state = 17},
  [1384] = {.lex_state = 0, .external_lex_state = 17},
  [1385] = {.lex_state = 0, .external_lex_state = 17},
  [1386] = {.lex_state = 0, .external_lex_state = 17},
  [1387] = {.lex_state = 0, .external_lex_state = 17},
  [1388] = {.lex_state = 0, .external_lex_state = 17},
  [1389] = {.lex_state = 0, .external_lex_state = 17},
  [1390] = {.lex_state = 0, .external_lex_state = 17},
  [1391] = {.lex_state = 0, .external_lex_state = 17},
  [1392] = {.lex_state = 0, .external_lex_state = 17},
  [1393] = {.lex_state = 0, .external_lex_state = 17},
  [1394] = {.lex_state = 0, .external_lex_state = 17},
  [1395] = {.lex_state = 0, .external_lex_state = 17},
  [1396] = {.lex_state = 0, .external_lex_state = 17},
  [1397] = {.lex_state = 0, .external_lex_state = 17},
  [1398] = {.lex_state = 0, .external_lex_state = 17},
  [1399] = {.lex_state = 0, .external_lex_state = 17},
  [1400] = {.lex_state = 0, .external_lex_state = 17},
  [1401] = {.lex_state = 0, .external_lex_state = 17},
  [1402] = {.lex_state = 0, .external_lex_state = 17},
  [1403] = {.lex_state = 0, .external_lex_state = 17},
  [1404] = {.lex_state = 0, .external_lex_state = 17},
  [1405] = {.lex_state = 0, .external_lex_state = 17},
  [1406] = {.lex_state = 0, .external_lex_state = 17},
  [1407] = {.lex_state = 0, .external_lex_state = 17},
  [1408] = {.lex_state = 0, .external_lex_state = 17},
  [1409] = {.lex_state = 0, .external_lex_state = 17},
  [1410] = {.lex_state = 0, .external_lex_state = 17},
  [1411] = {.lex_state = 0, .external_lex_state = 17},
  [1412] = {.lex_state = 0, .external_lex_state = 17},
  [1413] = {.lex_state = 0, .external_lex_state = 17},
  [1414] = {.lex_state = 0, .external_lex_state = 17},
  [1415] = {.lex_state = 0, .external_lex_state = 17},
  [1416] = {.lex_state = 0, .external_lex_state = 17},
  [1417] = {.lex_state = 0, .external_lex_state = 17},
  [1418] = {.lex_state = 0, .external_lex_state = 17},
  [1419] = {.lex_state = 0, .external_lex_state = 17},
  [1420] = {.lex_state = 0, .external_lex_state = 17},
  [1421] = {.lex_state = 0, .external_lex_state = 17},
  [1422] = {.lex_state = 0, .external_lex_state = 17},
  [1423] = {.lex_state = 0, .external_lex_state = 17},
  [1424] = {.lex_state = 0, .external_lex_state = 17},
  [1425] = {.lex_state = 0, .external_lex_state = 17},
  [1426] = {.lex_state = 0, .external_lex_state = 17},
  [1427] = {.lex_state = 0, .external_lex_state = 17},
  [1428] = {.lex_state = 0, .external_lex_state = 17},
  [1429] = {.lex_state = 0, .external_lex_state = 17},
  [1430] = {.lex_state = 0, .external_lex_state = 17},
  [1431] = {.lex_state = 0, .external_lex_state = 17},
  [1432] = {.lex_state = 0, .external_lex_state = 17},
  [1433] = {.lex_state = 0, .external_lex_state = 17},
  [1434] = {.lex_state = 0, .external_lex_state = 17},
  [1435] = {.lex_state = 0, .external_lex_state = 17},
  [1436] = {.lex_state = 0, .external_lex_state = 17},
  [1437] = {.lex_state = 0, .external_lex_state = 17},
  [1438] = {.lex_state = 0, .external_lex_state = 17},
  [1439] = {.lex_state = 0, .external_lex_state = 17},
  [1440] = {.lex_state = 0, .external_lex_state = 17},
  [1441] = {.lex_state = 0, .external_lex_state = 17},
  [1442] = {.lex_state = 0, .external_lex_state = 17},
  [1443] = {.lex_state = 0, .external_lex_state = 17},
  [1444] = {.lex_state = 0, .external_lex_state = 17},
  [1445] = {.lex_state = 0, .external_lex_state = 17},
  [1446] = {.lex_state = 0, .external_lex_state = 17},
  [1447] = {.lex_state = 0, .external_lex_state = 17},
  [1448] = {.lex_state = 0, .external_lex_state = 17},
  [1449] = {.lex_state = 0, .external_lex_state = 17},
  [1450] = {.lex_state = 0, .external_lex_state = 17},
  [1451] = {.lex_state = 0, .external_lex_state = 17},
  [1452] = {.lex_state = 0, .external_lex_state = 17},
  [1453] = {.lex_state = 0, .external_lex_state = 17},
  [1454] = {.lex_state = 0, .external_lex_state = 17},
  [1455] = {.lex_state = 0, .external_lex_state = 17},
  [1456] = {.lex_state = 0, .external_lex_state = 17},
  [1457] = {.lex_state = 0, .external_lex_state = 17},
  [1458] = {.lex_state = 0, .external_lex_state = 17},
  [1459] = {.lex_state = 0, .external_lex_state = 17},
  [1460] = {.lex_state = 0, .external_lex_state = 17},
  [1461] = {.lex_state = 0, .external_lex_state = 17},
  [1462] = {.lex_state = 0, .external_lex_state = 17},
  [1463] = {.lex_state = 0, .external_lex_state = 17},
  [1464] = {.lex_state = 0, .external_lex_state = 17},
  [1465] = {.lex_state = 0, .external_lex_state = 17},
  [1466] = {.lex_state = 0, .external_lex_state = 17},
  [1467] = {.lex_state = 0, .external_lex_state = 17},
  [1468] = {.lex_state = 0, .external_lex_state = 17},
  [1469] = {.lex_state = 0, .external_lex_state = 17},
  [1470] = {.lex_state = 0, .external_lex_state = 17},
  [1471] = {.lex_state = 0, .external_lex_state = 17},
  [1472] = {.lex_state = 0, .external_lex_state = 17},
  [1473] = {.lex_state = 0, .external_lex_state = 17},
  [1474] = {.lex_state = 0, .external_lex_state = 17},
  [1475] = {.lex_state = 0, .external_lex_state = 17},
  [1476] = {.lex_state = 0, .external_lex_state = 17},
  [1477] = {.lex_state = 0, .external_lex_state = 17},
  [1478] = {.lex_state = 0, .external_lex_state = 17},
  [1479] = {.lex_state = 0, .external_lex_state = 17},
  [1480] = {.lex_state = 0, .external_lex_state = 17},
  [1481] = {.lex_state = 0, .external_lex_state = 17},
  [1482] = {.lex_state = 0, .external_lex_state = 17},
  [1483] = {.lex_state = 0, .external_lex_state = 17},
  [1484] = {.lex_state = 0, .external_lex_state = 17},
  [1485] = {.lex_state = 0, .external_lex_state = 17},
  [1486] = {.lex_state = 0, .external_lex_state = 17},
  [1487] = {.lex_state = 0, .external_lex_state = 17},
  [1488] = {.lex_state = 0, .external_lex_state = 17},
  [1489] = {.lex_state = 0, .external_lex_state = 17},
  [1490] = {.lex_state = 0, .external_lex_state = 17},
  [1491] = {.lex_state = 0, .external_lex_state = 17},
  [1492] = {.lex_state = 0, .external_lex_state = 17},
  [1493] = {.lex_state = 0, .external_lex_state = 17},
  [1494] = {.lex_state = 0, .external_lex_state = 17},
  [1495] = {.lex_state = 0, .external_lex_state = 17},
  [1496] = {.lex_state = 0, .external_lex_state = 17},
  [1497] = {.lex_state = 0, .external_lex_state = 17},
  [1498] = {.lex_state = 0, .external_lex_state = 17},
  [1499] = {.lex_state = 0, .external_lex_state = 17},
  [1500] = {.lex_state = 0, .external_lex_state = 17},
  [1501] = {.lex_state = 0, .external_lex_state = 17},
  [1502] = {.lex_state = 0, .external_lex_state = 17},
  [1503] = {.lex_state = 0, .external_lex_state = 17},
  [1504] = {.lex_state = 0, .external_lex_state = 17},
  [1505] = {.lex_state = 0, .external_lex_state = 17},
  [1506] = {.lex_state = 0, .external_lex_state = 17},
  [1507] = {.lex_state = 0, .external_lex_state = 17},
  [1508] = {.lex_state = 0, .external_lex_state = 17},
  [1509] = {.lex_state = 0, .external_lex_state = 17},
  [1510] = {.lex_state = 0, .external_lex_state = 17},
  [1511] = {.lex_state = 0, .external_lex_state = 17},
  [1512] = {.lex_state = 0, .external_lex_state = 17},
  [1513] = {.lex_state = 0, .external_lex_state = 17},
  [1514] = {.lex_state = 0, .external_lex_state = 17},
  [1515] = {.lex_state = 0, .external_lex_state = 17},
  [1516] = {.lex_state = 0, .external_lex_state = 17},
  [1517] = {.lex_state = 0, .external_lex_state = 17},
  [1518] = {.lex_state = 0, .external_lex_state = 17},
  [1519] = {.lex_state = 0, .external_lex_state = 17},
  [1520] = {.lex_state = 0, .external_lex_state = 17},
  [1521] = {.lex_state = 0, .external_lex_state = 17},
  [1522] = {.lex_state = 0, .external_lex_state = 17},
  [1523] = {.lex_state = 0, .external_lex_state = 17},
  [1524] = {.lex_state = 0, .external_lex_state = 17},
  [1525] = {.lex_state = 0, .external_lex_state = 17},
  [1526] = {.lex_state = 0, .external_lex_state = 17},
  [1527] = {.lex_state = 0, .external_lex_state = 17},
  [1528] = {.lex_state = 0, .external_lex_state = 17},
  [1529] = {.lex_state = 0, .external_lex_state = 17},
  [1530] = {.lex_state = 0, .external_lex_state = 17},
  [1531] = {.lex_state = 0, .external_lex_state = 17},
  [1532] = {.lex_state = 0, .external_lex_state = 17},
  [1533] = {.lex_state = 0, .external_lex_state = 17},
  [1534] = {.lex_state = 0, .external_lex_state = 17},
  [1535] = {.lex_state = 0, .external_lex_state = 17},
  [1536] = {.lex_state = 0, .external_lex_state = 17},
  [1537] = {.lex_state = 0, .external_lex_state = 17},
  [1538] = {.lex_state = 0, .external_lex_state = 17},
  [1539] = {.lex_state = 0, .external_lex_state = 17},
  [1540] = {.lex_state = 0, .external_lex_state = 17},
  [1541] = {.lex_state = 0, .external_lex_state = 17},
  [1542] = {.lex_state = 0, .external_lex_state = 17},
  [1543] = {.lex_state = 0, .external_lex_state = 17},
  [1544] = {.lex_state = 0, .external_lex_state = 17},
  [1545] = {.lex_state = 0, .external_lex_state = 17},
  [1546] = {.lex_state = 0, .external_lex_state = 17},
  [1547] = {.lex_state = 0, .external_lex_state = 17},
  [1548] = {.lex_state = 0, .external_lex_state = 17},
  [1549] = {.lex_state = 0, .external_lex_state = 17},
  [1550] = {.lex_state = 0, .external_lex_state = 17},
  [1551] = {.lex_state = 0, .external_lex_state = 17},
  [1552] = {.lex_state = 0, .external_lex_state = 17},
  [1553] = {.lex_state = 0, .external_lex_state = 17},
  [1554] = {.lex_state = 0, .external_lex_state = 17},
  [1555] = {.lex_state = 0, .external_lex_state = 17},
  [1556] = {.lex_state = 0, .external_lex_state = 17},
  [1557] = {.lex_state = 0, .external_lex_state = 17},
  [1558] = {.lex_state = 0, .external_lex_state = 17},
  [1559] = {.lex_state = 0, .external_lex_state = 17},
  [1560] = {.lex_state = 0, .external_lex_state = 17},
  [1561] = {.lex_state = 0, .external_lex_state = 17},
  [1562] = {.lex_state = 0, .external_lex_state = 17},
  [1563] = {.lex_state = 0, .external_lex_state = 17},
  [1564] = {.lex_state = 0, .external_lex_state = 17},
  [1565] = {.lex_state = 0, .external_lex_state = 17},
  [1566] = {.lex_state = 0, .external_lex_state = 17},
  [1567] = {.lex_state = 0, .external_lex_state = 17},
  [1568] = {.lex_state = 0, .external_lex_state = 17},
  [1569] = {.lex_state = 0, .external_lex_state = 17},
  [1570] = {.lex_state = 0, .external_lex_state = 17},
  [1571] = {.lex_state = 0, .external_lex_state = 17},
  [1572] = {.lex_state = 0, .external_lex_state = 17},
  [1573] = {.lex_state = 0, .external_lex_state = 17},
  [1574] = {.lex_state = 0, .external_lex_state = 17},
  [1575] = {.lex_state = 0, .external_lex_state = 17},
  [1576] = {.lex_state = 0, .external_lex_state = 17},
  [1577] = {.lex_state = 0, .external_lex_state = 17},
  [1578] = {.lex_state = 0, .external_lex_state = 17},
  [1579] = {.lex_state = 0, .external_lex_state = 17},
  [1580] = {.lex_state = 0, .external_lex_state = 17},
  [1581] = {.lex_state = 0, .external_lex_state = 17},
  [1582] = {.lex_state = 0, .external_lex_state = 17},
  [1583] = {.lex_state = 0, .external_lex_state = 17},
  [1584] = {.lex_state = 0, .external_lex_state = 17},
  [1585] = {.lex_state = 0, .external_lex_state = 17},
  [1586] = {.lex_state = 0, .external_lex_state = 17},
  [1587] = {.lex_state = 0, .external_lex_state = 17},
  [1588] = {.lex_state = 0, .external_lex_state = 17},
  [1589] = {.lex_state = 0, .external_lex_state = 17},
  [1590] = {.lex_state = 0, .external_lex_state = 17},
  [1591] = {.lex_state = 0, .external_lex_state = 17},
  [1592] = {.lex_state = 0, .external_lex_state = 17},
  [1593] = {.lex_state = 0, .external_lex_state = 17},
  [1594] = {.lex_state = 0, .external_lex_state = 17},
  [1595] = {.lex_state = 0, .external_lex_state = 17},
  [1596] = {.lex_state = 0, .external_lex_state = 17},
  [1597] = {.lex_state = 0, .external_lex_state = 17},
  [1598] = {.lex_state = 0, .external_lex_state = 17},
  [1599] = {.lex_state = 0, .external_lex_state = 17},
  [1600] = {.lex_state = 0, .external_lex_state = 17},
  [1601] = {.lex_state = 0, .external_lex_state = 17},
  [1602] = {.lex_state = 0, .external_lex_state = 17},
  [1603] = {.lex_state = 0, .external_lex_state = 17},
  [1604] = {.lex_state = 0, .external_lex_state = 17},
  [1605] = {.lex_state = 0, .external_lex_state = 17},
  [1606] = {.lex_state = 0, .external_lex_state = 17},
  [1607] = {.lex_state = 0, .external_lex_state = 17},
  [1608] = {.lex_state = 0, .external_lex_state = 17},
  [1609] = {.lex_state = 0, .external_lex_state = 17},
  [1610] = {.lex_state = 0, .external_lex_state = 17},
  [1611] = {.lex_state = 0, .external_lex_state = 17},
  [1612] = {.lex_state = 0, .external_lex_state = 17},
  [1613] = {.lex_state = 0, .external_lex_state = 17},
  [1614] = {.lex_state = 0, .external_lex_state = 17},
  [1615] = {.lex_state = 0, .external_lex_state = 17},
  [1616] = {.lex_state = 0, .external_lex_state = 17},
  [1617] = {.lex_state = 0, .external_lex_state = 17},
  [1618] = {.lex_state = 0, .external_lex_state = 17},
  [1619] = {.lex_state = 0, .external_lex_state = 17},
  [1620] = {.lex_state = 0, .external_lex_state = 17},
  [1621] = {.lex_state = 0, .external_lex_state = 17},
  [1622] = {.lex_state = 0, .external_lex_state = 17},
  [1623] = {.lex_state = 0, .external_lex_state = 17},
  [1624] = {.lex_state = 0, .external_lex_state = 17},
  [1625] = {.lex_state = 0, .external_lex_state = 17},
  [1626] = {.lex_state = 0, .external_lex_state = 17},
  [1627] = {.lex_state = 0, .external_lex_state = 17},
  [1628] = {.lex_state = 0, .external_lex_state = 17},
  [1629] = {.lex_state = 0, .external_lex_state = 17},
  [1630] = {.lex_state = 0, .external_lex_state = 17},
  [1631] = {.lex_state = 0, .external_lex_state = 17},
  [1632] = {.lex_state = 0, .external_lex_state = 17},
  [1633] = {.lex_state = 0, .external_lex_state = 17},
  [1634] = {.lex_state = 0, .external_lex_state = 17},
  [1635] = {.lex_state = 0, .external_lex_state = 17},
  [1636] = {.lex_state = 0, .external_lex_state = 17},
  [1637] = {.lex_state = 0, .external_lex_state = 17},
  [1638] = {.lex_state = 0, .external_lex_state = 17},
  [1639] = {.lex_state = 0, .external_lex_state = 17},
  [1640] = {.lex_state = 0, .external_lex_state = 17},
  [1641] = {.lex_state = 0, .external_lex_state = 17},
  [1642] = {.lex_state = 0, .external_lex_state = 17},
  [1643] = {.lex_state = 0, .external_lex_state = 17},
  [1644] = {.lex_state = 0, .external_lex_state = 17},
  [1645] = {.lex_state = 0, .external_lex_state = 17},
  [1646] = {.lex_state = 0, .external_lex_state = 17},
  [1647] = {.lex_state = 0, .external_lex_state = 17},
  [1648] = {.lex_state = 0, .external_lex_state = 17},
  [1649] = {.lex_state = 0, .external_lex_state = 17},
  [1650] = {.lex_state = 0, .external_lex_state = 17},
  [1651] = {.lex_state = 0, .external_lex_state = 17},
  [1652] = {.lex_state = 0, .external_lex_state = 17},
  [1653] = {.lex_state = 0, .external_lex_state = 17},
  [1654] = {.lex_state = 0, .external_lex_state = 17},
  [1655] = {.lex_state = 0, .external_lex_state = 17},
  [1656] = {.lex_state = 0, .external_lex_state = 17},
  [1657] = {.lex_state = 0, .external_lex_state = 17},
  [1658] = {.lex_state = 0, .external_lex_state = 17},
  [1659] = {.lex_state = 0, .external_lex_state = 17},
  [1660] = {.lex_state = 0, .external_lex_state = 17},
  [1661] = {.lex_state = 0, .external_lex_state = 17},
  [1662] = {.lex_state = 0, .external_lex_state = 17},
  [1663] = {.lex_state = 0, .external_lex_state = 17},
  [1664] = {.lex_state = 0, .external_lex_state = 17},
  [1665] = {.lex_state = 0, .external_lex_state = 17},
  [1666] = {.lex_state = 0, .external_lex_state = 17},
  [1667] = {.lex_state = 0, .external_lex_state = 17},
  [1668] = {.lex_state = 0, .external_lex_state = 17},
  [1669] = {.lex_state = 0, .external_lex_state = 17},
  [1670] = {.lex_state = 0, .external_lex_state = 17},
  [1671] = {.lex_state = 0, .external_lex_state = 17},
  [1672] = {.lex_state = 0, .external_lex_state = 17},
  [1673] = {.lex_state = 0, .external_lex_state = 17},
  [1674] = {.lex_state = 0, .external_lex_state = 17},
  [1675] = {.lex_state = 0, .external_lex_state = 17},
  [1676] = {.lex_state = 0, .external_lex_state = 17},
  [1677] = {.lex_state = 0, .external_lex_state = 17},
  [1678] = {.lex_state = 0, .external_lex_state = 17},
  [1679] = {.lex_state = 0, .external_lex_state = 17},
  [1680] = {.lex_state = 0, .external_lex_state = 17},
  [1681] = {.lex_state = 0, .external_lex_state = 17},
  [1682] = {.lex_state = 0, .external_lex_state = 17},
  [1683] = {.lex_state = 0, .external_lex_state = 17},
  [1684] = {.lex_state = 0, .external_lex_state = 17},
  [1685] = {.lex_state = 0, .external_lex_state = 17},
  [1686] = {.lex_state = 0, .external_lex_state = 17},
  [1687] = {.lex_state = 0, .external_lex_state = 17},
  [1688] = {.lex_state = 0, .external_lex_state = 17},
  [1689] = {.lex_state = 0, .external_lex_state = 17},
  [1690] = {.lex_state = 0, .external_lex_state = 17},
  [1691] = {.lex_state = 0, .external_lex_state = 17},
  [1692] = {.lex_state = 0, .external_lex_state = 17},
  [1693] = {.lex_state = 0, .external_lex_state = 17},
  [1694] = {.lex_state = 0, .external_lex_state = 17},
  [1695] = {.lex_state = 0, .external_lex_state = 17},
  [1696] = {.lex_state = 0, .external_lex_state = 17},
  [1697] = {.lex_state = 0, .external_lex_state = 17},
  [1698] = {.lex_state = 0, .external_lex_state = 17},
  [1699] = {.lex_state = 0, .external_lex_state = 17},
  [1700] = {.lex_state = 0, .external_lex_state = 17},
  [1701] = {.lex_state = 0, .external_lex_state = 17},
  [1702] = {.lex_state = 0, .external_lex_state = 17},
  [1703] = {.lex_state = 0, .external_lex_state = 17},
  [1704] = {.lex_state = 0, .external_lex_state = 17},
  [1705] = {.lex_state = 0, .external_lex_state = 17},
  [1706] = {.lex_state = 0, .external_lex_state = 17},
  [1707] = {.lex_state = 0, .external_lex_state = 17},
  [1708] = {.lex_state = 0, .external_lex_state = 17},
  [1709] = {.lex_state = 0, .external_lex_state = 17},
  [1710] = {.lex_state = 0, .external_lex_state = 17},
  [1711] = {.lex_state = 0, .external_lex_state = 17},
  [1712] = {.lex_state = 0, .external_lex_state = 17},
  [1713] = {.lex_state = 0, .external_lex_state = 17},
  [1714] = {.lex_state = 0, .external_lex_state = 17},
  [1715] = {.lex_state = 0, .external_lex_state = 17},
  [1716] = {.lex_state = 0, .external_lex_state = 17},
  [1717] = {.lex_state = 0, .external_lex_state = 17},
  [1718] = {.lex_state = 0, .external_lex_state = 17},
  [1719] = {.lex_state = 0, .external_lex_state = 17},
  [1720] = {.lex_state = 0, .external_lex_state = 17},
  [1721] = {.lex_state = 0, .external_lex_state = 17},
  [1722] = {.lex_state = 0, .external_lex_state = 17},
  [1723] = {.lex_state = 0, .external_lex_state = 17},
  [1724] = {.lex_state = 0, .external_lex_state = 17},
  [1725] = {.lex_state = 0, .external_lex_state = 17},
  [1726] = {.lex_state = 0, .external_lex_state = 17},
  [1727] = {.lex_state = 0, .external_lex_state = 17},
  [1728] = {.lex_state = 0, .external_lex_state = 17},
  [1729] = {.lex_state = 0, .external_lex_state = 17},
  [1730] = {.lex_state = 0, .external_lex_state = 17},
  [1731] = {.lex_state = 0, .external_lex_state = 17},
  [1732] = {.lex_state = 0, .external_lex_state = 17},
  [1733] = {.lex_state = 0, .external_lex_state = 17},
  [1734] = {.lex_state = 0, .external_lex_state = 17},
  [1735] = {.lex_state = 0, .external_lex_state = 17},
  [1736] = {.lex_state = 0, .external_lex_state = 17},
  [1737] = {.lex_state = 0, .external_lex_state = 17},
  [1738] = {.lex_state = 0, .external_lex_state = 17},
  [1739] = {.lex_state = 0, .external_lex_state = 17},
  [1740] = {.lex_state = 0, .external_lex_state = 17},
  [1741] = {.lex_state = 0, .external_lex_state = 17},
  [1742] = {.lex_state = 0, .external_lex_state = 17},
  [1743] = {.lex_state = 0, .external_lex_state = 17},
  [1744] = {.lex_state = 0, .external_lex_state = 17},
  [1745] = {.lex_state = 0, .external_lex_state = 17},
  [1746] = {.lex_state = 0, .external_lex_state = 17},
  [1747] = {.lex_state = 0, .external_lex_state = 17},
  [1748] = {.lex_state = 0, .external_lex_state = 17},
  [1749] = {.lex_state = 0, .external_lex_state = 17},
  [1750] = {.lex_state = 0, .external_lex_state = 17},
  [1751] = {.lex_state = 0, .external_lex_state = 17},
  [1752] = {.lex_state = 0, .external_lex_state = 17},
  [1753] = {.lex_state = 0, .external_lex_state = 17},
  [1754] = {.lex_state = 0, .external_lex_state = 17},
  [1755] = {.lex_state = 0, .external_lex_state = 17},
  [1756] = {.lex_state = 0, .external_lex_state = 17},
  [1757] = {.lex_state = 0, .external_lex_state = 17},
  [1758] = {.lex_state = 0, .external_lex_state = 17},
  [1759] = {.lex_state = 0, .external_lex_state = 17},
  [1760] = {.lex_state = 0, .external_lex_state = 17},
  [1761] = {.lex_state = 0, .external_lex_state = 17},
  [1762] = {.lex_state = 0, .external_lex_state = 17},
  [1763] = {.lex_state = 0, .external_lex_state = 17},
  [1764] = {.lex_state = 0, .external_lex_state = 17},
  [1765] = {.lex_state = 0, .external_lex_state = 17},
  [1766] = {.lex_state = 0, .external_lex_state = 17},
  [1767] = {.lex_state = 0, .external_lex_state = 17},
  [1768] = {.lex_state = 0, .external_lex_state = 17},
  [1769] = {.lex_state = 0, .external_lex_state = 17},
  [1770] = {.lex_state = 0, .external_lex_state = 17},
  [1771] = {.lex_state = 0, .external_lex_state = 17},
  [1772] = {.lex_state = 0, .external_lex_state = 17},
  [1773] = {.lex_state = 0, .external_lex_state = 17},
  [1774] = {.lex_state = 0, .external_lex_state = 17},
  [1775] = {.lex_state = 0, .external_lex_state = 17},
  [1776] = {.lex_state = 0, .external_lex_state = 17},
  [1777] = {.lex_state = 0, .external_lex_state = 17},
  [1778] = {.lex_state = 0, .external_lex_state = 17},
  [1779] = {.lex_state = 0, .external_lex_state = 19},
  [1780] = {.lex_state = 0, .external_lex_state = 19},
  [1781] = {.lex_state = 0, .external_lex_state = 19},
  [1782] = {.lex_state = 0, .external_lex_state = 19},
  [1783] = {.lex_state = 0, .external_lex_state = 19},
  [1784] = {.lex_state = 0, .external_lex_state = 19},
  [1785] = {.lex_state = 0, .external_lex_state = 19},
  [1786] = {.lex_state = 0, .external_lex_state = 19},
  [1787] = {.lex_state = 0, .external_lex_state = 19},
  [1788] = {.lex_state = 0, .external_lex_state = 19},
  [1789] = {.lex_state = 0, .external_lex_state = 19},
  [1790] = {.lex_state = 0, .external_lex_state = 19},
  [1791] = {.lex_state = 0, .external_lex_state = 19},
  [1792] = {.lex_state = 0, .external_lex_state = 19},
  [1793] = {.lex_state = 0, .external_lex_state = 19},
  [1794] = {.lex_state = 0, .external_lex_state = 19},
  [1795] = {.lex_state = 0, .external_lex_state = 19},
  [1796] = {.lex_state = 0, .external_lex_state = 19},
  [1797] = {.lex_state = 0, .external_lex_state = 19},
  [1798] = {.lex_state = 0, .external_lex_state = 19},
  [1799] = {.lex_state = 0, .external_lex_state = 19},
  [1800] = {.lex_state = 0, .external_lex_state = 19},
  [1801] = {.lex_state = 0, .external_lex_state = 19},
  [1802] = {.lex_state = 0, .external_lex_state = 19},
  [1803] = {.lex_state = 0, .external_lex_state = 19},
  [1804] = {.lex_state = 0, .external_lex_state = 19},
  [1805] = {.lex_state = 0, .external_lex_state = 19},
  [1806] = {.lex_state = 0, .external_lex_state = 19},
  [1807] = {.lex_state = 0, .external_lex_state = 19},
  [1808] = {.lex_state = 0, .external_lex_state = 19},
  [1809] = {.lex_state = 0, .external_lex_state = 19},
  [1810] = {.lex_state = 0, .external_lex_state = 19},
  [1811] = {.lex_state = 0, .external_lex_state = 19},
  [1812] = {.lex_state = 0, .external_lex_state = 19},
  [1813] = {.lex_state = 0, .external_lex_state = 19},
  [1814] = {.lex_state = 0, .external_lex_state = 19},
  [1815] = {.lex_state = 0, .external_lex_state = 19},
  [1816] = {.lex_state = 0, .external_lex_state = 19},
  [1817] = {.lex_state = 0, .external_lex_state = 19},
  [1818] = {.lex_state = 0, .external_lex_state = 19},
  [1819] = {.lex_state = 0, .external_lex_state = 19},
  [1820] = {.lex_state = 0, .external_lex_state = 19},
  [1821] = {.lex_state = 0, .external_lex_state = 19},
  [1822] = {.lex_state = 0, .external_lex_state = 19},
  [1823] = {.lex_state = 0, .external_lex_state = 19},
  [1824] = {.lex_state = 0, .external_lex_state = 19},
  [1825] = {.lex_state = 0, .external_lex_state = 19},
  [1826] = {.lex_state = 0, .external_lex_state = 19},
  [1827] = {.lex_state = 0, .external_lex_state = 19},
  [1828] = {.lex_state = 0, .external_lex_state = 19},
  [1829] = {.lex_state = 0, .external_lex_state = 19},
  [1830] = {.lex_state = 0, .external_lex_state = 19},
  [1831] = {.lex_state = 0, .external_lex_state = 19},
  [1832] = {.lex_state = 0, .external_lex_state = 19},
  [1833] = {.lex_state = 0, .external_lex_state = 19},
  [1834] = {.lex_state = 0, .external_lex_state = 19},
  [1835] = {.lex_state = 0, .external_lex_state = 19},
  [1836] = {.lex_state = 0, .external_lex_state = 19},
  [1837] = {.lex_state = 0, .external_lex_state = 19},
  [1838] = {.lex_state = 0, .external_lex_state = 19},
  [1839] = {.lex_state = 0, .external_lex_state = 19},
  [1840] = {.lex_state = 0, .external_lex_state = 19},
  [1841] = {.lex_state = 0, .external_lex_state = 19},
  [1842] = {.lex_state = 0, .external_lex_state = 19},
  [1843] = {.lex_state = 0, .external_lex_state = 19},
  [1844] = {.lex_state = 0, .external_lex_state = 19},
  [1845] = {.lex_state = 0, .external_lex_state = 19},
  [1846] = {.lex_state = 0, .external_lex_state = 19},
  [1847] = {.lex_state = 0, .external_lex_state = 19},
  [1848] = {.lex_state = 0, .external_lex_state = 19},
  [1849] = {.lex_state = 0, .external_lex_state = 19},
  [1850] = {.lex_state = 0, .external_lex_state = 19},
  [1851] = {.lex_state = 1, .external_lex_state = 20},
  [1852] = {.lex_state = 1, .external_lex_state = 20},
  [1853] = {.lex_state = 1, .external_lex_state = 21},
  [1854] = {.lex_state = 1, .external_lex_state = 21},
  [1855] = {.lex_state = 1, .external_lex_state = 22},
  [1856] = {.lex_state = 0, .external_lex_state = 23},
  [1857] = {.lex_state = 0, .external_lex_state = 23},
  [1858] = {.lex_state = 0, .external_lex_state = 23},
  [1859] = {.lex_state = 0, .external_lex_state = 23},
  [1860] = {.lex_state = 1, .external_lex_state = 24},
  [1861] = {.lex_state = 0, .external_lex_state = 23},
  [1862] = {.lex_state = 0, .external_lex_state = 23},
  [1863] = {.lex_state = 0, .external_lex_state = 23},
  [1864] = {.lex_state = 0, .external_lex_state = 23},
  [1865] = {.lex_state = 0, .external_lex_state = 23},
  [1866] = {.lex_state = 0, .external_lex_state = 23},
  [1867] = {.lex_state = 0, .external_lex_state = 23},
  [1868] = {.lex_state = 0, .external_lex_state = 23},
  [1869] = {.lex_state = 0, .external_lex_state = 23},
  [1870] = {.lex_state = 0, .external_lex_state = 23},
  [1871] = {.lex_state = 0, .external_lex_state = 23},
  [1872] = {.lex_state = 0, .external_lex_state = 23},
  [1873] = {.lex_state = 0, .external_lex_state = 23},
  [1874] = {.lex_state = 0, .external_lex_state = 23},
  [1875] = {.lex_state = 0, .external_lex_state = 23},
  [1876] = {.lex_state = 0, .external_lex_state = 23},
  [1877] = {.lex_state = 0, .external_lex_state = 23},
  [1878] = {.lex_state = 0, .external_lex_state = 23},
  [1879] = {.lex_state = 0, .external_lex_state = 23},
  [1880] = {.lex_state = 0, .external_lex_state = 23},
  [1881] = {.lex_state = 0, .external_lex_state = 23},
  [1882] = {.lex_state = 0, .external_lex_state = 23},
  [1883] = {.lex_state = 0, .external_lex_state = 23},
  [1884] = {.lex_state = 0, .external_lex_state = 23},
  [1885] = {.lex_state = 0, .external_lex_state = 23},
  [1886] = {.lex_state = 0, .external_lex_state = 23},
  [1887] = {.lex_state = 0, .external_lex_state = 23},
  [1888] = {.lex_state = 0, .external_lex_state = 23},
  [1889] = {.lex_state = 0, .external_lex_state = 23},
  [1890] = {.lex_state = 0, .external_lex_state = 23},
  [1891] = {.lex_state = 0, .external_lex_state = 23},
  [1892] = {.lex_state = 1, .external_lex_state = 20},
  [1893] = {.lex_state = 0, .external_lex_state = 23},
  [1894] = {.lex_state = 0, .external_lex_state = 23},
  [1895] = {.lex_state = 0, .external_lex_state = 23},
  [1896] = {.lex_state = 0, .external_lex_state = 23},
  [1897] = {.lex_state = 0, .external_lex_state = 23},
  [1898] = {.lex_state = 0, .external_lex_state = 23},
  [1899] = {.lex_state = 0, .external_lex_state = 23},
  [1900] = {.lex_state = 0, .external_lex_state = 23},
  [1901] = {.lex_state = 0, .external_lex_state = 23},
  [1902] = {.lex_state = 0, .external_lex_state = 23},
  [1903] = {.lex_state = 0, .external_lex_state = 23},
  [1904] = {.lex_state = 0, .external_lex_state = 23},
  [1905] = {.lex_state = 0, .external_lex_state = 23},
  [1906] = {.lex_state = 0, .external_lex_state = 23},
  [1907] = {.lex_state = 0, .external_lex_state = 23},
  [1908] = {.lex_state = 0, .external_lex_state = 23},
  [1909] = {.lex_state = 0, .external_lex_state = 23},
  [1910] = {.lex_state = 0, .external_lex_state = 23},
  [1911] = {.lex_state = 0, .external_lex_state = 23},
  [1912] = {.lex_state = 0, .external_lex_state = 23},
  [1913] = {.lex_state = 0, .external_lex_state = 23},
  [1914] = {.lex_state = 0, .external_lex_state = 23},
  [1915] = {.lex_state = 0, .external_lex_state = 23},
  [1916] = {.lex_state = 0, .external_lex_state = 23},
  [1917] = {.lex_state = 0, .external_lex_state = 23},
  [1918] = {.lex_state = 0, .external_lex_state = 23},
  [1919] = {.lex_state = 0, .external_lex_state = 23},
  [1920] = {.lex_state = 0, .external_lex_state = 23},
  [1921] = {.lex_state = 0, .external_lex_state = 23},
  [1922] = {.lex_state = 0, .external_lex_state = 25},
  [1923] = {.lex_state = 0, .external_lex_state = 25},
  [1924] = {.lex_state = 0, .external_lex_state = 25},
  [1925] = {.lex_state = 0, .external_lex_state = 25},
  [1926] = {.lex_state = 0, .external_lex_state = 25},
  [1927] = {.lex_state = 0, .external_lex_state = 25},
  [1928] = {.lex_state = 0, .external_lex_state = 25},
  [1929] = {.lex_state = 0, .external_lex_state = 25},
  [1930] = {.lex_state = 0, .external_lex_state = 25},
  [1931] = {.lex_state = 0, .external_lex_state = 25},
  [1932] = {.lex_state = 0, .external_lex_state = 25},
  [1933] = {.lex_state = 0, .external_lex_state = 25},
  [1934] = {.lex_state = 0, .external_lex_state = 25},
  [1935] = {.lex_state = 0, .external_lex_state = 25},
  [1936] = {.lex_state = 0, .external_lex_state = 25},
  [1937] = {.lex_state = 0, .external_lex_state = 25},
  [1938] = {.lex_state = 0, .external_lex_state = 25},
  [1939] = {.lex_state = 0, .external_lex_state = 25},
  [1940] = {.lex_state = 0, .external_lex_state = 25},
  [1941] = {.lex_state = 0, .external_lex_state = 25},
  [1942] = {.lex_state = 0, .external_lex_state = 25},
  [1943] = {.lex_state = 0, .external_lex_state = 25},
  [1944] = {.lex_state = 0, .external_lex_state = 25},
  [1945] = {.lex_state = 0, .external_lex_state = 25},
  [1946] = {.lex_state = 0, .external_lex_state = 25},
  [1947] = {.lex_state = 0, .external_lex_state = 25},
  [1948] = {.lex_state = 0, .external_lex_state = 25},
  [1949] = {.lex_state = 0, .external_lex_state = 25},
  [1950] = {.lex_state = 0, .external_lex_state = 25},
  [1951] = {.lex_state = 0, .external_lex_state = 25},
  [1952] = {.lex_state = 0, .external_lex_state = 25},
  [1953] = {.lex_state = 0, .external_lex_state = 25},
  [1954] = {.lex_state = 0, .external_lex_state = 25},
  [1955] = {.lex_state = 0, .external_lex_state = 25},
  [1956] = {.lex_state = 0, .external_lex_state = 25},
  [1957] = {.lex_state = 0, .external_lex_state = 25},
  [1958] = {.lex_state = 0, .external_lex_state = 25},
  [1959] = {.lex_state = 0, .external_lex_state = 25},
  [1960] = {.lex_state = 1, .external_lex_state = 21},
  [1961] = {.lex_state = 0, .external_lex_state = 25},
  [1962] = {.lex_state = 0, .external_lex_state = 25},
  [1963] = {.lex_state = 0, .external_lex_state = 25},
  [1964] = {.lex_state = 0, .external_lex_state = 25},
  [1965] = {.lex_state = 0, .external_lex_state = 25},
  [1966] = {.lex_state = 0, .external_lex_state = 25},
  [1967] = {.lex_state = 0, .external_lex_state = 25},
  [1968] = {.lex_state = 0, .external_lex_state = 25},
  [1969] = {.lex_state = 0, .external_lex_state = 25},
  [1970] = {.lex_state = 0, .external_lex_state = 25},
  [1971] = {.lex_state = 0, .external_lex_state = 25},
  [1972] = {.lex_state = 0, .external_lex_state = 25},
  [1973] = {.lex_state = 0, .external_lex_state = 25},
  [1974] = {.lex_state = 0, .external_lex_state = 25},
  [1975] = {.lex_state = 0, .external_lex_state = 25},
  [1976] = {.lex_state = 0, .external_lex_state = 25},
  [1977] = {.lex_state = 0, .external_lex_state = 25},
  [1978] = {.lex_state = 0, .external_lex_state = 25},
  [1979] = {.lex_state = 0, .external_lex_state = 25},
  [1980] = {.lex_state = 0, .external_lex_state = 25},
  [1981] = {.lex_state = 0, .external_lex_state = 25},
  [1982] = {.lex_state = 0, .external_lex_state = 25},
  [1983] = {.lex_state = 0, .external_lex_state = 25},
  [1984] = {.lex_state = 0, .external_lex_state = 25},
  [1985] = {.lex_state = 0, .external_lex_state = 25},
  [1986] = {.lex_state = 0, .external_lex_state = 25},
  [1987] = {.lex_state = 0, .external_lex_state = 25},
  [1988] = {.lex_state = 0, .external_lex_state = 25},
  [1989] = {.lex_state = 0, .external_lex_state = 25},
  [1990] = {.lex_state = 0, .external_lex_state = 25},
  [1991] = {.lex_state = 0, .external_lex_state = 25},
  [1992] = {.lex_state = 0, .external_lex_state = 25},
  [1993] = {.lex_state = 0, .external_lex_state = 25},
  [1994] = {.lex_state = 0, .external_lex_state = 25},
  [1995] = {.lex_state = 0, .external_lex_state = 25},
  [1996] = {.lex_state = 0, .external_lex_state = 25},
  [1997] = {.lex_state = 0, .external_lex_state = 25},
  [1998] = {.lex_state = 0, .external_lex_state = 25},
  [1999] = {.lex_state = 0, .external_lex_state = 25},
  [2000] = {.lex_state = 0, .external_lex_state = 25},
  [2001] = {.lex_state = 0, .external_lex_state = 25},
  [2002] = {.lex_state = 0, .external_lex_state = 25},
  [2003] = {.lex_state = 0, .external_lex_state = 25},
  [2004] = {.lex_state = 0, .external_lex_state = 25},
  [2005] = {.lex_state = 0, .external_lex_state = 25},
  [2006] = {.lex_state = 0, .external_lex_state = 25},
  [2007] = {.lex_state = 0, .external_lex_state = 25},
  [2008] = {.lex_state = 0, .external_lex_state = 25},
  [2009] = {.lex_state = 0, .external_lex_state = 25},
  [2010] = {.lex_state = 0, .external_lex_state = 25},
  [2011] = {.lex_state = 0, .external_lex_state = 25},
  [2012] = {.lex_state = 0, .external_lex_state = 25},
  [2013] = {.lex_state = 0, .external_lex_state = 25},
  [2014] = {.lex_state = 0, .external_lex_state = 25},
  [2015] = {.lex_state = 0, .external_lex_state = 25},
  [2016] = {.lex_state = 0, .external_lex_state = 25},
  [2017] = {.lex_state = 0, .external_lex_state = 25},
  [2018] = {.lex_state = 0, .external_lex_state = 25},
  [2019] = {.lex_state = 0, .external_lex_state = 25},
  [2020] = {.lex_state = 0, .external_lex_state = 25},
  [2021] = {.lex_state = 0, .external_lex_state = 25},
  [2022] = {.lex_state = 0, .external_lex_state = 25},
  [2023] = {.lex_state = 0, .external_lex_state = 25},
  [2024] = {.lex_state = 0, .external_lex_state = 25},
  [2025] = {.lex_state = 0, .external_lex_state = 25},
  [2026] = {.lex_state = 0, .external_lex_state = 25},
  [2027] = {.lex_state = 0, .external_lex_state = 25},
  [2028] = {.lex_state = 0, .external_lex_state = 25},
  [2029] = {.lex_state = 0, .external_lex_state = 25},
  [2030] = {.lex_state = 0, .external_lex_state = 25},
  [2031] = {.lex_state = 0, .external_lex_state = 25},
  [2032] = {.lex_state = 0, .external_lex_state = 25},
  [2033] = {.lex_state = 0, .external_lex_state = 25},
  [2034] = {.lex_state = 0, .external_lex_state = 25},
  [2035] = {.lex_state = 0, .external_lex_state = 25},
  [2036] = {.lex_state = 0, .external_lex_state = 25},
  [2037] = {.lex_state = 0, .external_lex_state = 25},
  [2038] = {.lex_state = 0, .external_lex_state = 25},
  [2039] = {.lex_state = 0, .external_lex_state = 25},
  [2040] = {.lex_state = 0, .external_lex_state = 25},
  [2041] = {.lex_state = 0, .external_lex_state = 25},
  [2042] = {.lex_state = 0, .external_lex_state = 25},
  [2043] = {.lex_state = 0, .external_lex_state = 25},
  [2044] = {.lex_state = 0, .external_lex_state = 25},
  [2045] = {.lex_state = 0, .external_lex_state = 25},
  [2046] = {.lex_state = 0, .external_lex_state = 25},
  [2047] = {.lex_state = 0, .external_lex_state = 25},
  [2048] = {.lex_state = 0, .external_lex_state = 25},
  [2049] = {.lex_state = 0, .external_lex_state = 25},
  [2050] = {.lex_state = 0, .external_lex_state = 25},
  [2051] = {.lex_state = 0, .external_lex_state = 25},
  [2052] = {.lex_state = 0, .external_lex_state = 11},
  [2053] = {.lex_state = 0, .external_lex_state = 10},
  [2054] = {.lex_state = 0, .external_lex_state = 11},
  [2055] = {.lex_state = 0, .external_lex_state = 23},
  [2056] = {.lex_state = 0, .external_lex_state = 23},
  [2057] = {.lex_state = 0, .external_lex_state = 10},
  [2058] = {.lex_state = 0, .external_lex_state = 23},
  [2059] = {.lex_state = 0, .external_lex_state = 13},
  [2060] = {.lex_state = 0, .external_lex_state = 16},
  [2061] = {.lex_state = 0, .external_lex_state = 10},
  [2062] = {.lex_state = 0, .external_lex_state = 23},
  [2063] = {.lex_state = 0, .external_lex_state = 13},
  [2064] = {.lex_state = 1, .external_lex_state = 23},
  [2065] = {.lex_state = 0, .external_lex_state = 23},
  [2066] = {.lex_state = 0, .external_lex_state = 13},
  [2067] = {.lex_state = 0, .external_lex_state = 13},
  [2068] = {.lex_state = 0, .external_lex_state = 23},
  [2069] = {.lex_state = 0, .external_lex_state = 13},
  [2070] = {.lex_state = 0, .external_lex_state = 10},
  [2071] = {.lex_state = 0, .external_lex_state = 23},
  [2072] = {.lex_state = 0, .external_lex_state = 11},
  [2073] = {.lex_state = 0, .external_lex_state = 23},
  [2074] = {.lex_state = 0, .external_lex_state = 10},
  [2075] = {.lex_state = 0, .external_lex_state = 13},
  [2076] = {.lex_state = 0, .external_lex_state = 10},
  [2077] = {.lex_state = 0, .external_lex_state = 13},
  [2078] = {.lex_state = 0, .external_lex_state = 11},
  [2079] = {.lex_state = 0, .external_lex_state = 11},
  [2080] = {.lex_state = 0, .external_lex_state = 10},
  [2081] = {.lex_state = 0, .external_lex_state = 11},
  [2082] = {.lex_state = 0, .external_lex_state = 11},
  [2083] = {.lex_state = 0, .external_lex_state = 25},
  [2084] = {.lex_state = 0, .external_lex_state = 17},
  [2085] = {.lex_state = 0, .external_lex_state = 25},
  [2086] = {.lex_state = 0, .external_lex_state = 25},
  [2087] = {.lex_state = 1, .external_lex_state = 25},
  [2088] = {.lex_state = 0, .external_lex_state = 25},
  [2089] = {.lex_state = 0, .external_lex_state = 25},
  [2090] = {.lex_state = 0, .external_lex_state = 25},
  [2091] = {.lex_state = 0, .external_lex_state = 25},
  [2092] = {.lex_state = 0, .external_lex_state = 25},
  [2093] = {.lex_state = 0, .external_lex_state = 13},
  [2094] = {.lex_state = 0, .external_lex_state = 23},
  [2095] = {.lex_state = 0, .external_lex_state = 17},
  [2096] = {.lex_state = 0, .external_lex_state = 23},
  [2097] = {.lex_state = 0, .external_lex_state = 23},
  [2098] = {.lex_state = 0, .external_lex_state = 23},
  [2099] = {.lex_state = 0, .external_lex_state = 23},
  [2100] = {.lex_state = 0, .external_lex_state = 23},
  [2101] = {.lex_state = 0, .external_lex_state = 23},
  [2102] = {.lex_state = 0, .external_lex_state = 23},
  [2103] = {.lex_state = 0, .external_lex_state = 23},
  [2104] = {.lex_state = 0, .external_lex_state = 23},
  [2105] = {.lex_state = 0, .external_lex_state = 17},
  [2106] = {.lex_state = 0, .external_lex_state = 23},
  [2107] = {.lex_state = 0, .external_lex_state = 23},
  [2108] = {.lex_state = 0, .external_lex_state = 23},
  [2109] = {.lex_state = 0, .external_lex_state = 23},
  [2110] = {.lex_state = 0, .external_lex_state = 23},
  [2111] = {.lex_state = 0, .external_lex_state = 17},
  [2112] = {.lex_state = 0, .external_lex_state = 23},
  [2113] = {.lex_state = 0, .external_lex_state = 23},
  [2114] = {.lex_state = 0, .external_lex_state = 23},
  [2115] = {.lex_state = 0, .external_lex_state = 23},
  [2116] = {.lex_state = 0, .external_lex_state = 25},
  [2117] = {.lex_state = 0, .external_lex_state = 25},
  [2118] = {.lex_state = 0, .external_lex_state = 25},
  [2119] = {.lex_state = 0, .external_lex_state = 25},
  [2120] = {.lex_state = 0, .external_lex_state = 25},
  [2121] = {.lex_state = 0, .external_lex_state = 25},
  [2122] = {.lex_state = 0, .external_lex_state = 25},
  [2123] = {.lex_state = 0, .external_lex_state = 25},
  [2124] = {.lex_state = 0, .external_lex_state = 25},
  [2125] = {.lex_state = 0, .external_lex_state = 25},
  [2126] = {.lex_state = 0, .external_lex_state = 25},
  [2127] = {.lex_state = 0, .external_lex_state = 25},
  [2128] = {.lex_state = 0, .external_lex_state = 25},
  [2129] = {.lex_state = 0, .external_lex_state = 25},
  [2130] = {.lex_state = 0, .external_lex_state = 25},
  [2131] = {.lex_state = 0, .external_lex_state = 25},
  [2132] = {.lex_state = 0, .external_lex_state = 25},
  [2133] = {.lex_state = 0, .external_lex_state = 25},
  [2134] = {.lex_state = 0, .external_lex_state = 25},
  [2135] = {.lex_state = 3, .external_lex_state = 26},
  [2136] = {.lex_state = 0, .external_lex_state = 27},
  [2137] = {.lex_state = 0, .external_lex_state = 27},
  [2138] = {.lex_state = 0, .external_lex_state = 27},
  [2139] = {.lex_state = 0, .external_lex_state = 27},
  [2140] = {.lex_state = 0, .external_lex_state = 27},
  [2141] = {.lex_state = 0, .external_lex_state = 27},
  [2142] = {.lex_state = 0, .external_lex_state = 27},
  [2143] = {.lex_state = 0, .external_lex_state = 27},
  [2144] = {.lex_state = 0, .external_lex_state = 27},
  [2145] = {.lex_state = 0, .external_lex_state = 27},
  [2146] = {.lex_state = 0, .external_lex_state = 27},
  [2147] = {.lex_state = 0, .external_lex_state = 27},
  [2148] = {.lex_state = 0, .external_lex_state = 27},
  [2149] = {.lex_state = 0, .external_lex_state = 27},
  [2150] = {.lex_state = 0, .external_lex_state = 27},
  [2151] = {.lex_state = 0, .external_lex_state = 27},
  [2152] = {.lex_state = 0, .external_lex_state = 27},
  [2153] = {.lex_state = 0, .external_lex_state = 27},
  [2154] = {.lex_state = 0, .external_lex_state = 27},
  [2155] = {.lex_state = 0, .external_lex_state = 27},
  [2156] = {.lex_state = 0, .external_lex_state = 27},
  [2157] = {.lex_state = 3},
  [2158] = {.lex_state = 0, .external_lex_state = 27},
  [2159] = {.lex_state = 0, .external_lex_state = 27},
  [2160] = {.lex_state = 0, .external_lex_state = 27},
  [2161] = {.lex_state = 4},
  [2162] = {.lex_state = 4},
  [2163] = {.lex_state = 2},
  [2164] = {.lex_state = 0, .external_lex_state = 27},
  [2165] = {.lex_state = 2},
  [2166] = {.lex_state = 4},
  [2167] = {.lex_state = 4},
  [2168] = {.lex_state = 4},
  [2169] = {.lex_state = 2},
  [2170] = {.lex_state = 0, .external_lex_state = 27},
  [2171] = {.lex_state = 2},
  [2172] = {.lex_state = 4},
  [2173] = {.lex_state = 0, .external_lex_state = 27},
  [2174] = {.lex_state = 2},
  [2175] = {.lex_state = 2},
  [2176] = {.lex_state = 2},
  [2177] = {.lex_state = 4},
  [2178] = {.lex_state = 4},
  [2179] = {.lex_state = 2},
  [2180] = {.lex_state = 2},
  [2181] = {.lex_state = 4},
  [2182] = {.lex_state = 2},
  [2183] = {.lex_state = 2},
  [2184] = {.lex_state = 0, .external_lex_state = 26},
  [2185] = {.lex_state = 2},
  [2186] = {.lex_state = 4},
  [2187] = {.lex_state = 4},
  [2188] = {.lex_state = 2},
  [2189] = {.lex_state = 2},
  [2190] = {.lex_state = 2},
  [2191] = {.lex_state = 0, .external_lex_state = 26},
  [2192] = {.lex_state = 4},
  [2193] = {.lex_state = 4},
  [2194] = {.lex_state = 4},
  [2195] = {.lex_state = 2},
  [2196] = {.lex_state = 4},
  [2197] = {.lex_state = 2},
  [2198] = {.lex_state = 4},
  [2199] = {.lex_state = 4},
  [2200] = {.lex_state = 0, .external_lex_state = 27},
  [2201] = {.lex_state = 2},
  [2202] = {.lex_state = 0, .external_lex_state = 27},
  [2203] = {.lex_state = 2},
  [2204] = {.lex_state = 4},
  [2205] = {.lex_state = 0, .external_lex_state = 27},
  [2206] = {.lex_state = 0, .external_lex_state = 27},
  [2207] = {.lex_state = 4},
  [2208] = {.lex_state = 0, .external_lex_state = 27},
  [2209] = {.lex_state = 4},
  [2210] = {.lex_state = 0, .external_lex_state = 27},
  [2211] = {.lex_state = 2},
  [2212] = {.lex_state = 0, .external_lex_state = 27},
  [2213] = {.lex_state = 4},
  [2214] = {.lex_state = 0, .external_lex_state = 27},
  [2215] = {.lex_state = 4},
  [2216] = {.lex_state = 0, .external_lex_state = 27},
  [2217] = {.lex_state = 0, .external_lex_state = 27},
  [2218] = {.lex_state = 0, .external_lex_state = 27},
  [2219] = {.lex_state = 2},
  [2220] = {.lex_state = 0, .external_lex_state = 27},
  [2221] = {.lex_state = 2},
  [2222] = {.lex_state = 0, .external_lex_state = 27},
  [2223] = {.lex_state = 0, .external_lex_state = 27},
  [2224] = {.lex_state = 0, .external_lex_state = 27},
  [2225] = {.lex_state = 0, .external_lex_state = 27},
  [2226] = {.lex_state = 2},
  [2227] = {.lex_state = 0, .external_lex_state = 27},
  [2228] = {.lex_state = 2},
  [2229] = {.lex_state = 0, .external_lex_state = 27},
  [2230] = {.lex_state = 2},
  [2231] = {.lex_state = 0, .external_lex_state = 27},
  [2232] = {.lex_state = 0, .external_lex_state = 27},
  [2233] = {.lex_state = 4},
  [2234] = {.lex_state = 0, .external_lex_state = 27},
  [2235] = {.lex_state = 4},
  [2236] = {.lex_state = 0, .external_lex_state = 27},
  [2237] = {.lex_state = 0, .external_lex_state = 27},
  [2238] = {.lex_state = 0, .external_lex_state = 27},
  [2239] = {.lex_state = 0, .external_lex_state = 27},
  [2240] = {.lex_state = 0, .external_lex_state = 27},
  [2241] = {.lex_state = 4},
  [2242] = {.lex_state = 0, .external_lex_state = 27},
  [2243] = {.lex_state = 0, .external_lex_state = 27},
  [2244] = {.lex_state = 0, .external_lex_state = 27},
  [2245] = {.lex_state = 0, .external_lex_state = 27},
  [2246] = {.lex_state = 0, .external_lex_state = 27},
  [2247] = {.lex_state = 0, .external_lex_state = 27},
  [2248] = {.lex_state = 0, .external_lex_state = 27},
  [2249] = {.lex_state = 0, .external_lex_state = 27},
  [2250] = {.lex_state = 0, .external_lex_state = 27},
  [2251] = {.lex_state = 0, .external_lex_state = 27},
  [2252] = {.lex_state = 0, .external_lex_state = 27},
  [2253] = {.lex_state = 0, .external_lex_state = 27},
  [2254] = {.lex_state = 0, .external_lex_state = 27},
  [2255] = {.lex_state = 0, .external_lex_state = 27},
  [2256] = {.lex_state = 0, .external_lex_state = 27},
  [2257] = {.lex_state = 0, .external_lex_state = 27},
  [2258] = {.lex_state = 0, .external_lex_state = 27},
  [2259] = {.lex_state = 0, .external_lex_state = 27},
  [2260] = {.lex_state = 0, .external_lex_state = 27},
  [2261] = {.lex_state = 0, .external_lex_state = 27},
  [2262] = {.lex_state = 0, .external_lex_state = 27},
  [2263] = {.lex_state = 0, .external_lex_state = 27},
  [2264] = {.lex_state = 0, .external_lex_state = 27},
  [2265] = {.lex_state = 0, .external_lex_state = 27},
  [2266] = {.lex_state = 0, .external_lex_state = 27},
  [2267] = {.lex_state = 0, .external_lex_state = 27},
  [2268] = {.lex_state = 0, .external_lex_state = 27},
  [2269] = {.lex_state = 0, .external_lex_state = 27},
  [2270] = {.lex_state = 0, .external_lex_state = 27},
  [2271] = {.lex_state = 0, .external_lex_state = 27},
  [2272] = {.lex_state = 0, .external_lex_state = 27},
  [2273] = {.lex_state = 0, .external_lex_state = 27},
  [2274] = {.lex_state = 0, .external_lex_state = 27},
  [2275] = {.lex_state = 0, .external_lex_state = 27},
  [2276] = {.lex_state = 0, .external_lex_state = 27},
  [2277] = {.lex_state = 0, .external_lex_state = 27},
  [2278] = {.lex_state = 0, .external_lex_state = 27},
  [2279] = {.lex_state = 0, .external_lex_state = 27},
  [2280] = {.lex_state = 0, .external_lex_state = 27},
  [2281] = {.lex_state = 0, .external_lex_state = 27},
  [2282] = {.lex_state = 0, .external_lex_state = 27},
  [2283] = {.lex_state = 0, .external_lex_state = 27},
  [2284] = {.lex_state = 0, .external_lex_state = 27},
  [2285] = {.lex_state = 0, .external_lex_state = 26},
  [2286] = {.lex_state = 2},
  [2287] = {.lex_state = 0, .external_lex_state = 27},
  [2288] = {.lex_state = 0, .external_lex_state = 26},
  [2289] = {.lex_state = 4},
  [2290] = {.lex_state = 0},
  [2291] = {.lex_state = 0},
  [2292] = {.lex_state = 0},
  [2293] = {.lex_state = 0},
  [2294] = {.lex_state = 0, .external_lex_state = 26},
  [2295] = {.lex_state = 0},
  [2296] = {.lex_state = 0, .external_lex_state = 26},
  [2297] = {.lex_state = 0, .external_lex_state = 26},
  [2298] = {.lex_state = 0},
  [2299] = {.lex_state = 0},
  [2300] = {.lex_state = 0},
  [2301] = {.lex_state = 0},
  [2302] = {.lex_state = 0},
  [2303] = {.lex_state = 0},
  [2304] = {.lex_state = 0, .external_lex_state = 26},
  [2305] = {.lex_state = 0},
  [2306] = {.lex_state = 1},
  [2307] = {.lex_state = 1},
  [2308] = {.lex_state = 1},
  [2309] = {.lex_state = 1},
  [2310] = {.lex_state = 1},
  [2311] = {.lex_state = 1},
  [2312] = {.lex_state = 1},
  [2313] = {.lex_state = 1},
  [2314] = {.lex_state = 1},
  [2315] = {.lex_state = 1},
  [2316] = {.lex_state = 1},
  [2317] = {.lex_state = 1},
  [2318] = {.lex_state = 1},
  [2319] = {.lex_state = 1},
  [2320] = {.lex_state = 1},
  [2321] = {.lex_state = 1},
  [2322] = {.lex_state = 1},
  [2323] = {.lex_state = 1},
  [2324] = {.lex_state = 1},
  [2325] = {.lex_state = 1},
  [2326] = {.lex_state = 1},
  [2327] = {.lex_state = 1},
  [2328] = {.lex_state = 1},
  [2329] = {.lex_state = 1},
  [2330] = {.lex_state = 1},
  [2331] = {.lex_state = 1},
  [2332] = {.lex_state = 1},
  [2333] = {.lex_state = 1},
  [2334] = {.lex_state = 1},
  [2335] = {.lex_state = 1},
  [2336] = {.lex_state = 1},
  [2337] = {.lex_state = 1},
  [2338] = {.lex_state = 1},
  [2339] = {.lex_state = 1},
  [2340] = {.lex_state = 1},
  [2341] = {.lex_state = 1},
  [2342] = {.lex_state = 1},
  [2343] = {.lex_state = 1},
  [2344] = {.lex_state = 1},
  [2345] = {.lex_state = 1},
  [2346] = {.lex_state = 1},
  [2347] = {.lex_state = 0},
  [2348] = {.lex_state = 1},
  [2349] = {.lex_state = 1},
  [2350] = {.lex_state = 1},
  [2351] = {.lex_state = 1},
  [2352] = {.lex_state = 1},
  [2353] = {.lex_state = 1},
  [2354] = {.lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DASH_GT_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [aux_sym_binary_operator_token1] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [anon_sym_L] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [sym__hex_literal] = ACTIONS(1),
    [sym__number_literal] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_return] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [sym_dot_dot_i] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__semicolon] = ACTIONS(1),
    [sym__raw_string_literal] = ACTIONS(1),
    [sym__external_else] = ACTIONS(1),
    [sym__external_open_parenthesis] = ACTIONS(1),
    [sym__external_close_parenthesis] = ACTIONS(1),
    [sym__external_open_brace] = ACTIONS(1),
    [sym__external_close_brace] = ACTIONS(1),
    [sym__external_open_bracket] = ACTIONS(1),
    [sym__external_close_bracket] = ACTIONS(1),
    [sym__external_open_bracket2] = ACTIONS(1),
    [sym__external_close_bracket2] = ACTIONS(1),
    [sym__error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(2347),
    [sym_function_definition] = STATE(556),
    [sym_if_statement] = STATE(556),
    [sym_for_statement] = STATE(556),
    [sym_while_statement] = STATE(556),
    [sym_repeat_statement] = STATE(556),
    [sym_braced_expression] = STATE(556),
    [sym_parenthesized_expression] = STATE(556),
    [sym_call] = STATE(556),
    [sym_subset] = STATE(556),
    [sym_subset2] = STATE(556),
    [sym_unary_operator] = STATE(556),
    [sym_binary_operator] = STATE(556),
    [sym_extract_operator] = STATE(556),
    [sym_namespace_operator] = STATE(556),
    [sym_integer] = STATE(556),
    [sym_complex] = STATE(556),
    [sym_float] = STATE(556),
    [sym__float_literal] = STATE(776),
    [sym_string] = STATE(769),
    [sym__single_quoted_string] = STATE(777),
    [sym__double_quoted_string] = STATE(779),
    [sym_na] = STATE(556),
    [sym__expression] = STATE(556),
    [sym__string_or_identifier] = STATE(2305),
    [sym__open_parenthesis] = STATE(1039),
    [sym__open_brace] = STATE(924),
    [aux_sym_program_repeat1] = STATE(1002),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_function] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_for] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [sym__hex_literal] = ACTIONS(29),
    [sym__number_literal] = ACTIONS(31),
    [anon_sym_SQUOTE] = ACTIONS(33),
    [anon_sym_DQUOTE] = ACTIONS(35),
    [sym_return] = ACTIONS(37),
    [sym_next] = ACTIONS(37),
    [sym_break] = ACTIONS(37),
    [sym_true] = ACTIONS(37),
    [sym_false] = ACTIONS(37),
    [sym_null] = ACTIONS(37),
    [sym_inf] = ACTIONS(37),
    [sym_nan] = ACTIONS(37),
    [anon_sym_NA] = ACTIONS(39),
    [anon_sym_NA_integer_] = ACTIONS(39),
    [anon_sym_NA_real_] = ACTIONS(39),
    [anon_sym_NA_complex_] = ACTIONS(39),
    [anon_sym_NA_character_] = ACTIONS(39),
    [sym_dots] = ACTIONS(37),
    [sym_dot_dot_i] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(43),
    [sym__semicolon] = ACTIONS(43),
    [sym__raw_string_literal] = ACTIONS(45),
    [sym__external_open_parenthesis] = ACTIONS(47),
    [sym__external_open_brace] = ACTIONS(49),
  },
  [2] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__else] = STATE(1485),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(93),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [3] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__else] = STATE(1488),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(101),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(101),
    [sym__semicolon] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(143),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [4] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__else] = STATE(1400),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(189),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(53),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [5] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__else] = STATE(1423),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(199),
    [sym__newline] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(201),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(199),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [6] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__else] = STATE(1424),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(205),
    [sym__newline] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(207),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(205),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [7] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__else] = STATE(1437),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(209),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(101),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [8] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__else] = STATE(1769),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(53),
    [sym__semicolon] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(249),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_close_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [9] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__else] = STATE(1070),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(257),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_close_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [10] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__else] = STATE(1071),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(205),
    [sym__semicolon] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(259),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_close_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [11] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__else] = STATE(1090),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(101),
    [sym__semicolon] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(261),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_close_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [12] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__else] = STATE(1455),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(263),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [13] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__else] = STATE(1463),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(199),
    [sym__newline] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(265),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [14] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__else] = STATE(1464),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(205),
    [sym__newline] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(267),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(205),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [15] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__else] = STATE(1476),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(269),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(101),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [16] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1668),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(309),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(53),
  },
  [17] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1675),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(199),
    [sym__newline] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(317),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(199),
  },
  [18] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__else] = STATE(1416),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(53),
    [sym__semicolon] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(319),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [19] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1691),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(321),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(101),
  },
  [20] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__else] = STATE(1446),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(199),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(323),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [21] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1642),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(325),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(101),
  },
  [22] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__else] = STATE(1114),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(53),
    [sym__semicolon] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(327),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [23] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__else] = STATE(1118),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(199),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(329),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [24] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__else] = STATE(1119),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(205),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(205),
    [sym__semicolon] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(331),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [25] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__else] = STATE(1129),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(101),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(101),
    [sym__semicolon] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(333),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [26] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__else] = STATE(1201),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(335),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(53),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [27] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__else] = STATE(1205),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(199),
    [sym__newline] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(337),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(199),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [28] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__else] = STATE(1206),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(205),
    [sym__newline] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(339),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(205),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [29] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__else] = STATE(1214),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(341),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(101),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [30] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__else] = STATE(1303),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(53),
    [sym__semicolon] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(343),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_close_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [31] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__else] = STATE(1308),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(199),
    [sym__semicolon] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(345),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_close_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [32] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__else] = STATE(1309),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(205),
    [sym__semicolon] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(347),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_close_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [33] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__else] = STATE(1316),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(101),
    [sym__semicolon] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(349),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_close_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [34] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__else] = STATE(1448),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(205),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(205),
    [sym__semicolon] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(351),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [35] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__else] = STATE(1492),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(199),
    [sym__newline] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(353),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [36] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__else] = STATE(1493),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(205),
    [sym__newline] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(355),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(205),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [37] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__else] = STATE(1503),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(357),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(101),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [38] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1624),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(359),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(53),
  },
  [39] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1631),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(197),
    [anon_sym_BSLASH] = ACTIONS(199),
    [anon_sym_function] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(197),
    [anon_sym_for] = ACTIONS(197),
    [anon_sym_while] = ACTIONS(197),
    [anon_sym_repeat] = ACTIONS(197),
    [anon_sym_QMARK] = ACTIONS(199),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(199),
    [sym__number_literal] = ACTIONS(197),
    [anon_sym_SQUOTE] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_return] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_true] = ACTIONS(197),
    [sym_false] = ACTIONS(197),
    [sym_null] = ACTIONS(197),
    [sym_inf] = ACTIONS(197),
    [sym_nan] = ACTIONS(197),
    [anon_sym_NA] = ACTIONS(197),
    [anon_sym_NA_integer_] = ACTIONS(197),
    [anon_sym_NA_real_] = ACTIONS(197),
    [anon_sym_NA_complex_] = ACTIONS(197),
    [anon_sym_NA_character_] = ACTIONS(197),
    [sym_dots] = ACTIONS(197),
    [sym_dot_dot_i] = ACTIONS(199),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(199),
    [sym__newline] = ACTIONS(199),
    [sym__raw_string_literal] = ACTIONS(199),
    [sym__external_else] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(199),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(199),
  },
  [40] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1632),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(205),
    [sym__newline] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(363),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(205),
  },
  [41] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1676),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(203),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_function] = ACTIONS(203),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(203),
    [anon_sym_while] = ACTIONS(203),
    [anon_sym_repeat] = ACTIONS(203),
    [anon_sym_QMARK] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(203),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(205),
    [sym__number_literal] = ACTIONS(203),
    [anon_sym_SQUOTE] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(205),
    [sym_return] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_true] = ACTIONS(203),
    [sym_false] = ACTIONS(203),
    [sym_null] = ACTIONS(203),
    [sym_inf] = ACTIONS(203),
    [sym_nan] = ACTIONS(203),
    [anon_sym_NA] = ACTIONS(203),
    [anon_sym_NA_integer_] = ACTIONS(203),
    [anon_sym_NA_real_] = ACTIONS(203),
    [anon_sym_NA_complex_] = ACTIONS(203),
    [anon_sym_NA_character_] = ACTIONS(203),
    [sym_dots] = ACTIONS(203),
    [sym_dot_dot_i] = ACTIONS(205),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(205),
    [sym__newline] = ACTIONS(205),
    [sym__raw_string_literal] = ACTIONS(205),
    [sym__external_else] = ACTIONS(365),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(205),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(205),
  },
  [42] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(369),
  },
  [43] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(371),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [44] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(371),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [45] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(375),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__semicolon] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [46] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(379),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [47] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [48] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [49] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [50] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [51] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [52] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [53] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [54] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [55] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [56] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [57] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [58] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [59] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [60] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(387),
    [sym_identifier] = ACTIONS(389),
    [anon_sym_BSLASH] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_for] = ACTIONS(389),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(389),
    [anon_sym_QMARK] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(389),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(387),
    [sym__number_literal] = ACTIONS(389),
    [anon_sym_SQUOTE] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [sym_return] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_break] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(389),
    [anon_sym_NA_integer_] = ACTIONS(389),
    [anon_sym_NA_real_] = ACTIONS(389),
    [anon_sym_NA_complex_] = ACTIONS(389),
    [anon_sym_NA_character_] = ACTIONS(389),
    [sym_dots] = ACTIONS(389),
    [sym_dot_dot_i] = ACTIONS(387),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(387),
    [sym__semicolon] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(387),
    [sym__external_else] = ACTIONS(387),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [61] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(391),
    [sym_identifier] = ACTIONS(393),
    [anon_sym_BSLASH] = ACTIONS(391),
    [anon_sym_function] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(393),
    [anon_sym_repeat] = ACTIONS(393),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(391),
    [sym__number_literal] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [sym_return] = ACTIONS(393),
    [sym_next] = ACTIONS(393),
    [sym_break] = ACTIONS(393),
    [sym_true] = ACTIONS(393),
    [sym_false] = ACTIONS(393),
    [sym_null] = ACTIONS(393),
    [sym_inf] = ACTIONS(393),
    [sym_nan] = ACTIONS(393),
    [anon_sym_NA] = ACTIONS(393),
    [anon_sym_NA_integer_] = ACTIONS(393),
    [anon_sym_NA_real_] = ACTIONS(393),
    [anon_sym_NA_complex_] = ACTIONS(393),
    [anon_sym_NA_character_] = ACTIONS(393),
    [sym_dots] = ACTIONS(393),
    [sym_dot_dot_i] = ACTIONS(391),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(391),
    [sym__semicolon] = ACTIONS(391),
    [sym__raw_string_literal] = ACTIONS(391),
    [sym__external_else] = ACTIONS(391),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(391),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [62] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(395),
    [sym_identifier] = ACTIONS(397),
    [anon_sym_BSLASH] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(397),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(397),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(397),
    [anon_sym_QMARK] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(395),
    [sym__number_literal] = ACTIONS(397),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [sym_return] = ACTIONS(397),
    [sym_next] = ACTIONS(397),
    [sym_break] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_inf] = ACTIONS(397),
    [sym_nan] = ACTIONS(397),
    [anon_sym_NA] = ACTIONS(397),
    [anon_sym_NA_integer_] = ACTIONS(397),
    [anon_sym_NA_real_] = ACTIONS(397),
    [anon_sym_NA_complex_] = ACTIONS(397),
    [anon_sym_NA_character_] = ACTIONS(397),
    [sym_dots] = ACTIONS(397),
    [sym_dot_dot_i] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(395),
    [sym__semicolon] = ACTIONS(395),
    [sym__raw_string_literal] = ACTIONS(395),
    [sym__external_else] = ACTIONS(395),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(395),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [63] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(399),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_BSLASH] = ACTIONS(399),
    [anon_sym_function] = ACTIONS(401),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(401),
    [anon_sym_for] = ACTIONS(401),
    [anon_sym_while] = ACTIONS(401),
    [anon_sym_repeat] = ACTIONS(401),
    [anon_sym_QMARK] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(399),
    [sym__number_literal] = ACTIONS(401),
    [anon_sym_SQUOTE] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [sym_return] = ACTIONS(401),
    [sym_next] = ACTIONS(401),
    [sym_break] = ACTIONS(401),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [sym_null] = ACTIONS(401),
    [sym_inf] = ACTIONS(401),
    [sym_nan] = ACTIONS(401),
    [anon_sym_NA] = ACTIONS(401),
    [anon_sym_NA_integer_] = ACTIONS(401),
    [anon_sym_NA_real_] = ACTIONS(401),
    [anon_sym_NA_complex_] = ACTIONS(401),
    [anon_sym_NA_character_] = ACTIONS(401),
    [sym_dots] = ACTIONS(401),
    [sym_dot_dot_i] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(399),
    [sym__semicolon] = ACTIONS(399),
    [sym__raw_string_literal] = ACTIONS(399),
    [sym__external_else] = ACTIONS(399),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(399),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [64] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(403),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_BSLASH] = ACTIONS(403),
    [anon_sym_function] = ACTIONS(405),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(405),
    [anon_sym_while] = ACTIONS(405),
    [anon_sym_repeat] = ACTIONS(405),
    [anon_sym_QMARK] = ACTIONS(403),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(403),
    [sym__number_literal] = ACTIONS(405),
    [anon_sym_SQUOTE] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(403),
    [sym_return] = ACTIONS(405),
    [sym_next] = ACTIONS(405),
    [sym_break] = ACTIONS(405),
    [sym_true] = ACTIONS(405),
    [sym_false] = ACTIONS(405),
    [sym_null] = ACTIONS(405),
    [sym_inf] = ACTIONS(405),
    [sym_nan] = ACTIONS(405),
    [anon_sym_NA] = ACTIONS(405),
    [anon_sym_NA_integer_] = ACTIONS(405),
    [anon_sym_NA_real_] = ACTIONS(405),
    [anon_sym_NA_complex_] = ACTIONS(405),
    [anon_sym_NA_character_] = ACTIONS(405),
    [sym_dots] = ACTIONS(405),
    [sym_dot_dot_i] = ACTIONS(403),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(403),
    [sym__semicolon] = ACTIONS(403),
    [sym__raw_string_literal] = ACTIONS(403),
    [sym__external_else] = ACTIONS(403),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(403),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [65] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(407),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_BSLASH] = ACTIONS(407),
    [anon_sym_function] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_for] = ACTIONS(409),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_repeat] = ACTIONS(409),
    [anon_sym_QMARK] = ACTIONS(407),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(409),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(407),
    [sym__number_literal] = ACTIONS(409),
    [anon_sym_SQUOTE] = ACTIONS(407),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(409),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(409),
    [anon_sym_NA_integer_] = ACTIONS(409),
    [anon_sym_NA_real_] = ACTIONS(409),
    [anon_sym_NA_complex_] = ACTIONS(409),
    [anon_sym_NA_character_] = ACTIONS(409),
    [sym_dots] = ACTIONS(409),
    [sym_dot_dot_i] = ACTIONS(407),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(407),
    [sym__semicolon] = ACTIONS(407),
    [sym__raw_string_literal] = ACTIONS(407),
    [sym__external_else] = ACTIONS(407),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(407),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [66] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(411),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_BSLASH] = ACTIONS(411),
    [anon_sym_function] = ACTIONS(413),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(413),
    [anon_sym_for] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(413),
    [anon_sym_repeat] = ACTIONS(413),
    [anon_sym_QMARK] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(411),
    [sym__number_literal] = ACTIONS(413),
    [anon_sym_SQUOTE] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [sym_return] = ACTIONS(413),
    [sym_next] = ACTIONS(413),
    [sym_break] = ACTIONS(413),
    [sym_true] = ACTIONS(413),
    [sym_false] = ACTIONS(413),
    [sym_null] = ACTIONS(413),
    [sym_inf] = ACTIONS(413),
    [sym_nan] = ACTIONS(413),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_dots] = ACTIONS(413),
    [sym_dot_dot_i] = ACTIONS(411),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(411),
    [sym__semicolon] = ACTIONS(411),
    [sym__raw_string_literal] = ACTIONS(411),
    [sym__external_else] = ACTIONS(411),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(411),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [67] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(415),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_BSLASH] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(417),
    [anon_sym_for] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(417),
    [anon_sym_repeat] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(415),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(417),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(415),
    [sym__number_literal] = ACTIONS(417),
    [anon_sym_SQUOTE] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(417),
    [anon_sym_NA_integer_] = ACTIONS(417),
    [anon_sym_NA_real_] = ACTIONS(417),
    [anon_sym_NA_complex_] = ACTIONS(417),
    [anon_sym_NA_character_] = ACTIONS(417),
    [sym_dots] = ACTIONS(417),
    [sym_dot_dot_i] = ACTIONS(415),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(415),
    [sym__semicolon] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(415),
    [sym__external_else] = ACTIONS(415),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(415),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [68] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(419),
    [sym_identifier] = ACTIONS(421),
    [anon_sym_BSLASH] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(421),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(421),
    [anon_sym_repeat] = ACTIONS(421),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(419),
    [sym__number_literal] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [sym_return] = ACTIONS(421),
    [sym_next] = ACTIONS(421),
    [sym_break] = ACTIONS(421),
    [sym_true] = ACTIONS(421),
    [sym_false] = ACTIONS(421),
    [sym_null] = ACTIONS(421),
    [sym_inf] = ACTIONS(421),
    [sym_nan] = ACTIONS(421),
    [anon_sym_NA] = ACTIONS(421),
    [anon_sym_NA_integer_] = ACTIONS(421),
    [anon_sym_NA_real_] = ACTIONS(421),
    [anon_sym_NA_complex_] = ACTIONS(421),
    [anon_sym_NA_character_] = ACTIONS(421),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(419),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(419),
    [sym__semicolon] = ACTIONS(419),
    [sym__raw_string_literal] = ACTIONS(419),
    [sym__external_else] = ACTIONS(419),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(419),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [69] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(423),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(423),
    [anon_sym_function] = ACTIONS(425),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(425),
    [anon_sym_while] = ACTIONS(425),
    [anon_sym_repeat] = ACTIONS(425),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(425),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(423),
    [sym__number_literal] = ACTIONS(425),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [sym_return] = ACTIONS(425),
    [sym_next] = ACTIONS(425),
    [sym_break] = ACTIONS(425),
    [sym_true] = ACTIONS(425),
    [sym_false] = ACTIONS(425),
    [sym_null] = ACTIONS(425),
    [sym_inf] = ACTIONS(425),
    [sym_nan] = ACTIONS(425),
    [anon_sym_NA] = ACTIONS(425),
    [anon_sym_NA_integer_] = ACTIONS(425),
    [anon_sym_NA_real_] = ACTIONS(425),
    [anon_sym_NA_complex_] = ACTIONS(425),
    [anon_sym_NA_character_] = ACTIONS(425),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(423),
    [sym__semicolon] = ACTIONS(423),
    [sym__raw_string_literal] = ACTIONS(423),
    [sym__external_else] = ACTIONS(423),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(423),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [70] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(427),
    [sym_identifier] = ACTIONS(429),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_for] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(429),
    [anon_sym_repeat] = ACTIONS(429),
    [anon_sym_QMARK] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(427),
    [sym__number_literal] = ACTIONS(429),
    [anon_sym_SQUOTE] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(427),
    [sym_return] = ACTIONS(429),
    [sym_next] = ACTIONS(429),
    [sym_break] = ACTIONS(429),
    [sym_true] = ACTIONS(429),
    [sym_false] = ACTIONS(429),
    [sym_null] = ACTIONS(429),
    [sym_inf] = ACTIONS(429),
    [sym_nan] = ACTIONS(429),
    [anon_sym_NA] = ACTIONS(429),
    [anon_sym_NA_integer_] = ACTIONS(429),
    [anon_sym_NA_real_] = ACTIONS(429),
    [anon_sym_NA_complex_] = ACTIONS(429),
    [anon_sym_NA_character_] = ACTIONS(429),
    [sym_dots] = ACTIONS(429),
    [sym_dot_dot_i] = ACTIONS(427),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(427),
    [sym__semicolon] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(427),
    [sym__external_else] = ACTIONS(427),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(427),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [71] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(431),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_BSLASH] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(433),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_repeat] = ACTIONS(433),
    [anon_sym_QMARK] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(431),
    [sym__number_literal] = ACTIONS(433),
    [anon_sym_SQUOTE] = ACTIONS(431),
    [anon_sym_DQUOTE] = ACTIONS(431),
    [sym_return] = ACTIONS(433),
    [sym_next] = ACTIONS(433),
    [sym_break] = ACTIONS(433),
    [sym_true] = ACTIONS(433),
    [sym_false] = ACTIONS(433),
    [sym_null] = ACTIONS(433),
    [sym_inf] = ACTIONS(433),
    [sym_nan] = ACTIONS(433),
    [anon_sym_NA] = ACTIONS(433),
    [anon_sym_NA_integer_] = ACTIONS(433),
    [anon_sym_NA_real_] = ACTIONS(433),
    [anon_sym_NA_complex_] = ACTIONS(433),
    [anon_sym_NA_character_] = ACTIONS(433),
    [sym_dots] = ACTIONS(433),
    [sym_dot_dot_i] = ACTIONS(431),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(431),
    [sym__semicolon] = ACTIONS(431),
    [sym__raw_string_literal] = ACTIONS(431),
    [sym__external_else] = ACTIONS(431),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(431),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [72] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(435),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(435),
    [anon_sym_function] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_while] = ACTIONS(437),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(435),
    [sym__number_literal] = ACTIONS(437),
    [anon_sym_SQUOTE] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [sym_return] = ACTIONS(437),
    [sym_next] = ACTIONS(437),
    [sym_break] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_null] = ACTIONS(437),
    [sym_inf] = ACTIONS(437),
    [sym_nan] = ACTIONS(437),
    [anon_sym_NA] = ACTIONS(437),
    [anon_sym_NA_integer_] = ACTIONS(437),
    [anon_sym_NA_real_] = ACTIONS(437),
    [anon_sym_NA_complex_] = ACTIONS(437),
    [anon_sym_NA_character_] = ACTIONS(437),
    [sym_dots] = ACTIONS(437),
    [sym_dot_dot_i] = ACTIONS(435),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(435),
    [sym__semicolon] = ACTIONS(435),
    [sym__raw_string_literal] = ACTIONS(435),
    [sym__external_else] = ACTIONS(435),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(435),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [73] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(439),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_repeat] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(439),
    [sym__number_literal] = ACTIONS(441),
    [anon_sym_SQUOTE] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(439),
    [sym_return] = ACTIONS(441),
    [sym_next] = ACTIONS(441),
    [sym_break] = ACTIONS(441),
    [sym_true] = ACTIONS(441),
    [sym_false] = ACTIONS(441),
    [sym_null] = ACTIONS(441),
    [sym_inf] = ACTIONS(441),
    [sym_nan] = ACTIONS(441),
    [anon_sym_NA] = ACTIONS(441),
    [anon_sym_NA_integer_] = ACTIONS(441),
    [anon_sym_NA_real_] = ACTIONS(441),
    [anon_sym_NA_complex_] = ACTIONS(441),
    [anon_sym_NA_character_] = ACTIONS(441),
    [sym_dots] = ACTIONS(441),
    [sym_dot_dot_i] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(439),
    [sym__semicolon] = ACTIONS(439),
    [sym__raw_string_literal] = ACTIONS(439),
    [sym__external_else] = ACTIONS(439),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(439),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [74] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(369),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [75] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(443),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_BSLASH] = ACTIONS(443),
    [anon_sym_function] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(445),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(445),
    [anon_sym_repeat] = ACTIONS(445),
    [anon_sym_QMARK] = ACTIONS(443),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(443),
    [sym__number_literal] = ACTIONS(445),
    [anon_sym_SQUOTE] = ACTIONS(443),
    [anon_sym_DQUOTE] = ACTIONS(443),
    [sym_return] = ACTIONS(445),
    [sym_next] = ACTIONS(445),
    [sym_break] = ACTIONS(445),
    [sym_true] = ACTIONS(445),
    [sym_false] = ACTIONS(445),
    [sym_null] = ACTIONS(445),
    [sym_inf] = ACTIONS(445),
    [sym_nan] = ACTIONS(445),
    [anon_sym_NA] = ACTIONS(445),
    [anon_sym_NA_integer_] = ACTIONS(445),
    [anon_sym_NA_real_] = ACTIONS(445),
    [anon_sym_NA_complex_] = ACTIONS(445),
    [anon_sym_NA_character_] = ACTIONS(445),
    [sym_dots] = ACTIONS(445),
    [sym_dot_dot_i] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(443),
    [sym__semicolon] = ACTIONS(443),
    [sym__raw_string_literal] = ACTIONS(443),
    [sym__external_else] = ACTIONS(443),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(443),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [76] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(447),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_BSLASH] = ACTIONS(447),
    [anon_sym_function] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_for] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(449),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(447),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(449),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [sym_return] = ACTIONS(449),
    [sym_next] = ACTIONS(449),
    [sym_break] = ACTIONS(449),
    [sym_true] = ACTIONS(449),
    [sym_false] = ACTIONS(449),
    [sym_null] = ACTIONS(449),
    [sym_inf] = ACTIONS(449),
    [sym_nan] = ACTIONS(449),
    [anon_sym_NA] = ACTIONS(449),
    [anon_sym_NA_integer_] = ACTIONS(449),
    [anon_sym_NA_real_] = ACTIONS(449),
    [anon_sym_NA_complex_] = ACTIONS(449),
    [anon_sym_NA_character_] = ACTIONS(449),
    [sym_dots] = ACTIONS(449),
    [sym_dot_dot_i] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(447),
    [sym__semicolon] = ACTIONS(447),
    [sym__raw_string_literal] = ACTIONS(447),
    [sym__external_else] = ACTIONS(447),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(447),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [77] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(451),
    [anon_sym_BSLASH] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(451),
    [anon_sym_for] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_repeat] = ACTIONS(451),
    [anon_sym_QMARK] = ACTIONS(453),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(453),
    [sym__number_literal] = ACTIONS(451),
    [anon_sym_SQUOTE] = ACTIONS(453),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_return] = ACTIONS(451),
    [sym_next] = ACTIONS(451),
    [sym_break] = ACTIONS(451),
    [sym_true] = ACTIONS(451),
    [sym_false] = ACTIONS(451),
    [sym_null] = ACTIONS(451),
    [sym_inf] = ACTIONS(451),
    [sym_nan] = ACTIONS(451),
    [anon_sym_NA] = ACTIONS(451),
    [anon_sym_NA_integer_] = ACTIONS(451),
    [anon_sym_NA_real_] = ACTIONS(451),
    [anon_sym_NA_complex_] = ACTIONS(451),
    [anon_sym_NA_character_] = ACTIONS(451),
    [sym_dots] = ACTIONS(451),
    [sym_dot_dot_i] = ACTIONS(453),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(453),
    [sym__newline] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(453),
    [sym__external_else] = ACTIONS(453),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(453),
    [sym__external_open_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [78] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(457),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [79] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(457),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [80] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(457),
    [anon_sym_AMP_AMP] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(457),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [81] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(455),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(457),
    [anon_sym_AMP_AMP] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(457),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_EQ] = ACTIONS(457),
    [anon_sym_EQ_EQ] = ACTIONS(457),
    [anon_sym_BANG_EQ] = ACTIONS(457),
    [anon_sym_STAR] = ACTIONS(455),
    [anon_sym_SLASH] = ACTIONS(457),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(457),
    [anon_sym_PIPE_GT] = ACTIONS(457),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(457),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [82] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(459),
    [anon_sym_BSLASH] = ACTIONS(461),
    [anon_sym_function] = ACTIONS(459),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_while] = ACTIONS(459),
    [anon_sym_repeat] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(461),
    [sym__number_literal] = ACTIONS(459),
    [anon_sym_SQUOTE] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [sym_return] = ACTIONS(459),
    [sym_next] = ACTIONS(459),
    [sym_break] = ACTIONS(459),
    [sym_true] = ACTIONS(459),
    [sym_false] = ACTIONS(459),
    [sym_null] = ACTIONS(459),
    [sym_inf] = ACTIONS(459),
    [sym_nan] = ACTIONS(459),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_dots] = ACTIONS(459),
    [sym_dot_dot_i] = ACTIONS(461),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__newline] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(461),
    [sym__external_else] = ACTIONS(461),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(461),
    [sym__external_open_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [83] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(463),
    [anon_sym_BSLASH] = ACTIONS(465),
    [anon_sym_function] = ACTIONS(463),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(463),
    [anon_sym_for] = ACTIONS(463),
    [anon_sym_while] = ACTIONS(463),
    [anon_sym_repeat] = ACTIONS(463),
    [anon_sym_QMARK] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(465),
    [sym__number_literal] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(463),
    [sym_next] = ACTIONS(463),
    [sym_break] = ACTIONS(463),
    [sym_true] = ACTIONS(463),
    [sym_false] = ACTIONS(463),
    [sym_null] = ACTIONS(463),
    [sym_inf] = ACTIONS(463),
    [sym_nan] = ACTIONS(463),
    [anon_sym_NA] = ACTIONS(463),
    [anon_sym_NA_integer_] = ACTIONS(463),
    [anon_sym_NA_real_] = ACTIONS(463),
    [anon_sym_NA_complex_] = ACTIONS(463),
    [anon_sym_NA_character_] = ACTIONS(463),
    [sym_dots] = ACTIONS(463),
    [sym_dot_dot_i] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(465),
    [sym__newline] = ACTIONS(465),
    [sym__raw_string_literal] = ACTIONS(465),
    [sym__external_else] = ACTIONS(465),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(465),
    [sym__external_open_brace] = ACTIONS(465),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [84] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(469),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [85] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(469),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [86] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(469),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [87] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(467),
    [anon_sym_LT_EQ] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(467),
    [anon_sym_GT_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(467),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(469),
    [anon_sym_PIPE_GT] = ACTIONS(469),
    [anon_sym_COLON] = ACTIONS(467),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(469),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [88] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [89] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [90] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [91] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [92] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [93] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [94] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [95] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [96] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [97] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [98] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [99] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [100] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [101] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(375),
    [sym__newline] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(375),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [102] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(379),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [103] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [104] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [105] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [106] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [107] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [108] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [109] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [110] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [111] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [112] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [113] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [114] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [115] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [116] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(389),
    [anon_sym_BSLASH] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_for] = ACTIONS(389),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(389),
    [anon_sym_QMARK] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(389),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(387),
    [sym__number_literal] = ACTIONS(389),
    [anon_sym_SQUOTE] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [sym_return] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_break] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(389),
    [anon_sym_NA_integer_] = ACTIONS(389),
    [anon_sym_NA_real_] = ACTIONS(389),
    [anon_sym_NA_complex_] = ACTIONS(389),
    [anon_sym_NA_character_] = ACTIONS(389),
    [sym_dots] = ACTIONS(389),
    [sym_dot_dot_i] = ACTIONS(387),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(387),
    [sym__newline] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(387),
    [sym__external_else] = ACTIONS(387),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(387),
    [sym__external_open_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [117] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(393),
    [anon_sym_BSLASH] = ACTIONS(391),
    [anon_sym_function] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(393),
    [anon_sym_repeat] = ACTIONS(393),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(391),
    [sym__number_literal] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [sym_return] = ACTIONS(393),
    [sym_next] = ACTIONS(393),
    [sym_break] = ACTIONS(393),
    [sym_true] = ACTIONS(393),
    [sym_false] = ACTIONS(393),
    [sym_null] = ACTIONS(393),
    [sym_inf] = ACTIONS(393),
    [sym_nan] = ACTIONS(393),
    [anon_sym_NA] = ACTIONS(393),
    [anon_sym_NA_integer_] = ACTIONS(393),
    [anon_sym_NA_real_] = ACTIONS(393),
    [anon_sym_NA_complex_] = ACTIONS(393),
    [anon_sym_NA_character_] = ACTIONS(393),
    [sym_dots] = ACTIONS(393),
    [sym_dot_dot_i] = ACTIONS(391),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(391),
    [sym__newline] = ACTIONS(391),
    [sym__raw_string_literal] = ACTIONS(391),
    [sym__external_else] = ACTIONS(391),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(391),
    [sym__external_open_brace] = ACTIONS(391),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [118] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(397),
    [anon_sym_BSLASH] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(397),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(397),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(397),
    [anon_sym_QMARK] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(395),
    [sym__number_literal] = ACTIONS(397),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [sym_return] = ACTIONS(397),
    [sym_next] = ACTIONS(397),
    [sym_break] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_inf] = ACTIONS(397),
    [sym_nan] = ACTIONS(397),
    [anon_sym_NA] = ACTIONS(397),
    [anon_sym_NA_integer_] = ACTIONS(397),
    [anon_sym_NA_real_] = ACTIONS(397),
    [anon_sym_NA_complex_] = ACTIONS(397),
    [anon_sym_NA_character_] = ACTIONS(397),
    [sym_dots] = ACTIONS(397),
    [sym_dot_dot_i] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(395),
    [sym__newline] = ACTIONS(395),
    [sym__raw_string_literal] = ACTIONS(395),
    [sym__external_else] = ACTIONS(395),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(395),
    [sym__external_open_brace] = ACTIONS(395),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [119] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_BSLASH] = ACTIONS(399),
    [anon_sym_function] = ACTIONS(401),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(401),
    [anon_sym_for] = ACTIONS(401),
    [anon_sym_while] = ACTIONS(401),
    [anon_sym_repeat] = ACTIONS(401),
    [anon_sym_QMARK] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(399),
    [sym__number_literal] = ACTIONS(401),
    [anon_sym_SQUOTE] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [sym_return] = ACTIONS(401),
    [sym_next] = ACTIONS(401),
    [sym_break] = ACTIONS(401),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [sym_null] = ACTIONS(401),
    [sym_inf] = ACTIONS(401),
    [sym_nan] = ACTIONS(401),
    [anon_sym_NA] = ACTIONS(401),
    [anon_sym_NA_integer_] = ACTIONS(401),
    [anon_sym_NA_real_] = ACTIONS(401),
    [anon_sym_NA_complex_] = ACTIONS(401),
    [anon_sym_NA_character_] = ACTIONS(401),
    [sym_dots] = ACTIONS(401),
    [sym_dot_dot_i] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(399),
    [sym__newline] = ACTIONS(399),
    [sym__raw_string_literal] = ACTIONS(399),
    [sym__external_else] = ACTIONS(399),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(399),
    [sym__external_open_brace] = ACTIONS(399),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [120] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_BSLASH] = ACTIONS(403),
    [anon_sym_function] = ACTIONS(405),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(405),
    [anon_sym_while] = ACTIONS(405),
    [anon_sym_repeat] = ACTIONS(405),
    [anon_sym_QMARK] = ACTIONS(403),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(403),
    [sym__number_literal] = ACTIONS(405),
    [anon_sym_SQUOTE] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(403),
    [sym_return] = ACTIONS(405),
    [sym_next] = ACTIONS(405),
    [sym_break] = ACTIONS(405),
    [sym_true] = ACTIONS(405),
    [sym_false] = ACTIONS(405),
    [sym_null] = ACTIONS(405),
    [sym_inf] = ACTIONS(405),
    [sym_nan] = ACTIONS(405),
    [anon_sym_NA] = ACTIONS(405),
    [anon_sym_NA_integer_] = ACTIONS(405),
    [anon_sym_NA_real_] = ACTIONS(405),
    [anon_sym_NA_complex_] = ACTIONS(405),
    [anon_sym_NA_character_] = ACTIONS(405),
    [sym_dots] = ACTIONS(405),
    [sym_dot_dot_i] = ACTIONS(403),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(403),
    [sym__newline] = ACTIONS(403),
    [sym__raw_string_literal] = ACTIONS(403),
    [sym__external_else] = ACTIONS(403),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(403),
    [sym__external_open_brace] = ACTIONS(403),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [121] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_BSLASH] = ACTIONS(407),
    [anon_sym_function] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_for] = ACTIONS(409),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_repeat] = ACTIONS(409),
    [anon_sym_QMARK] = ACTIONS(407),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(409),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(407),
    [sym__number_literal] = ACTIONS(409),
    [anon_sym_SQUOTE] = ACTIONS(407),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(409),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(409),
    [anon_sym_NA_integer_] = ACTIONS(409),
    [anon_sym_NA_real_] = ACTIONS(409),
    [anon_sym_NA_complex_] = ACTIONS(409),
    [anon_sym_NA_character_] = ACTIONS(409),
    [sym_dots] = ACTIONS(409),
    [sym_dot_dot_i] = ACTIONS(407),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(407),
    [sym__newline] = ACTIONS(407),
    [sym__raw_string_literal] = ACTIONS(407),
    [sym__external_else] = ACTIONS(407),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(407),
    [sym__external_open_brace] = ACTIONS(407),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [122] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_BSLASH] = ACTIONS(411),
    [anon_sym_function] = ACTIONS(413),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(413),
    [anon_sym_for] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(413),
    [anon_sym_repeat] = ACTIONS(413),
    [anon_sym_QMARK] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(411),
    [sym__number_literal] = ACTIONS(413),
    [anon_sym_SQUOTE] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [sym_return] = ACTIONS(413),
    [sym_next] = ACTIONS(413),
    [sym_break] = ACTIONS(413),
    [sym_true] = ACTIONS(413),
    [sym_false] = ACTIONS(413),
    [sym_null] = ACTIONS(413),
    [sym_inf] = ACTIONS(413),
    [sym_nan] = ACTIONS(413),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_dots] = ACTIONS(413),
    [sym_dot_dot_i] = ACTIONS(411),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(411),
    [sym__newline] = ACTIONS(411),
    [sym__raw_string_literal] = ACTIONS(411),
    [sym__external_else] = ACTIONS(411),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(411),
    [sym__external_open_brace] = ACTIONS(411),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [123] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_BSLASH] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(417),
    [anon_sym_for] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(417),
    [anon_sym_repeat] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(415),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(417),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(415),
    [sym__number_literal] = ACTIONS(417),
    [anon_sym_SQUOTE] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(417),
    [anon_sym_NA_integer_] = ACTIONS(417),
    [anon_sym_NA_real_] = ACTIONS(417),
    [anon_sym_NA_complex_] = ACTIONS(417),
    [anon_sym_NA_character_] = ACTIONS(417),
    [sym_dots] = ACTIONS(417),
    [sym_dot_dot_i] = ACTIONS(415),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__newline] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(415),
    [sym__external_else] = ACTIONS(415),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(415),
    [sym__external_open_brace] = ACTIONS(415),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [124] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(421),
    [anon_sym_BSLASH] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(421),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(421),
    [anon_sym_repeat] = ACTIONS(421),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(419),
    [sym__number_literal] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [sym_return] = ACTIONS(421),
    [sym_next] = ACTIONS(421),
    [sym_break] = ACTIONS(421),
    [sym_true] = ACTIONS(421),
    [sym_false] = ACTIONS(421),
    [sym_null] = ACTIONS(421),
    [sym_inf] = ACTIONS(421),
    [sym_nan] = ACTIONS(421),
    [anon_sym_NA] = ACTIONS(421),
    [anon_sym_NA_integer_] = ACTIONS(421),
    [anon_sym_NA_real_] = ACTIONS(421),
    [anon_sym_NA_complex_] = ACTIONS(421),
    [anon_sym_NA_character_] = ACTIONS(421),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(419),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(419),
    [sym__newline] = ACTIONS(419),
    [sym__raw_string_literal] = ACTIONS(419),
    [sym__external_else] = ACTIONS(419),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(419),
    [sym__external_open_brace] = ACTIONS(419),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [125] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(423),
    [anon_sym_function] = ACTIONS(425),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(425),
    [anon_sym_while] = ACTIONS(425),
    [anon_sym_repeat] = ACTIONS(425),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(425),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(423),
    [sym__number_literal] = ACTIONS(425),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [sym_return] = ACTIONS(425),
    [sym_next] = ACTIONS(425),
    [sym_break] = ACTIONS(425),
    [sym_true] = ACTIONS(425),
    [sym_false] = ACTIONS(425),
    [sym_null] = ACTIONS(425),
    [sym_inf] = ACTIONS(425),
    [sym_nan] = ACTIONS(425),
    [anon_sym_NA] = ACTIONS(425),
    [anon_sym_NA_integer_] = ACTIONS(425),
    [anon_sym_NA_real_] = ACTIONS(425),
    [anon_sym_NA_complex_] = ACTIONS(425),
    [anon_sym_NA_character_] = ACTIONS(425),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(423),
    [sym__newline] = ACTIONS(423),
    [sym__raw_string_literal] = ACTIONS(423),
    [sym__external_else] = ACTIONS(423),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(423),
    [sym__external_open_brace] = ACTIONS(423),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [126] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(429),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_for] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(429),
    [anon_sym_repeat] = ACTIONS(429),
    [anon_sym_QMARK] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(427),
    [sym__number_literal] = ACTIONS(429),
    [anon_sym_SQUOTE] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(427),
    [sym_return] = ACTIONS(429),
    [sym_next] = ACTIONS(429),
    [sym_break] = ACTIONS(429),
    [sym_true] = ACTIONS(429),
    [sym_false] = ACTIONS(429),
    [sym_null] = ACTIONS(429),
    [sym_inf] = ACTIONS(429),
    [sym_nan] = ACTIONS(429),
    [anon_sym_NA] = ACTIONS(429),
    [anon_sym_NA_integer_] = ACTIONS(429),
    [anon_sym_NA_real_] = ACTIONS(429),
    [anon_sym_NA_complex_] = ACTIONS(429),
    [anon_sym_NA_character_] = ACTIONS(429),
    [sym_dots] = ACTIONS(429),
    [sym_dot_dot_i] = ACTIONS(427),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(427),
    [sym__newline] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(427),
    [sym__external_else] = ACTIONS(427),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(427),
    [sym__external_open_brace] = ACTIONS(427),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [127] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_BSLASH] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(433),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_repeat] = ACTIONS(433),
    [anon_sym_QMARK] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(431),
    [sym__number_literal] = ACTIONS(433),
    [anon_sym_SQUOTE] = ACTIONS(431),
    [anon_sym_DQUOTE] = ACTIONS(431),
    [sym_return] = ACTIONS(433),
    [sym_next] = ACTIONS(433),
    [sym_break] = ACTIONS(433),
    [sym_true] = ACTIONS(433),
    [sym_false] = ACTIONS(433),
    [sym_null] = ACTIONS(433),
    [sym_inf] = ACTIONS(433),
    [sym_nan] = ACTIONS(433),
    [anon_sym_NA] = ACTIONS(433),
    [anon_sym_NA_integer_] = ACTIONS(433),
    [anon_sym_NA_real_] = ACTIONS(433),
    [anon_sym_NA_complex_] = ACTIONS(433),
    [anon_sym_NA_character_] = ACTIONS(433),
    [sym_dots] = ACTIONS(433),
    [sym_dot_dot_i] = ACTIONS(431),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(431),
    [sym__newline] = ACTIONS(431),
    [sym__raw_string_literal] = ACTIONS(431),
    [sym__external_else] = ACTIONS(431),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(431),
    [sym__external_open_brace] = ACTIONS(431),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [128] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(435),
    [anon_sym_function] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_while] = ACTIONS(437),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(435),
    [sym__number_literal] = ACTIONS(437),
    [anon_sym_SQUOTE] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [sym_return] = ACTIONS(437),
    [sym_next] = ACTIONS(437),
    [sym_break] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_null] = ACTIONS(437),
    [sym_inf] = ACTIONS(437),
    [sym_nan] = ACTIONS(437),
    [anon_sym_NA] = ACTIONS(437),
    [anon_sym_NA_integer_] = ACTIONS(437),
    [anon_sym_NA_real_] = ACTIONS(437),
    [anon_sym_NA_complex_] = ACTIONS(437),
    [anon_sym_NA_character_] = ACTIONS(437),
    [sym_dots] = ACTIONS(437),
    [sym_dot_dot_i] = ACTIONS(435),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(435),
    [sym__newline] = ACTIONS(435),
    [sym__raw_string_literal] = ACTIONS(435),
    [sym__external_else] = ACTIONS(435),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(435),
    [sym__external_open_brace] = ACTIONS(435),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [129] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_repeat] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(439),
    [sym__number_literal] = ACTIONS(441),
    [anon_sym_SQUOTE] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(439),
    [sym_return] = ACTIONS(441),
    [sym_next] = ACTIONS(441),
    [sym_break] = ACTIONS(441),
    [sym_true] = ACTIONS(441),
    [sym_false] = ACTIONS(441),
    [sym_null] = ACTIONS(441),
    [sym_inf] = ACTIONS(441),
    [sym_nan] = ACTIONS(441),
    [anon_sym_NA] = ACTIONS(441),
    [anon_sym_NA_integer_] = ACTIONS(441),
    [anon_sym_NA_real_] = ACTIONS(441),
    [anon_sym_NA_complex_] = ACTIONS(441),
    [anon_sym_NA_character_] = ACTIONS(441),
    [sym_dots] = ACTIONS(441),
    [sym_dot_dot_i] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(439),
    [sym__newline] = ACTIONS(439),
    [sym__raw_string_literal] = ACTIONS(439),
    [sym__external_else] = ACTIONS(439),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(439),
    [sym__external_open_brace] = ACTIONS(439),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [130] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [131] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_BSLASH] = ACTIONS(443),
    [anon_sym_function] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(445),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(445),
    [anon_sym_repeat] = ACTIONS(445),
    [anon_sym_QMARK] = ACTIONS(443),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(443),
    [sym__number_literal] = ACTIONS(445),
    [anon_sym_SQUOTE] = ACTIONS(443),
    [anon_sym_DQUOTE] = ACTIONS(443),
    [sym_return] = ACTIONS(445),
    [sym_next] = ACTIONS(445),
    [sym_break] = ACTIONS(445),
    [sym_true] = ACTIONS(445),
    [sym_false] = ACTIONS(445),
    [sym_null] = ACTIONS(445),
    [sym_inf] = ACTIONS(445),
    [sym_nan] = ACTIONS(445),
    [anon_sym_NA] = ACTIONS(445),
    [anon_sym_NA_integer_] = ACTIONS(445),
    [anon_sym_NA_real_] = ACTIONS(445),
    [anon_sym_NA_complex_] = ACTIONS(445),
    [anon_sym_NA_character_] = ACTIONS(445),
    [sym_dots] = ACTIONS(445),
    [sym_dot_dot_i] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(443),
    [sym__newline] = ACTIONS(443),
    [sym__raw_string_literal] = ACTIONS(443),
    [sym__external_else] = ACTIONS(443),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(443),
    [sym__external_open_brace] = ACTIONS(443),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [132] = {
    [sym_call_arguments] = STATE(843),
    [sym_subset_arguments] = STATE(844),
    [sym_subset2_arguments] = STATE(849),
    [sym__open_parenthesis] = STATE(670),
    [sym__open_bracket] = STATE(671),
    [sym__open_bracket2] = STATE(672),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_BSLASH] = ACTIONS(447),
    [anon_sym_function] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(151),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_for] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(449),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(447),
    [anon_sym_TILDE] = ACTIONS(153),
    [anon_sym_BANG] = ACTIONS(449),
    [anon_sym_PLUS] = ACTIONS(155),
    [anon_sym_DASH] = ACTIONS(157),
    [anon_sym_LT_DASH] = ACTIONS(159),
    [anon_sym_LT_LT_DASH] = ACTIONS(159),
    [anon_sym_COLON_EQ] = ACTIONS(159),
    [anon_sym_DASH_GT] = ACTIONS(161),
    [anon_sym_DASH_GT_GT] = ACTIONS(163),
    [anon_sym_PIPE] = ACTIONS(165),
    [anon_sym_AMP] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(169),
    [anon_sym_AMP_AMP] = ACTIONS(171),
    [anon_sym_LT] = ACTIONS(173),
    [anon_sym_LT_EQ] = ACTIONS(175),
    [anon_sym_GT] = ACTIONS(173),
    [anon_sym_GT_EQ] = ACTIONS(175),
    [anon_sym_EQ_EQ] = ACTIONS(175),
    [anon_sym_BANG_EQ] = ACTIONS(175),
    [anon_sym_STAR] = ACTIONS(177),
    [anon_sym_SLASH] = ACTIONS(179),
    [anon_sym_STAR_STAR] = ACTIONS(181),
    [anon_sym_CARET] = ACTIONS(181),
    [aux_sym_binary_operator_token1] = ACTIONS(183),
    [anon_sym_PIPE_GT] = ACTIONS(183),
    [anon_sym_COLON] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(187),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [sym_return] = ACTIONS(449),
    [sym_next] = ACTIONS(449),
    [sym_break] = ACTIONS(449),
    [sym_true] = ACTIONS(449),
    [sym_false] = ACTIONS(449),
    [sym_null] = ACTIONS(449),
    [sym_inf] = ACTIONS(449),
    [sym_nan] = ACTIONS(449),
    [anon_sym_NA] = ACTIONS(449),
    [anon_sym_NA_integer_] = ACTIONS(449),
    [anon_sym_NA_real_] = ACTIONS(449),
    [anon_sym_NA_complex_] = ACTIONS(449),
    [anon_sym_NA_character_] = ACTIONS(449),
    [sym_dots] = ACTIONS(449),
    [sym_dot_dot_i] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(447),
    [sym__newline] = ACTIONS(447),
    [sym__raw_string_literal] = ACTIONS(447),
    [sym__external_else] = ACTIONS(447),
    [sym__external_open_parenthesis] = ACTIONS(191),
    [sym__external_close_parenthesis] = ACTIONS(447),
    [sym__external_open_brace] = ACTIONS(447),
    [sym__external_open_bracket] = ACTIONS(193),
    [sym__external_open_bracket2] = ACTIONS(195),
  },
  [133] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(451),
    [anon_sym_BSLASH] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(451),
    [anon_sym_for] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_repeat] = ACTIONS(451),
    [anon_sym_QMARK] = ACTIONS(453),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(453),
    [sym__number_literal] = ACTIONS(451),
    [anon_sym_SQUOTE] = ACTIONS(453),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_return] = ACTIONS(451),
    [sym_next] = ACTIONS(451),
    [sym_break] = ACTIONS(451),
    [sym_true] = ACTIONS(451),
    [sym_false] = ACTIONS(451),
    [sym_null] = ACTIONS(451),
    [sym_inf] = ACTIONS(451),
    [sym_nan] = ACTIONS(451),
    [anon_sym_NA] = ACTIONS(451),
    [anon_sym_NA_integer_] = ACTIONS(451),
    [anon_sym_NA_real_] = ACTIONS(451),
    [anon_sym_NA_complex_] = ACTIONS(451),
    [anon_sym_NA_character_] = ACTIONS(451),
    [sym_dots] = ACTIONS(451),
    [sym_dot_dot_i] = ACTIONS(453),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(453),
    [sym__semicolon] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(453),
    [sym__external_else] = ACTIONS(453),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(453),
    [sym__external_close_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [134] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym__semicolon] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_close_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [135] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym__semicolon] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_close_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [136] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(457),
    [anon_sym_AMP_AMP] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym__semicolon] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_close_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [137] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(455),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(457),
    [anon_sym_AMP_AMP] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(457),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_EQ] = ACTIONS(457),
    [anon_sym_EQ_EQ] = ACTIONS(457),
    [anon_sym_BANG_EQ] = ACTIONS(457),
    [anon_sym_STAR] = ACTIONS(455),
    [anon_sym_SLASH] = ACTIONS(457),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(457),
    [anon_sym_PIPE_GT] = ACTIONS(457),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym__semicolon] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_close_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [138] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(453),
    [sym_identifier] = ACTIONS(451),
    [anon_sym_BSLASH] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(451),
    [anon_sym_for] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_repeat] = ACTIONS(451),
    [anon_sym_QMARK] = ACTIONS(453),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(453),
    [sym__number_literal] = ACTIONS(451),
    [anon_sym_SQUOTE] = ACTIONS(453),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_return] = ACTIONS(451),
    [sym_next] = ACTIONS(451),
    [sym_break] = ACTIONS(451),
    [sym_true] = ACTIONS(451),
    [sym_false] = ACTIONS(451),
    [sym_null] = ACTIONS(451),
    [sym_inf] = ACTIONS(451),
    [sym_nan] = ACTIONS(451),
    [anon_sym_NA] = ACTIONS(451),
    [anon_sym_NA_integer_] = ACTIONS(451),
    [anon_sym_NA_real_] = ACTIONS(451),
    [anon_sym_NA_complex_] = ACTIONS(451),
    [anon_sym_NA_character_] = ACTIONS(451),
    [sym_dots] = ACTIONS(451),
    [sym_dot_dot_i] = ACTIONS(453),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(453),
    [sym__semicolon] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(453),
    [sym__external_else] = ACTIONS(453),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [139] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(459),
    [anon_sym_BSLASH] = ACTIONS(461),
    [anon_sym_function] = ACTIONS(459),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_while] = ACTIONS(459),
    [anon_sym_repeat] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(461),
    [sym__number_literal] = ACTIONS(459),
    [anon_sym_SQUOTE] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [sym_return] = ACTIONS(459),
    [sym_next] = ACTIONS(459),
    [sym_break] = ACTIONS(459),
    [sym_true] = ACTIONS(459),
    [sym_false] = ACTIONS(459),
    [sym_null] = ACTIONS(459),
    [sym_inf] = ACTIONS(459),
    [sym_nan] = ACTIONS(459),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_dots] = ACTIONS(459),
    [sym_dot_dot_i] = ACTIONS(461),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(461),
    [sym__semicolon] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(461),
    [sym__external_else] = ACTIONS(461),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(461),
    [sym__external_close_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [140] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(463),
    [anon_sym_BSLASH] = ACTIONS(465),
    [anon_sym_function] = ACTIONS(463),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(463),
    [anon_sym_for] = ACTIONS(463),
    [anon_sym_while] = ACTIONS(463),
    [anon_sym_repeat] = ACTIONS(463),
    [anon_sym_QMARK] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(465),
    [sym__number_literal] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(463),
    [sym_next] = ACTIONS(463),
    [sym_break] = ACTIONS(463),
    [sym_true] = ACTIONS(463),
    [sym_false] = ACTIONS(463),
    [sym_null] = ACTIONS(463),
    [sym_inf] = ACTIONS(463),
    [sym_nan] = ACTIONS(463),
    [anon_sym_NA] = ACTIONS(463),
    [anon_sym_NA_integer_] = ACTIONS(463),
    [anon_sym_NA_real_] = ACTIONS(463),
    [anon_sym_NA_complex_] = ACTIONS(463),
    [anon_sym_NA_character_] = ACTIONS(463),
    [sym_dots] = ACTIONS(463),
    [sym_dot_dot_i] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(465),
    [sym__semicolon] = ACTIONS(465),
    [sym__raw_string_literal] = ACTIONS(465),
    [sym__external_else] = ACTIONS(465),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(465),
    [sym__external_close_brace] = ACTIONS(465),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [141] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(469),
    [sym__semicolon] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_close_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [142] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(469),
    [sym__semicolon] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_close_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [143] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(469),
    [sym__semicolon] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_close_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [144] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(467),
    [anon_sym_LT_EQ] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(467),
    [anon_sym_GT_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(467),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(469),
    [anon_sym_PIPE_GT] = ACTIONS(469),
    [anon_sym_COLON] = ACTIONS(467),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(469),
    [sym__semicolon] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_close_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [145] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [146] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [147] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [148] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [149] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [150] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [151] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [152] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [153] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [154] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [155] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [156] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [157] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [158] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__semicolon] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_close_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [159] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_close_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [160] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [161] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [162] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [163] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [164] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [165] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [166] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [167] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [168] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [169] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [170] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [171] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [172] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [173] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(389),
    [anon_sym_BSLASH] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_for] = ACTIONS(389),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(389),
    [anon_sym_QMARK] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(389),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(387),
    [sym__number_literal] = ACTIONS(389),
    [anon_sym_SQUOTE] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [sym_return] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_break] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(389),
    [anon_sym_NA_integer_] = ACTIONS(389),
    [anon_sym_NA_real_] = ACTIONS(389),
    [anon_sym_NA_complex_] = ACTIONS(389),
    [anon_sym_NA_character_] = ACTIONS(389),
    [sym_dots] = ACTIONS(389),
    [sym_dot_dot_i] = ACTIONS(387),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(387),
    [sym__semicolon] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(387),
    [sym__external_else] = ACTIONS(387),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(387),
    [sym__external_close_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [174] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(393),
    [anon_sym_BSLASH] = ACTIONS(391),
    [anon_sym_function] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(393),
    [anon_sym_repeat] = ACTIONS(393),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(391),
    [sym__number_literal] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [sym_return] = ACTIONS(393),
    [sym_next] = ACTIONS(393),
    [sym_break] = ACTIONS(393),
    [sym_true] = ACTIONS(393),
    [sym_false] = ACTIONS(393),
    [sym_null] = ACTIONS(393),
    [sym_inf] = ACTIONS(393),
    [sym_nan] = ACTIONS(393),
    [anon_sym_NA] = ACTIONS(393),
    [anon_sym_NA_integer_] = ACTIONS(393),
    [anon_sym_NA_real_] = ACTIONS(393),
    [anon_sym_NA_complex_] = ACTIONS(393),
    [anon_sym_NA_character_] = ACTIONS(393),
    [sym_dots] = ACTIONS(393),
    [sym_dot_dot_i] = ACTIONS(391),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(391),
    [sym__semicolon] = ACTIONS(391),
    [sym__raw_string_literal] = ACTIONS(391),
    [sym__external_else] = ACTIONS(391),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(391),
    [sym__external_close_brace] = ACTIONS(391),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [175] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(397),
    [anon_sym_BSLASH] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(397),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(397),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(397),
    [anon_sym_QMARK] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(395),
    [sym__number_literal] = ACTIONS(397),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [sym_return] = ACTIONS(397),
    [sym_next] = ACTIONS(397),
    [sym_break] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_inf] = ACTIONS(397),
    [sym_nan] = ACTIONS(397),
    [anon_sym_NA] = ACTIONS(397),
    [anon_sym_NA_integer_] = ACTIONS(397),
    [anon_sym_NA_real_] = ACTIONS(397),
    [anon_sym_NA_complex_] = ACTIONS(397),
    [anon_sym_NA_character_] = ACTIONS(397),
    [sym_dots] = ACTIONS(397),
    [sym_dot_dot_i] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(395),
    [sym__semicolon] = ACTIONS(395),
    [sym__raw_string_literal] = ACTIONS(395),
    [sym__external_else] = ACTIONS(395),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(395),
    [sym__external_close_brace] = ACTIONS(395),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [176] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_BSLASH] = ACTIONS(399),
    [anon_sym_function] = ACTIONS(401),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(401),
    [anon_sym_for] = ACTIONS(401),
    [anon_sym_while] = ACTIONS(401),
    [anon_sym_repeat] = ACTIONS(401),
    [anon_sym_QMARK] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(399),
    [sym__number_literal] = ACTIONS(401),
    [anon_sym_SQUOTE] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [sym_return] = ACTIONS(401),
    [sym_next] = ACTIONS(401),
    [sym_break] = ACTIONS(401),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [sym_null] = ACTIONS(401),
    [sym_inf] = ACTIONS(401),
    [sym_nan] = ACTIONS(401),
    [anon_sym_NA] = ACTIONS(401),
    [anon_sym_NA_integer_] = ACTIONS(401),
    [anon_sym_NA_real_] = ACTIONS(401),
    [anon_sym_NA_complex_] = ACTIONS(401),
    [anon_sym_NA_character_] = ACTIONS(401),
    [sym_dots] = ACTIONS(401),
    [sym_dot_dot_i] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(399),
    [sym__semicolon] = ACTIONS(399),
    [sym__raw_string_literal] = ACTIONS(399),
    [sym__external_else] = ACTIONS(399),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(399),
    [sym__external_close_brace] = ACTIONS(399),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [177] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_BSLASH] = ACTIONS(403),
    [anon_sym_function] = ACTIONS(405),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(405),
    [anon_sym_while] = ACTIONS(405),
    [anon_sym_repeat] = ACTIONS(405),
    [anon_sym_QMARK] = ACTIONS(403),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(403),
    [sym__number_literal] = ACTIONS(405),
    [anon_sym_SQUOTE] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(403),
    [sym_return] = ACTIONS(405),
    [sym_next] = ACTIONS(405),
    [sym_break] = ACTIONS(405),
    [sym_true] = ACTIONS(405),
    [sym_false] = ACTIONS(405),
    [sym_null] = ACTIONS(405),
    [sym_inf] = ACTIONS(405),
    [sym_nan] = ACTIONS(405),
    [anon_sym_NA] = ACTIONS(405),
    [anon_sym_NA_integer_] = ACTIONS(405),
    [anon_sym_NA_real_] = ACTIONS(405),
    [anon_sym_NA_complex_] = ACTIONS(405),
    [anon_sym_NA_character_] = ACTIONS(405),
    [sym_dots] = ACTIONS(405),
    [sym_dot_dot_i] = ACTIONS(403),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(403),
    [sym__semicolon] = ACTIONS(403),
    [sym__raw_string_literal] = ACTIONS(403),
    [sym__external_else] = ACTIONS(403),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(403),
    [sym__external_close_brace] = ACTIONS(403),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [178] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_BSLASH] = ACTIONS(407),
    [anon_sym_function] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_for] = ACTIONS(409),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_repeat] = ACTIONS(409),
    [anon_sym_QMARK] = ACTIONS(407),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(409),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(407),
    [sym__number_literal] = ACTIONS(409),
    [anon_sym_SQUOTE] = ACTIONS(407),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(409),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(409),
    [anon_sym_NA_integer_] = ACTIONS(409),
    [anon_sym_NA_real_] = ACTIONS(409),
    [anon_sym_NA_complex_] = ACTIONS(409),
    [anon_sym_NA_character_] = ACTIONS(409),
    [sym_dots] = ACTIONS(409),
    [sym_dot_dot_i] = ACTIONS(407),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(407),
    [sym__semicolon] = ACTIONS(407),
    [sym__raw_string_literal] = ACTIONS(407),
    [sym__external_else] = ACTIONS(407),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(407),
    [sym__external_close_brace] = ACTIONS(407),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [179] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_BSLASH] = ACTIONS(411),
    [anon_sym_function] = ACTIONS(413),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(413),
    [anon_sym_for] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(413),
    [anon_sym_repeat] = ACTIONS(413),
    [anon_sym_QMARK] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(411),
    [sym__number_literal] = ACTIONS(413),
    [anon_sym_SQUOTE] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [sym_return] = ACTIONS(413),
    [sym_next] = ACTIONS(413),
    [sym_break] = ACTIONS(413),
    [sym_true] = ACTIONS(413),
    [sym_false] = ACTIONS(413),
    [sym_null] = ACTIONS(413),
    [sym_inf] = ACTIONS(413),
    [sym_nan] = ACTIONS(413),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_dots] = ACTIONS(413),
    [sym_dot_dot_i] = ACTIONS(411),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(411),
    [sym__semicolon] = ACTIONS(411),
    [sym__raw_string_literal] = ACTIONS(411),
    [sym__external_else] = ACTIONS(411),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(411),
    [sym__external_close_brace] = ACTIONS(411),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [180] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_BSLASH] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(417),
    [anon_sym_for] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(417),
    [anon_sym_repeat] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(415),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(417),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(415),
    [sym__number_literal] = ACTIONS(417),
    [anon_sym_SQUOTE] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(417),
    [anon_sym_NA_integer_] = ACTIONS(417),
    [anon_sym_NA_real_] = ACTIONS(417),
    [anon_sym_NA_complex_] = ACTIONS(417),
    [anon_sym_NA_character_] = ACTIONS(417),
    [sym_dots] = ACTIONS(417),
    [sym_dot_dot_i] = ACTIONS(415),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(415),
    [sym__semicolon] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(415),
    [sym__external_else] = ACTIONS(415),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(415),
    [sym__external_close_brace] = ACTIONS(415),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [181] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(421),
    [anon_sym_BSLASH] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(421),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(421),
    [anon_sym_repeat] = ACTIONS(421),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(419),
    [sym__number_literal] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [sym_return] = ACTIONS(421),
    [sym_next] = ACTIONS(421),
    [sym_break] = ACTIONS(421),
    [sym_true] = ACTIONS(421),
    [sym_false] = ACTIONS(421),
    [sym_null] = ACTIONS(421),
    [sym_inf] = ACTIONS(421),
    [sym_nan] = ACTIONS(421),
    [anon_sym_NA] = ACTIONS(421),
    [anon_sym_NA_integer_] = ACTIONS(421),
    [anon_sym_NA_real_] = ACTIONS(421),
    [anon_sym_NA_complex_] = ACTIONS(421),
    [anon_sym_NA_character_] = ACTIONS(421),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(419),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(419),
    [sym__semicolon] = ACTIONS(419),
    [sym__raw_string_literal] = ACTIONS(419),
    [sym__external_else] = ACTIONS(419),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(419),
    [sym__external_close_brace] = ACTIONS(419),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [182] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(423),
    [anon_sym_function] = ACTIONS(425),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(425),
    [anon_sym_while] = ACTIONS(425),
    [anon_sym_repeat] = ACTIONS(425),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(425),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(423),
    [sym__number_literal] = ACTIONS(425),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [sym_return] = ACTIONS(425),
    [sym_next] = ACTIONS(425),
    [sym_break] = ACTIONS(425),
    [sym_true] = ACTIONS(425),
    [sym_false] = ACTIONS(425),
    [sym_null] = ACTIONS(425),
    [sym_inf] = ACTIONS(425),
    [sym_nan] = ACTIONS(425),
    [anon_sym_NA] = ACTIONS(425),
    [anon_sym_NA_integer_] = ACTIONS(425),
    [anon_sym_NA_real_] = ACTIONS(425),
    [anon_sym_NA_complex_] = ACTIONS(425),
    [anon_sym_NA_character_] = ACTIONS(425),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(423),
    [sym__semicolon] = ACTIONS(423),
    [sym__raw_string_literal] = ACTIONS(423),
    [sym__external_else] = ACTIONS(423),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(423),
    [sym__external_close_brace] = ACTIONS(423),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [183] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(429),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_for] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(429),
    [anon_sym_repeat] = ACTIONS(429),
    [anon_sym_QMARK] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(427),
    [sym__number_literal] = ACTIONS(429),
    [anon_sym_SQUOTE] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(427),
    [sym_return] = ACTIONS(429),
    [sym_next] = ACTIONS(429),
    [sym_break] = ACTIONS(429),
    [sym_true] = ACTIONS(429),
    [sym_false] = ACTIONS(429),
    [sym_null] = ACTIONS(429),
    [sym_inf] = ACTIONS(429),
    [sym_nan] = ACTIONS(429),
    [anon_sym_NA] = ACTIONS(429),
    [anon_sym_NA_integer_] = ACTIONS(429),
    [anon_sym_NA_real_] = ACTIONS(429),
    [anon_sym_NA_complex_] = ACTIONS(429),
    [anon_sym_NA_character_] = ACTIONS(429),
    [sym_dots] = ACTIONS(429),
    [sym_dot_dot_i] = ACTIONS(427),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(427),
    [sym__semicolon] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(427),
    [sym__external_else] = ACTIONS(427),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(427),
    [sym__external_close_brace] = ACTIONS(427),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [184] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_BSLASH] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(433),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_repeat] = ACTIONS(433),
    [anon_sym_QMARK] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(431),
    [sym__number_literal] = ACTIONS(433),
    [anon_sym_SQUOTE] = ACTIONS(431),
    [anon_sym_DQUOTE] = ACTIONS(431),
    [sym_return] = ACTIONS(433),
    [sym_next] = ACTIONS(433),
    [sym_break] = ACTIONS(433),
    [sym_true] = ACTIONS(433),
    [sym_false] = ACTIONS(433),
    [sym_null] = ACTIONS(433),
    [sym_inf] = ACTIONS(433),
    [sym_nan] = ACTIONS(433),
    [anon_sym_NA] = ACTIONS(433),
    [anon_sym_NA_integer_] = ACTIONS(433),
    [anon_sym_NA_real_] = ACTIONS(433),
    [anon_sym_NA_complex_] = ACTIONS(433),
    [anon_sym_NA_character_] = ACTIONS(433),
    [sym_dots] = ACTIONS(433),
    [sym_dot_dot_i] = ACTIONS(431),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(431),
    [sym__semicolon] = ACTIONS(431),
    [sym__raw_string_literal] = ACTIONS(431),
    [sym__external_else] = ACTIONS(431),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(431),
    [sym__external_close_brace] = ACTIONS(431),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [185] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(435),
    [anon_sym_function] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_while] = ACTIONS(437),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(435),
    [sym__number_literal] = ACTIONS(437),
    [anon_sym_SQUOTE] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [sym_return] = ACTIONS(437),
    [sym_next] = ACTIONS(437),
    [sym_break] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_null] = ACTIONS(437),
    [sym_inf] = ACTIONS(437),
    [sym_nan] = ACTIONS(437),
    [anon_sym_NA] = ACTIONS(437),
    [anon_sym_NA_integer_] = ACTIONS(437),
    [anon_sym_NA_real_] = ACTIONS(437),
    [anon_sym_NA_complex_] = ACTIONS(437),
    [anon_sym_NA_character_] = ACTIONS(437),
    [sym_dots] = ACTIONS(437),
    [sym_dot_dot_i] = ACTIONS(435),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(435),
    [sym__semicolon] = ACTIONS(435),
    [sym__raw_string_literal] = ACTIONS(435),
    [sym__external_else] = ACTIONS(435),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(435),
    [sym__external_close_brace] = ACTIONS(435),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [186] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_repeat] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(439),
    [sym__number_literal] = ACTIONS(441),
    [anon_sym_SQUOTE] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(439),
    [sym_return] = ACTIONS(441),
    [sym_next] = ACTIONS(441),
    [sym_break] = ACTIONS(441),
    [sym_true] = ACTIONS(441),
    [sym_false] = ACTIONS(441),
    [sym_null] = ACTIONS(441),
    [sym_inf] = ACTIONS(441),
    [sym_nan] = ACTIONS(441),
    [anon_sym_NA] = ACTIONS(441),
    [anon_sym_NA_integer_] = ACTIONS(441),
    [anon_sym_NA_real_] = ACTIONS(441),
    [anon_sym_NA_complex_] = ACTIONS(441),
    [anon_sym_NA_character_] = ACTIONS(441),
    [sym_dots] = ACTIONS(441),
    [sym_dot_dot_i] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(439),
    [sym__semicolon] = ACTIONS(439),
    [sym__raw_string_literal] = ACTIONS(439),
    [sym__external_else] = ACTIONS(439),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(439),
    [sym__external_close_brace] = ACTIONS(439),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [187] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [188] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_BSLASH] = ACTIONS(443),
    [anon_sym_function] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(445),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(445),
    [anon_sym_repeat] = ACTIONS(445),
    [anon_sym_QMARK] = ACTIONS(443),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(443),
    [sym__number_literal] = ACTIONS(445),
    [anon_sym_SQUOTE] = ACTIONS(443),
    [anon_sym_DQUOTE] = ACTIONS(443),
    [sym_return] = ACTIONS(445),
    [sym_next] = ACTIONS(445),
    [sym_break] = ACTIONS(445),
    [sym_true] = ACTIONS(445),
    [sym_false] = ACTIONS(445),
    [sym_null] = ACTIONS(445),
    [sym_inf] = ACTIONS(445),
    [sym_nan] = ACTIONS(445),
    [anon_sym_NA] = ACTIONS(445),
    [anon_sym_NA_integer_] = ACTIONS(445),
    [anon_sym_NA_real_] = ACTIONS(445),
    [anon_sym_NA_complex_] = ACTIONS(445),
    [anon_sym_NA_character_] = ACTIONS(445),
    [sym_dots] = ACTIONS(445),
    [sym_dot_dot_i] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(443),
    [sym__semicolon] = ACTIONS(443),
    [sym__raw_string_literal] = ACTIONS(443),
    [sym__external_else] = ACTIONS(443),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(443),
    [sym__external_close_brace] = ACTIONS(443),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [189] = {
    [sym_call_arguments] = STATE(925),
    [sym_subset_arguments] = STATE(927),
    [sym_subset2_arguments] = STATE(928),
    [sym__open_parenthesis] = STATE(674),
    [sym__open_bracket] = STATE(675),
    [sym__open_bracket2] = STATE(676),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_BSLASH] = ACTIONS(447),
    [anon_sym_function] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(211),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_for] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(449),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(447),
    [anon_sym_TILDE] = ACTIONS(213),
    [anon_sym_BANG] = ACTIONS(449),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(217),
    [anon_sym_LT_DASH] = ACTIONS(219),
    [anon_sym_LT_LT_DASH] = ACTIONS(219),
    [anon_sym_COLON_EQ] = ACTIONS(219),
    [anon_sym_DASH_GT] = ACTIONS(221),
    [anon_sym_DASH_GT_GT] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_AMP] = ACTIONS(227),
    [anon_sym_PIPE_PIPE] = ACTIONS(229),
    [anon_sym_AMP_AMP] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(233),
    [anon_sym_LT_EQ] = ACTIONS(235),
    [anon_sym_GT] = ACTIONS(233),
    [anon_sym_GT_EQ] = ACTIONS(235),
    [anon_sym_EQ_EQ] = ACTIONS(235),
    [anon_sym_BANG_EQ] = ACTIONS(235),
    [anon_sym_STAR] = ACTIONS(237),
    [anon_sym_SLASH] = ACTIONS(239),
    [anon_sym_STAR_STAR] = ACTIONS(241),
    [anon_sym_CARET] = ACTIONS(241),
    [aux_sym_binary_operator_token1] = ACTIONS(243),
    [anon_sym_PIPE_GT] = ACTIONS(243),
    [anon_sym_COLON] = ACTIONS(245),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_AT] = ACTIONS(247),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [sym_return] = ACTIONS(449),
    [sym_next] = ACTIONS(449),
    [sym_break] = ACTIONS(449),
    [sym_true] = ACTIONS(449),
    [sym_false] = ACTIONS(449),
    [sym_null] = ACTIONS(449),
    [sym_inf] = ACTIONS(449),
    [sym_nan] = ACTIONS(449),
    [anon_sym_NA] = ACTIONS(449),
    [anon_sym_NA_integer_] = ACTIONS(449),
    [anon_sym_NA_real_] = ACTIONS(449),
    [anon_sym_NA_complex_] = ACTIONS(449),
    [anon_sym_NA_character_] = ACTIONS(449),
    [sym_dots] = ACTIONS(449),
    [sym_dot_dot_i] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(447),
    [sym__semicolon] = ACTIONS(447),
    [sym__raw_string_literal] = ACTIONS(447),
    [sym__external_else] = ACTIONS(447),
    [sym__external_open_parenthesis] = ACTIONS(251),
    [sym__external_open_brace] = ACTIONS(447),
    [sym__external_close_brace] = ACTIONS(447),
    [sym__external_open_bracket] = ACTIONS(253),
    [sym__external_open_bracket2] = ACTIONS(255),
  },
  [190] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(451),
    [anon_sym_BSLASH] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(451),
    [anon_sym_for] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_repeat] = ACTIONS(451),
    [anon_sym_QMARK] = ACTIONS(453),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(453),
    [sym__number_literal] = ACTIONS(451),
    [anon_sym_SQUOTE] = ACTIONS(453),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_return] = ACTIONS(451),
    [sym_next] = ACTIONS(451),
    [sym_break] = ACTIONS(451),
    [sym_true] = ACTIONS(451),
    [sym_false] = ACTIONS(451),
    [sym_null] = ACTIONS(451),
    [sym_inf] = ACTIONS(451),
    [sym_nan] = ACTIONS(451),
    [anon_sym_NA] = ACTIONS(451),
    [anon_sym_NA_integer_] = ACTIONS(451),
    [anon_sym_NA_real_] = ACTIONS(451),
    [anon_sym_NA_complex_] = ACTIONS(451),
    [anon_sym_NA_character_] = ACTIONS(451),
    [sym_dots] = ACTIONS(451),
    [sym_dot_dot_i] = ACTIONS(453),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(453),
    [sym__newline] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(453),
    [sym__external_else] = ACTIONS(453),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(453),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [191] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(457),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [192] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(457),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [193] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(457),
    [anon_sym_AMP_AMP] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(457),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [194] = {
    [sym_call_arguments] = STATE(899),
    [sym_subset_arguments] = STATE(900),
    [sym_subset2_arguments] = STATE(905),
    [sym__open_parenthesis] = STATE(666),
    [sym__open_bracket] = STATE(667),
    [sym__open_bracket2] = STATE(668),
    [ts_builtin_sym_end] = ACTIONS(371),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [195] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(459),
    [anon_sym_BSLASH] = ACTIONS(461),
    [anon_sym_function] = ACTIONS(459),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_while] = ACTIONS(459),
    [anon_sym_repeat] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(461),
    [sym__number_literal] = ACTIONS(459),
    [anon_sym_SQUOTE] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [sym_return] = ACTIONS(459),
    [sym_next] = ACTIONS(459),
    [sym_break] = ACTIONS(459),
    [sym_true] = ACTIONS(459),
    [sym_false] = ACTIONS(459),
    [sym_null] = ACTIONS(459),
    [sym_inf] = ACTIONS(459),
    [sym_nan] = ACTIONS(459),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_dots] = ACTIONS(459),
    [sym_dot_dot_i] = ACTIONS(461),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__newline] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(461),
    [sym__external_else] = ACTIONS(461),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(461),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [196] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(463),
    [anon_sym_BSLASH] = ACTIONS(465),
    [anon_sym_function] = ACTIONS(463),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(463),
    [anon_sym_for] = ACTIONS(463),
    [anon_sym_while] = ACTIONS(463),
    [anon_sym_repeat] = ACTIONS(463),
    [anon_sym_QMARK] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(465),
    [sym__number_literal] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(463),
    [sym_next] = ACTIONS(463),
    [sym_break] = ACTIONS(463),
    [sym_true] = ACTIONS(463),
    [sym_false] = ACTIONS(463),
    [sym_null] = ACTIONS(463),
    [sym_inf] = ACTIONS(463),
    [sym_nan] = ACTIONS(463),
    [anon_sym_NA] = ACTIONS(463),
    [anon_sym_NA_integer_] = ACTIONS(463),
    [anon_sym_NA_real_] = ACTIONS(463),
    [anon_sym_NA_complex_] = ACTIONS(463),
    [anon_sym_NA_character_] = ACTIONS(463),
    [sym_dots] = ACTIONS(463),
    [sym_dot_dot_i] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(465),
    [sym__newline] = ACTIONS(465),
    [sym__raw_string_literal] = ACTIONS(465),
    [sym__external_else] = ACTIONS(465),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(465),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(465),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [197] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(469),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [198] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(469),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [199] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(469),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [200] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(467),
    [anon_sym_LT_EQ] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(467),
    [anon_sym_GT_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(467),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(469),
    [anon_sym_PIPE_GT] = ACTIONS(469),
    [anon_sym_COLON] = ACTIONS(467),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(469),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [201] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [202] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [203] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [204] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [205] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [206] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [207] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [208] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [209] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [210] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [211] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [212] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [213] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [214] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(375),
    [sym__newline] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(375),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [215] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(379),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [216] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [217] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [218] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [219] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [220] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [221] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [222] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [223] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [224] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [225] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [226] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [227] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [228] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [229] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(389),
    [anon_sym_BSLASH] = ACTIONS(387),
    [anon_sym_function] = ACTIONS(389),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_for] = ACTIONS(389),
    [anon_sym_while] = ACTIONS(389),
    [anon_sym_repeat] = ACTIONS(389),
    [anon_sym_QMARK] = ACTIONS(387),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(389),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(387),
    [sym__number_literal] = ACTIONS(389),
    [anon_sym_SQUOTE] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [sym_return] = ACTIONS(389),
    [sym_next] = ACTIONS(389),
    [sym_break] = ACTIONS(389),
    [sym_true] = ACTIONS(389),
    [sym_false] = ACTIONS(389),
    [sym_null] = ACTIONS(389),
    [sym_inf] = ACTIONS(389),
    [sym_nan] = ACTIONS(389),
    [anon_sym_NA] = ACTIONS(389),
    [anon_sym_NA_integer_] = ACTIONS(389),
    [anon_sym_NA_real_] = ACTIONS(389),
    [anon_sym_NA_complex_] = ACTIONS(389),
    [anon_sym_NA_character_] = ACTIONS(389),
    [sym_dots] = ACTIONS(389),
    [sym_dot_dot_i] = ACTIONS(387),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(387),
    [sym__newline] = ACTIONS(387),
    [sym__raw_string_literal] = ACTIONS(387),
    [sym__external_else] = ACTIONS(387),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(387),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(387),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [230] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(393),
    [anon_sym_BSLASH] = ACTIONS(391),
    [anon_sym_function] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(393),
    [anon_sym_while] = ACTIONS(393),
    [anon_sym_repeat] = ACTIONS(393),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(391),
    [sym__number_literal] = ACTIONS(393),
    [anon_sym_SQUOTE] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [sym_return] = ACTIONS(393),
    [sym_next] = ACTIONS(393),
    [sym_break] = ACTIONS(393),
    [sym_true] = ACTIONS(393),
    [sym_false] = ACTIONS(393),
    [sym_null] = ACTIONS(393),
    [sym_inf] = ACTIONS(393),
    [sym_nan] = ACTIONS(393),
    [anon_sym_NA] = ACTIONS(393),
    [anon_sym_NA_integer_] = ACTIONS(393),
    [anon_sym_NA_real_] = ACTIONS(393),
    [anon_sym_NA_complex_] = ACTIONS(393),
    [anon_sym_NA_character_] = ACTIONS(393),
    [sym_dots] = ACTIONS(393),
    [sym_dot_dot_i] = ACTIONS(391),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(391),
    [sym__newline] = ACTIONS(391),
    [sym__raw_string_literal] = ACTIONS(391),
    [sym__external_else] = ACTIONS(391),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(391),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(391),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [231] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(397),
    [anon_sym_BSLASH] = ACTIONS(395),
    [anon_sym_function] = ACTIONS(397),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(397),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(397),
    [anon_sym_QMARK] = ACTIONS(395),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(395),
    [sym__number_literal] = ACTIONS(397),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [sym_return] = ACTIONS(397),
    [sym_next] = ACTIONS(397),
    [sym_break] = ACTIONS(397),
    [sym_true] = ACTIONS(397),
    [sym_false] = ACTIONS(397),
    [sym_null] = ACTIONS(397),
    [sym_inf] = ACTIONS(397),
    [sym_nan] = ACTIONS(397),
    [anon_sym_NA] = ACTIONS(397),
    [anon_sym_NA_integer_] = ACTIONS(397),
    [anon_sym_NA_real_] = ACTIONS(397),
    [anon_sym_NA_complex_] = ACTIONS(397),
    [anon_sym_NA_character_] = ACTIONS(397),
    [sym_dots] = ACTIONS(397),
    [sym_dot_dot_i] = ACTIONS(395),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(395),
    [sym__newline] = ACTIONS(395),
    [sym__raw_string_literal] = ACTIONS(395),
    [sym__external_else] = ACTIONS(395),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(395),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(395),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [232] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(401),
    [anon_sym_BSLASH] = ACTIONS(399),
    [anon_sym_function] = ACTIONS(401),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(401),
    [anon_sym_for] = ACTIONS(401),
    [anon_sym_while] = ACTIONS(401),
    [anon_sym_repeat] = ACTIONS(401),
    [anon_sym_QMARK] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(399),
    [sym__number_literal] = ACTIONS(401),
    [anon_sym_SQUOTE] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [sym_return] = ACTIONS(401),
    [sym_next] = ACTIONS(401),
    [sym_break] = ACTIONS(401),
    [sym_true] = ACTIONS(401),
    [sym_false] = ACTIONS(401),
    [sym_null] = ACTIONS(401),
    [sym_inf] = ACTIONS(401),
    [sym_nan] = ACTIONS(401),
    [anon_sym_NA] = ACTIONS(401),
    [anon_sym_NA_integer_] = ACTIONS(401),
    [anon_sym_NA_real_] = ACTIONS(401),
    [anon_sym_NA_complex_] = ACTIONS(401),
    [anon_sym_NA_character_] = ACTIONS(401),
    [sym_dots] = ACTIONS(401),
    [sym_dot_dot_i] = ACTIONS(399),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(399),
    [sym__newline] = ACTIONS(399),
    [sym__raw_string_literal] = ACTIONS(399),
    [sym__external_else] = ACTIONS(399),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(399),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(399),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [233] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(405),
    [anon_sym_BSLASH] = ACTIONS(403),
    [anon_sym_function] = ACTIONS(405),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(405),
    [anon_sym_for] = ACTIONS(405),
    [anon_sym_while] = ACTIONS(405),
    [anon_sym_repeat] = ACTIONS(405),
    [anon_sym_QMARK] = ACTIONS(403),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(403),
    [sym__number_literal] = ACTIONS(405),
    [anon_sym_SQUOTE] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(403),
    [sym_return] = ACTIONS(405),
    [sym_next] = ACTIONS(405),
    [sym_break] = ACTIONS(405),
    [sym_true] = ACTIONS(405),
    [sym_false] = ACTIONS(405),
    [sym_null] = ACTIONS(405),
    [sym_inf] = ACTIONS(405),
    [sym_nan] = ACTIONS(405),
    [anon_sym_NA] = ACTIONS(405),
    [anon_sym_NA_integer_] = ACTIONS(405),
    [anon_sym_NA_real_] = ACTIONS(405),
    [anon_sym_NA_complex_] = ACTIONS(405),
    [anon_sym_NA_character_] = ACTIONS(405),
    [sym_dots] = ACTIONS(405),
    [sym_dot_dot_i] = ACTIONS(403),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(403),
    [sym__newline] = ACTIONS(403),
    [sym__raw_string_literal] = ACTIONS(403),
    [sym__external_else] = ACTIONS(403),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(403),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(403),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [234] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(409),
    [anon_sym_BSLASH] = ACTIONS(407),
    [anon_sym_function] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_for] = ACTIONS(409),
    [anon_sym_while] = ACTIONS(409),
    [anon_sym_repeat] = ACTIONS(409),
    [anon_sym_QMARK] = ACTIONS(407),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(409),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(407),
    [sym__number_literal] = ACTIONS(409),
    [anon_sym_SQUOTE] = ACTIONS(407),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [sym_return] = ACTIONS(409),
    [sym_next] = ACTIONS(409),
    [sym_break] = ACTIONS(409),
    [sym_true] = ACTIONS(409),
    [sym_false] = ACTIONS(409),
    [sym_null] = ACTIONS(409),
    [sym_inf] = ACTIONS(409),
    [sym_nan] = ACTIONS(409),
    [anon_sym_NA] = ACTIONS(409),
    [anon_sym_NA_integer_] = ACTIONS(409),
    [anon_sym_NA_real_] = ACTIONS(409),
    [anon_sym_NA_complex_] = ACTIONS(409),
    [anon_sym_NA_character_] = ACTIONS(409),
    [sym_dots] = ACTIONS(409),
    [sym_dot_dot_i] = ACTIONS(407),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(407),
    [sym__newline] = ACTIONS(407),
    [sym__raw_string_literal] = ACTIONS(407),
    [sym__external_else] = ACTIONS(407),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(407),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(407),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [235] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(413),
    [anon_sym_BSLASH] = ACTIONS(411),
    [anon_sym_function] = ACTIONS(413),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(413),
    [anon_sym_for] = ACTIONS(413),
    [anon_sym_while] = ACTIONS(413),
    [anon_sym_repeat] = ACTIONS(413),
    [anon_sym_QMARK] = ACTIONS(411),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(411),
    [sym__number_literal] = ACTIONS(413),
    [anon_sym_SQUOTE] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [sym_return] = ACTIONS(413),
    [sym_next] = ACTIONS(413),
    [sym_break] = ACTIONS(413),
    [sym_true] = ACTIONS(413),
    [sym_false] = ACTIONS(413),
    [sym_null] = ACTIONS(413),
    [sym_inf] = ACTIONS(413),
    [sym_nan] = ACTIONS(413),
    [anon_sym_NA] = ACTIONS(413),
    [anon_sym_NA_integer_] = ACTIONS(413),
    [anon_sym_NA_real_] = ACTIONS(413),
    [anon_sym_NA_complex_] = ACTIONS(413),
    [anon_sym_NA_character_] = ACTIONS(413),
    [sym_dots] = ACTIONS(413),
    [sym_dot_dot_i] = ACTIONS(411),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(411),
    [sym__newline] = ACTIONS(411),
    [sym__raw_string_literal] = ACTIONS(411),
    [sym__external_else] = ACTIONS(411),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(411),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(411),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [236] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(417),
    [anon_sym_BSLASH] = ACTIONS(415),
    [anon_sym_function] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(417),
    [anon_sym_for] = ACTIONS(417),
    [anon_sym_while] = ACTIONS(417),
    [anon_sym_repeat] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(415),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(417),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(415),
    [sym__number_literal] = ACTIONS(417),
    [anon_sym_SQUOTE] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(417),
    [anon_sym_NA_integer_] = ACTIONS(417),
    [anon_sym_NA_real_] = ACTIONS(417),
    [anon_sym_NA_complex_] = ACTIONS(417),
    [anon_sym_NA_character_] = ACTIONS(417),
    [sym_dots] = ACTIONS(417),
    [sym_dot_dot_i] = ACTIONS(415),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(415),
    [sym__newline] = ACTIONS(415),
    [sym__raw_string_literal] = ACTIONS(415),
    [sym__external_else] = ACTIONS(415),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(415),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(415),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [237] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(421),
    [anon_sym_BSLASH] = ACTIONS(419),
    [anon_sym_function] = ACTIONS(421),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(421),
    [anon_sym_for] = ACTIONS(421),
    [anon_sym_while] = ACTIONS(421),
    [anon_sym_repeat] = ACTIONS(421),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(419),
    [sym__number_literal] = ACTIONS(421),
    [anon_sym_SQUOTE] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [sym_return] = ACTIONS(421),
    [sym_next] = ACTIONS(421),
    [sym_break] = ACTIONS(421),
    [sym_true] = ACTIONS(421),
    [sym_false] = ACTIONS(421),
    [sym_null] = ACTIONS(421),
    [sym_inf] = ACTIONS(421),
    [sym_nan] = ACTIONS(421),
    [anon_sym_NA] = ACTIONS(421),
    [anon_sym_NA_integer_] = ACTIONS(421),
    [anon_sym_NA_real_] = ACTIONS(421),
    [anon_sym_NA_complex_] = ACTIONS(421),
    [anon_sym_NA_character_] = ACTIONS(421),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(419),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(419),
    [sym__newline] = ACTIONS(419),
    [sym__raw_string_literal] = ACTIONS(419),
    [sym__external_else] = ACTIONS(419),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(419),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(419),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [238] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(425),
    [anon_sym_BSLASH] = ACTIONS(423),
    [anon_sym_function] = ACTIONS(425),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(425),
    [anon_sym_while] = ACTIONS(425),
    [anon_sym_repeat] = ACTIONS(425),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(425),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(423),
    [sym__number_literal] = ACTIONS(425),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [sym_return] = ACTIONS(425),
    [sym_next] = ACTIONS(425),
    [sym_break] = ACTIONS(425),
    [sym_true] = ACTIONS(425),
    [sym_false] = ACTIONS(425),
    [sym_null] = ACTIONS(425),
    [sym_inf] = ACTIONS(425),
    [sym_nan] = ACTIONS(425),
    [anon_sym_NA] = ACTIONS(425),
    [anon_sym_NA_integer_] = ACTIONS(425),
    [anon_sym_NA_real_] = ACTIONS(425),
    [anon_sym_NA_complex_] = ACTIONS(425),
    [anon_sym_NA_character_] = ACTIONS(425),
    [sym_dots] = ACTIONS(425),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(423),
    [sym__newline] = ACTIONS(423),
    [sym__raw_string_literal] = ACTIONS(423),
    [sym__external_else] = ACTIONS(423),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(423),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(423),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [239] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(429),
    [anon_sym_BSLASH] = ACTIONS(427),
    [anon_sym_function] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_for] = ACTIONS(429),
    [anon_sym_while] = ACTIONS(429),
    [anon_sym_repeat] = ACTIONS(429),
    [anon_sym_QMARK] = ACTIONS(427),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(427),
    [sym__number_literal] = ACTIONS(429),
    [anon_sym_SQUOTE] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(427),
    [sym_return] = ACTIONS(429),
    [sym_next] = ACTIONS(429),
    [sym_break] = ACTIONS(429),
    [sym_true] = ACTIONS(429),
    [sym_false] = ACTIONS(429),
    [sym_null] = ACTIONS(429),
    [sym_inf] = ACTIONS(429),
    [sym_nan] = ACTIONS(429),
    [anon_sym_NA] = ACTIONS(429),
    [anon_sym_NA_integer_] = ACTIONS(429),
    [anon_sym_NA_real_] = ACTIONS(429),
    [anon_sym_NA_complex_] = ACTIONS(429),
    [anon_sym_NA_character_] = ACTIONS(429),
    [sym_dots] = ACTIONS(429),
    [sym_dot_dot_i] = ACTIONS(427),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(427),
    [sym__newline] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(427),
    [sym__external_else] = ACTIONS(427),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(427),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(427),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [240] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(433),
    [anon_sym_BSLASH] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(433),
    [anon_sym_for] = ACTIONS(433),
    [anon_sym_while] = ACTIONS(433),
    [anon_sym_repeat] = ACTIONS(433),
    [anon_sym_QMARK] = ACTIONS(431),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(431),
    [sym__number_literal] = ACTIONS(433),
    [anon_sym_SQUOTE] = ACTIONS(431),
    [anon_sym_DQUOTE] = ACTIONS(431),
    [sym_return] = ACTIONS(433),
    [sym_next] = ACTIONS(433),
    [sym_break] = ACTIONS(433),
    [sym_true] = ACTIONS(433),
    [sym_false] = ACTIONS(433),
    [sym_null] = ACTIONS(433),
    [sym_inf] = ACTIONS(433),
    [sym_nan] = ACTIONS(433),
    [anon_sym_NA] = ACTIONS(433),
    [anon_sym_NA_integer_] = ACTIONS(433),
    [anon_sym_NA_real_] = ACTIONS(433),
    [anon_sym_NA_complex_] = ACTIONS(433),
    [anon_sym_NA_character_] = ACTIONS(433),
    [sym_dots] = ACTIONS(433),
    [sym_dot_dot_i] = ACTIONS(431),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(431),
    [sym__newline] = ACTIONS(431),
    [sym__raw_string_literal] = ACTIONS(431),
    [sym__external_else] = ACTIONS(431),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(431),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(431),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [241] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(435),
    [anon_sym_function] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_for] = ACTIONS(437),
    [anon_sym_while] = ACTIONS(437),
    [anon_sym_repeat] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(435),
    [sym__number_literal] = ACTIONS(437),
    [anon_sym_SQUOTE] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [sym_return] = ACTIONS(437),
    [sym_next] = ACTIONS(437),
    [sym_break] = ACTIONS(437),
    [sym_true] = ACTIONS(437),
    [sym_false] = ACTIONS(437),
    [sym_null] = ACTIONS(437),
    [sym_inf] = ACTIONS(437),
    [sym_nan] = ACTIONS(437),
    [anon_sym_NA] = ACTIONS(437),
    [anon_sym_NA_integer_] = ACTIONS(437),
    [anon_sym_NA_real_] = ACTIONS(437),
    [anon_sym_NA_complex_] = ACTIONS(437),
    [anon_sym_NA_character_] = ACTIONS(437),
    [sym_dots] = ACTIONS(437),
    [sym_dot_dot_i] = ACTIONS(435),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(435),
    [sym__newline] = ACTIONS(435),
    [sym__raw_string_literal] = ACTIONS(435),
    [sym__external_else] = ACTIONS(435),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(435),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(435),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [242] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(441),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_for] = ACTIONS(441),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_repeat] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(439),
    [sym__number_literal] = ACTIONS(441),
    [anon_sym_SQUOTE] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(439),
    [sym_return] = ACTIONS(441),
    [sym_next] = ACTIONS(441),
    [sym_break] = ACTIONS(441),
    [sym_true] = ACTIONS(441),
    [sym_false] = ACTIONS(441),
    [sym_null] = ACTIONS(441),
    [sym_inf] = ACTIONS(441),
    [sym_nan] = ACTIONS(441),
    [anon_sym_NA] = ACTIONS(441),
    [anon_sym_NA_integer_] = ACTIONS(441),
    [anon_sym_NA_real_] = ACTIONS(441),
    [anon_sym_NA_complex_] = ACTIONS(441),
    [anon_sym_NA_character_] = ACTIONS(441),
    [sym_dots] = ACTIONS(441),
    [sym_dot_dot_i] = ACTIONS(439),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(439),
    [sym__newline] = ACTIONS(439),
    [sym__raw_string_literal] = ACTIONS(439),
    [sym__external_else] = ACTIONS(439),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(439),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(439),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [243] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [244] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(445),
    [anon_sym_BSLASH] = ACTIONS(443),
    [anon_sym_function] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(445),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(445),
    [anon_sym_repeat] = ACTIONS(445),
    [anon_sym_QMARK] = ACTIONS(443),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(443),
    [sym__number_literal] = ACTIONS(445),
    [anon_sym_SQUOTE] = ACTIONS(443),
    [anon_sym_DQUOTE] = ACTIONS(443),
    [sym_return] = ACTIONS(445),
    [sym_next] = ACTIONS(445),
    [sym_break] = ACTIONS(445),
    [sym_true] = ACTIONS(445),
    [sym_false] = ACTIONS(445),
    [sym_null] = ACTIONS(445),
    [sym_inf] = ACTIONS(445),
    [sym_nan] = ACTIONS(445),
    [anon_sym_NA] = ACTIONS(445),
    [anon_sym_NA_integer_] = ACTIONS(445),
    [anon_sym_NA_real_] = ACTIONS(445),
    [anon_sym_NA_complex_] = ACTIONS(445),
    [anon_sym_NA_character_] = ACTIONS(445),
    [sym_dots] = ACTIONS(445),
    [sym_dot_dot_i] = ACTIONS(443),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(443),
    [sym__newline] = ACTIONS(443),
    [sym__raw_string_literal] = ACTIONS(443),
    [sym__external_else] = ACTIONS(443),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(443),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(443),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [245] = {
    [sym_call_arguments] = STATE(903),
    [sym_subset_arguments] = STATE(907),
    [sym_subset2_arguments] = STATE(908),
    [sym__open_parenthesis] = STATE(682),
    [sym__open_bracket] = STATE(683),
    [sym__open_bracket2] = STATE(684),
    [sym_identifier] = ACTIONS(449),
    [anon_sym_BSLASH] = ACTIONS(447),
    [anon_sym_function] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_for] = ACTIONS(449),
    [anon_sym_while] = ACTIONS(449),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(447),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(449),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [sym__hex_literal] = ACTIONS(447),
    [sym__number_literal] = ACTIONS(449),
    [anon_sym_SQUOTE] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [sym_return] = ACTIONS(449),
    [sym_next] = ACTIONS(449),
    [sym_break] = ACTIONS(449),
    [sym_true] = ACTIONS(449),
    [sym_false] = ACTIONS(449),
    [sym_null] = ACTIONS(449),
    [sym_inf] = ACTIONS(449),
    [sym_nan] = ACTIONS(449),
    [anon_sym_NA] = ACTIONS(449),
    [anon_sym_NA_integer_] = ACTIONS(449),
    [anon_sym_NA_real_] = ACTIONS(449),
    [anon_sym_NA_complex_] = ACTIONS(449),
    [anon_sym_NA_character_] = ACTIONS(449),
    [sym_dots] = ACTIONS(449),
    [sym_dot_dot_i] = ACTIONS(447),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(447),
    [sym__newline] = ACTIONS(447),
    [sym__raw_string_literal] = ACTIONS(447),
    [sym__external_else] = ACTIONS(447),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(447),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(447),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [246] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(451),
    [anon_sym_BSLASH] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(451),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(451),
    [anon_sym_for] = ACTIONS(451),
    [anon_sym_while] = ACTIONS(451),
    [anon_sym_repeat] = ACTIONS(451),
    [anon_sym_QMARK] = ACTIONS(453),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(451),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(453),
    [sym__number_literal] = ACTIONS(451),
    [anon_sym_SQUOTE] = ACTIONS(453),
    [anon_sym_DQUOTE] = ACTIONS(453),
    [sym_return] = ACTIONS(451),
    [sym_next] = ACTIONS(451),
    [sym_break] = ACTIONS(451),
    [sym_true] = ACTIONS(451),
    [sym_false] = ACTIONS(451),
    [sym_null] = ACTIONS(451),
    [sym_inf] = ACTIONS(451),
    [sym_nan] = ACTIONS(451),
    [anon_sym_NA] = ACTIONS(451),
    [anon_sym_NA_integer_] = ACTIONS(451),
    [anon_sym_NA_real_] = ACTIONS(451),
    [anon_sym_NA_complex_] = ACTIONS(451),
    [anon_sym_NA_character_] = ACTIONS(451),
    [sym_dots] = ACTIONS(451),
    [sym_dot_dot_i] = ACTIONS(453),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(453),
    [sym__newline] = ACTIONS(453),
    [sym__raw_string_literal] = ACTIONS(453),
    [sym__external_else] = ACTIONS(453),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(453),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(453),
  },
  [247] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(457),
  },
  [248] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(457),
  },
  [249] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(457),
    [anon_sym_AMP_AMP] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(457),
  },
  [250] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(455),
    [anon_sym_BSLASH] = ACTIONS(457),
    [anon_sym_function] = ACTIONS(455),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(455),
    [anon_sym_for] = ACTIONS(455),
    [anon_sym_while] = ACTIONS(455),
    [anon_sym_repeat] = ACTIONS(455),
    [anon_sym_QMARK] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(455),
    [anon_sym_LT_DASH] = ACTIONS(457),
    [anon_sym_LT_LT_DASH] = ACTIONS(457),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_DASH_GT] = ACTIONS(455),
    [anon_sym_DASH_GT_GT] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(457),
    [anon_sym_AMP_AMP] = ACTIONS(457),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(457),
    [anon_sym_GT] = ACTIONS(455),
    [anon_sym_GT_EQ] = ACTIONS(457),
    [anon_sym_EQ_EQ] = ACTIONS(457),
    [anon_sym_BANG_EQ] = ACTIONS(457),
    [anon_sym_STAR] = ACTIONS(455),
    [anon_sym_SLASH] = ACTIONS(457),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(457),
    [anon_sym_PIPE_GT] = ACTIONS(457),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(457),
    [sym__number_literal] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(457),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_return] = ACTIONS(455),
    [sym_next] = ACTIONS(455),
    [sym_break] = ACTIONS(455),
    [sym_true] = ACTIONS(455),
    [sym_false] = ACTIONS(455),
    [sym_null] = ACTIONS(455),
    [sym_inf] = ACTIONS(455),
    [sym_nan] = ACTIONS(455),
    [anon_sym_NA] = ACTIONS(455),
    [anon_sym_NA_integer_] = ACTIONS(455),
    [anon_sym_NA_real_] = ACTIONS(455),
    [anon_sym_NA_complex_] = ACTIONS(455),
    [anon_sym_NA_character_] = ACTIONS(455),
    [sym_dots] = ACTIONS(455),
    [sym_dot_dot_i] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(457),
    [sym__newline] = ACTIONS(457),
    [sym__raw_string_literal] = ACTIONS(457),
    [sym__external_else] = ACTIONS(457),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(457),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(457),
  },
  [251] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(459),
    [anon_sym_BSLASH] = ACTIONS(461),
    [anon_sym_function] = ACTIONS(459),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(459),
    [anon_sym_for] = ACTIONS(459),
    [anon_sym_while] = ACTIONS(459),
    [anon_sym_repeat] = ACTIONS(459),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(461),
    [sym__number_literal] = ACTIONS(459),
    [anon_sym_SQUOTE] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(461),
    [sym_return] = ACTIONS(459),
    [sym_next] = ACTIONS(459),
    [sym_break] = ACTIONS(459),
    [sym_true] = ACTIONS(459),
    [sym_false] = ACTIONS(459),
    [sym_null] = ACTIONS(459),
    [sym_inf] = ACTIONS(459),
    [sym_nan] = ACTIONS(459),
    [anon_sym_NA] = ACTIONS(459),
    [anon_sym_NA_integer_] = ACTIONS(459),
    [anon_sym_NA_real_] = ACTIONS(459),
    [anon_sym_NA_complex_] = ACTIONS(459),
    [anon_sym_NA_character_] = ACTIONS(459),
    [sym_dots] = ACTIONS(459),
    [sym_dot_dot_i] = ACTIONS(461),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(461),
    [sym__newline] = ACTIONS(461),
    [sym__raw_string_literal] = ACTIONS(461),
    [sym__external_else] = ACTIONS(461),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(461),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(461),
  },
  [252] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(463),
    [anon_sym_BSLASH] = ACTIONS(465),
    [anon_sym_function] = ACTIONS(463),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(463),
    [anon_sym_for] = ACTIONS(463),
    [anon_sym_while] = ACTIONS(463),
    [anon_sym_repeat] = ACTIONS(463),
    [anon_sym_QMARK] = ACTIONS(465),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(463),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(465),
    [sym__number_literal] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(463),
    [sym_next] = ACTIONS(463),
    [sym_break] = ACTIONS(463),
    [sym_true] = ACTIONS(463),
    [sym_false] = ACTIONS(463),
    [sym_null] = ACTIONS(463),
    [sym_inf] = ACTIONS(463),
    [sym_nan] = ACTIONS(463),
    [anon_sym_NA] = ACTIONS(463),
    [anon_sym_NA_integer_] = ACTIONS(463),
    [anon_sym_NA_real_] = ACTIONS(463),
    [anon_sym_NA_complex_] = ACTIONS(463),
    [anon_sym_NA_character_] = ACTIONS(463),
    [sym_dots] = ACTIONS(463),
    [sym_dot_dot_i] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(465),
    [sym__newline] = ACTIONS(465),
    [sym__raw_string_literal] = ACTIONS(465),
    [sym__external_else] = ACTIONS(465),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(465),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(465),
  },
  [253] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(469),
  },
  [254] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(469),
  },
  [255] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(469),
  },
  [256] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_BSLASH] = ACTIONS(469),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_repeat] = ACTIONS(467),
    [anon_sym_QMARK] = ACTIONS(469),
    [anon_sym_TILDE] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_LT_DASH] = ACTIONS(469),
    [anon_sym_LT_LT_DASH] = ACTIONS(469),
    [anon_sym_COLON_EQ] = ACTIONS(469),
    [anon_sym_DASH_GT] = ACTIONS(467),
    [anon_sym_DASH_GT_GT] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(469),
    [anon_sym_LT] = ACTIONS(467),
    [anon_sym_LT_EQ] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(467),
    [anon_sym_GT_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_STAR] = ACTIONS(467),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(469),
    [anon_sym_PIPE_GT] = ACTIONS(469),
    [anon_sym_COLON] = ACTIONS(467),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(469),
    [sym__number_literal] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(469),
    [anon_sym_DQUOTE] = ACTIONS(469),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(467),
    [anon_sym_NA_integer_] = ACTIONS(467),
    [anon_sym_NA_real_] = ACTIONS(467),
    [anon_sym_NA_complex_] = ACTIONS(467),
    [anon_sym_NA_character_] = ACTIONS(467),
    [sym_dots] = ACTIONS(467),
    [sym_dot_dot_i] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(469),
    [sym__newline] = ACTIONS(469),
    [sym__raw_string_literal] = ACTIONS(469),
    [sym__external_else] = ACTIONS(469),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(469),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(469),
  },
  [257] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [258] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [259] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [260] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [261] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [262] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [263] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [264] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [265] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [266] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [267] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [268] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [269] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_LT_DASH] = ACTIONS(371),
    [anon_sym_LT_LT_DASH] = ACTIONS(371),
    [anon_sym_COLON_EQ] = ACTIONS(371),
    [anon_sym_DASH_GT] = ACTIONS(373),
    [anon_sym_DASH_GT_GT] = ACTIONS(371),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_LT_EQ] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(371),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(371),
    [anon_sym_PIPE_GT] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(373),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [270] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(375),
    [sym__newline] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(375),
  },
  [271] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(279),
    [anon_sym_LT_LT_DASH] = ACTIONS(279),
    [anon_sym_COLON_EQ] = ACTIONS(279),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sym_PIPE] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
    [anon_sym_PIPE_PIPE] = ACTIONS(289),
    [anon_sym_AMP_AMP] = ACTIONS(291),
    [anon_sym_LT] = ACTIONS(293),
    [anon_sym_LT_EQ] = ACTIONS(295),
    [anon_sym_GT] = ACTIONS(293),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(299),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [aux_sym_binary_operator_token1] = ACTIONS(303),
    [anon_sym_PIPE_GT] = ACTIONS(303),
    [anon_sym_COLON] = ACTIONS(305),
    [anon_sym_DOLLAR] = ACTIONS(307),
    [anon_sym_AT] = ACTIONS(307),
    [sym__hex_literal] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(311),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(313),
    [sym__external_open_bracket2] = ACTIONS(315),
    [sym__external_close_bracket2] = ACTIONS(379),
  },
  [272] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(686),
    [sym__open_bracket] = STATE(687),
    [sym__open_bracket2] = STATE(522),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(271),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(275),
    [anon_sym_DASH] = ACTIONS(277),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(281),
    [anon_sym_DASH_GT_GT] = ACTIONS(283),
    [anon_sy