% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_create_state_machine_alias}
\alias{sfn_create_state_machine_alias}
\title{Creates an alias for a state machine that points to one or two versions
of the same state machine}
\usage{
sfn_create_state_machine_alias(description = NULL, name, routingConfiguration)
}
\arguments{
\item{description}{A description for the state machine alias.}

\item{name}{[required] The name of the state machine alias.

To avoid conflict with version ARNs, don't use an integer in the name of
the alias.}

\item{routingConfiguration}{[required] The routing configuration of a state machine alias. The routing
configuration shifts execution traffic between two state machine
versions. \code{routingConfiguration} contains an array of \code{RoutingConfig}
objects that specify up to two state machine versions. Step Functions
then randomly choses which version to run an execution with based on the
weight assigned to each \code{RoutingConfig}.}
}
\description{
Creates an \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-alias.html}{alias} for a state machine that points to one or two \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-version.html}{versions} of the same state machine. You can set your application to call \code{\link[=sfn_start_execution]{start_execution}} with an alias and update the version the alias uses without changing the client's code.

See \url{https://www.paws-r-sdk.com/docs/sfn_create_state_machine_alias/} for full documentation.
}
\keyword{internal}
