% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_redrive_execution}
\alias{sfn_redrive_execution}
\title{Restarts unsuccessful executions of Standard workflows that didn't
complete successfully in the last 14 days}
\usage{
sfn_redrive_execution(executionArn, clientToken = NULL)
}
\arguments{
\item{executionArn}{[required] The Amazon Resource Name (ARN) of the execution to be redriven.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you don’t specify a client token, the
Amazon Web Services SDK automatically generates a client token and uses
it for the request to ensure idempotency. The API will return idempotent
responses for the last 10 client tokens used to successfully redrive the
execution. These client tokens are valid for up to 15 minutes after they
are first used.}
}
\description{
Restarts unsuccessful executions of Standard workflows that didn't complete successfully in the last 14 days. These include failed, aborted, or timed out executions. When you \href{https://docs.aws.amazon.com/step-functions/latest/dg/redrive-executions.html}{redrive} an execution, it continues the failed execution from the unsuccessful step and uses the same input. Step Functions preserves the results and execution history of the successful steps, and doesn't rerun these steps when you redrive an execution. Redriven executions use the same state machine definition and execution ARN as the original execution attempt.

See \url{https://www.paws-r-sdk.com/docs/sfn_redrive_execution/} for full documentation.
}
\keyword{internal}
