# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Resource Explorer
#'
#' @description
#' Amazon Web Services Resource Explorer is a resource search and discovery
#' service. By using Resource Explorer, you can explore your resources
#' using an internet search engine-like experience. Examples of resources
#' include Amazon Relational Database Service (Amazon RDS) instances,
#' Amazon Simple Storage Service (Amazon S3) buckets, or Amazon DynamoDB
#' tables. You can search for your resources using resource metadata like
#' names, tags, and IDs. Resource Explorer can search across all of the
#' Amazon Web Services Regions in your account in which you turn the
#' service on, to simplify your cross-Region workloads.
#' 
#' Resource Explorer scans the resources in each of the Amazon Web Services
#' Regions in your Amazon Web Services account in which you turn on
#' Resource Explorer. Resource Explorer [creates and maintains an
#' index](https://docs.aws.amazon.com/resource-explorer/latest/userguide/getting-started-terms-and-concepts.html#term-index)
#' in each Region, with the details of that Region's resources.
#' 
#' You can [search across all of the indexed Regions in your
#' account](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html)
#' by designating one of your Amazon Web Services Regions to contain the
#' aggregator index for the account. When you [promote a local index in a
#' Region to become the aggregator index for the
#' account](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region-turn-on.html),
#' Resource Explorer automatically replicates the index information from
#' all local indexes in the other Regions to the aggregator index.
#' Therefore, the Region with the aggregator index has a copy of all
#' resource information for all Regions in the account where you turned on
#' Resource Explorer. As a result, views in the aggregator index Region
#' include resources from all of the indexed Regions in your account.
#' 
#' For more information about Amazon Web Services Resource Explorer,
#' including how to enable and configure the service, see the [Amazon Web
#' Services Resource Explorer User
#' Guide](https://docs.aws.amazon.com/resource-explorer/latest/userguide/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- resourceexplorer(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- resourceexplorer()
#' svc$associate_default_view(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=resourceexplorer_associate_default_view]{associate_default_view} \tab Sets the specified view as the default for the Amazon Web Services Region in which you call this operation\cr
#'  \link[=resourceexplorer_batch_get_view]{batch_get_view} \tab Retrieves details about a list of views\cr
#'  \link[=resourceexplorer_create_index]{create_index} \tab Turns on Amazon Web Services Resource Explorer in the Amazon Web Services Region in which you called this operation by creating an index\cr
#'  \link[=resourceexplorer_create_view]{create_view} \tab Creates a view that users can query by using the Search operation\cr
#'  \link[=resourceexplorer_delete_index]{delete_index} \tab Deletes the specified index and turns off Amazon Web Services Resource Explorer in the specified Amazon Web Services Region\cr
#'  \link[=resourceexplorer_delete_view]{delete_view} \tab Deletes the specified view\cr
#'  \link[=resourceexplorer_disassociate_default_view]{disassociate_default_view} \tab After you call this operation, the affected Amazon Web Services Region no longer has a default view\cr
#'  \link[=resourceexplorer_get_account_level_service_configuration]{get_account_level_service_configuration} \tab Retrieves the status of your account's Amazon Web Services service access, and validates the service linked role required to access the multi-account search feature\cr
#'  \link[=resourceexplorer_get_default_view]{get_default_view} \tab Retrieves the Amazon Resource Name (ARN) of the view that is the default for the Amazon Web Services Region in which you call this operation\cr
#'  \link[=resourceexplorer_get_index]{get_index} \tab Retrieves details about the Amazon Web Services Resource Explorer index in the Amazon Web Services Region in which you invoked the operation\cr
#'  \link[=resourceexplorer_get_view]{get_view} \tab Retrieves details of the specified view\cr
#'  \link[=resourceexplorer_list_indexes]{list_indexes} \tab Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource information for Amazon Web Services Resource Explorer\cr
#'  \link[=resourceexplorer_list_indexes_for_members]{list_indexes_for_members} \tab Retrieves a list of a member's indexes in all Amazon Web Services Regions that are currently collecting resource information for Amazon Web Services Resource Explorer\cr
#'  \link[=resourceexplorer_list_supported_resource_types]{list_supported_resource_types} \tab Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer\cr
#'  \link[=resourceexplorer_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that are attached to the specified resource\cr
#'  \link[=resourceexplorer_list_views]{list_views} \tab Lists the Amazon resource names (ARNs) of the views available in the Amazon Web Services Region in which you call this operation\cr
#'  \link[=resourceexplorer_search]{search} \tab Searches for resources and displays details about all resources that match the specified criteria\cr
#'  \link[=resourceexplorer_tag_resource]{tag_resource} \tab Adds one or more tag key and value pairs to an Amazon Web Services Resource Explorer view or index\cr
#'  \link[=resourceexplorer_untag_resource]{untag_resource} \tab Removes one or more tag key and value pairs from an Amazon Web Services Resource Explorer view or index\cr
#'  \link[=resourceexplorer_update_index_type]{update_index_type} \tab Changes the type of the index from one of the following types to the other\cr
#'  \link[=resourceexplorer_update_view]{update_view} \tab Modifies some of the details of a view
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname resourceexplorer
#' @export
resourceexplorer <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .resourceexplorer$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.resourceexplorer <- list()

.resourceexplorer$operations <- list()

.resourceexplorer$metadata <- list(
  service_name = "resourceexplorer",
  endpoints = list("*" = list(endpoint = "resource-explorer-2.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "resource-explorer-2.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "resource-explorer-2.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "resource-explorer-2.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "resource-explorer-2.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "resource-explorer-2.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Resource Explorer 2",
  api_version = "2022-07-28",
  signing_name = "resource-explorer-2",
  json_version = "1.1",
  target_prefix = ""
)

.resourceexplorer$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.resourceexplorer$metadata, handlers, config)
}
