% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{plot_element_cycle}
\alias{plot_element_cycle}
\title{Plot element cycle}
\usage{
plot_element_cycle(
  cycle = "Nitrogen cycle",
  anno_df = NULL,
  only_anno = FALSE,
  cell_fill = NA,
  cell_color = "orange",
  chemical_size = 7,
  chemical_bold = TRUE,
  chemical_color = "black",
  chemical_label = TRUE,
  reaction_width = 1,
  reaction_arrow_size = 4,
  reaction_arrow_closed = TRUE,
  gene_or_ko = "gene",
  gene_size = 3,
  gene_x_offset = 0.3,
  gene_y_offset = 0.15,
  gene_label = TRUE,
  gene_color = NULL,
  gene_bold = TRUE,
  gene_italic = TRUE,
  gene_label_fill = "white"
)
}
\arguments{
\item{cycle}{one of c("Carbon cycle","Nitrogen cycle","Phosphorus cycle","Sulfur cycle","Iron cycle")}

\item{anno_df}{anno_df, columns should contains Gene or KO and Group}

\item{only_anno}{only show genes in anno_df?}

\item{cell_fill}{cell fill color}

\item{cell_color}{cell border color}

\item{chemical_size}{chemical text size}

\item{chemical_bold}{chemical text bold}

\item{chemical_color}{chemical text color}

\item{chemical_label}{chemical text in geom_label or geom_text?}

\item{reaction_width}{reaction line width}

\item{reaction_arrow_size}{reaction arrow size}

\item{reaction_arrow_closed}{reaction arrow closed?}

\item{gene_or_ko}{"gene" or "ko"}

\item{gene_size}{gene text size}

\item{gene_x_offset}{gene_x_offset}

\item{gene_y_offset}{gene_y_offset}

\item{gene_label}{gene text in geom_label or geom_text?}

\item{gene_color}{gene text color}

\item{gene_bold}{gene text blod?}

\item{gene_italic}{gene text italic?}

\item{gene_label_fill}{gene label fill color}
}
\value{
ggplot
}
\description{
Plot element cycle
}
\examples{
if (requireNamespace("ggforce")) plot_element_cycle()
}
