% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perumammals-data.R
\docType{data}
\name{peru_mammals_ecoregions_meta}
\alias{peru_mammals_ecoregions_meta}
\title{Metadata for Peruvian mammal ecoregions}
\format{
A tibble with one row per ecoregion code and 2 variables:
\describe{
\item{ecoregion_code}{Character. Ecoregion abbreviation. The codes used
in the dataset are:
\itemize{
\item \code{"OCE"} – Oceánica
\item \code{"BPP"} – Bosque Pluvial del Pacífico
\item \code{"BSE"} – Bosque Seco Ecuatorial
\item \code{"COS"} – Costa
\item \code{"VOC"} – Vertiente Occidental
\item \code{"PAR"} – Páramo
\item \code{"PUN"} – Puna
\item \code{"YUN"} – Yungas
\item \code{"SB"}  – Selva Baja
\item \code{"SP"}  – Sabana de Palmera
}}
\item{ecoregion_label}{Character. Human-readable label/description
of the ecoregion in Spanish.}
}
}
\source{
Pacheco et al. (2021).
}
\usage{
data("peru_mammals_ecoregions_meta")
}
\description{
Definitions of the ecoregion codes used in \code{\link{peru_mammals}}
and \code{\link{peru_mammals_ecoregions}}. The codes follow the
abbreviations used by Pacheco et al. (2021), based on Peruvian
ecoregion schemes.
}
\seealso{
\code{\link{peru_mammals}},
\code{\link{peru_mammals_ecoregions}}
}
\keyword{datasets}
