% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water-n.r
\name{water_n}
\alias{water_n}
\title{Refractive index of water}
\usage{
water_n(temperature = 20, w.length = 540, type = "freshwater")
}
\arguments{
\item{temperature}{numeric Water temperature in degrees Celcius (C)}

\item{w.length}{numeric Wavelength in nanometres (nm)}

\item{type}{character One of "freshwater" or "seawater".}
}
\description{
The refractive index, usually abbreviated as \eqn{n} varies with temperature
and wavelength.
}
\details{
Function `n.water()` implements the function proposed by Parrish for
approximation of \eqn{n} for freshwater and seawater. The function is valid
for wavelengths from 400 nm to 700 nm, and for temperatures from 0 C to 30 C.
The function is vectorized.
}
\examples{

water_n(w.length = (40:70)*10)
water_n(temperature = seq(0, 30, by = 5))

}
\references{
Chris Parrish (2020) Index of Refraction of Seawater and Freshwater as a
Function of Wavelength and Temperature.
 \url{https://research.engr.oregonstate.edu/parrish/index-refraction-seawater-and-freshwater-function-wavelength-and-temperature}
}
\seealso{
For other materials see \code{\link{refractive_index.mspct}} and to
compute reflectance from \eqn{n} see \code{\link[photobiology]{Rfr_from_n}}.
}
