% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psv.R
\name{psv}
\alias{psv}
\alias{psr}
\alias{pse}
\alias{psc}
\alias{psv.spp}
\alias{psd}
\title{Phylogenetic Species Diversity Metrics}
\usage{
psv(
  comm,
  tree,
  compute.var = TRUE,
  scale.vcv = TRUE,
  prune.tree = FALSE,
  cpp = TRUE
)

psr(
  comm,
  tree,
  compute.var = TRUE,
  scale.vcv = TRUE,
  prune.tree = FALSE,
  cpp = TRUE
)

pse(comm, tree, scale.vcv = TRUE, prune.tree = FALSE, cpp = TRUE)

psc(comm, tree, scale.vcv = TRUE, prune.tree = FALSE)

psv.spp(comm, tree, scale.vcv = TRUE, prune.tree = FALSE, cpp = TRUE)

psd(
  comm,
  tree,
  compute.var = TRUE,
  scale.vcv = TRUE,
  prune.tree = FALSE,
  cpp = TRUE
)
}
\arguments{
\item{comm}{Community data matrix, site as rows and species as columns, site names as row names.}

\item{tree}{A phylo tree object with class "phylo" or a phylogenetic covariance matrix.}

\item{compute.var}{Logical, default is TRUE, computes the expected variances
for PSV and PSR for each community.}

\item{scale.vcv}{Logical, default is TRUE, scale the phylogenetic covariance
matrix to bound the metric between 0 and 1 (i.e. correlations).}

\item{prune.tree}{Logical, default is FALSE, prune the phylogeny before converting
to var-cov matrix? Pruning and then converting VS converting then subsetting may
have different var-cov matrix resulted.}

\item{cpp}{Logical, default is TRUE, whether to use cpp for internal calculations.}
}
\value{
Returns a dataframe of the respective phylogenetic species diversity metric values
}
\description{
Calculate the bounded phylogenetic biodiversity metrics:
phylogenetic species variability, richness, evenness and clustering for one or multiple communities.
}
\details{
\emph{Phylogenetic species variability (PSV)} quantifies how
phylogenetic relatedness decreases the variance of a hypothetical
unselected/neutral trait shared by all species in a community.
The expected value of PSV is statistically independent of species richness,
is one when all species in a community are unrelated (i.e., a star phylogeny)
and approaches zero as species become more related. PSV is directly related
to mean phylogenetic distance, except except calculated on a scaled phylogenetic
covariance matrix. The expected variance around PSV for any community of a particular
species richness can be approximated. To address how individual species
contribute to the mean PSV of a data set, the function \code{psv.spp} gives
signed proportions of the total deviation from the mean PSV that occurs when
all species are removed from the data set one at a time. The absolute values
of these \dQuote{species effects} tend to positively correlate with species prevalence.
}
\note{
These metrics are bounded either between zero and one (PSV, PSE, PSC)
or zero and species richness (PSR); but the metrics asymptotically approach
zero as relatedness increases. Zero can be assigned to communities with less
than two species, but conclusions drawn from assigning communities zero values
need be carefully explored for any data set. The data sets need not be
species-community data sets but may be any community data set with an associated phylogeny.
}
\examples{
psv(comm = comm_a, tree = phylotree) 
}
\references{
Helmus M.R., Bland T.J., Williams C.K. & Ives A.R. 2007.
Phylogenetic measures of biodiversity. American Naturalist, 169, E68-E83
}
\author{
Matthew Helmus \email{mrhelmus@gmail.com}
}
