% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.piar_aggregation_structure.R
\name{weights.piar_aggregation_structure}
\alias{weights.piar_aggregation_structure}
\alias{weights<-}
\alias{weights<-.piar_aggregation_structure}
\alias{set_weights}
\title{Get the weights for an aggregation structure}
\usage{
\method{weights}{piar_aggregation_structure}(object, ..., ea_only = TRUE, na.rm = FALSE)

weights(object) <- value

\method{weights}{piar_aggregation_structure}(object) <- value

set_weights(object, value)
}
\arguments{
\item{object}{A price index aggregation structure, as made by
\code{\link[=aggregation_structure]{aggregation_structure()}}.}

\item{...}{Not currently used.}

\item{ea_only}{Should weights be returned for only the elemental aggregates
(the default)? Setting to \code{FALSE} gives the weights for the entire
aggregation structure.}

\item{na.rm}{Should missing values be removed when aggregating the
weights (i.e., when \code{ea_only = FALSE})? By default, missing values are
not removed.}

\item{value}{A numeric vector of weights for the elemental aggregates of
\code{object}.}
}
\value{
\code{weights()} returns a named vector of weights for the elemental aggregates.
The replacement method replaces these values without changing the
aggregation structure. (\code{set_weights()} is an alias that's easier to use with
pipes.)

If \code{ea_only = FALSE} then the return value is a list
with a named vector of weights for each level in the aggregation structure.
}
\description{
Get and set the weights for a price index aggregation structure.
}
\examples{
# A simple aggregation structure
#            1
#      |-----+-----|
#      11          12
#  |---+---|       |
#  111     112     121
#  (1)     (3)     (4)

aggregation_weights <- data.frame(
  level1 = c("1", "1", "1"),
  level2 = c("11", "11", "12"),
  ea     = c("111", "112", "121"),
  weight = c(1, 3, 4)
)

pias <- as_aggregation_structure(aggregation_weights)

# Extract the weights

weights(pias)

# ... or update them

weights(pias) <- 1:3
weights(pias)

}
\seealso{
Other aggregation structure methods: 
\code{\link{as.matrix.piar_aggregation_structure}()},
\code{\link{cut.piar_aggregation_structure}()},
\code{\link{levels.piar_aggregation_structure}()},
\code{\link{update.piar_aggregation_structure}()}
}
\concept{aggregation structure methods}
