% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m278inshcm.R
\name{m278inshcm}
\alias{m278inshcm}
\title{Minenergo-278. Thermal conductivity of pipe insulation materials}
\usage{
m278inshcm(temperature = 110, material = "aerocrete")
}
\arguments{
\item{temperature}{temperature of heat carrier (water) inside the pipe, [\emph{°C}].
Type: \code{\link{assert_double}}.}

\item{material}{designation of insulation material as it stated in \code{\link{m278insdata}},
Type: \code{\link{assert_subset}}.}
}
\value{
Thermal conductivity of insulation materials at given
 set of temperatures, [\emph{W/m/°C}], [\emph{W/m/K}].
 Type: \code{\link{assert_double}}.
}
\description{
Get normative values of thermal conductivity of pipe insulation
 materials affirmed by
 \href{https://docs.cntd.ru/document/1200035568}{Minenergo Method 278} as
 a function of temperature of heat carrier (water).
}
\examples{
 library(pipenostics)

# Averaged thermal conductivity of pipe insulation at 110 °C
print(m278insdata)
mean(m278inshcm(110, m278insdata[["material"]]))
# [1] 0.09033974  # [\emph{W/m/°C}]

}
\seealso{
Other Minenergo: 
\code{\link{m278hlair}()},
\code{\link{m278hlcha}()},
\code{\link{m278hlund}()},
\code{\link{m278insdata}},
\code{\link{m278soildata}},
\code{\link{m325beta}()},
\code{\link{m325nhl}()},
\code{\link{m325nhldata}},
\code{\link{m325testbench}}
}
\concept{Minenergo}
