% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_paste_if_found}
\alias{utils_paste_if_found}
\title{Conditionally amend character string vector.}
\usage{
utils_paste_if_found(regex_filter, string_filter, default, ignore_case, ...)
}
\arguments{
\item{regex_filter}{Pattern to look for provided as a character string regex.}

\item{string_filter}{Character string vector to search into for the pattern
provided in \code{regex_filter} above.}

\item{default}{Character string returned if pattern provided in \code{regex_filter}
not found.}

\item{ignore_case}{Boolean specifying whether case should be ignored (\code{TRUE})
or not (\code{FALSE}).}

\item{...}{Character string(s) to be paste together using a space as separator
and returned if pattern provided in \code{regex_filter} found.}
}
\value{
A character string vector.
}
\description{
Searches for specified pattern in provided character string. Return pasted
provided character string(s) if found or provided default character string
if not.
}
\examples{
\dontrun{
  utils_paste_if_found(
    "^glasgow", c("glasgow-entrepreneurs", "aberdeen-entrepreneurs"),
    "pattern not found", TRUE, "pattern", "found"
  )
}
}
