% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BubleyDyerMRPGenerator.R
\name{BubleyDyerMRPGenerator}
\alias{BubleyDyerMRPGenerator}
\title{Generator of an approximated MRP matrix.}
\usage{
BubleyDyerMRPGenerator(poset = NULL, seed = NULL)
}
\arguments{
\item{poset}{Object of S4 class \code{POSet} representing the poset whose MRP are computed.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{seed}{Positive integer to initialize the random linear extension generation.}
}
\value{
An object of S4 class \code{BubleyDyerMRPGenerator}.
}
\description{
Creates an object of S4 class \code{BubleyDyerMRPGenerator} for the computation of an approximated
MRP matrix, starting from a set of random linear extensions, sampled according to the Bubley-Dyer procedure.
Actually, this function does not compute the MRP matrix, but just the object that will compute it,
by using function \code{BubleyDyerMRP}.
}
\examples{
el <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = el, dom = dom)

BDgen <- BubleyDyerMRPGenerator(pos)

}
