% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re.clustsize.bin.R
\name{re.clustsize.bin}
\alias{re.clustsize.bin}
\title{Relative efficiency of a cluster randomized or multisite trial with binary outcome
with varying cluster sizes}
\usage{
re.clustsize.bin(m, m.sd, pc, pt, sigma.u)
}
\arguments{
\item{m}{The number of subjects per cluster or the mean cluster size (if unequal number of participants per cluster).}

\item{m.sd}{The standard deviation of cluster sizes (in case of unequal number of participants per cluster).}

\item{pc}{The probability of the outcome in control clusters.}

\item{pt}{The probability of the outcome in treatment clusters.}

\item{sigma.u}{Standard deviation of the cluster random effect.}
}
\value{
The computed RE.
}
\description{
For a binary outcome, computes the relative efficiency (ratio of the variances) of a cluster randomized
or multisite trial with varying cluster (site) sizes to that of a trial with constant cluster sizes,
assuming equal total number of subjects. This approximation may not be valid for all combinations of
parameters, for example when m.sd is large.
}
\details{
Candel MJJM and van Breukelen GJP (2010) Sample size adjustments for varying cluster sizes in
cluster randomized trials with binary outcomes analyzed with second-order PQL mixed logistic regression.
Statistics in Medicine 29(14):1488-1501.
}
\examples{
re.clustsize.bin(m = 60, m.sd = 45, pc = 0.25, pt = 0.15, sigma.u = 0.3)
}
