% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omiForSubFigure.R
\name{omiForSubFigure}
\alias{omiForSubFigure}
\title{Generate Values for par("omi") That Will Place a New Plot in a Sub-Region of
an Existing One}
\usage{
omiForSubFigure(
  bottom,
  left,
  top,
  right,
  units = "proportion",
  region = "device"
)
}
\arguments{
\item{bottom}{Boundary value for the bottom edge.}

\item{left}{Boundary value for the left edge.}

\item{top}{Boundary value for the top edge.}

\item{right}{Boundary value for the right edge.}

\item{units}{The units in which the boundary parameters are defined. Must be one
one of "proportion" or "data". Defaults to "proportion".}

\item{region}{The region of the plot to use for defining the boundaries. Must
be one of "device", "figure", "plot", or "data". Only necessary
when using units of "proportion".}
}
\description{
Generate Values for par("omi") That Will Place a New Plot in a Sub-Region of
an Existing One
}
\details{
The choice of accepting proportions instead of data units by default
         is to more easily handle empty devices, otherwise there is a risk of
         getting confused by the fact that par("usr") defaults to c(0, 1, 0, 1).
}
\examples{
\dontrun{

plot(1:10, pch = 19, col = 'black')
oldPar = par()
par(omi = omiForSubFigure(0.6, 0.25, 0.8, 0.45, region = 'device'))
par(mar = c(0,0,0,0))
plot(1:10, pch = 19, col = 'red')
par(oldPar)
par(omi = omiForSubFigure(2, 6, 5, 10, units = 'data'))
par(mar = c(0,0,0,0))
plot(1:10, pch = 19, col = 'blue')
par(oldPar)

## Illustrates how the proportions line up:

plot(1:10, pch = 19)
par(xpd = NA)
oldPar = par()

## Show where the propotions are as a reference:
abline(v = convertUnits('proportion', seq(0, 1, by = 0.1), 'data',
       region = 'device', axis = 'x'), lty = 2, col = 'red')
abline(h = convertUnits('proportion', seq(0, 1, by = 0.1), 'data',
       region = 'device', axis = 'y'), lty = 2, col = 'red')

## Create a new sub-plot.
par(omi = omiForSubFigure(0.2, 0.2, 0.8, 0.8, region = 'device'))

plot(1:10, pch = 19, col = 'red')
highlightFigureRegion()

par(oldPar)

}

}
\author{
Jasper Watson
}
