% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime.R
\name{simulate.spacetimeobj}
\alias{simulate.spacetimeobj}
\title{Simulation of space-time models}
\usage{
\method{simulate}{spacetimeobj}(
  object,
  nsim = 1,
  seed = NULL,
  kappa = NULL,
  sigma = NULL,
  gamma = NULL,
  rho = NULL,
  ...
)
}
\arguments{
\item{object}{Space-time object created by \code{\link[=spacetime.operators]{spacetime.operators()}}}

\item{nsim}{The number of simulations.}

\item{seed}{an object specifying if and how the random number generator should be initialized (‘seeded’).}

\item{kappa}{kappa parameter if it should be updated}

\item{sigma}{sigma parameter if it should be updated}

\item{gamma}{gamma parameter if it should be updated}

\item{rho}{rho parameter if it should be updated}

\item{...}{Currently not used.}
}
\value{
A matrix with the simulations as columns.
}
\description{
Simulation of space-time models
}
\examples{
s <- seq(from = 0, to = 20, length.out = 101)
t <- seq(from = 0, to = 20, length.out = 31)

op_cov <- spacetime.operators(space_loc = s, time_loc = t,
                             kappa = 5, sigma = 10, alpha = 1,
                             beta = 2, rho = 1, gamma = 0.05)
x <- simulate(op_cov, nsim = 1) 
image(matrix(x, nrow = length(s), ncol = length(t)))                              
}
