% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfpca_twoStep.R
\name{determine_npc}
\alias{determine_npc}
\title{Determine the number of FPCs based on the share of explained variance}
\usage{
determine_npc(evalues, npc_criterion)
}
\arguments{
\item{evalues}{Vector of estimated variances of the FPC scores.}

\item{npc_criterion}{Either (i) a share between 0 and 1, or (ii) a vector with
two elements for the targeted explained share of variance and a cut-off scree
plot criterion, both between 0 and 1. For the latter, e.g.,
\code{npc_criterion = c(0.9,0.02)} tries to choose a number of FPCs that
explains at least 90\% of variation, but only includes FPCs that explain at
least 2\% of variation (even if this means 90\% explained variation is not reached).}
}
\value{
Integer for the number of fucntional principal components
}
\description{
This internal function is called in \code{gfpca_twoStep}, \code{fpca_gauss}
and \code{bfpca} to determine the number of functional principal components
based on their share of explained variance.
}
