% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad.R
\name{str_pad}
\alias{str_pad}
\title{Pad a string to minimum width}
\usage{
str_pad(
  string,
  width,
  side = c("left", "right", "both"),
  pad = " ",
  use_width = TRUE
)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{width}{Minimum width of padded strings.}

\item{side}{Side on which padding character is added (left, right or both).}

\item{pad}{Single padding character (default is a space).}

\item{use_width}{If \code{FALSE}, use the length of the string instead of the
width; see \code{\link[=str_width]{str_width()}}/\code{\link[=str_length]{str_length()}} for the difference.}
}
\value{
A character vector the same length as \code{stringr}/\code{width}/\code{pad}.
}
\description{
Pad a string to a fixed width, so that
\code{str_length(str_pad(x, n))} is always greater than or equal to \code{n}.
}
\examples{
rbind(
  str_pad("hadley", 30, "left"),
  str_pad("hadley", 30, "right"),
  str_pad("hadley", 30, "both")
)

# All arguments are vectorised except side
str_pad(c("a", "abc", "abcdef"), 10)
str_pad("a", c(5, 10, 20))
str_pad("a", 10, pad = c("-", "_", " "))

# Longer strings are returned unchanged
str_pad("hadley", 3)
}
\seealso{
\code{\link[=str_trim]{str_trim()}} to remove whitespace;
\code{\link[=str_trunc]{str_trunc()}} to decrease the maximum width of a string.
}
