% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLAS.r
\name{read.lasheader}
\alias{read.lasheader}
\title{Read header from a .las or .laz file}
\usage{
read.lasheader(file)
}
\arguments{
\item{file}{filepath character string to the .las or .laz file}
}
\value{
A \code{list}
}
\description{
Reads header from .las or .laz files according to LAS specifications and returns
a \code{list} labeled according to LAS specifications. See the ASPRS documentation for the
\href{https://community.asprs.org/leadership-restricted/leadership-content/public-documents/standards}{LAS file format}.
}
\examples{
lazfile   <- system.file("extdata", "example.las", package="rlas")
lasheader <- read.lasheader(lazfile)
}
\seealso{
Other rlas: 
\code{\link{write.las}()}
}
\concept{rlas}
