% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction.R
\name{correct_intensity}
\alias{correct_intensity}
\title{Truncate and correct 'MRI' intensity}
\usage{
correct_intensity(image, mask = NULL, intensity_truncation = c(0.025, 0.975))
}
\arguments{
\item{image}{'MRI' image to be corrected, will be passed to
\code{\link{as_ANTsImage}}}

\item{mask}{binary mask image}

\item{intensity_truncation}{numerical length of two, quantile probabilities
to truncate.}
}
\value{
An \code{'ANTsImage'} instance
}
\description{
Uses \code{ants.abp_n4} to truncate and correct intensity
}
\examples{

if(interactive() && ants_available()) {
  ants <- load_ants()
  scale <- (0.1 + outer(
    seq(0, 1, length.out = 256)^6,
    seq(0, 1, length.out = 256)^2,
    FUN = "+"
  )) / 6
  img = ants$image_read(ants$get_ants_data('r16')) * scale

  corrected <- correct_intensity(img)

  pal <- gray.colors(255, start = 0)
  par(mfrow = c(1, 2), mar = c(0.1, 0.1, 2.1, 0.1),
      bg = "black", fg = "white")
  image(img[], asp = 1, axes = FALSE,
        col = pal, ylim = c(1, 0),
        main = "Original", col.main = "white")
  image(corrected[], asp = 1, axes = FALSE,
        col = pal, ylim = c(1, 0),
        main = "Corrected", col.main = "white")

}

}
