% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_pos_and_access.R
\name{subset_cols}
\alias{subset_cols}
\alias{subset_cols,TableTree,numeric-method}
\alias{subset_cols,ElementaryTable,numeric-method}
\alias{subset_cols,ANY,character-method}
\alias{subset_cols,TableRow,numeric-method}
\alias{subset_cols,LabelRow,numeric-method}
\alias{subset_cols,InstantiatedColumnInfo,numeric-method}
\alias{subset_cols,LayoutColTree,numeric-method}
\title{Subset a table or row to particular columns}
\usage{
subset_cols(
  tt,
  j,
  newcinfo = NULL,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  ...
)

\S4method{subset_cols}{TableTree,numeric}(
  tt,
  j,
  newcinfo = NULL,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  ...
)

\S4method{subset_cols}{ElementaryTable,numeric}(
  tt,
  j,
  newcinfo = NULL,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  ...
)

\S4method{subset_cols}{ANY,character}(
  tt,
  j,
  newcinfo = NULL,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  ...
)

\S4method{subset_cols}{TableRow,numeric}(
  tt,
  j,
  newcinfo = NULL,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  ...
)

\S4method{subset_cols}{LabelRow,numeric}(
  tt,
  j,
  newcinfo = NULL,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  ...
)

\S4method{subset_cols}{InstantiatedColumnInfo,numeric}(
  tt,
  j,
  newcinfo = NULL,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  ...
)

\S4method{subset_cols}{LayoutColTree,numeric}(
  tt,
  j,
  newcinfo = NULL,
  keep_topleft = TRUE,
  keep_titles = TRUE,
  keep_footers = keep_titles,
  ...
)
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{j}{(\code{integer}, \code{logical} or \code{character})\cr The column(s) to subset \code{tt}
down to. Character vectors are interpreted as a \emph{column path}, not as names.
Path can include \code{"*"} wildcards.}

\item{newcinfo}{(\code{NULL} or \code{InstantiatedColumnInfo})\cr The new column info,
if precomputed. Generally should not be manually set by users.}

\item{keep_topleft}{(\code{flag})\cr if \code{TRUE} (the default), top_left material for the table will be carried over to the
subset.}

\item{keep_titles}{(\code{flag})\cr if \code{TRUE} (the default), all title material for the table will be carried over to the
subset.}

\item{keep_footers}{(\code{flag})\cr if \code{TRUE}, all footer material for the table will be carried over to the subset. It
defaults to \code{keep_titles}.}

\item{...}{Ignored.}
}
\description{
Subset a table or row to particular columns
}
\examples{
lyt <- basic_table(
  title = "Title",
  subtitles = c("Sub", "titles"),
  prov_footer = "prov footer",
  main_footer = "main footer"
) \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by("SEX") \%>\%
  analyze(c("AGE"))

tbl <- build_table(lyt, DM)

subset_cols(tbl, c(1, 3))
subset_cols(tbl, c("ARM", "*", "SEX", "F"))
}
