% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sasfunclust_functions.R
\name{sasfclust}
\alias{sasfclust}
\title{Sparse and Smooth Functional Data Clustering}
\usage{
sasfclust(
  X = NULL,
  timeindex = NULL,
  curve = NULL,
  grid = NULL,
  q = 30,
  lambda_l = 10,
  lambda_s = 10,
  G = 2,
  tol = 10^-7,
  maxit = 50,
  par_LQA = list(eps_diff = 1e-06, MAX_iter_LQA = 200, eps_LQA = 1e-05),
  plot = F,
  trace = F,
  init = "kmeans",
  varcon = "diagonal",
  lambda_s_ini = NULL
)
}
\arguments{
\item{X}{For functional data observed over a regular grid: a matrix of where  the rows must correspond to argument values and columns to replications.
For functional data observed over an irregular grid:  a vector of length \eqn{\sum_{i=1}^{N}n_i}, with \eqn{N}  the number of curves,
where the entries from  \eqn{\sum_{i=1}^{k-1}(n_i+1)} to \eqn{\sum_{i=1}^{k}n_i} are elements representing the observations for curve \eqn{k}.}

\item{timeindex}{A vector of length \eqn{\sum_{i=1}^{N}n_i}. The entries from  \eqn{\sum_{i=1}^{k-1}(n_i+1)} to \eqn{\sum_{i=1}^{k}n_i} provide the locations on \code{grid} of curve  \eqn{k}.
So for example, if the \eqn{k}th curve is observed at time points \eqn{t_l,t_m} of the \code{grid} then the the entries from  \eqn{\sum_{i=1}^{k-1}(n_i+1)} to \eqn{\sum_{i=1}^{k}n_i} would be \eqn{l,m}, being \eqn{n_k=2}.
If X is a matrix, timeindex is ignored.}

\item{curve}{A vector of length \eqn{\sum_{i=1}^{N}n_i}. The entries from  \eqn{\sum_{i=1}^{k-1}(n_i+1)} to \eqn{\sum_{i=1}^{k}n_i} are equal to  \eqn{k}.
If X is a matrix, curve is ignored.}

\item{grid}{The vector of time points where the curves are sampled.
For Functional data observed over an irregular grid, \code{timeindex} and \code{grid} provide the time points for each curve.}

\item{q}{The dimension of the set of B-spline functions.}

\item{lambda_l}{Tuning parameter of the functional adaptive pairwise fusion penalty (FAPFP).}

\item{lambda_s}{Tuning parameter of the smoothness penalty.}

\item{G}{The number of clusters.}

\item{tol}{The tolerance for the stopping condition of the expectation conditional maximization (ECM) algorithms.
The algorithm stops when the log-likelihood difference between two consecutive iterations is less or equal than \code{tol}.}

\item{maxit}{The maximum number of iterations allowed in the ECM algorithm.}

\item{par_LQA}{A list of parameters for the local quadratic approximation (LQA) in the ECM algorithm.
\code{eps_diff} is the lower bound for the coefficient mean differences, values below \code{eps_diff} are set to zero.
\code{MAX_iter_LQA} is the maximum number of iterations allowed in the LQA.
\code{eps_LQA} is the tolerance for the stopping condition of LQA.}

\item{plot}{If TRUE, the estimated cluster means are plotted at each iteration of the ECM algorithm. Default is FALSE.}

\item{trace}{If TRUE, information are shown at each iteration of the ECM algorithm. Default is FALSE.}

\item{init}{It is the way to initialize the ECM algorithm. There are three ways of initialization: "kmeans", "model-based", and "hierarchical", that
provide initialization through the k-means algorithm,  model-based clustering based on parameterized finite Gaussian mixture model, and  hierarchical clustering, respectively.
Default is "kmeans".}

\item{varcon}{A vector of character strings indicating the type of coefficient covariance matrix. Three values are allowed: "full", "diagonal", and "equal".
"full" means unrestricted cluster coefficient covariance matrices allowed to be different among clusters.
"diagonal" means diagonal cluster coefficient covariance matrices that are equal among clusters.
"equal" means diagonal cluster coefficient covariance matrices, with equal diagonal entries, that are equal among clusters.
Default is "diagonal".}

\item{lambda_s_ini}{The tuning parameter used to obtain the functional data through smoothing B-splines before applying the initialization algorithm.
If NULL a Generalized cross validation procedure is used as described in Ramsay (2005). Default is NULL.}
}
\value{
A list containing the following arguments:
\code{mod} that is a list composed by
\itemize{
\item \code{data}: A list containing the vectorized form of \code{X}, \code{timeindex}, and \code{curve}. For functional data observed over a regular grid \code{timeindex} and \code{curve} are trivially obtained.

\item \code{parameters}: A list containing all the estimated parameters.

\item \code{vars}: A list containing results from the Expectation step of the ECM algorithm.

\item \code{FullS}: The matrix of B-spline computed over \code{grid}.

\item \code{grid}: The vector of time points where the curves are sampled.

\item \code{W}: The basis roughness penalty matrix containing the inner products of pairs of basis function second derivatives.

\item \code{AW_vec}: Vectorized version of the diagonal matrix used in the approximation of FAPFP.

\item \code{P_tot}: Sparse Matrix used to compute all the pairwise comparisons in the FAPFP.

\item \code{lambda_s}: Tuning parameter of the smoothness penalty.

\item \code{lambda_l}: Tuning parameter of the FAPFP.
}

A list, named \code{clus}, containing the following arguments:
\itemize{
\item \code{classes}: The vector of cluster membership.

\item \code{po_pr}: Posterior probabilities of cluster membership.
}

\code{mean_fd} The estimated cluster mean functions.

\code{class} A label for the output type.
}
\description{
Sparse and smooth functional clustering (SaS-Funclust) allows to cluster a sample of curves
into homogeneous groups while jointly detecting the most informative portion of domain. (Centofanti et al., 2021).
}
\examples{
library(sasfunclust)
train<-simulate_data("Scenario I",n_i=20,var_e = 1,var_b = 0.5^2)
mod<-sasfclust(X=train$X,grid=train$grid,lambda_s = 10^-6,lambda_l =10,G = 2,maxit = 5,q=10)
plot(mod)
}
\references{
Centofanti, F., Lepore, A., & Palumbo, B. (2021).
Sparse and Smooth Functional Data Clustering.
\emph{arXiv preprint arXiv:2103.15224}.

Ramsay, J., Ramsay, J., & Silverman, B. W. (2005). Functional Data Analysis. Springer Science & Business Media.
}
\seealso{
\code{\link{sasfclust_cv}}
}
