% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_xmile.R
\name{as.data.frame.sdbuildR_sim}
\alias{as.data.frame.sdbuildR_sim}
\title{Create data frame of simulation results}
\usage{
\method{as.data.frame}{sdbuildR_sim}(x, row.names = NULL, optional = FALSE, direction = "long", ...)
}
\arguments{
\item{x}{Output of simulate().}

\item{row.names}{NULL or a character vector giving the row names for the data frame. Missing values are not allowed.}

\item{optional}{Ignored parameter.}

\item{direction}{Format of data frame, either "long" (default) or "wide".}

\item{...}{Optional parameters}
}
\value{
A data.frame with simulation results. For \code{direction = "long"} (default),
the data frame has three columns: \code{time}, \code{variable}, and \code{value}.
For \code{direction = "wide"}, the data frame has columns \code{time} followed by
one column per variable.
}
\description{
Convert simulation results to a data.frame.
}
\examples{
sfm <- xmile("SIR")
sim <- simulate(sfm)
df <- as.data.frame(sim)
head(df)

# Get results in wide format
df_wide <- as.data.frame(sim, direction = "wide")
head(df_wide)

}
\seealso{
\code{\link[=simulate]{simulate()}}, \code{\link[=xmile]{xmile()}}
}
\concept{build}
