% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insightmaker_to_sfm.R
\name{insightmaker_to_sfm}
\alias{insightmaker_to_sfm}
\title{Import Insight Maker model}
\usage{
insightmaker_to_sfm(
  URL,
  file,
  keep_nonnegative_flow = TRUE,
  keep_nonnegative_stock = FALSE,
  keep_solver = FALSE
)
}
\arguments{
\item{URL}{URL to Insight Maker model. Character.}

\item{file}{File path to Insight Maker model. Only used if URL is not specified. Needs to be a character with suffix .InsightMaker.}

\item{keep_nonnegative_flow}{If TRUE, keeps original non-negativity setting of flows. Defaults to TRUE.}

\item{keep_nonnegative_stock}{If TRUE, keeps original non-negativity setting of stocks Defaults to FALSE.}

\item{keep_solver}{If TRUE, keep the ODE solver as it is. If FALSE, switch to Euler integration in case of non-negative stocks to reproduce the Insight Maker data exactly. Defaults to FALSE.}
}
\value{
A stock-and-flow model object of class \code{\link[=xmile]{sdbuildR_xmile}}
}
\description{
Import a stock-and-flow model from \href{https://insightmaker.com/}{Insight Maker}. Models may be your own or another user's. Importing causal loop diagrams or agent-based models is not supported.
}
\details{
Insight Maker models can be imported using either a URL or an Insight Maker file. Ensure the URL refers to a public (not private) model. To download a model file from Insight Maker, first clone the model if it is not your own. Then, go to "Share" (top right), "Export", and "Download Insight Maker file".
}
\examples{
\dontshow{if (has_internet() && Sys.getenv("NOT_CRAN") == "true") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load a model from Insight Maker
sfm <- insightmaker_to_sfm(
  URL =
    "https://insightmaker.com/insight/43tz1nvUgbIiIOGSGtzIzj/Romeo-Juliet"
)
plot(sfm)

\dontshow{
sfm <- sim_specs(sfm, save_at = .5)
}

# Simulate the model
sim <- simulate(sfm)
plot(sim)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=build]{build()}}, \code{\link[=xmile]{xmile()}}
}
\concept{insightmaker}
