% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfg.R
\name{sfg_multipoint}
\alias{sfg_multipoint}
\title{sfg multipoint}
\usage{
sfg_multipoint(obj, x = NULL, y = NULL, z = NULL, m = NULL)
}
\arguments{
\item{obj}{matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}
}
\value{
\code{sfg} object of MULTIPOINT geometry
}
\description{
constructs sfg MULTIPOINT object
}
\examples{

sfg_multipoint( 1:2 )
sfg_multipoint( 1:3 )
sfg_multipoint( 1:4 )

sfg_multipoint( matrix( 1:3, ncol = 3 ) )
sfg_multipoint( data.frame( x = 1, y = 2, z = 3 )  )

sfg_multipoint( matrix( 1:4, ncol = 2 ) )
sfg_multipoint( matrix( 1:24, ncol = 2, byrow = TRUE ) )
sfg_multipoint( matrix( 1:24, ncol = 3, byrow = TRUE ) )
sfg_multipoint( matrix( 1:24, ncol = 4, byrow = TRUE ) )

sfg_multipoint( data.frame( x = 1:5, y = 1:5 ) )

## using columns

sfg_multipoint( matrix( 1:24, ncol = 4, byrow = TRUE ), x = 1, y = 2 )
sfg_multipoint( matrix( 1:24, ncol = 4, byrow = TRUE ), x = 1, y = 2, z = 3 )
sfg_multipoint( matrix( 1:24, ncol = 4, byrow = TRUE ), x = 3, y = 4 )

df <- data.frame( x = 1:5, y = 1:5, z = 11:15, m = 11:15 )
sfg_multipoint( df, x = "x", y = "y" )
sfg_multipoint( df, x = "x", y = "y", z = "z" )
sfg_multipoint( df, x = "x", y = "y", z = "z", m = "m" )

}
