% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlite_db.R
\name{db.write_table}
\alias{db.write_table}
\title{Write data frames to remote database tables with additional validation}
\usage{
db.write_table(
  con,
  data,
  table,
  schema = NA,
  append_only = FALSE,
  drop_overwrite = NA
)
}
\arguments{
\item{con}{An object that inherits from
\code{\link[=DBI]{DBIConnection-class}}, typically generated by
\code{\link[=DBI]{dbConnect()}}}

\item{data}{A \code{data.frame}, \code{tbl}, or other valid SQL data type
containing the data to write to the database.}

\item{table}{A character string specifying the DBMS table name.}

\item{schema}{A character string specifying the schema in which the table is
nested.}

\item{append_only}{A logical specifying whether the operation is
\code{INSERT} or \code{UPDATE}. Default of \code{append_only = FALSE} means
execute \code{DELETE} on table, and update with new data.}

\item{drop_overwrite}{A logical specifying whether the operation is
\code{DROP} and \code{INSERT}. This will overwrite any existing field
types.}
}
\value{
Returns \code{TRUE} if the SQL query executes successfully,
  \code{FALSE} otherwise.
}
\description{
Wrapper function to write data to table in default or custom
  schema. Returns \code{TRUE} if successful, \code{FALSE} otherwise.
}
\examples{
connection <- connect_sqlite(auto_disconnect = FALSE)

db.write_table(con = connection, table = 'iris', data = iris)

}
