% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_sphere.R
\name{interpolate_spline}
\alias{interpolate_spline}
\title{Splines on the sphere}
\usage{
interpolate_spline(
  observations,
  targets,
  value,
  lon_obs = lon,
  lat_obs = lat,
  lon_targets = lon,
  lat_targets = lat,
  k = 50
)
}
\arguments{
\item{observations}{data.frame of observations.}

\item{targets}{data.frame of locations to calculate the interpolated and
smoothed values for (target points).}

\item{value}{Column with values in \code{observations}.}

\item{lon_obs}{Column in \code{observations} with longitude (lon is default).}

\item{lat_obs}{Column in \code{observations} with latitude (lat is default).}

\item{lon_targets}{Column in \code{targets} with longitude (lon is default).}

\item{lat_targets}{Column in \code{targets} with latitude (lat is default).}

\item{k}{(default 50) is the basis dimension. For small data sets reduce
\code{k} manually rather than using default.}
}
\value{
Object equal to object \code{targets} including an extra column
 with predicted values.
}
\description{
Spline interpolation and smoothing on the sphere.
}
\details{
\code{observations} should include at least columns for longitude
and latitude.

\code{targets} should include at least columns for longitude,
latitude and value of interest to interpolate and smooth.

A smooth of the general type discussed in Duchon (1977) is used:
the sphere is embedded in a 3D Euclidean space, but smoothing employs a
penalty based on second derivatives (so that locally as the smoothing
parameter tends to zero we recover a "normal" thin plate spline on the
tangent space). This is an unpublished suggestion of Jean Duchon.
}
\examples{
\dontrun{
target <- sf::st_drop_geometry(nl_postcode3)
obs <- dplyr::sample_n(insurance, 1000)
pop_df <- interpolate_spline(obs, target, population_pc4, k = 20)
pop_sf <- dplyr::left_join(nl_postcode3, pop_df)
choropleth(pop_sf, value = "population_pc4_pred", n = 13)
}

}
\references{
\code{\link[mgcv:smooth.construct.sos.smooth.spec]{Splines on
the sphere}}
}
\author{
Martin Haringa
}
