% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size_effect.R
\name{ppi_samplesize_effect}
\alias{ppi_samplesize_effect}
\title{Simulate Effect of Sample Size on Projection Pursuit Index Under Gaussian Noise}
\usage{
ppi_samplesize_effect(index_fun, n_sim = 100)
}
\arguments{
\item{index_fun}{A function taking two numeric vectors (\code{x}, \code{y}) and returning a scalar index.}

\item{n_sim}{Integer. Number of simulations per sample size. Default is 100.}
}
\value{
A tibble with:
\itemize{
\item \code{sample_size}: sample size used for each simulation block
\item \code{percentile95}: 95th percentile of the index values over simulations
}
}
\description{
For a given index function, simulates how the index behaves across a range
of sample sizes when applied to pairs of standard normal noise.
}
\examples{
\dontrun{
ppi_samplesize_effect(scag_index("stringy"), n_sim = 3)
}
}
