% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{bin_timepoints}
\alias{bin_timepoints}
\title{Categorize Observed Timepoints According to Scheduled Timepoints}
\usage{
bin_timepoints(
  observed,
  scheduled = unique(observed[!is.na(observed)]),
  breaks = c(-Inf, midpoints(scheduled), Inf),
  labels = make_visit_labels(seq_along(scheduled) - 1),
  ...
)
}
\arguments{
\item{observed}{A numeric vector of values.}

\item{scheduled}{A numeric vector of unique, \link{finite} values. Length must be
at least 2. The default is to take the \link{unique}, \link{finite} values of
\code{observed}.}

\item{breaks}{A numeric vector of unique values. \code{-Inf} and \code{Inf} are valid.
Passed to \code{\link[=cut]{cut()}}. The default is to take the midpoints of \code{scheduled} and
to put them in between \verb{c(-Inf, [Inf])}.}

\item{labels}{A vector of labels for the resulting \code{\link{ordered}} factor. Passed
to \code{\link[=cut]{cut()}}. Must have \code{\link[=length]{length()}} equal to \code{scheduled}. Defaults to
\code{"Baseline"} as the first level's label and \code{"Visit#"} for all subsequent
\link{levels}, where \verb{#} is the numeric index of the timepoint minus 1.}

\item{...}{Additional arguments passed to \code{\link[=cut]{cut()}}.}
}
\value{
And [\verb{ordered] factor} with the same length as \code{observed}.
}
\description{
Create an \link{ordered} factor from a vector of observed values, associating each
observed value with the \link[=levels]{level} corresponding to a vector of
expected/\code{scheduled} values.
}
\examples{
observed_timepoints <- c(0, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89)
scheduled_timepoints <- c(0, 1, 2, 3, 4, 5, 10, 15, 20, 30, 50, 75)
bin_timepoints(
  observed_timepoints,
  scheduled = scheduled_timepoints
)

bin_timepoints(
  observed_timepoints,
  scheduled = scheduled_timepoints,
  breaks = c(-Inf, 0.1, 1.5, 2.5, 3.5, 4.4, 7, 11, 15.1, 21, 31, 58, 80)
)

bin_timepoints(
  observed_timepoints,
  scheduled = scheduled_timepoints,
  labels = month.name
)

bin_timepoints(
  observed_timepoints,
  scheduled = scheduled_timepoints,
  labels = make_visit_labels(scheduled_timepoints, visit = "Week")
)

bin_timepoints(observed_timepoints)
}
