% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent.R
\name{needs_indention_one}
\alias{needs_indention_one}
\title{Check whether indention is needed}
\usage{
needs_indention_one(pd, potential_trigger_pos, other_trigger_tokens)
}
\arguments{
\item{pd}{A parse table.}

\item{potential_trigger_pos}{the index of the token in the parse table
for which it should be checked whether it should trigger indention.}

\item{other_trigger_tokens}{Other tokens that are going to cause indention
if on the same line as the token corresponding to \code{potential_trigger} and
directly followed by a line break.}
}
\value{
Returns \code{TRUE} if indention is needed, \code{FALSE} otherwise.

\code{TRUE} if indention is needed, \code{FALSE} otherwise.
}
\description{
Determine whether the tokens corresponding to \code{potential_trigger_pos} should
cause indention, considering that there might be other potential triggers
\code{other_trigger_tokens} that are going to cause indention.
Indention is needed if the two conditions apply:
}
\details{
\itemize{
\item there is no multi-line token between the trigger and the first line break.
\item there is no other token between the potential trigger and the first line
break that is going to cause indention. Note that such an other trigger
only causes indention if there is a line break after that other triggering
token, not otherwise. If it causes indention, it is said to be an active
trigger, if it does not, it is called an inactive trigger.
See 'Details' for an example where there is an other trigger token, but
since the next token is on the same line as the other trigger,
the trigger is passive.
}
}
\examples{
style_text(c(
  "call(named = c,",
  "named = b)"
), strict = FALSE)
}
\keyword{internal}
