% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tgve.R
\name{tgve}
\alias{tgve}
\title{Open static TGVE instance}
\usage{
tgve(
  path = Sys.getenv("TEMP_path_ENV"),
  browse = TRUE,
  remote = FALSE,
  url = "https://tgve.github.io/app/"
)
}
\arguments{
\item{path}{character directory of a current instance to browse. Defaults to
`TEMP_PATH_ENV` environment variable.}

\item{browse}{boolean to decide whether to browse the instance or not.}

\item{remote}{boolean whether to run a remote instance of TGVE. If TRUE
the above `path` and `browse` parameters will be ignored. Defaults to `FALSE`}

\item{url}{if `remote` is true, then this will be used as the parameter
to pass to internal function `openURL`. It defaults, for convenience,
to `https://tgve.github.io/app/` instance.}
}
\value{
directory of the new instance if `path` is not provided.
}
\description{
This is the main and most basic function to run an instance of TGVE without
back-end. Compared to \link[tgver]{tgve_server}, this function only uses
internal functions to setup an instance then opens the entry HTML file.
If a path of an instance is provided it opens it, otherwise creates an
instance from a `tempdir`.
}
\examples{
\donttest{
tgve()
# just get the path of the HTML
p = tgve(browse = FALSE)
file.exists(p)
}

}
