% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_feed_by_stops}
\alias{filter_feed_by_stops}
\title{Filter a gtfs feed so that it only contains trips that pass the given stops}
\usage{
filter_feed_by_stops(gtfs_obj, stop_ids = NULL, stop_names = NULL)
}
\arguments{
\item{gtfs_obj}{gtfs feed (tidygtfs object)}

\item{stop_ids}{vector with stop_ids. You can either provide stop_ids or stop_names}

\item{stop_names}{vector with stop_names (will be converted to stop_ids)}
}
\value{
tidygtfs object with filtered tables
}
\description{
Only stop_times, stops, routes, services (in calendar and calendar_dates), shapes,
frequencies and transfers belonging to one of those trips are kept.
}
\note{
The returned gtfs_obj likely contains more than just the stops given (i.e. all stops
that belong to a trip passing the initial stop).
}
\seealso{
\code{\link[=filter_feed_by_date]{filter_feed_by_date()}}, \code{\link[=filter_feed_by_area]{filter_feed_by_area()}}, \code{\link[=filter_feed_by_trips]{filter_feed_by_trips()}}
}
