% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-bw.R
\name{all_bw}
\alias{all_bw}
\title{Verify Values in Vector are Between Two Others}
\usage{
all_bw(x, lo = -Inf, hi = Inf, na.rm = FALSE, bounds = "[]")
}
\arguments{
\item{x}{vector logical (treated as integer), integer, numeric, or character.
Factors are treated as their underlying integer vectors.}

\item{lo}{scalar vector of type coercible to the type of \code{x}, cannot be NA,
use \code{-Inf} to indicate unbounded (default).}

\item{hi}{scalar vector of type coercible to the type of \code{x}, cannot be NA,
use \code{Inf} to indicate unbounded (default), must be greater than or equal to
\code{lo}.}

\item{na.rm}{TRUE, or FALSE (default), whether NAs are considered to be
in bounds.  Unlike with \code{\link[=all]{all()}}, for \code{all_bw} \code{na.rm=FALSE} returns an
error string if there are NAs instead of NA.  Arguably NA, but not NaN,
should be considered to be in \verb{[-Inf,Inf]}, but since \code{NA < Inf} is NA we
treat them as always being out of bounds.}

\item{bounds}{\code{character(1L)} for values between \code{lo} and \code{hi}:
\itemize{
\item \dQuote{[]} include \code{lo} and \code{hi}
\item \dQuote{()} exclude \code{lo} and \code{hi}
\item \dQuote{(]} exclude \code{lo}, include \code{hi}
\item \dQuote{[)} include \code{lo}, exclude \code{hi}
}}
}
\value{
TRUE if all values in \code{x} conform to the specified bounds, a string
describing the first position that fails otherwise
}
\description{
Similar to \code{isTRUE(all(x >= lo & x <= hi))} with default settings,
except that it is substantially faster and returns a string describing the
first encountered violation rather than FALSE on failure.
}
\details{
You can modify the comparison to be strictly greater/less than via the
\code{bounds} parameter, and the treatment of NAs with \code{na.rm}.  Note that NAs are
considered to be out of bounds by default.  While technically incorrect
since we cannot know whether an NA value is in or out of bounds, this
assumption is both conservative and convenient.  Zero length \code{x} will always
succeed.

If \code{x} and \code{lo}/\code{hi} are different types, \code{lo}/\code{hi} will be coerced to the
type of \code{x}.  When \code{lo}/\code{hi} are numeric and \code{x} is integer, if \code{lo}/\code{hi}
values are outside of the integer range then that side will be treated as if
you had used \code{-Inf}/\code{Inf}.  \code{-Inf} and \code{Inf} mean \code{lo} and \code{hi} will be
unbounded for all data types.
}
\examples{
all_bw(runif(100), 0, 1)
all_bw(runif(100) * 2, 0, 1)
all_bw(NA, 0, 1)              # This is does not return NA
all_bw(NA, 0, 1, na.rm=TRUE)

vec <- c(runif(100, 0, 1e12), Inf, 0)
all_bw(vec, 0)      # All +ve numbers
all_bw(vec, hi=0)   # All -ve numbers
all_bw(vec, 0, bounds="(]") # All strictly +ve nums
all_bw(vec, 0, bounds="[)") # All finite +ve nums
}
