% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{store_raster}
\alias{store_raster}
\title{Store a raster dataset in a workspace}
\usage{
store_raster(
  x,
  dataset,
  name,
  timestamp = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S")
)
}
\arguments{
\item{x}{the workspace object}

\item{dataset}{the SpatRaster object to store in the workspace.}

\item{name}{name associated with the SpatRaster, if a workspace file with this name exists
already it will be replaced.}

\item{timestamp}{A timestamp string to associate with the entry in the workspace.}
}
\value{
Returns the \link{workspace} object passed to \code{x} parameter. Called primarily for side effects.
}
\description{
Store a SpatRaster object as a TIFF file into an existing workspace.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
# Create example raster (requires terra package)
if (requireNamespace("terra", quietly = TRUE)) {
  r <- terra::rast(ncols=10, nrows=10, vals=1:100)
  z <- store_raster(x = z, dataset = r, name = "example_raster")
  z
}
}
\seealso{
\link{workspace} for package documentation

Other functions to write in a workspace: 
\code{\link{delete_dataset}()},
\code{\link{store_dataset}()},
\code{\link{store_json}()},
\code{\link{store_rds}()},
\code{\link{store_yaml}()}
}
\concept{functions to write in a workspace}
