% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{rename_seq}
\alias{rename_seq}
\title{Rename files with a sequential numeric prefix}
\usage{
rename_seq(
  pattern = "^[0-9]+-.+[.]Rmd$",
  format = "auto",
  replace = TRUE,
  start = 1,
  dry_run = TRUE
)
}
\arguments{
\item{pattern}{A regular expression for \code{\link[=list.files]{list.files()}} to obtain
the files to be renamed. For example, to rename \code{.jpeg} files, use
\code{pattern = "[.]jpeg$"}.}

\item{format}{The format for the numeric prefix. This is passed to
\code{\link[=sprintf]{sprintf()}}. The default format is \code{"\\\%0Nd"} where \code{N = floor(log10(n)) + 1} and \code{n} is the number of files, which means the
prefix may be padded with zeros. For example, if there are 150 files to be
renamed, the format will be \code{"\\\%03d"} and the prefixes will be
\code{001}, \code{002}, ..., \code{150}.}

\item{replace}{Whether to remove existing numeric prefixes in filenames.}

\item{start}{The starting number for the prefix (it can start from 0).}

\item{dry_run}{Whether to not really rename files. To be safe, the default is
\code{TRUE}. If you have looked at the new filenames and are sure the new
names are what you want, you may rerun \code{rename_seq()} with
\code{dry_run = FALSE} to actually rename files.}
}
\value{
A named character vector. The names are original filenames, and the
vector itself is the new filenames.
}
\description{
Rename a series of files and add an incremental numeric prefix to the
filenames. For example, files \file{a.txt}, \file{b.txt}, and \file{c.txt}
can be renamed to \file{1-a.txt}, \file{2-b.txt}, and \file{3-c.txt}.
}
\examples{
xfun::rename_seq()
xfun::rename_seq("[.](jpeg|png)$", format = "\%04d")
}
