% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{coefficient.sm}
\alias{coefficient.sm}
\title{Coefficient-based scale model with user-specified prior on fixed effects}
\usage{
coefficient.sm(X, logComp, c.mu = NULL, c.cor = NULL)
}
\arguments{
\item{X}{A numeric design matrix passed internally by \code{aldex()} to the
scale model. Rows correspond to fixed-effect coefficients/covariates
(\code{P = nrow(X)}) and columns correspond to samples
(\code{N = ncol(X)}). (Automatically supplied by \code{aldex()}.)}

\item{logComp}{A numeric array of Monte Carlo log-compositions with
dimensions \code{features x samples x nsample}. This scale model uses
\code{nsample} (the number of Monte Carlo draws) but does not otherwise use
\code{logComp}. (Automatically supplied by \code{aldex()}.)}

\item{c.mu}{Numeric vector of length \code{P} giving the mean of the fixed
effect coefficients in log2-scale space. Must not be \code{NULL}.}

\item{c.cor}{Numeric \code{P x P} covariance matrix for the fixed effect
coefficients in log2-scale space. Must not be \code{NULL}.}
}
\value{
A numeric matrix of dimension \code{N x nsample} giving Monte Carlo
draws of the log2 scale for each sample (rows) across \code{nsample} draws
(columns).
}
\description{
Draws Monte Carlo samples of the log2 scale by sampling fixed-effect
coefficients from a multivariate normal distribution and mapping them
through the design matrix \code{X}. This scale model is useful when you
want to encode prior information about how covariates (e.g., treatment,
batch, time) affect scale, rather than specifying scale moments directly
per sample.
}
\details{
Specifically, for each Monte Carlo draw \eqn{b^{(m)} \sim N(c.mu, c.cor)},
the per-sample log2 scale is computed as \eqn{b^{(m)T} X}, producing an
\code{N x nsample} matrix of log2-scale draws.

For example, with an intercept and a treatment indicator where treatment is
expected to increase log2 scale by ~1 on average, one might use
\code{c.mu = c(0, 1)} and \code{c.cor = diag(c(0.25, 0.25))} (i.e., SD 0.5
for each coefficient, independent).
}
\author{
Kyle McGovern
}
