% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_configuration.r
\name{write.SysConfig}
\alias{write.SysConfig}
\title{Write an Amiga system-configuration file}
\usage{
write.SysConfig(x, file)
}
\arguments{
\item{x}{An S3 \link{SysConfig} class object.}

\item{file}{A file name to which the binary file should be written.}
}
\value{
Returns \code{NULL} or an \code{integer} status passed on by the
\code{\link[=close]{close()}} function, that is used to close the file connection.
It is returned invisibly.
}
\description{
Write a \link{SysConfig} class object to an Amiga binary system-configuration file.
}
\details{
Amiga OS 1.x stored system preferences in a binary system-configuration file. This
function writes a \link{SysConfig} class object as such a binary file. This file
can be used on an Amiga or in an emulator.
}
\examples{
## First generate a simple SysConfig object to write to a file:
sc <- simpleSysConfig()

## And write to the tempdir:
write.SysConfig(sc, file.path(tempdir(), "system-configuration"))
}
\seealso{
Other SysConfig.operations: 
\code{\link{SysConfig}},
\code{\link{rawToSysConfig}()},
\code{\link{read.SysConfig}()},
\code{\link{simpleSysConfig}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{SysConfig.operations}
\concept{io.operations}
