% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_matrix.R
\name{corr_matrix}
\alias{corr_matrix}
\title{Correlation Matrix}
\usage{
corr_matrix(
  data,
  type = "pearson",
  corr_plot = FALSE,
  sig.level = 0.01,
  highlight = FALSE,
  html = FALSE
)
}
\arguments{
\item{data}{Input dataset.}

\item{type}{Pearson or Spearman correlation, default is Pearson.}

\item{corr_plot}{Generate a correlation matrix plot, default is false.}

\item{sig.level}{Significant level. Default is 0.01.}

\item{highlight}{Highlight p-value(s) that is less than sig.level, default is FALSE}

\item{html}{Whether the output should be in HTML format,used when knitting into HTML. Default is FALSE.}
}
\value{
A data frame which contains row names, column names, correlation coefficients, and p-values.

A plot of the correlation if corrplot is set to be true.
}
\description{
Column 1: Row names representing Variable 1 in the correlation test.
  
  Column 2: Column names representing Variable 2 in the correlation test.
  
  Column 3: The correlation coefficients quantifying the strength and direction of the relationship.
  
  Column 4: The p-values associated with the correlations, indicating the statistical significance
            of the observed relationships. Lower p-values suggest stronger evidence against the null hypothesis.

The table provides valuable insights into the relationships between variables, helping to identify
statistically significant correlations.
}
\examples{
data(mtcars)
corr_matrix(mtcars, type = 'pearson')
}
