% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allen-mcmc.R
\name{allen_illustrate}
\alias{allen_illustrate}
\title{Illustrate Basic and Composite Allen Relations}
\usage{
allen_illustrate(relations = "basic", ...)
}
\arguments{
\item{relations}{A \code{\link{character}} string specifying the relation.
It must be one of "\code{basic}", "\code{concurrent}", "\code{distinct}",
"\code{stratigraphic}", "\code{branching}", "\code{transformation}", "\code{reticulation}",
"\code{sequence}", "\code{branch}", "\code{transform}", or "\code{reticulate}" (see details).}

\item{...}{Further arguments to be passed to internal methods.}
}
\value{
\code{allen_illustrate()} is called it for its side-effects: it results in a
graphic being displayed.
}
\description{
Illustrate Basic and Composite Allen Relations
}
\details{
Illustrate basic and composite Allen relations for several chronological
model domains with a Nokel lattice. Chronological model domains include
stratigraphy and branching, transformative, and reticulate processes of
artifact change.

The illustrative graphics include:
\describe{
\item{\code{basic}}{the 13 basic Allen relations (default);}
\item{\code{concurrent}}{concurrent relations;}
\item{\code{distinct}}{relations with distinct endpoints;}
\item{\code{stratigraphic}}{basic relations established by an observation of
superposition;}
\item{\code{branching}}{basic branching relations;}
\item{\code{transformation}}{basic relations of transformation;}
\item{\code{reticulation}}{basic relations of reticulation;}
\item{\code{sequence}}{composite relations in a stratigraphic sequence;}
\item{\code{branch}}{composite relations of branching;}
\item{\code{transform}}{composite relations of transformation; or}
\item{\code{reticulate}}{composite relations of reticulation.}
}
}
\examples{
## Plot the basic Allen relations
allen_illustrate()
}
\references{
Harris, E. C. (1997). \emph{Principles of Archaeological Stratigraphy}.
Second edition. London: Academic Press.

Lyman, R. L. and O'Brien, M. J. (2017). "Sedation and Cladistics: The
Difference between Anagenetic and Cladogenetic Evolution". In \emph{Mapping Our
Ancestors: Phylogenetic Approaches in Anthropology and Prehistory},
edited by Lipo, C. P., O'Brien, M. J., Couard, M., and Shennan,
S. J. New York: Routledge. \doi{10.4324/9780203786376}.

Viola, T. (2020). \emph{Peirce on the Uses of History}. De Gruyter.
\doi{10.1515/9783110651560}. See chapter 3, "Historicity as Process",
especially p. 83-88.
}
\seealso{
Other Allen's intervals: 
\code{\link{allen_analyze}()},
\code{\link{allen_complement}()},
\code{\link{allen_composition}()},
\code{\link{allen_converse}()},
\code{\link{allen_intersect}()},
\code{\link{allen_joint_concurrency}()},
\code{\link{allen_observe}()},
\code{\link{allen_observe_frequency}()},
\code{\link{allen_relation}()},
\code{\link{allen_relation_code}()},
\code{\link{allen_union}()}
}
\author{
T. S. Dye
}
\concept{Allen's intervals}
