% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/read.R
\docType{methods}
\name{read_oxcal}
\alias{read_oxcal}
\alias{read_oxcal-method}
\alias{read_oxcal,character-method}
\title{Read OxCal Output}
\usage{
read_oxcal(file, ...)

\S4method{read_oxcal}{character}(file, calendar = CE())
}
\arguments{
\item{file}{the name of the file which the data are to be read from.
    Each row of the table appears as one line of the file.  If it does
    not contain an \emph{absolute} path, the file name is
    \emph{relative} to the current working directory,
    \code{\link{getwd}()}. Tilde-expansion is performed where supported.
    This can be a compressed file (see \code{\link{file}}).

    Alternatively, \code{file} can be a readable text-mode
    \link{connection} (which will be opened for reading if
    necessary, and if so \code{\link{close}}d (and hence destroyed) at
    the end of the function call).  (If \code{\link{stdin}()} is used,
    the prompts for lines may be somewhat confusing.  Terminate input
    with a blank line or an \abbr{EOF} signal, \code{Ctrl-D} on Unix and
    \code{Ctrl-Z} on Windows.  Any pushback on \code{stdin()} will be
    cleared before return.)

    \code{file} can also be a complete URL.  (For the supported URL
    schemes, see the \sQuote{URLs} section of the help for
    \code{\link{url}}.)
  }

\item{...}{Further arguments to be passed to \code{read.table}.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the calendar
(see \code{\link[aion:calendar]{aion::calendar()}}). It should be \code{\link[=CE]{CE()}} unless you change the
default settings in 'OxCal'.}
}
\value{
An \code{\linkS4class{EventsMCMC}} object.
}
\description{
Reads MCMC output.
}
\examples{
if (requireNamespace("ArchaeoData", quietly = TRUE)) {
  ## Import OxCal Output
  path <- "oxcal/ksarakil/"

  path_output <- system.file(path, "MCMC_Sample.csv", package = "ArchaeoData")
  (oxcal <- read_oxcal(path_output))
}
}
\references{
Bronk Ramsey, C. (2009). Bayesian Analysis of Radiocarbon Dates.
\emph{Radiocarbon}, 51(1), 337-360. \doi{10.1017/S0033822200033865}.
}
\seealso{
\code{\link[utils:read.table]{utils::read.table()}}

Other read methods: 
\code{\link{as_coda}()},
\code{\link{as_events}()},
\code{\link{as_phases}()},
\code{\link{check}},
\code{\link{read_bcal}()},
\code{\link{read_chronomodel}}
}
\author{
T. S. Dye, N. Frerebeau
}
\concept{read methods}
