% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showTrajectory.R
\name{showTrajectory}
\alias{showTrajectory}
\title{Displays a trajectory plot from a set of coordinates.}
\usage{
showTrajectory(data, stepSize = 0, pal)
}
\arguments{
\item{data}{A data frame containing the trajectory coordinates with columns `x` and `y`.}

\item{stepSize}{An integer specifying the interval for plotting segments of the trajectory. 
If set to 0, the entire trajectory is plotted. Default is 0.}

\item{pal}{A color palette to be used for plotting the trajectory segments.}
}
\value{
A plot displaying the trajectory based on the provided coordinates and settings.
}
\description{
Visualizes the trajectory represented by a series of points. The function can display 
the full trajectory or a subset based on a specified step size. It supports customizable 
color palettes for enhanced visualization.
}
\examples{
# Generate example trajectory data
path <- system.file('extdata/track.txt', package='BioTrajectory')
data <- BioTrajectory::readtrackData(path)
data <- na.omit(data)
palette <- grDevices::colorRampPalette(c("purple","blue","cyan","yellow","orange","red"))
# Show the full trajectory
showTrajectory(data, stepSize = 0, pal = palette)
# Show the trajectory with a step size of 36
showTrajectory(data, stepSize = 36, pal = palette)

}
