% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mover.R
\name{mover}
\alias{mover}
\title{Inference using MOVER in match designs (EXPERIMENTAL)}
\usage{
mover(
  object,
  endpoint = NULL,
  conf.level = 0.95,
  p.value = TRUE,
  type = "Wilson",
  tol = 1e-06
)
}
\arguments{
\item{object}{\R object of class \code{S4BuyseTest}, i.e., output of \code{\link{BuyseTest}}}

\item{endpoint}{[character] for which endpoint the confidence intervals should be output?}

\item{conf.level}{[numeric] confidence level for the confidence intervals.}

\item{p.value}{[logical] should the confidence interval be inverted to obtain a p-value.}

\item{type}{[character] method used to compute confidence intervals for a proportion: \code{"Wilson"} or \code{"Agresti-Coull"}.}

\item{tol}{[numeric, >0] numeric tolerance for what is considered neglectable (i.e. 0).}
}
\description{
Implementation of the method of variance estimates recovery (MOVER), an alternative method for statistic inference in a matched design proposed by Matsouaka et al. (2022), for the Net Treatment Benefit.
}
\details{
The p-value calculation is performed by finding the confidence level such that the upper or lower bound of the corresponding confidence interval is 0.
This was not part of the methodology presented in the original paper.
}
\references{
R A Matsouaka, A Coles (2022). \bold{Robust statistical inference for the matched net benefit and the matched win ratio using prioritized composite endpoints}. \emph{Stat Methods Med Res} 31(8):1423-1438. doi: 10.1177/09622802221090761.
}
