% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DYNATE.R
\name{Test_Leaf}
\alias{Test_Leaf}
\title{Test_Leaf
The function is used to generate Leaf P-values for case-control study.
Users can input the leaf information through argument struct_map.
If there is not leaf information e.g. struct_map=NULL, Test_Leaf will automatically construct leaf.
Argument thresh_val specifies the leaf size constructed from the function.
When the argument Gmat_case and Gmat_ctrl is null, Test_Leaf will automatically generate those matrices.}
\usage{
Test_Leaf(snp_dat = NULL, thresh_val = 10, covars = NULL, teststat = "FET")
}
\arguments{
\item{snp_dat}{an optional data frame containing patients mutation information. If \code{snp_dat=NULL}, the mutation information should be taken from \code{Gmat_case}, \code{Gmat_ctrl} and \code{glm_input}. See vignettes for detail.}

\item{thresh_val}{a positive integer for leaf size.}

\item{covars}{an optional vector about the name of covariates to be considered in the fitting process. Should be NULL (default) or a character vector.}

\item{teststat}{the statistic used to derive p-value. Must be one of "FET" (default) or "score".}
}
\value{
a dataframe of rejected leafs with snp information.
}
\description{
Test_Leaf
The function is used to generate Leaf P-values for case-control study.
Users can input the leaf information through argument struct_map.
If there is not leaf information e.g. struct_map=NULL, Test_Leaf will automatically construct leaf.
Argument thresh_val specifies the leaf size constructed from the function.
When the argument Gmat_case and Gmat_ctrl is null, Test_Leaf will automatically generate those matrices.
}
\examples{
data("snp_dat")

# Set leaf size M
M <- 5

#Construct leaves and generate leaf p-value.
p.leaf <- Test_Leaf(snp_dat=snp_dat,thresh_val=M)
summary(p.leaf)

}
