% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbHasCompleted,DatabaseConnectorDbiResult-method}
\alias{dbHasCompleted,DatabaseConnectorDbiResult-method}
\title{Completion status}
\usage{
\S4method{dbHasCompleted}{DatabaseConnectorDbiResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \link[DBI:DBIResult-class]{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbHasCompleted()} returns a logical scalar.
For a query initiated by \code{\link[DBI:dbSendQuery]{dbSendQuery()}} with non-empty result set,
\code{dbHasCompleted()} returns \code{FALSE} initially
and \code{TRUE} after calling \code{\link[DBI:dbFetch]{dbFetch()}} without limit.
For a query initiated by \code{\link[DBI:dbSendStatement]{dbSendStatement()}},
\code{dbHasCompleted()} always returns \code{TRUE}.
}
\description{
This method returns if the operation has completed.
A \code{SELECT} query is completed if all rows have been fetched.
A data manipulation statement is always completed.

}
\seealso{
Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()}

Other DBIResultArrow generics: 
\code{\link[DBI]{DBIResultArrow-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbFetchArrow}()},
\code{\link[DBI]{dbFetchArrowChunk}()},
\code{\link[DBI]{dbIsValid}()}

Other data retrieval generics: 
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbFetchArrow}()},
\code{\link[DBI]{dbFetchArrowChunk}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbGetQueryArrow}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendQueryArrow}()}
}
