% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_reg.R
\name{q_reg}
\alias{q_reg}
\title{Quantile Regression}
\usage{
q_reg(dep_variable, factors, stressed_factors = NULL, h = 1, qtau = 0.05)
}
\arguments{
\item{dep_variable}{A numeric vector representing the dependent variable (e.g., GDP growth, inflation).}

\item{factors}{A matrix of factor estimates from an MLDFM model, with rows corresponding to time periods and columns corresponding to factors.}

\item{stressed_factors}{An optional matrix of stressed factors. If provided, the function computes projections under the stressed scenario.}

\item{h}{Integer representing the forecast horizon (in time steps) for the quantile regression.}

\item{qtau}{Numeric. The quantile level used in quantile regression.}
}
\value{
A list containing:
\describe{
\item{\code{pred_q}}{The quantile regression predictions based on the estimated factors.}
\item{\code{coeff}}{The regression coefficients for each variable in the model.}
\item{\code{pvalues}}{The p-values for each regression coefficient.}
\item{\code{stderr}}{The standard errors for each regression coefficient.}
\item{\code{stressed_pred_q}}{The quantile predictions under the stressed scenario, only if \code{stressed_factors} is provided.}
}
}
\description{
Estimates quantile regressions of a dependent variable on dynamic factors.
Optionally computes projections under stressed scenarios using the provided stressed factors.
}
\keyword{internal}
