% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/height_crown_base_silva.R
\name{height_crown_base_silva}
\alias{height_crown_base_silva}
\title{Estimate a tree's height to crown base}
\usage{
height_crown_base_silva(species_id, dbh_cm, height_m)
}
\arguments{
\item{species_id}{Vector of species id's following the \emph{tum_wwk_short}
species coding. Ideally, these species_id's are provided as a
\code{fe_species_tum_wwk_short} object. If they are provided as another
\code{fe_species} object, \code{height_crown_base_silva} will make an
attempt to convert them. If this is not possible, the function will
terminate with an error. The species id's can also be provided as numeric
values (\code{double} or \code{integer}) or \code{character}. These will be
internally converted to \code{fe_species_tum_wwk_short}. If this fails
(i.e. the user provided species codes not defined in the \emph{tum_wwk_short}
coding), an error is thrown and the function terminates.}

\item{dbh_cm}{Vector of tree dbh values in cm (dbh = stem diameter at breast
height, i.e. 1.3 m)}

\item{height_m}{Vector of tree height values in m}
}
\value{
An estimate of the tree's height to crown base in m.
}
\description{
This function can be used to estimate a tree's height to crown base,
given its stem diameter at breast height, its height and its species.
This is the height to crown base function implemented in the forest growth
simulator SILVA \insertCite{pretzsch_single_2002}{ForestElementsR}. Height to
crown base in this context is defined as the height where the lowest living
branch of the tree's primary crown branches of the stem.
}
\examples{
# Estimate the height to crown base of a Scots pine with a stem diameter
# at breast height of 45.2 cm and a total height of 29.2 m:
height_crown_base_silva(
  species_id = "3",     # will be internally converted to tum_wwk_short
  dbh_cm = 45.2,
  height_m = 29.2
) # 20.9 m (rounded)

# Height to crown base estimate for a European beech with
# the same height and diameter:
height_crown_base_silva(
  species_id = "5",     # will be internally converted to tum_wwk_short
  dbh_cm = 45.2,
  height_m = 29.2
) # 15.0 m (rounded)

# Run on vectors
spec <- mm_forest_1_fe_stand_spatial$trees$species_id
h <- mm_forest_1_fe_stand_spatial$trees$height_m
d <- mm_forest_1_fe_stand_spatial$trees$dbh_cm
height_crown_base_silva(spec, d, h)

}
\references{
\insertAllCited{}
}
